/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.cmar;

import ca.pfv.spmf.algorithms.classifiers.cmar.FPNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FPTree {
    List<Short> headerList = null;
    Map<Short, FPNode> mapItemNodes = new HashMap<Short, FPNode>();
    Map<Short, FPNode> mapItemLastNode = new HashMap<Short, FPNode>();
    FPNode root = new FPNode();

    public void addInstance(List<Short> transaction, Short klass) {
        FPNode currentNode = this.root;
        for (Short item : transaction) {
            FPNode child = currentNode.getChildByItem(item);
            if (child == null) {
                FPNode newNode = new FPNode();
                newNode.item = item;
                newNode.parent = currentNode;
                newNode.supportByklass = new HashMap();
                newNode.supportByklass.put(klass, 1L);
                currentNode.childs.add(newNode);
                currentNode = newNode;
                this.updateHeaderTable(item, newNode);
                continue;
            }
            ++child.support;
            Long counterByKlass = child.supportByklass.getOrDefault(klass, 0L);
            child.supportByklass.put(klass, counterByKlass + 1L);
            currentNode = child;
        }
    }

    private void updateHeaderTable(Short item, FPNode newNode) {
        FPNode lastNode = this.mapItemLastNode.get(item);
        if (lastNode != null) {
            lastNode.nextNode = newNode;
        }
        this.mapItemLastNode.put(item, newNode);
        FPNode headernode = this.mapItemNodes.get(item);
        if (headernode == null) {
            this.mapItemNodes.put(item, newNode);
        }
    }

    void addPrefixPath(List<FPNode> prefixPath, Map<Short, Long> mapSupportBeta, long relativeMinsupp) {
        long pathCount = prefixPath.get((int)0).support;
        FPNode currentNode = this.root;
        int i = prefixPath.size() - 1;
        while (i >= 1) {
            FPNode pathItem = prefixPath.get(i);
            if (mapSupportBeta.get(pathItem.item) >= relativeMinsupp) {
                FPNode child = currentNode.getChildByItem(pathItem.item);
                if (child == null) {
                    FPNode newNode = new FPNode();
                    newNode.item = pathItem.item;
                    newNode.parent = currentNode;
                    newNode.support = pathCount;
                    newNode.supportByklass = (HashMap)prefixPath.get((int)0).supportByklass.clone();
                    currentNode.childs.add(newNode);
                    currentNode = newNode;
                    this.updateHeaderTable(pathItem.item, newNode);
                } else {
                    for (Map.Entry<Short, Long> entry : prefixPath.get((int)0).supportByklass.entrySet()) {
                        Long counter = child.supportByklass.get(entry.getKey());
                        if (counter == null) {
                            child.supportByklass.put(entry.getKey(), entry.getValue());
                            continue;
                        }
                        child.supportByklass.put(entry.getKey(), counter + entry.getValue());
                    }
                    child.support += pathCount;
                    currentNode = child;
                }
            }
            --i;
        }
    }

    void createHeaderList(final Map<Short, Long> mapSupport) {
        this.headerList = new ArrayList<Short>(this.mapItemNodes.size());
        for (Map.Entry<Short, FPNode> entry : this.mapItemNodes.entrySet()) {
            this.headerList.add(entry.getKey());
        }
        Collections.sort(this.headerList, new Comparator<Short>(){

            @Override
            public int compare(Short id1, Short id2) {
                int compare = ((Long)mapSupport.get(id1)).compareTo((Long)mapSupport.get(id1));
                return compare == 0 ? id1 - id2 : compare;
            }
        });
    }
}

