/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.cmar;

import ca.pfv.spmf.algorithms.classifiers.cmar.CRTree;
import ca.pfv.spmf.algorithms.classifiers.cmar.RuleCMAR;
import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.general.Rule;
import ca.pfv.spmf.algorithms.classifiers.general.RuleClassifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassifierCMAR
extends RuleClassifier {
    private static final long serialVersionUID = 346166758556004366L;

    public ClassifierCMAR(List<Rule> rules, Dataset training, int delta) {
        super("CMAR");
        RuleCMAR.NUMBER_INSTANCES = training.getInstances().size();
        CRTree.NUMBER_SINGLETONS = training.getDistinctItemsCount();
        CRTree crTree = new CRTree(training, delta);
        for (Rule rule : rules) {
            crTree.insert(rule);
        }
        crTree.pruneUsingCover();
        this.rules = crTree.getRules();
    }

    @Override
    public short predict(Instance instance) {
        List<RuleCMAR> matchingRules = this.obtainallRulesForRecord(instance.getItems());
        if (matchingRules.isEmpty()) {
            return NOPREDICTION;
        }
        if (matchingRules.size() == 1) {
            return matchingRules.get(0).getKlass();
        }
        if (this.onlyOneClass(matchingRules)) {
            return matchingRules.get(0).getKlass();
        }
        Map<Short, List<RuleCMAR>> ruleGroups = this.groupRulesByKlass(matchingRules);
        return this.getClassWithBestChiQuareValue(ruleGroups);
    }

    private Map<Short, List<RuleCMAR>> groupRulesByKlass(List<RuleCMAR> rules) {
        HashMap<Short, List<RuleCMAR>> rulesByGroup = new HashMap<Short, List<RuleCMAR>>();
        for (RuleCMAR rule : rules) {
            ArrayList<RuleCMAR> rulesForKlass = (ArrayList<RuleCMAR>)rulesByGroup.get(rule.getKlass());
            if (rulesForKlass == null) {
                rulesForKlass = new ArrayList<RuleCMAR>();
                rulesByGroup.put(rule.getKlass(), rulesForKlass);
            }
            rulesForKlass.add(rule);
        }
        return rulesByGroup;
    }

    private boolean onlyOneClass(List<RuleCMAR> rules) {
        short firstKlass = rules.get(0).getKlass();
        int i = 1;
        while (i < rules.size()) {
            if (rules.get(i).getKlass() != firstKlass) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private short getClassWithBestChiQuareValue(Map<Short, List<RuleCMAR>> rulesByGroup) {
        double bestChi = -1.0;
        short bestKlass = -1;
        for (Map.Entry<Short, List<RuleCMAR>> entry : rulesByGroup.entrySet()) {
            double wcsValue = 0.0;
            List<RuleCMAR> rules = entry.getValue();
            for (RuleCMAR rule : rules) {
                double chiSquare = rule.getChiSquare();
                double chiSquareUB = rule.getChiSquareUpperBound();
                wcsValue += chiSquare * chiSquare / chiSquareUB;
            }
            if (!(wcsValue > bestChi)) continue;
            bestChi = wcsValue;
            bestKlass = entry.getKey();
        }
        return bestKlass;
    }

    private List<RuleCMAR> obtainallRulesForRecord(Short[] example) {
        ArrayList<RuleCMAR> result = new ArrayList<RuleCMAR>();
        for (Rule rule : this.rules) {
            if (!rule.matching(example)) continue;
            result.add((RuleCMAR)rule);
        }
        return result;
    }
}

