/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.cba;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.classifiers.cba.Replace;
import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.general.Rule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RuleCBA
extends Rule
implements Comparable<RuleCBA>,
Serializable {
    private static final long serialVersionUID = 3873840518047980112L;
    private double pessimisticErrorRate;
    private long hits;
    private long misses;
    private long time;
    private Boolean mark = false;
    private Map<Short, Long> klassesCovered;
    private List<Replace> replace;

    public RuleCBA() {
        this.klassesCovered = new HashMap<Short, Long>();
        this.replace = new ArrayList<Replace>();
        this.time = System.currentTimeMillis();
    }

    public RuleCBA(short klass) {
        super(klass);
        this.klassesCovered = new HashMap<Short, Long>();
        this.replace = new ArrayList<Replace>();
        this.time = System.currentTimeMillis();
        this.pessimisticErrorRate = 0.0;
        this.hits = 0L;
        this.misses = 0L;
    }

    public RuleCBA(RuleCBA rule) {
        super(rule.klass);
        this.add(rule.antecedent);
        this.supportAntecedent = rule.supportAntecedent;
        this.supportKlass = rule.supportKlass;
        this.supportRule = rule.supportRule;
        this.replace = new ArrayList<Replace>();
        int i = 0;
        while (i < rule.replace.size()) {
            this.replace.add(new Replace(this.replace.get(i)));
            ++i;
        }
        this.klassesCovered = new HashMap<Short, Long>(rule.klassesCovered);
        this.pessimisticErrorRate = rule.pessimisticErrorRate;
        this.hits = rule.hits;
        this.mark = rule.mark;
        this.misses = rule.misses;
    }

    public long getMisses() {
        return this.misses;
    }

    public double getPessimisticErrorRate() {
        return this.pessimisticErrorRate;
    }

    public void evaluate(Dataset train) {
        this.supportAntecedent = 0L;
        this.supportRule = 0L;
        this.supportKlass = 0L;
        for (Instance instance : train.getInstances()) {
            Short[] items = instance.getItems();
            Boolean matchAntecedent = ArraysAlgos.isSubsetOf(this.antecedent, items);
            Boolean matchConsequent = instance.getKlass() == this.klass;
            if (matchConsequent.booleanValue()) {
                ++this.supportKlass;
                ++this.hits;
            } else {
                ++this.misses;
            }
            if (matchAntecedent.booleanValue()) {
                ++this.supportAntecedent;
            }
            if (!matchAntecedent.booleanValue() || !matchConsequent.booleanValue()) continue;
            ++this.supportRule;
        }
        this.pessimisticErrorRate = (1.0 * (double)this.misses + RuleCBA.errors((double)this.hits + (double)this.misses * 1.0, (double)this.misses * 1.0)) / (double)(this.misses + this.hits);
        this.time = System.currentTimeMillis();
    }

    public void addReplace(Replace replace) {
        this.replace.add(replace);
    }

    public void mark() {
        this.mark = true;
    }

    public void incrementKlassCovered(short klass) {
        Long value = this.klassesCovered.get(klass);
        if (value != null) {
            this.klassesCovered.put(klass, value + 1L);
        } else {
            this.klassesCovered.put(klass, 1L);
        }
    }

    public void decrementKlassCovered(short klass) {
        Long value = this.klassesCovered.get(klass);
        if (value != null) {
            this.klassesCovered.put(klass, value - 1L);
        }
    }

    public boolean isMark() {
        return this.mark;
    }

    public boolean isPrecedence(RuleCBA r) {
        if (this.getConfidence() > r.getConfidence()) {
            return true;
        }
        if (this.getConfidence() < r.getConfidence()) {
            return false;
        }
        if (this.getSupportRule() > r.getSupportRule()) {
            return true;
        }
        if (this.getSupportRule() < r.getSupportRule()) {
            return false;
        }
        if (this.getAntecedent().size() < r.getAntecedent().size()) {
            return true;
        }
        return this.getAntecedent().size() <= r.getAntecedent().size();
    }

    public int getReplaceCount() {
        return this.replace.size();
    }

    public Replace getReplace(int j) {
        return this.replace.get(j);
    }

    public Long getKlassesCovered(short klass) {
        return this.klassesCovered.get(klass);
    }

    @Override
    public int compareTo(RuleCBA a) {
        if (a.getConfidence() < this.getConfidence()) {
            return -1;
        }
        if (a.getConfidence() > this.getConfidence()) {
            return 1;
        }
        if (a.getSupportRule() < this.getSupportRule()) {
            return -1;
        }
        if (a.getSupportRule() > this.getSupportRule()) {
            return 1;
        }
        if (a.time < this.time) {
            return 1;
        }
        if (a.time > this.time) {
            return -1;
        }
        return 0;
    }

    @Override
    public String getMeasuresToString() {
        return " #SUP: " + this.getSupportRule() + " #CONF: " + this.getConfidence() + " #ERROR: " + this.getPessimisticErrorRate();
    }
}

