/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.cba;

import ca.pfv.spmf.algorithms.classifiers.cba.RuleCBA;
import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AprioriForCBA {
    private long minSupRelative;

    public List<RuleCBA> runAlgorithm(Dataset dataset, double minSup, double minConf) {
        this.minSupRelative = (long)Math.ceil(minSup * (double)dataset.getInstances().size());
        ArrayList<RuleCBA> rules = new ArrayList<RuleCBA>();
        List<Short> frequent1 = this.generateSingletons(dataset);
        if (frequent1.isEmpty()) {
            return new ArrayList<RuleCBA>();
        }
        Collections.sort(frequent1, new Comparator<Short>(){

            @Override
            public int compare(Short o1, Short o2) {
                return o1 - o2;
            }
        });
        List<RuleCBA> level = null;
        int k = 2;
        do {
            level = k == 2 ? this.generateAndTestCandidateSize2(dataset, minConf, rules, frequent1) : this.generateAndTestCandidateSizeK(dataset, minConf, rules, level);
            ++k;
        } while (!level.isEmpty());
        return rules;
    }

    private List<RuleCBA> generateAndTestCandidateSizeK(Dataset dataset, double minConf, List<RuleCBA> rules, List<RuleCBA> level) {
        ArrayList<RuleCBA> levelX = new ArrayList<RuleCBA>();
        int i = 0;
        while (i < level.size()) {
            RuleCBA rule1 = level.get(i);
            int j = i + 1;
            while (j < level.size()) {
                RuleCBA rule2 = level.get(j);
                if (rule1.isCombinable(rule2)) {
                    RuleCBA newRule = new RuleCBA(rule1);
                    newRule.add(rule2.get(rule2.size() - 1));
                    if (this.areSubsetsFrequents(newRule, level)) {
                        newRule.evaluate(dataset);
                        if (newRule.getSupportRule() >= this.minSupRelative) {
                            levelX.add(newRule);
                            if (newRule.getConfidence() >= minConf) {
                                rules.add(newRule);
                            }
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return levelX;
    }

    private List<RuleCBA> generateAndTestCandidateSize2(Dataset dataset, double minConf, List<RuleCBA> rules, List<Short> frequent1) {
        ArrayList<RuleCBA> levelX = new ArrayList<RuleCBA>();
        for (Short item1 : frequent1) {
            RuleCBA rule = new RuleCBA();
            rule.add(item1);
            int j = 0;
            while (j < dataset.getClassesCount()) {
                short klass = dataset.getKlassAt(j);
                rule.setKlass(klass);
                RuleCBA newRule = new RuleCBA(rule);
                newRule.evaluate(dataset);
                if (newRule.getSupportRule() >= this.minSupRelative) {
                    levelX.add(newRule);
                    if (newRule.getConfidence() >= minConf) {
                        rules.add(newRule);
                    }
                }
                ++j;
            }
        }
        return levelX;
    }

    private List<Short> generateSingletons(Dataset dataset) {
        HashMap<Short, Long> mapItemCount = new HashMap<Short, Long>();
        for (Instance instance : dataset.getInstances()) {
            Short[] items = instance.getItems();
            int j = 0;
            while (j < items.length - 1) {
                short item = items[j];
                Long count = mapItemCount.getOrDefault(item, 0L);
                count = count + 1L;
                mapItemCount.put(item, count);
                ++j;
            }
        }
        ArrayList<Short> frequent1 = new ArrayList<Short>();
        for (Map.Entry entry : mapItemCount.entrySet()) {
            if ((Long)entry.getValue() < this.minSupRelative) continue;
            frequent1.add((Short)entry.getKey());
        }
        return frequent1;
    }

    protected boolean areSubsetsFrequents(RuleCBA candidate, List<RuleCBA> levelK1) {
        int positionToRemove = 0;
        while (positionToRemove < candidate.getAntecedent().size()) {
            boolean found = false;
            for (RuleCBA rule : levelK1) {
                if (this.sameAs(rule.getAntecedent(), candidate.getAntecedent(), positionToRemove) != 0) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            ++positionToRemove;
        }
        return true;
    }

    int sameAs(List<Short> itemset1, List<Short> itemsets2, int posRemoved) {
        int j = 0;
        int i = 0;
        while (i < itemset1.size()) {
            if (j == posRemoved) {
                ++j;
            }
            if (itemset1.get(i).equals(itemsets2.get(j))) {
                ++j;
            } else {
                if (itemset1.get(i) > itemsets2.get(j)) {
                    return 1;
                }
                return -1;
            }
            ++i;
        }
        return 0;
    }
}

