/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.adt;

import ca.pfv.spmf.algorithms.classifiers.adt.RuleADT;
import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class RuleExtractorADT {
    private double minConf;
    private Dataset dataset;

    public RuleExtractorADT(Dataset training, double minConf) {
        this.dataset = training;
        this.minConf = minConf;
    }

    public List<RuleADT> run() {
        int n;
        List<RuleADT> rules = this.generateK();
        List<Object> candidates = new ArrayList<RuleADT>();
        HashMap<RuleADT, Long> candidatesH = new HashMap<RuleADT, Long>();
        for (RuleADT ruleADT : rules) {
            List<Short> antecedent = ruleADT.getAntecedent();
            int j = 0;
            while (j < antecedent.size()) {
                ArrayList<Short> newAntecedent = new ArrayList<Short>(antecedent);
                newAntecedent.remove(j);
                RuleADT newRule = new RuleADT(newAntecedent, ruleADT.getKlass());
                if (!candidates.contains(newRule)) {
                    candidates.add(newRule);
                }
                ++j;
            }
        }
        for (RuleADT ruleADT : candidates) {
            ruleADT.calculateSupports(this.dataset);
        }
        candidates.removeIf(rule -> rule.getConfidence() < this.minConf);
        rules.addAll(candidates);
        do {
            n = ((RuleADT)candidates.get(0)).getAntecedent().size() - 1;
            for (RuleADT ruleADT : candidates) {
                List<Short> antecedent = ruleADT.getAntecedent();
                int j = 0;
                while (j < antecedent.size()) {
                    ArrayList<Short> newAntecedent = new ArrayList<Short>(antecedent);
                    newAntecedent.remove(j);
                    RuleADT newRule = new RuleADT(newAntecedent, ruleADT.getKlass());
                    Long count = candidatesH.getOrDefault(newRule, 0L);
                    candidatesH.put(newRule, count + 1L);
                    ++j;
                }
            }
            candidates = candidatesH.entrySet().stream().filter(candidate -> (Long)candidate.getValue() >= (long)k).map(candidate -> (RuleADT)candidate.getKey()).collect(Collectors.toList());
            candidatesH.clear();
            for (RuleADT ruleADT : candidates) {
                ruleADT.calculateSupports(this.dataset);
            }
            candidates.removeIf(rule -> rule.getConfidence() < this.minConf);
            rules.addAll(candidates);
        } while (n != 1 && !candidates.isEmpty() && ((RuleADT)candidates.get(0)).getAntecedent().size() > 1);
        return rules;
    }

    private List<RuleADT> generateK() {
        ArrayList<RuleADT> rules = new ArrayList<RuleADT>();
        HashMap<ArrayList<Short>, List> mapAntecedentToIndex = new HashMap<ArrayList<Short>, List>();
        for (Instance instance : this.dataset.getInstances()) {
            List indexAntecedents;
            Short[] antecedent = Arrays.copyOfRange(instance.getItems(), 0, this.dataset.getAttributes().size());
            ArrayList<Short> antecedentArray = new ArrayList<Short>(Arrays.asList(antecedent));
            short klass = instance.getKlass();
            RuleADT rule2 = new RuleADT(antecedent, klass);
            if (mapAntecedentToIndex.containsKey(antecedentArray) && rules.contains(rule2)) {
                indexAntecedents = mapAntecedentToIndex.getOrDefault(antecedent, new ArrayList());
                int index = rules.lastIndexOf(rule2);
                ((RuleADT)rules.get(index)).incrementSupportRule();
                ((RuleADT)rules.get(index)).incrementSupportAntecedent();
                int j = 0;
                while (j < indexAntecedents.size()) {
                    index = (Integer)indexAntecedents.get(j);
                    ((RuleADT)rules.get(index)).incrementSupportAntecedent();
                    ++j;
                }
                mapAntecedentToIndex.put(antecedentArray, indexAntecedents);
                continue;
            }
            rules.add(rule2);
            rule2.incrementSupportAntecedent();
            rule2.incrementSupportRule();
            indexAntecedents = mapAntecedentToIndex.getOrDefault(antecedent, new ArrayList());
            indexAntecedents.add(rules.size() - 1);
            mapAntecedentToIndex.put(antecedentArray, indexAntecedents);
        }
        rules.removeIf(rule -> rule.getConfidence() < this.minConf);
        return rules;
    }
}

