/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.adt;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.general.Rule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RuleADT
extends Rule
implements Serializable {
    private static final long serialVersionUID = -878688143431488747L;
    private long misses;
    private long hits;
    private List<Integer> coveredInstances;

    public RuleADT(Short[] antecedent, short klass) {
        super(antecedent, klass);
        this.coveredInstances = new ArrayList<Integer>();
        this.misses = 0L;
        this.hits = 0L;
    }

    public RuleADT(RuleADT rule) {
        super(rule.klass);
        this.add(rule.antecedent);
        this.supportAntecedent = rule.supportAntecedent;
        this.supportRule = rule.supportRule;
        this.misses = rule.misses;
        this.hits = rule.hits;
        this.coveredInstances = new ArrayList<Integer>(rule.coveredInstances);
    }

    public RuleADT(List<Short> newAntecedent, short klass) {
        super(klass);
        this.coveredInstances = new ArrayList<Integer>();
        this.antecedent = new ArrayList<Short>(newAntecedent);
        this.misses = 0L;
        this.hits = 0L;
    }

    public RuleADT(short klass) {
        super(klass);
        this.coveredInstances = new ArrayList<Integer>();
    }

    void addCoveredInstance(Integer tid) {
        this.coveredInstances.add(tid);
    }

    public double getPessimisticErrorEstimate() {
        return RuleADT.errors(this.hits + this.misses, this.misses) + (double)this.misses;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " hits: " + this.hits + " misses: " + this.misses + " per: " + this.getPessimisticErrorEstimate();
    }

    void calculateSupports(Dataset train) {
        this.supportAntecedent = 0L;
        this.supportRule = 0L;
        for (Instance instance : train.getInstances()) {
            Short[] items = instance.getItems();
            Boolean matchAntecedent = ArraysAlgos.isSubsetOf(this.antecedent, items);
            Boolean matchConsequent = instance.getKlass() == this.klass;
            if (!matchAntecedent.booleanValue()) continue;
            ++this.supportAntecedent;
            if (!matchConsequent.booleanValue()) continue;
            ++this.supportRule;
        }
    }

    void incrementMisses() {
        ++this.misses;
    }

    void incrementHits() {
        ++this.hits;
    }

    public List<Integer> getCoveredInstances() {
        return this.coveredInstances;
    }

    public double getMisses() {
        return this.misses;
    }

    public double getMerit() {
        double n = this.hits + this.misses;
        if (n <= 0.0) {
            return 0.0;
        }
        return (n - (double)this.misses) / n;
    }

    @Override
    public String getMeasuresToString() {
        return " #SUP: " + this.getSupportRule() + " #CONF: " + this.getConfidence() + " #MERIT: " + this.getMerit() + " #ERROR: " + this.getPessimisticErrorEstimate();
    }
}

