/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.acn;

import ca.pfv.spmf.algorithms.classifiers.acn.AprioriNegativeForACN;
import ca.pfv.spmf.algorithms.classifiers.acn.ClassifierACN;
import ca.pfv.spmf.algorithms.classifiers.acn.RuleACN;
import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.general.ClassificationAlgorithm;
import ca.pfv.spmf.algorithms.classifiers.general.RuleClassifier;
import java.util.List;

public class AlgoACN
extends ClassificationAlgorithm {
    private double minSup;
    private double minConf;
    private double minAcc;
    private double minCorr;

    public AlgoACN(double minSup, double minConf, double minAcc, double minCorr) {
        this.minSup = minSup;
        this.minConf = minConf;
        this.minAcc = minAcc;
        this.minCorr = minCorr;
    }

    @Override
    public RuleClassifier train(Dataset training) {
        AprioriNegativeForACN apriori = new AprioriNegativeForACN(training, this.minSup, this.minConf);
        List<RuleACN> rules = apriori.run();
        return new ClassifierACN(rules, training, this.minConf, this.minAcc, this.minCorr);
    }

    @Override
    public String getName() {
        return "ACN";
    }
}

