/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.accf;

import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.general.Rule;
import ca.pfv.spmf.algorithms.classifiers.general.RuleClassifier;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ClassifierACCF
extends RuleClassifier
implements Serializable {
    private static final long serialVersionUID = -8202761480378245086L;

    public ClassifierACCF(List<Rule> rules) {
        super("ACCF");
        Collections.sort(rules, new Comparator<Rule>(){

            @Override
            public int compare(Rule arg0, Rule arg1) {
                if (Double.compare(arg0.getConfidence(), arg1.getConfidence()) != 0) {
                    return -Double.compare(arg0.getConfidence(), arg1.getConfidence());
                }
                if (Double.compare(arg0.getSupportRule(), arg1.getSupportRule()) != 0) {
                    return -Double.compare(arg0.getSupportRule(), arg1.getSupportRule());
                }
                return -Integer.compare(arg0.size(), arg1.size());
            }
        });
        int i = 0;
        while (i < rules.size()) {
            this.add(rules.get(i));
            ++i;
        }
    }

    @Override
    public short predict(Instance instance) {
        Short[] example = instance.getItems();
        for (Rule rule : this.rules) {
            if (!rule.matching(example)) continue;
            return rule.getKlass();
        }
        for (Rule rule : this.rules) {
            List<Short> ruleAntecedent = rule.getAntecedent();
            if (!ClassifierACCF.hasNonEmptyIntersection(ruleAntecedent, example)) continue;
            return rule.getKlass();
        }
        return NOPREDICTION;
    }

    public static boolean hasNonEmptyIntersection(List<Short> antecedent, Short[] instance) {
        Short[] shortArray = instance;
        int n = instance.length;
        int n2 = 0;
        while (n2 < n) {
            Short item = shortArray[n2];
            if (antecedent.contains(item)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

