/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.accf;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.classifiers.accf.ItemsetACCF;
import ca.pfv.spmf.algorithms.classifiers.accf.RuleACCF;
import ca.pfv.spmf.algorithms.classifiers.accf.SupersetTable;
import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.general.Rule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CHARMForACCF {
    private Map<Short, BitSetSupport> klasses;
    private SupersetTable supersetTable;
    private List<Rule> rules;

    public List<Rule> run(Dataset dataset, double minSup, double minConf) {
        long minSupRelative = (long)Math.ceil(minSup * (double)dataset.getInstances().size());
        this.rules = new ArrayList<Rule>();
        this.supersetTable = new SupersetTable();
        this.klasses = new HashMap<Short, BitSetSupport>();
        final Map<Short, BitSetSupport> mapItemSingletons = this.generateSingletons(dataset);
        ArrayList<Short> frequentItems = new ArrayList<Short>();
        for (Map.Entry<Short, BitSetSupport> entry : mapItemSingletons.entrySet()) {
            Short item = entry.getKey();
            BitSetSupport bitset = entry.getValue();
            if (bitset.support < minSupRelative) continue;
            frequentItems.add(item);
        }
        Collections.sort(frequentItems, new Comparator<Short>(){

            @Override
            public int compare(Short arg0, Short arg1) {
                return (int)(((BitSetSupport)mapItemSingletons.get((Object)arg0)).support - ((BitSetSupport)mapItemSingletons.get((Object)arg1)).support);
            }
        });
        int i = 0;
        while (i < frequentItems.size()) {
            Short itemI = (Short)frequentItems.get(i);
            if (itemI != null) {
                BitSetSupport bitsetI = mapItemSingletons.get(itemI);
                Short[] itemsetI = new Short[]{itemI};
                ArrayList<Short[]> prefixedItems = new ArrayList<Short[]>();
                ArrayList<BitSetSupport> prefixedBitsets = new ArrayList<BitSetSupport>();
                int j = i + 1;
                while (j < frequentItems.size()) {
                    Short itemJ = (Short)frequentItems.get(j);
                    if (itemJ != null) {
                        BitSetSupport bitsetJ = mapItemSingletons.get(itemJ);
                        BitSetSupport bitsetUnion = this.and(bitsetI, bitsetJ);
                        if (bitsetUnion.support >= minSupRelative) {
                            Short[] union;
                            if (bitsetI.support == bitsetJ.support && bitsetUnion.support == bitsetI.support) {
                                frequentItems.set(j, null);
                                union = new Short[itemsetI.length + 1];
                                System.arraycopy(itemsetI, 0, union, 0, itemsetI.length);
                                union[itemsetI.length] = itemJ;
                                itemsetI = union;
                            } else if (bitsetI.support < bitsetJ.support && bitsetUnion.support == bitsetI.support) {
                                union = new Short[itemsetI.length + 1];
                                System.arraycopy(itemsetI, 0, union, 0, itemsetI.length);
                                union[itemsetI.length] = itemJ;
                                itemsetI = union;
                            } else if (bitsetI.support > bitsetJ.support && bitsetUnion.support == bitsetJ.support) {
                                frequentItems.set(j, null);
                                prefixedItems.add(new Short[]{itemJ});
                                prefixedBitsets.add(bitsetUnion);
                            } else {
                                prefixedItems.add(new Short[]{itemJ});
                                prefixedBitsets.add(bitsetUnion);
                            }
                        }
                    }
                    ++j;
                }
                if (prefixedItems.size() > 0) {
                    this.processPrefixedItems(itemsetI, prefixedItems, prefixedBitsets, minConf, minSupRelative);
                }
                this.generateRules(null, itemsetI, bitsetI, minConf);
            }
            ++i;
        }
        return this.rules;
    }

    private Map<Short, BitSetSupport> generateSingletons(Dataset dataset) {
        HashMap<Short, BitSetSupport> singletons = new HashMap<Short, BitSetSupport>();
        List<Instance> instances = dataset.getInstances();
        int i = 0;
        while (i < instances.size()) {
            Instance instance = instances.get(i);
            int j = 0;
            while (j < dataset.getAttributes().size()) {
                Short item = instance.getItems()[j];
                BitSetSupport tids = (BitSetSupport)singletons.get(item);
                if (tids == null) {
                    tids = new BitSetSupport();
                    singletons.put(item, tids);
                }
                tids.bitset.set(i);
                ++tids.support;
                ++j;
            }
            Short klass = instance.getKlass();
            BitSetSupport tids = this.klasses.get(klass);
            if (tids == null) {
                tids = new BitSetSupport();
                this.klasses.put(klass, tids);
            }
            tids.bitset.set(i);
            ++tids.support;
            ++i;
        }
        return singletons;
    }

    private void processPrefixedItems(Short[] prefix, List<Short[]> prefixedItemsets, List<BitSetSupport> prefixedBitsets, double minConf, double minSupRelative) {
        if (prefixedItemsets.size() == 1) {
            Short[] itemsetI = prefixedItemsets.get(0);
            BitSetSupport bitsetI = prefixedBitsets.get(0);
            this.generateRules(prefix, itemsetI, bitsetI, minConf);
            return;
        }
        if (prefixedItemsets.size() == 2) {
            Short[] itemsetI = prefixedItemsets.get(0);
            BitSetSupport bitsetI = prefixedBitsets.get(0);
            Short[] itemsetJ = prefixedItemsets.get(1);
            BitSetSupport bitsetJ = prefixedBitsets.get(1);
            BitSetSupport bitsetSupportIJ = this.and(bitsetI, bitsetJ);
            if ((double)bitsetSupportIJ.support >= minSupRelative) {
                Short[] suffixIJ = ArraysAlgos.concatenate(itemsetI, itemsetJ);
                this.generateRules(prefix, suffixIJ, bitsetSupportIJ, minConf);
            }
            if (bitsetSupportIJ.support != bitsetI.support) {
                this.generateRules(prefix, itemsetI, bitsetI, minConf);
            }
            if (bitsetSupportIJ.support != bitsetJ.support) {
                this.generateRules(prefix, itemsetJ, bitsetJ, minConf);
            }
            return;
        }
        int i = 0;
        while (i < prefixedItemsets.size()) {
            Short[] itemsetI = prefixedItemsets.get(i);
            if (itemsetI != null) {
                BitSetSupport bitsetI = prefixedBitsets.get(i);
                ArrayList<Short[]> prefixedIitemsets = new ArrayList<Short[]>();
                ArrayList<BitSetSupport> prefixedIBitsets = new ArrayList<BitSetSupport>();
                int j = i + 1;
                while (j < prefixedItemsets.size()) {
                    Short[] itemsetJ = prefixedItemsets.get(j);
                    if (itemsetJ != null) {
                        BitSetSupport bitsetJ = prefixedBitsets.get(j);
                        BitSetSupport bitsetUnion = this.and(bitsetI, bitsetJ);
                        if (!((double)bitsetUnion.support < minSupRelative)) {
                            Short[] union;
                            if (bitsetI.support == bitsetJ.support && bitsetUnion.support == bitsetI.support) {
                                prefixedItemsets.set(j, null);
                                prefixedBitsets.set(j, null);
                                union = ArraysAlgos.concatenate(itemsetI, itemsetJ);
                                itemsetI = union;
                            } else if (bitsetI.support < bitsetJ.support && bitsetUnion.support == bitsetI.support) {
                                union = ArraysAlgos.concatenate(itemsetI, itemsetJ);
                                itemsetI = union;
                            } else if (bitsetI.support > bitsetJ.support && bitsetUnion.support == bitsetJ.support) {
                                prefixedItemsets.set(j, null);
                                prefixedBitsets.set(j, null);
                                prefixedIitemsets.add(itemsetJ);
                                prefixedIBitsets.add(bitsetUnion);
                            } else {
                                prefixedIitemsets.add(itemsetJ);
                                prefixedIBitsets.add(bitsetUnion);
                            }
                        }
                    }
                    ++j;
                }
                if (prefixedIitemsets.size() > 0) {
                    Short[] newPrefix = ArraysAlgos.concatenate(prefix, itemsetI);
                    this.processPrefixedItems(newPrefix, prefixedIitemsets, prefixedIBitsets, minConf, minSupRelative);
                }
                this.generateRules(prefix, itemsetI, bitsetI, minConf);
            }
            ++i;
        }
    }

    private void generateRules(Short[] prefix, Short[] suffix, BitSetSupport bitset, double minConf) {
        Object[] items = prefix == null ? suffix : ArraysAlgos.concatenate(prefix, suffix);
        Arrays.sort(items);
        ItemsetACCF itemset2 = new ItemsetACCF((Short[])items, bitset.support);
        if (this.supersetTable.isSuperset(itemset2, bitset.bitset)) {
            for (Map.Entry<Short, BitSetSupport> klass : this.klasses.entrySet()) {
                BitSetSupport klassbitset = klass.getValue();
                long supportKlass = klassbitset.support;
                Short itemKlass = klass.getKey();
                BitSetSupport bitsetRule = this.and(bitset, klassbitset);
                RuleACCF rule = new RuleACCF((Short[])items, (short)itemKlass);
                rule.setSupportAntecedent(bitset.support);
                rule.setSupportRule(bitsetRule.support);
                rule.setSupportKlass(supportKlass);
                if (!(rule.getConfidence() >= minConf)) continue;
                this.rules.add(rule);
            }
            this.supersetTable.add(itemset2, bitset.bitset);
        }
    }

    private BitSetSupport and(BitSetSupport tidsetI, BitSetSupport tidsetJ) {
        BitSetSupport bitsetSupportIJ = new BitSetSupport();
        bitsetSupportIJ.bitset = (BitSet)tidsetI.bitset.clone();
        bitsetSupportIJ.bitset.and(tidsetJ.bitset);
        bitsetSupportIJ.support = bitsetSupportIJ.bitset.cardinality();
        return bitsetSupportIJ;
    }

    private class BitSetSupport {
        BitSet bitset = new BitSet();
        long support;

        private BitSetSupport() {
        }
    }
}

