/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.acac;

import ca.pfv.spmf.algorithms.classifiers.acac.RuleACAC;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.general.RuleClassifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassifierACAC
extends RuleClassifier
implements Serializable {
    private static final long serialVersionUID = -8555494816204669319L;

    public ClassifierACAC(List<RuleACAC> rules) {
        super("ACAC");
        this.rules.addAll(rules);
    }

    @Override
    public short predict(Instance rawInstance) {
        Short[] instance = rawInstance.getItems();
        ArrayList<RuleACAC> firedRules = new ArrayList<RuleACAC>();
        int i = 0;
        while (i < this.rules.size()) {
            RuleACAC rule = (RuleACAC)this.rules.get(i);
            if (rule.matching(instance)) {
                firedRules.add(rule);
            }
            ++i;
        }
        if (firedRules.isEmpty()) {
            return NOPREDICTION;
        }
        HashMap<Short, Double> mapStrengths = new HashMap<Short, Double>();
        HashMap rulesPerKlass = new HashMap();
        Short klass = ((RuleACAC)firedRules.get(0)).getKlass();
        for (RuleACAC firedRule : firedRules) {
            short ruleKlass = firedRule.getKlass();
            Double val = (Double)mapStrengths.get(ruleKlass);
            if (val == null) {
                mapStrengths.put(ruleKlass, 0.0);
                ArrayList<RuleACAC> list = new ArrayList<RuleACAC>();
                rulesPerKlass.put(ruleKlass, list);
                list.add(firedRule);
                continue;
            }
            ((List)rulesPerKlass.get(ruleKlass)).add(firedRule);
        }
        if (rulesPerKlass.size() == 1) {
            return klass;
        }
        double numberKlasses = rulesPerKlass.size();
        for (Map.Entry entry : rulesPerKlass.entrySet()) {
            klass = (Short)entry.getKey();
            List rules = (List)entry.getValue();
            double n = rules.size();
            double supAcc = 0.0;
            double numerator = 0.0;
            for (RuleACAC rule : rules) {
                double informationGain = -1.0 / (Math.log(numberKlasses) / Math.log(2.0));
                if (Double.isInfinite(informationGain)) {
                    informationGain = 0.0;
                }
                for (Map.Entry perKlass : rulesPerKlass.entrySet()) {
                    short klassI = (Short)perKlass.getKey();
                    double ruleSup = rule.getSupportByKlass(klassI);
                    double condsup = rule.getSupportAntecedent();
                    double pCiX = (ruleSup + 1.0) / (condsup + numberKlasses);
                    informationGain += pCiX * (Math.log(pCiX) / Math.log(2.0));
                }
                supAcc += (double)rule.getSupportAntecedent();
                numerator += (double)rule.getSupportAntecedent() * informationGain;
            }
            double strength = 0.9 * (1.0 - numerator / supAcc) + 0.1 * n / (double)firedRules.size();
            mapStrengths.put(klass, strength);
        }
        return (Short)Collections.max(mapStrengths.entrySet(), (entry1, entry2) -> ((Double)entry1.getValue()).compareTo((Double)entry2.getValue())).getKey();
    }
}

