/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.gcd;

import ca.pfv.spmf.algorithms.associationrules.gcd.Primes;
import ca.pfv.spmf.algorithms.associationrules.gcd.Transaction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DatTransformer {
    private Integer[] transRules;
    private List<Integer[]> inputFile = new ArrayList<Integer[]>();
    private Map<Integer, List<Transaction>> transactionSets = new TreeMap<Integer, List<Transaction>>();
    private double freqThreshold;
    private Integer freqThresholdPrime;
    private int rows = 0;

    public void cleanUP() {
        this.transRules = null;
        this.inputFile.clear();
        for (List<Transaction> set : this.transactionSets.values()) {
            set.clear();
        }
        this.transactionSets.clear();
    }

    public DatTransformer(List<String> inputLines, double freqThreshold) throws IOException, ClassNotFoundException {
        this.freqThreshold = freqThreshold;
        this.read(inputLines);
        this.transform();
    }

    public int getRowsCount() {
        return this.rows;
    }

    public double getFreqThreshold() {
        return this.freqThreshold;
    }

    public Integer[] primes2originals(List<Integer> primeFactors) {
        Integer[] translated = new Integer[primeFactors.size()];
        List<Integer> transRulesList = Arrays.asList(this.transRules);
        int i = 0;
        while (i < primeFactors.size()) {
            translated[i] = transRulesList.indexOf(primeFactors.get(i));
            ++i;
        }
        return translated;
    }

    private void transform() throws IOException, ClassNotFoundException {
        for (Object[] objectArray : this.inputFile) {
            int i = 0;
            while (i < objectArray.length) {
                objectArray[i] = this.transRules[(Integer)objectArray[i]];
                ++i;
            }
            Arrays.sort(objectArray);
            Object primeSet_key = objectArray[0];
            if ((Integer)primeSet_key > this.freqThresholdPrime) continue;
            List<Transaction> list = this.transactionSets.get(primeSet_key);
            if (list == null) {
                list = new ArrayList<Transaction>();
                this.transactionSets.put((Integer)primeSet_key, list);
            }
            list.add(new Transaction((Integer[])objectArray));
        }
        this.removeRepeatedTransactions();
        System.gc();
    }

    private void removeRepeatedTransactions() {
        HashMap<Integer, List<Transaction>> nonObsoleteTransactionSets = new HashMap<Integer, List<Transaction>>();
        for (Map.Entry<Integer, List<Transaction>> entry : this.transactionSets.entrySet()) {
            Integer prime = entry.getKey();
            List<Transaction> set = entry.getValue();
            Collections.sort(set);
            int setSize = set.size();
            int i = setSize - 1;
            while (i > 0) {
                Transaction lastTransaction;
                Transaction transaction = set.get(i);
                if (transaction.equals(lastTransaction = set.get(i - 1))) {
                    int newFrequency = transaction.getFrequency() + 1;
                    lastTransaction.setFrequency(newFrequency);
                    transaction.makeObsolete();
                }
                --i;
            }
            ArrayList<Transaction> nonObsoleteTransactionSet = new ArrayList<Transaction>();
            int i2 = 0;
            while (i2 < setSize) {
                Transaction transaction = set.get(i2);
                if (!transaction.isObsolete()) {
                    nonObsoleteTransactionSet.add(transaction);
                }
                ++i2;
            }
            if (nonObsoleteTransactionSet.isEmpty()) continue;
            nonObsoleteTransactionSets.put(prime, nonObsoleteTransactionSet);
        }
        this.transactionSets = nonObsoleteTransactionSets;
    }

    private void read(List<String> inputLines) throws IOException {
        HashMap<Integer, Integer> freqs = new HashMap<Integer, Integer>();
        int cols = 0;
        for (String line : inputLines) {
            ++this.rows;
            String[] tokens = line.split("\\s+");
            Integer[] integerArray = new Integer[tokens.length];
            int i = 0;
            while (i < tokens.length) {
                String token = tokens[i];
                int number = Integer.parseInt(token);
                integerArray[i] = number;
                Integer freq = (Integer)freqs.get(number);
                if (freq != null) {
                    int newValue = freq + 1;
                    freqs.put(number, newValue);
                } else {
                    freqs.put(number, 1);
                }
                if (number > cols) {
                    cols = number;
                }
                ++i;
            }
            this.inputFile.add(integerArray);
        }
        this.freqThreshold *= (double)this.rows;
        System.out.println("Minimum item frequency is: " + (int)this.freqThreshold);
        Set entries = freqs.entrySet();
        ArrayList sortedEntries = new ArrayList(entries);
        Collections.sort(sortedEntries, new Comparator<Map.Entry<Integer, Integer>>(){

            @Override
            public int compare(Map.Entry<Integer, Integer> o1, Map.Entry<Integer, Integer> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        this.transRules = new Integer[cols + 1];
        Primes primes = Primes.getInstance();
        for (Map.Entry entry : sortedEntries) {
            this.transRules[((Integer)entry.getKey()).intValue()] = primes.getNextPrime();
            if (this.freqThresholdPrime != null || !((double)((Integer)entry.getValue()).intValue() < this.freqThreshold)) continue;
            this.freqThresholdPrime = this.transRules[(Integer)entry.getKey()];
        }
        if (this.freqThresholdPrime == null) {
            this.freqThresholdPrime = Integer.MAX_VALUE;
        }
        Transaction.setMaxPrimeThreshold(this.freqThresholdPrime);
    }

    public Map<Integer, List<Transaction>> getTransactionSets() {
        return this.transactionSets;
    }
}

