/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.spam.AlgoVMSP;
import java.io.IOException;

public class DescriptionAlgoVMSP
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "VMSP";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/VMSP.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        AlgoVMSP algo = new AlgoVMSP();
        if (parameters.length >= 2 && !"".equals(parameters[1])) {
            algo.setMaximumPatternLength(DescriptionAlgoVMSP.getParamAsInteger(parameters[1]));
        }
        if (parameters.length >= 3 && !"".equals(parameters[2])) {
            algo.setMaxGap(DescriptionAlgoVMSP.getParamAsInteger(parameters[2]));
        }
        if (parameters.length >= 4 && !"".equals(parameters[3])) {
            boolean outputSeqIdentifiers = DescriptionAlgoVMSP.getParamAsBoolean(parameters[3]);
            algo.showSequenceIdentifiersInOutput(outputSeqIdentifiers);
        }
        algo.runAlgorithm(inputFile, outputFile, DescriptionAlgoVMSP.getParamAsDouble(parameters[0]));
        algo.printStatistics();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.5 or 50%)", Double.class, false), new DescriptionOfParameter("Max pattern length", "(e.g. 4 items)", Integer.class, true), new DescriptionOfParameter("Max gap", "(e.g. 1 item)", Integer.class, true), new DescriptionOfParameter("Show sequence ids?", "(default: false)", Boolean.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple sequence database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential patterns", "Frequent sequential patterns", "Frequent maximal sequential patterns"};
    }
}

