/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.vme.AlgoVME;
import java.io.IOException;

public class DescriptionAlgoVME
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "VME";
    }

    @Override
    public String getAlgorithmCategory() {
        return "FREQUENT ITEMSET MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/vme.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double threshold = DescriptionAlgoVME.getParamAsDouble(parameters[0]);
        AlgoVME algo = new AlgoVME();
        if (parameters.length >= 2 && !"".equals(parameters[1])) {
            algo.setMaximumPatternLength(DescriptionAlgoVME.getParamAsInteger(parameters[1]));
        }
        algo.runAlgorithm(inputFile, outputFile, threshold);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Threshold (%)", "(e.g. 0.15 or 15%)", Double.class, false), new DescriptionOfParameter("Max pattern length", "(e.g. 2 items)", Integer.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with profit information"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Frequent patterns", "Erasable patterns", "Erasable itemsets"};
    }
}

