/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.uspan.AlgoUSpan;
import java.io.IOException;

public class DescriptionAlgoUSpan
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "USpan";
    }

    @Override
    public String getAlgorithmCategory() {
        return "HIGH-UTILITY PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/USpan.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        AlgoUSpan algo = new AlgoUSpan();
        if (parameters.length >= 2 && !"".equals(parameters[1])) {
            algo.setMaxPatternLength(DescriptionAlgoUSpan.getParamAsInteger(parameters[1]));
        }
        algo.runAlgorithm(inputFile, outputFile, DescriptionAlgoUSpan.getParamAsInteger(parameters[0]));
        algo.printStatistics();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minimum utility", "(e.g. 35)", Integer.class, false), new DescriptionOfParameter("Maximum length", "(e.g. 4)", Integer.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Sequence Database with utility values"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "High-utility patterns", "Sequential patterns", "High-utility patterns", "High-utility sequential patterns"};
    }
}

