/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequential_rules.topseqrules_and_tns.AlgoTopSeqRules;
import ca.pfv.spmf.input.sequence_database_array_integers.SequenceDatabase;
import java.io.IOException;

public class DescriptionAlgoTopSeqRules
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "TopSeqRules";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL RULE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/TopSeqRules.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int k = DescriptionAlgoTopSeqRules.getParamAsInteger(parameters[0]);
        double minconf = DescriptionAlgoTopSeqRules.getParamAsDouble(parameters[1]);
        SequenceDatabase sequenceDatabase = new SequenceDatabase();
        sequenceDatabase.loadFile(inputFile);
        AlgoTopSeqRules algo = new AlgoTopSeqRules();
        if (parameters.length >= 3 && !"".equals(parameters[2])) {
            algo.setMaxAntecedentSize(DescriptionAlgoTopSeqRules.getParamAsInteger(parameters[2]));
        }
        if (parameters.length >= 4 && !"".equals(parameters[3])) {
            algo.setMaxConsequentSize(DescriptionAlgoTopSeqRules.getParamAsInteger(parameters[3]));
        }
        algo.runAlgorithm(k, sequenceDatabase, minconf);
        algo.printStats();
        algo.writeResultTofile(outputFile);
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("k", "(e.g. 3 patterns)", Integer.class, false), new DescriptionOfParameter("Minconf (%)", "(e.g. 0.8 or 80%)", Double.class, false), new DescriptionOfParameter("Max antecedent size", "(e.g. 1 items)", Integer.class, true), new DescriptionOfParameter("Max consequent size", "(e.g. 2 items)", Integer.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple sequence database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential rules", "Top-k frequent sequential rules"};
    }
}

