/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.associationrules.TopKRules_and_TNR.AlgoTopKRules;
import ca.pfv.spmf.algorithms.associationrules.TopKRules_and_TNR.Database;
import java.io.IOException;

public class DescriptionAlgoTopKRules
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "TopKRules";
    }

    @Override
    public String getAlgorithmCategory() {
        return "ASSOCIATION RULE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/TopKAssociationRules.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        Database database = new Database();
        database.loadFile(inputFile);
        int k = DescriptionAlgoTopKRules.getParamAsInteger(parameters[0]);
        double minconf = DescriptionAlgoTopKRules.getParamAsDouble(parameters[1]);
        AlgoTopKRules algo = new AlgoTopKRules();
        if (parameters.length >= 3 && !"".equals(parameters[2])) {
            algo.setMaxAntecedentSize(DescriptionAlgoTopKRules.getParamAsInteger(parameters[2]));
        }
        if (parameters.length >= 4 && !"".equals(parameters[3])) {
            algo.setMaxConsequentSize(DescriptionAlgoTopKRules.getParamAsInteger(parameters[3]));
        }
        algo.runAlgorithm(k, minconf, database);
        algo.printStats();
        algo.writeResultTofile(outputFile);
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("k", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("Minconf (%)", "(e.g. 0.8 or 80%)", Double.class, false), new DescriptionOfParameter("Max antecedent size", "(e.g. 1 items)", Integer.class, true), new DescriptionOfParameter("Max consequent size", "(e.g. 2 items)", Integer.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Association rules", "Top-k association rules"};
    }
}

