/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.associationrules.TopKRules_and_TNR.AlgoTopKClassRules;
import ca.pfv.spmf.algorithms.associationrules.TopKRules_and_TNR.Database;
import java.io.IOException;

public class DescriptionAlgoTopKClassRules
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "TopKClassRules";
    }

    @Override
    public String getAlgorithmCategory() {
        return "ASSOCIATION RULE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/TopKAClassAssociationRules.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        Database database = new Database();
        database.loadFile(inputFile);
        int k = DescriptionAlgoTopKClassRules.getParamAsInteger(parameters[0]);
        double minconf = DescriptionAlgoTopKClassRules.getParamAsDouble(parameters[1]);
        AlgoTopKClassRules algo = new AlgoTopKClassRules();
        String[] itemsString = parameters[2].split(",");
        int[] requiredItems = new int[itemsString.length];
        int i = 0;
        while (i < itemsString.length) {
            requiredItems[i] = Integer.parseInt(itemsString[i]);
            ++i;
        }
        if (parameters.length >= 4 && !"".equals(parameters[3])) {
            algo.setMaxAntecedentSize(DescriptionAlgoTopKClassRules.getParamAsInteger(parameters[3]));
        }
        if (parameters.length >= 5 && !"".equals(parameters[4])) {
            algo.setMaxSupport(DescriptionAlgoTopKClassRules.getParamAsDouble(parameters[4]));
        }
        algo.runAlgorithm(k, minconf, database, requiredItems);
        algo.printStats();
        algo.writeResultTofile(outputFile);
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("k", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("Minconf (%)", "(e.g. 0.8 or 80%)", Double.class, false), new DescriptionOfParameter("Fixed consequent items", "(e.g. 1,2,3)", String.class, false), new DescriptionOfParameter("Max antecedent size", "(e.g. 1 items)", Integer.class, true), new DescriptionOfParameter("Maxsup (%)", "(e.g. 0.8 or 80%)", Double.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Association rules", "Top-k class association rules"};
    }
}

