/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.episodes.tup.tup_preinsertion.AlgoTUP_preinsertion;
import java.io.IOException;

public class DescriptionAlgoTUP_Preinsertion
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "TUP_Preinsertion";
    }

    @Override
    public String getAlgorithmCategory() {
        return "EPISODE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/TUP.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int maxTimeDuration = DescriptionAlgoTUP_Preinsertion.getParamAsInteger(parameters[0]);
        int k = DescriptionAlgoTUP_Preinsertion.getParamAsInteger(parameters[1]);
        AlgoTUP_preinsertion algo = new AlgoTUP_preinsertion();
        algo.runAlgorithm(inputFile, maxTimeDuration, k);
        algo.writeResultTofile(outputFile);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Max. Time duration", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("k", "(e.g. 3)", Integer.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Rathore et al.";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Episodes", "High-utility patterns", "High-Utility episodes", "Top-k High-Utility episodes"};
    }
}

