/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.sppgrowth.AlgoTSPIN;
import java.io.IOException;

public class DescriptionAlgoTSPIN
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "TSPIN";
    }

    @Override
    public String getAlgorithmCategory() {
        return "PERIODIC PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/TSPIN_periodic.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int maxPer = DescriptionAlgoTSPIN.getParamAsInteger(parameters[0]);
        int k = DescriptionAlgoTSPIN.getParamAsInteger(parameters[1]);
        int maxLA = DescriptionAlgoTSPIN.getParamAsInteger(parameters[2]);
        boolean noTimestamps = DescriptionAlgoTSPIN.getParamAsBoolean(parameters[3]);
        AlgoTSPIN algo = new AlgoTSPIN(maxPer, maxLA, k, noTimestamps);
        algo.runAlgorithm(inputFile, outputFile);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Maximum periodicity", "(e.g. 5 transactions)", Integer.class, false), new DescriptionOfParameter("k", "(e.g. 3)", Integer.class, false), new DescriptionOfParameter("Maximum lability", "(e.g. 1)", Integer.class, false), new DescriptionOfParameter("Has no timestamps?", "(e.g. false)", Boolean.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Ying Wang and Peng Yang and Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Frequent patterns", "Periodic patterns", "Periodic frequent patterns", "Top-k   Stable Periodic frequent itemsets"};
    }
}

