/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.tkuce.AlgoTKUCEP;
import java.io.IOException;

public class DescriptionAlgoTKUCEP
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "TKU-CEP";
    }

    @Override
    public String getAlgorithmCategory() {
        return "HIGH-UTILITY PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/top-k-TKUCEP.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int k = DescriptionAlgoTKUCEP.getParamAsInteger(parameters[0]);
        AlgoTKUCEP algo = new AlgoTKUCEP();
        algo.runAlgorithm(inputFile, outputFile, k);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("k", "(e.g. 3)", Integer.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Song et al.";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "High-utility patterns", "High-utility itemsets", "Top-k High-utility itemsets"};
    }
}

