/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.fhuqiminer.EnumCombination;
import ca.pfv.spmf.algorithms.frequentpatterns.fhuqiminer.tkq.AlgoTKQ;
import java.io.File;
import java.io.IOException;

public class DescriptionAlgoTKQ
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "TKQ";
    }

    @Override
    public String getAlgorithmCategory() {
        return "HIGH-UTILITY PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/tkq_quantitative_top_k.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        String inputProfitFile = DescriptionAlgoTKQ.getParamAsString(parameters[0]);
        File file = new File(inputFile);
        if (file.getParent() != null) {
            inputProfitFile = String.valueOf(file.getParent()) + File.separator + inputProfitFile;
        }
        int k = DescriptionAlgoTKQ.getParamAsInteger(parameters[1]);
        int relativeCoefficient = DescriptionAlgoTKQ.getParamAsInteger(parameters[2]);
        EnumCombination method = EnumCombination.valueOf(DescriptionAlgoTKQ.getParamAsString(parameters[3]));
        AlgoTKQ algo = new AlgoTKQ();
        algo.runAlgorithm(k, inputFile, inputProfitFile, relativeCoefficient, method, outputFile);
        algo.printStatistics();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Profit table", "(e.g. dbHUQI_p.txt)", String.class, false), new DescriptionOfParameter("k", "(e.g. 15)", Integer.class, false), new DescriptionOfParameter("Relative coefficient", "(e.g. 3)", Integer.class, false), new DescriptionOfParameter("Method", "(e.g. COMBINEALL)", String.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Nouioua et al.";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values (HUQI)"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "High-utility patterns", "Quantitative high utility itemsets"};
    }
}

