/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.episodes.emma.AlgoTKE;
import java.io.IOException;

public class DescriptionAlgoTKE
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "TKE";
    }

    @Override
    public String getAlgorithmCategory() {
        return "EPISODE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/TKEepisodes.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int k = DescriptionAlgoTKE.getParamAsInteger(parameters[0]);
        int maxWindow = DescriptionAlgoTKE.getParamAsInteger(parameters[1]);
        boolean selftIncrement = DescriptionAlgoTKE.getParamAsBoolean(parameters[2]);
        AlgoTKE algo = new AlgoTKE();
        algo.runAlgorithm(inputFile, outputFile, k, maxWindow, selftIncrement);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("k", "(e.g. 6)", Integer.class, false), new DescriptionOfParameter("Max. Time duration", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("Has no timestamps?", "(default: false)", Boolean.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Yang Peng, Philippe Fournier-Viger, Yanjun Yang";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with timestamps"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Episodes", "Frequent episodes", "Top-k frequent episodes"};
    }
}

