/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.skopus.AlgoSkopus;

public class DescriptionAlgoSkopus
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "SKOPUS";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/SKOPUS.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws Exception {
        int k = DescriptionAlgoSkopus.getParamAsInteger(parameters[0]);
        boolean useLeverageMeasureInsteadOfSupport = DescriptionAlgoSkopus.getParamAsBoolean(parameters[1]);
        int maximumSequentialPatternLength = DescriptionAlgoSkopus.getParamAsInteger(parameters[2]);
        boolean useSmoothedValues = DescriptionAlgoSkopus.getParamAsBoolean(parameters[3]);
        double smoothingCoefficient = 0.0;
        if (parameters.length >= 5 && !"".equals(parameters[4])) {
            smoothingCoefficient = DescriptionAlgoSkopus.getParamAsDouble(parameters[4]);
        }
        AlgoSkopus algorithm = new AlgoSkopus();
        algorithm.runAlgorithm(inputFile, outputFile, useLeverageMeasureInsteadOfSupport, false, useSmoothedValues, smoothingCoefficient, maximumSequentialPatternLength, k);
        algorithm.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("k ", "(e.g. 5 patterns)", Double.class, false), new DescriptionOfParameter("Use leverage?", "(e.g. true)", Boolean.class, false), new DescriptionOfParameter("Max pattern length", "(e.g. 10 items)", Integer.class, false), new DescriptionOfParameter("Use smoothed value?", "(e.g. true)", Boolean.class, false), new DescriptionOfParameter("Smoothing coefficient", "(e.g. 0.5)", Double.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Petijean et al.";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple sequence database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential patterns", "Top-k frequent sequential patterns with leverage"};
    }
}

