/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.rpgrowth.AlgoRPGrowth;
import java.io.IOException;

public class DescriptionAlgoRPGrowth
extends DescriptionOfAlgorithm {
    @Override
    public String getImplementationAuthorNames() {
        return "Ryan Benton and Blake Johns";
    }

    @Override
    public String getName() {
        return "RPGrowth_itemsets";
    }

    @Override
    public String getAlgorithmCategory() {
        return "FREQUENT ITEMSET MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/rpgrowthalgo.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoRPGrowth.getParamAsDouble(parameters[0]);
        double minraresup = DescriptionAlgoRPGrowth.getParamAsDouble(parameters[1]);
        AlgoRPGrowth algorithm = new AlgoRPGrowth();
        if (parameters.length >= 3 && !"".equals(parameters[2])) {
            algorithm.setMaximumPatternLength(DescriptionAlgoRPGrowth.getParamAsInteger(parameters[2]));
        }
        if (parameters.length >= 4 && !"".equals(parameters[3])) {
            algorithm.setMinimumPatternLength(DescriptionAlgoRPGrowth.getParamAsInteger(parameters[3]));
        }
        algorithm.runAlgorithm(inputFile, outputFile, minsup, minraresup);
        algorithm.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.6 or 60%)", Double.class, false), new DescriptionOfParameter("Minraresup (%)", "(e.g. 0.1 or 10%)", Double.class, false), new DescriptionOfParameter("Max pattern length", "(e.g. 2 items)", Integer.class, true), new DescriptionOfParameter("Min pattern length", "(e.g. 2 items)", Integer.class, true)};
        return parameters;
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Frequent patterns", "Frequent itemsets"};
    }
}

