/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.episodes.poerm.AlgoPOERMAll;
import java.io.IOException;

public class DescriptionAlgoPOERM_ALL
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "POERMALL";
    }

    @Override
    public String getAlgorithmCategory() {
        return "EPISODE RULE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/POERM_episode_rules.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minSupport = DescriptionAlgoPOERM_ALL.getParamAsInteger(parameters[0]);
        int xSpan = DescriptionAlgoPOERM_ALL.getParamAsInteger(parameters[1]);
        int ySpan = DescriptionAlgoPOERM_ALL.getParamAsInteger(parameters[2]);
        double minConfidence = DescriptionAlgoPOERM_ALL.getParamAsDouble(parameters[3]);
        int xySpan = DescriptionAlgoPOERM_ALL.getParamAsInteger(parameters[4]);
        boolean selftIncrement = DescriptionAlgoPOERM_ALL.getParamAsBoolean(parameters[5]);
        AlgoPOERMAll poerm = new AlgoPOERMAll();
        poerm.runAlgorithm(inputFile, minSupport, xSpan, ySpan, minConfidence, xySpan, selftIncrement);
        poerm.writeRule2File(outputFile);
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minimum Support", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("XSpan?", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("YSpan?", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("Minimum confidence?", "(e.g. 0.5)", Double.class, false), new DescriptionOfParameter("XYSpan?", "(e.g. 3)", Integer.class, false), new DescriptionOfParameter("Without timestamps?", "(default: false)", Boolean.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Chen YangMing, Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with timestamps"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Episode rules", "Frequent episode rules"};
    }
}

