/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.AlgoPHM;
import java.io.IOException;

public class DescriptionAlgoPHM_irregular
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "PHM_irregular";
    }

    @Override
    public String getAlgorithmCategory() {
        return "HIGH-UTILITY PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/PHM_irregular.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minutil = DescriptionAlgoPHM_irregular.getParamAsInteger(parameters[0]);
        int regularityThreshold = DescriptionAlgoPHM_irregular.getParamAsInteger(parameters[1]);
        AlgoPHM algo = new AlgoPHM();
        if (parameters.length >= 3 && !"".equals(parameters[5])) {
            algo.setMinimumLength(DescriptionAlgoPHM_irregular.getParamAsInteger(parameters[5]));
        }
        if (parameters.length >= 4 && !"".equals(parameters[6])) {
            algo.setMaximumLength(DescriptionAlgoPHM_irregular.getParamAsInteger(parameters[6]));
        }
        algo.runAlgorithmIrregular(inputFile, outputFile, minutil, regularityThreshold);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minimum utility", "(e.g. 20)", Integer.class, false), new DescriptionOfParameter("Regularity threshold", "(e.g. 2 transactions)", Integer.class, false), new DescriptionOfParameter("Minimum number of items", "(e.g. 1 items)", Integer.class, true), new DescriptionOfParameter("Maximum number of items", "(e.g. 5 items)", Integer.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Periodic patterns", "High-utility patterns", "Periodic frequent patterns", "Periodic high-utility itemsets"};
    }
}

