/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.occur.AlgoOccur;
import java.io.File;
import java.io.IOException;

public class DescriptionAlgoOccur
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "OCCUR";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/OCCUR.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        String patternFile = DescriptionAlgoOccur.getParamAsString(parameters[0]);
        File file = new File(inputFile);
        patternFile = file.getParent() == null ? parameters[0] : String.valueOf(file.getParent()) + File.separator + parameters[0];
        AlgoOccur algo = new AlgoOccur();
        algo.runAlgorithm(inputFile, patternFile, outputFile);
        algo.printStatistics();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Pattern file", "(e.g. spmPatterns.txt)", String.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Sequential patterns"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential patterns", "Frequent sequential patterns with occurrences"};
    }
}

