/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.opusminer.AlgoOpusMiner;
import java.io.IOException;

public class DescriptionAlgoOPUSMiner
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "OPUS-Miner";
    }

    @Override
    public String getAlgorithmCategory() {
        return "FREQUENT ITEMSET MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/OPUSMINER.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int k = DescriptionAlgoOPUSMiner.getParamAsInteger(parameters[0]);
        boolean filter = DescriptionAlgoOPUSMiner.getParamAsBoolean(parameters[1]);
        boolean searchByLift = DescriptionAlgoOPUSMiner.getParamAsBoolean(parameters[2]);
        boolean redundancyTests = DescriptionAlgoOPUSMiner.getParamAsBoolean(parameters[3]);
        boolean correctionForMultiCompare = DescriptionAlgoOPUSMiner.getParamAsBoolean(parameters[4]);
        boolean printClosure = DescriptionAlgoOPUSMiner.getParamAsBoolean(parameters[5]);
        AlgoOpusMiner algorithm = new AlgoOpusMiner();
        algorithm.runAlgorithm(inputFile, outputFile, printClosure, filter, k, searchByLift, correctionForMultiCompare, redundancyTests, false);
        algorithm.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("k", "(e.g. 3)", Integer.class, false), new DescriptionOfParameter("Check independency?", "(e.g. true)", Boolean.class, false), new DescriptionOfParameter("Search by lift?", "(e.g. true)", Boolean.class, false), new DescriptionOfParameter("Check redundancy?", "(e.g. true)", Boolean.class, false), new DescriptionOfParameter("Correction for multicompare?", "(e.g. true)", Boolean.class, false), new DescriptionOfParameter("Print closure?", "(e.g. false)", Boolean.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Java conversion by Xiang Li and Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Frequent patterns", "Frequent itemsets", "Self-Sufficient Itemsets"};
    }
}

