/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.clustering.optics.AlgoOPTICS;
import java.io.IOException;

public class DescriptionAlgoOPTICSDBScanCluster
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "OPTICS-dbscan-clusters";
    }

    @Override
    public String getAlgorithmCategory() {
        return "CLUSTERING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/Optics.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minPts = DescriptionAlgoOPTICSDBScanCluster.getParamAsInteger(parameters[0]);
        double epsilon = DescriptionAlgoOPTICSDBScanCluster.getParamAsDouble(parameters[1]);
        double epsilonPrime = DescriptionAlgoOPTICSDBScanCluster.getParamAsDouble(parameters[2]);
        String separator = parameters.length > 3 && !"".equals(parameters[3]) ? DescriptionAlgoOPTICSDBScanCluster.getParamAsString(parameters[3]) : " ";
        AlgoOPTICS algo = new AlgoOPTICS();
        algo.computerClusterOrdering(inputFile, minPts, epsilon, separator);
        algo.extractDBScan(minPts, epsilonPrime);
        algo.printStatistics();
        algo.saveToFile(outputFile);
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("minPts", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("epsilon", "(e.g. 2)", Double.class, false), new DescriptionOfParameter("epsilonPrime", "(e.g. 5)", Double.class, false), new DescriptionOfParameter("separator", "(default: ' ')", String.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Database of double vectors"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Clusters", "Density-based clusters"};
    }
}

