/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.clustering.optics.AlgoOPTICS;
import java.io.IOException;

public class DescriptionAlgoOPTICSClusterOrdering
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "OPTICS-cluster-ordering";
    }

    @Override
    public String getAlgorithmCategory() {
        return "CLUSTERING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/Optics.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minPts = DescriptionAlgoOPTICSClusterOrdering.getParamAsInteger(parameters[0]);
        double epsilon = DescriptionAlgoOPTICSClusterOrdering.getParamAsDouble(parameters[1]);
        String separator = parameters.length > 2 && !"".equals(parameters[2]) ? DescriptionAlgoOPTICSClusterOrdering.getParamAsString(parameters[2]) : " ";
        AlgoOPTICS algo = new AlgoOPTICS();
        algo.computerClusterOrdering(inputFile, minPts, epsilon, separator);
        algo.printStatistics();
        algo.saveClusterOrderingToFile(outputFile);
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("minPts", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("epsilon", "(e.g. 2)", Double.class, false), new DescriptionOfParameter("separator", "(default: ' ')", String.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Database of double vectors"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Density-based cluster ordering of points"};
    }
}

