/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.AlgoMLHUIMiner;
import java.io.File;
import java.io.IOException;

public class DescriptionAlgoMLHUIMiner
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "MLHUIMiner";
    }

    @Override
    public String getAlgorithmCategory() {
        return "HIGH-UTILITY PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/MLHUIMiner_cross.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minutil = DescriptionAlgoMLHUIMiner.getParamAsDouble(parameters[0]);
        String taxonomyFilename = parameters[1];
        File file = new File(inputFile);
        String taxonomyPath = file.getParent() == null ? taxonomyFilename : String.valueOf(file.getParent()) + File.separator + taxonomyFilename;
        AlgoMLHUIMiner algo = new AlgoMLHUIMiner();
        algo.runAlgorithm(inputFile, taxonomyPath, outputFile, minutil);
        algo.printStatistics();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("minutil", "(e.g. 60)", Double.class, false), new DescriptionOfParameter("taxonomy file", "(e.g. taxonomy_CLHMiner.txt)", String.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Fournier-Viger et al.";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values", "Transaction database with taxonomy"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "High-utility patterns", "High-utility itemsets", "Multi-Level High-utility itemsets"};
    }
}

