/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.episodes.minepiplus.AlgoMINEPIPlus;
import java.io.IOException;

public class DescriptionAlgoMINEPIPlus
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "MINEPI+";
    }

    @Override
    public String getAlgorithmCategory() {
        return "EPISODE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/MINEPI_PLUS_EPISODE.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minSup = DescriptionAlgoMINEPIPlus.getParamAsInteger(parameters[0]);
        int maxWindow = DescriptionAlgoMINEPIPlus.getParamAsInteger(parameters[1]);
        boolean selftIncrement = DescriptionAlgoMINEPIPlus.getParamAsBoolean(parameters[2]);
        AlgoMINEPIPlus algo = new AlgoMINEPIPlus();
        algo.runAlgorithm(inputFile, outputFile, minSup, maxWindow, selftIncrement);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minimum support", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("Max. Time duration", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("Has no timestamps?", "(default: false)", Boolean.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Yang Peng";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with timestamps"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Episodes", "Frequent episodes"};
    }
}

