/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.lppm.AlgoLPPMBreadth2;
import java.io.IOException;

public class DescriptionAlgoLPPMBreadth
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "LPPM_breadth";
    }

    @Override
    public String getAlgorithmCategory() {
        return "PERIODIC PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/Local-periodic.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int maxPer = DescriptionAlgoLPPMBreadth.getParamAsInteger(parameters[0]);
        int minDur = DescriptionAlgoLPPMBreadth.getParamAsInteger(parameters[1]);
        int maxSoPer = DescriptionAlgoLPPMBreadth.getParamAsInteger(parameters[2]);
        boolean noTimestamps = DescriptionAlgoLPPMBreadth.getParamAsBoolean(parameters[3]);
        AlgoLPPMBreadth2 algo = new AlgoLPPMBreadth2();
        algo.runAlgorithm(inputFile, outputFile, maxPer, minDur, maxSoPer, noTimestamps);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Maximum periodicity", "(e.g. 3 transactions)", Integer.class, false), new DescriptionOfParameter("Minimum duration", "(e.g. 7 transactions)", Integer.class, false), new DescriptionOfParameter("Maximum Spillover", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("Has no timestamps?", "(e.g. true)", Boolean.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Peng Yang and Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Frequent patterns", "Periodic patterns", "Periodic frequent patterns", "Local Periodic frequent itemsets"};
    }
}

