/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.goKrimp.AlgoGoKrimp;
import ca.pfv.spmf.algorithms.sequentialpatterns.goKrimp.DataReader;
import java.io.File;
import java.io.IOException;

public class DescriptionAlgoGoKrimp
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "GoKrimp";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/GoKrimp.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        String labelFilePath = "";
        if (parameters.length >= 1 && !"".equals(parameters[0])) {
            File file;
            labelFilePath = parameters[0];
            labelFilePath = labelFilePath == null ? "" : ((file = new File(inputFile)).getParent() == null ? parameters[0] : String.valueOf(file.getParent()) + File.separator + parameters[0]);
        }
        DataReader d = new DataReader();
        AlgoGoKrimp g = d.readData_SPMF(inputFile, labelFilePath);
        g.setOutputFilePath(outputFile);
        g.gokrimp();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Label file name ", "(e.g. test_goKrimp.lab)", String.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Hoang Thanh Lam";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple sequence database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential patterns", "Frequent Sequential patterns", "Compressing sequential patterns"};
    }
}

