/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.fhuqiminer.AlgoFHUQIMiner;
import ca.pfv.spmf.algorithms.frequentpatterns.fhuqiminer.EnumCombination;
import java.io.File;
import java.io.IOException;

public class DescriptionAlgoFHUQIMiner
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "FHUQIMiner";
    }

    @Override
    public String getAlgorithmCategory() {
        return "HIGH-UTILITY PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/fhuqiminer_quantitative.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        String inputProfitFile = DescriptionAlgoFHUQIMiner.getParamAsString(parameters[0]);
        File file = new File(inputFile);
        if (file.getParent() != null) {
            inputProfitFile = String.valueOf(file.getParent()) + File.separator + inputProfitFile;
        }
        float minUtility = DescriptionAlgoFHUQIMiner.getParamAsFloat(parameters[1]);
        int relativeCoefficient = DescriptionAlgoFHUQIMiner.getParamAsInteger(parameters[2]);
        EnumCombination method = EnumCombination.valueOf(DescriptionAlgoFHUQIMiner.getParamAsString(parameters[3]));
        AlgoFHUQIMiner algo = new AlgoFHUQIMiner();
        algo.runAlgorithm(inputFile, inputProfitFile, minUtility, relativeCoefficient, method, outputFile);
        algo.printStatistics();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Profit table", "(e.g. dbHUQI_p.txt)", String.class, false), new DescriptionOfParameter("Minimum utility (%)", "(e.g. 0.2)", Float.class, false), new DescriptionOfParameter("Relative coefficient", "(e.g. 3)", Integer.class, false), new DescriptionOfParameter("Method", "(e.g. COMBINEALL)", String.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Nouioua et al.";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values (HUQI)"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "High-utility patterns", "Quantitative high utility itemsets"};
    }
}

