/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.associationrules.fhsar.AlgoFHSAR;
import java.io.File;
import java.io.IOException;

public class DescriptionAlgoFHSAR
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "FHSAR";
    }

    @Override
    public String getAlgorithmCategory() {
        return "ASSOCIATION RULE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/SensitiveAssociationRules.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoFHSAR.getParamAsDouble(parameters[0]);
        double minconf = DescriptionAlgoFHSAR.getParamAsDouble(parameters[1]);
        String sarFile = parameters[2];
        File file = new File(inputFile);
        String sarFileFullPath = file.getParent() == null ? sarFile : String.valueOf(file.getParent()) + File.separator + sarFile;
        AlgoFHSAR algorithm = new AlgoFHSAR();
        algorithm.runAlgorithm(inputFile, sarFileFullPath, outputFile, minsup, minconf);
        algorithm.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.5 or 50%)", Double.class, false), new DescriptionOfParameter("Minconf (%)", "(e.g. 0.6 or 60%)", Double.class, false), new DescriptionOfParameter("SAR file name)", "(e.g. sar.txt)", String.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sanitized transaction database"};
    }
}

