/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.AlgoFHMPlus;
import java.io.IOException;

public class DescriptionAlgoFHMPlus
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "FHM+";
    }

    @Override
    public String getAlgorithmCategory() {
        return "HIGH-UTILITY PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/FHMPlus.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minutil = DescriptionAlgoFHMPlus.getParamAsInteger(parameters[0]);
        int minimumLength = DescriptionAlgoFHMPlus.getParamAsInteger(parameters[1]);
        int maximumLength = DescriptionAlgoFHMPlus.getParamAsInteger(parameters[2]);
        AlgoFHMPlus algo = new AlgoFHMPlus();
        algo.runAlgorithm(inputFile, outputFile, minutil, minimumLength, maximumLength);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minimum utility", "(e.g. 30)", Integer.class, false), new DescriptionOfParameter("Minimum length", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("Maximum length", "(e.g. 3)", Integer.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "High-utility patterns", "High-utility itemsets", "High-utility itemsets with length constraints"};
    }
}

