/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.feacp.AlgoFEACP;
import java.io.File;
import java.io.IOException;

public class DescriptionAlgoFEACP
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "FEACP";
    }

    @Override
    public String getAlgorithmCategory() {
        return "HIGH-UTILITY PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/cross_FEACP.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minutil = DescriptionAlgoFEACP.getParamAsInteger(parameters[0]);
        String taxonomyFilename = parameters[1];
        File file = new File(inputFile);
        String taxonomyPath = file.getParent() == null ? taxonomyFilename : String.valueOf(file.getParent()) + File.separator + taxonomyFilename;
        AlgoFEACP algo = new AlgoFEACP();
        algo.runAlgorithm(minutil, inputFile, outputFile, taxonomyPath, Integer.MAX_VALUE);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("minutil", "(e.g. 60)", Integer.class, false), new DescriptionOfParameter("taxonomy file", "(e.g. taxonomy_CLHMiner.txt)", String.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Bay Vo et al.";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values", "Transaction database with taxonomy"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "High-utility patterns", "High-utility itemsets", "Cross-Level High-utility itemsets"};
    }
}

