/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.episodes.emma.AlgoEMMA;
import java.io.IOException;

public class DescriptionAlgoEMMA
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "EMMA";
    }

    @Override
    public String getAlgorithmCategory() {
        return "EPISODE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/EMMA.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minSup = DescriptionAlgoEMMA.getParamAsInteger(parameters[0]);
        int maxWindow = DescriptionAlgoEMMA.getParamAsInteger(parameters[1]);
        boolean selftIncrement = DescriptionAlgoEMMA.getParamAsBoolean(parameters[2]);
        AlgoEMMA algo = new AlgoEMMA();
        algo.runAlgorithm(inputFile, outputFile, minSup, maxWindow, selftIncrement);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minimum support", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("Max. Time duration", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("Has no timestamps?", "(default: false)", Boolean.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Yang Peng";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with timestamps"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Episodes", "Frequent episodes"};
    }
}

