/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.cost.AlgoCEPM;
import java.io.IOException;

public class DescriptionAlgoCorCEPB
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "CORCEPB";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/CORCEPB.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minsup = DescriptionAlgoCorCEPB.getParamAsInteger(parameters[0]);
        double maxcost = DescriptionAlgoCorCEPB.getParamAsDouble(parameters[1]);
        double minOccupancy = DescriptionAlgoCorCEPB.getParamAsDouble(parameters[2]);
        int maxPatternLength = 999;
        if (parameters.length >= 4 && !"".equals(parameters[3])) {
            maxPatternLength = DescriptionAlgoCorCEPB.getParamAsInteger(parameters[3]);
        }
        boolean sortByCorrelation = false;
        if (parameters.length >= 5 && !"".equals(parameters[4])) {
            sortByCorrelation = DescriptionAlgoCorCEPB.getParamAsBoolean(parameters[4]);
        }
        AlgoCEPM algo = new AlgoCEPM();
        algo.setMaximumPatternLength(maxPatternLength);
        algo.runAlgorithmCorCEPB(inputFile, outputFile, minsup, maxcost, minOccupancy, sortByCorrelation);
        algo.printStatistics();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup", "(e.g. 2)", Double.class, false), new DescriptionOfParameter("Maxcost", "(e.g. 50)", Integer.class, false), new DescriptionOfParameter("Minoccupancy", "(e.g. 0.1)", Double.class, false), new DescriptionOfParameter("Max pattern length", "(e.g. 4)", Integer.class, true), new DescriptionOfParameter("Sort by correlation?", "(default: false)", Boolean.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Jiaxuan Li";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Sequence Database with cost and binary utility"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential patterns", "Cost-efficient Sequential patterns"};
    }
}

