/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.algorithms.timeseries.reader_writer.AlgoTimeSeriesReader;
import ca.pfv.spmf.algorithms.timeseries.sax.AlgoConvertTimeSeriesFileToSequencesWithSAX;
import ca.pfv.spmf.gui.PreferencesManager;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;

public class DescriptionAlgoConvertTimeSeriesToSequenceWithSAX
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "Convert_time_series_to_sequence_database_using_SAX";
    }

    @Override
    public String getAlgorithmCategory() {
        return "TIME SERIES MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/SAXTimeSeries.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int numberOfSegments = DescriptionAlgoConvertTimeSeriesToSequenceWithSAX.getParamAsInteger(parameters[0]);
        int numberOfSymbols = DescriptionAlgoConvertTimeSeriesToSequenceWithSAX.getParamAsInteger(parameters[1]);
        String separator = DescriptionAlgoConvertTimeSeriesToSequenceWithSAX.getParamAsString(parameters[2]);
        boolean deactivatePAA = false;
        if (parameters.length > 3 && !"".equals(parameters[3])) {
            deactivatePAA = DescriptionAlgoConvertTimeSeriesToSequenceWithSAX.getParamAsBoolean(parameters[3]);
        }
        Charset charset = PreferencesManager.getInstance().getPreferedCharset();
        AlgoTimeSeriesReader reader = new AlgoTimeSeriesReader();
        List<TimeSeries> timeSeries = reader.runAlgorithm(inputFile, separator);
        reader.printStats();
        AlgoConvertTimeSeriesFileToSequencesWithSAX algorithm = new AlgoConvertTimeSeriesFileToSequencesWithSAX();
        algorithm.runAlgorithm(timeSeries, outputFile, numberOfSegments, numberOfSymbols, deactivatePAA);
        algorithm.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Number of segments", "(e.g. 3)", Integer.class, false), new DescriptionOfParameter("Number of symbols", "(e.g. 3)", Integer.class, false), new DescriptionOfParameter("Separator", "(e.g. , )", String.class, false), new DescriptionOfParameter("Deactivate PAA", "(default: false)", String.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Time series database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple sequence database"};
    }
}

