/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.cori.AlgoCORI;
import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import java.io.IOException;

public class DescriptionAlgoCORI
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "CORI";
    }

    @Override
    public String getAlgorithmCategory() {
        return "FREQUENT ITEMSET MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/CORI.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoCORI.getParamAsDouble(parameters[0]);
        double minbond = DescriptionAlgoCORI.getParamAsDouble(parameters[1]);
        TransactionDatabase database = new TransactionDatabase();
        try {
            database.loadFile(inputFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        AlgoCORI algo = new AlgoCORI();
        if (parameters.length >= 3 && !"".equals(parameters[2])) {
            algo.setShowTransactionIdentifiers(DescriptionAlgoCORI.getParamAsBoolean(parameters[2]));
        }
        if (parameters.length >= 4 && !"".equals(parameters[3])) {
            algo.setMaximumPatternLength(DescriptionAlgoCORI.getParamAsInteger(parameters[3]));
        }
        algo.runAlgorithm(outputFile, database, minsup, minbond, false);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Maxsup (%)", "(e.g. 0.8 or 80%)", Double.class, false), new DescriptionOfParameter("Minbond (%)", "(e.g. 0.2 or 20%)", Double.class, false), new DescriptionOfParameter("Show transaction ids?", "(default: false)", Boolean.class, true), new DescriptionOfParameter("Max pattern length", "(e.g. 2 items)", Integer.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Rare patterns", "Correlated patterns", "Rare itemsets", "Correlated itemsets", "Rare correlated itemsets"};
    }
}

