/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.associationrules.agrawal94_association_rules.AlgoAgrawalFaster94;
import ca.pfv.spmf.algorithms.frequentpatterns.cfpgrowth.AlgoCFPGrowth;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets;
import java.io.File;
import java.io.IOException;

public class DescriptionAlgoCFFPGrowthAssociationRulesLift
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "CFPGrowth++_association_rules_with_lift";
    }

    @Override
    public String getAlgorithmCategory() {
        return "ASSOCIATION RULE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/AssociationRulesWithLift.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        String misFile = parameters[0];
        double minconf = DescriptionAlgoCFFPGrowthAssociationRulesLift.getParamAsDouble(parameters[1]);
        double minlift = DescriptionAlgoCFFPGrowthAssociationRulesLift.getParamAsDouble(parameters[2]);
        File file = new File(inputFile);
        String misFileFullPath = file.getParent() == null ? misFile : String.valueOf(file.getParent()) + File.separator + misFile;
        AlgoCFPGrowth cfpgrowth = new AlgoCFPGrowth();
        Itemsets patterns = cfpgrowth.runAlgorithm(inputFile, null, misFileFullPath);
        cfpgrowth.printStats();
        int databaseSize = cfpgrowth.getDatabaseSize();
        AlgoAgrawalFaster94 algoAgrawal = new AlgoAgrawalFaster94();
        algoAgrawal.runAlgorithm(patterns, outputFile, databaseSize, minconf, minlift);
        algoAgrawal.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("MIS file name", "(e.g. MIS.txt)", String.class, false), new DescriptionOfParameter("Minimum confidence (%)", "(e.g. 0.6 or 60%)", Double.class, false), new DescriptionOfParameter("Minimum lift ", "(e.g. 0.2)", Double.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Azadeh Soltani, Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Association rules", "Association rules with lift and multiple support thresholds"};
    }
}

