/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class AlgorithmManager {
    List<DescriptionOfAlgorithm> algorithms = AlgorithmManager.getDescriptionOfAlgorithmsInPackage("ca.pfv.spmf.algorithmmanager.descriptions.");
    static AlgorithmManager instance = null;

    private AlgorithmManager() throws Exception {
        Collections.sort(this.algorithms, new Comparator<DescriptionOfAlgorithm>(){

            @Override
            public int compare(DescriptionOfAlgorithm description1, DescriptionOfAlgorithm description2) {
                if (!description1.getAlgorithmCategory().equals(description2.getAlgorithmCategory())) {
                    return description1.getAlgorithmCategory().compareTo(description2.getAlgorithmCategory());
                }
                return description1.getName().compareTo(description2.getName());
            }
        });
    }

    public static AlgorithmManager getInstance() throws Exception {
        if (instance == null) {
            instance = new AlgorithmManager();
        }
        return instance;
    }

    public List<String> getListOfAlgorithmsAsString(boolean includeTools, boolean includeAlgorithms) {
        ArrayList<String> listOfNames = new ArrayList<String>();
        String previousCategory = null;
        for (DescriptionOfAlgorithm algorithm : this.algorithms) {
            if (!"DATASET TOOLS".equals(algorithm.getAlgorithmCategory()) ? !includeAlgorithms : !includeTools) continue;
            if (!algorithm.getAlgorithmCategory().equals(previousCategory)) {
                listOfNames.add(" --- " + algorithm.getAlgorithmCategory() + " --- ");
                previousCategory = algorithm.getAlgorithmCategory();
            }
            listOfNames.add(algorithm.getName());
        }
        return listOfNames;
    }

    private static List<DescriptionOfAlgorithm> getDescriptionOfAlgorithmsInPackage(String packageName) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<DescriptionOfAlgorithm> classes = new ArrayList<DescriptionOfAlgorithm>();
        String originalPackageName = packageName;
        URL packageURL = classLoader.getResource(packageName = packageName.replace(".", "/"));
        if (packageURL.getProtocol().equals("jar")) {
            String jarFileName = URLDecoder.decode(packageURL.getFile(), "UTF-8");
            jarFileName = jarFileName.substring(5, jarFileName.indexOf(33));
            System.out.println(">" + jarFileName);
            JarFile jf = new JarFile(jarFileName);
            Enumeration<JarEntry> jarEntries = jf.entries();
            while (jarEntries.hasMoreElements()) {
                String entryName = jarEntries.nextElement().getName();
                if (!entryName.startsWith(packageName) || !entryName.endsWith(".class")) continue;
                entryName = entryName.substring(packageName.length(), entryName.lastIndexOf(46));
                Class<?> theClass = Class.forName(String.valueOf(originalPackageName) + entryName);
                if (theClass.getSuperclass() != DescriptionOfAlgorithm.class) continue;
                DescriptionOfAlgorithm instance = (DescriptionOfAlgorithm)theClass.newInstance();
                classes.add(instance);
            }
            jf.close();
        } else {
            File[] contenuti;
            URI uri = new URI(packageURL.toString());
            File folder = new File(uri.getPath());
            File[] fileArray = contenuti = folder.listFiles();
            int n = contenuti.length;
            int n2 = 0;
            while (n2 < n) {
                File actual = fileArray[n2];
                String entryName = actual.getName();
                if (entryName.endsWith(".class")) {
                    entryName = entryName.substring(0, entryName.lastIndexOf(46));
                    Class<?> theClass = Class.forName(String.valueOf(originalPackageName) + entryName);
                    if (theClass.getSuperclass().equals(DescriptionOfAlgorithm.class)) {
                        DescriptionOfAlgorithm instance = (DescriptionOfAlgorithm)theClass.newInstance();
                        classes.add(instance);
                    }
                }
                ++n2;
            }
        }
        return classes;
    }

    public DescriptionOfAlgorithm getDescriptionOfAlgorithm(String nameOfAlgorithm) {
        for (DescriptionOfAlgorithm algorithm : this.algorithms) {
            if (!algorithm.getName().equals(nameOfAlgorithm)) continue;
            return algorithm;
        }
        return null;
    }
}

