/*
 * Decompiled with CFR 0.152.
 */
package fastminer.algo.closed;

import fastminer.algo.closed.BitVector;
import fastminer.algo.closed.CPStorage;
import fastminer.algo.closed.ItemSet;
import fastminer.utils.MemoryLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NEclatClosed {
    int outputCount = 0;
    public int numOfFItem;
    public int minSupport;
    public Item[] item;
    public int[] itemsetX;
    public int itemsetXLen = 0;
    public EnumTreeNode nlRoot;
    private Map<Integer, BitSet> mapItemTIDS;
    private CPStorage cpStorage;
    List<ItemSet> closedItemsets = new ArrayList<ItemSet>();
    static Comparator<Item> comp = new Comparator<Item>(){

        @Override
        public int compare(Item a, Item b) {
            return b.num - a.num;
        }
    };
    private int numOfTrans;

    public List<ItemSet> process(int[][] transactions, double minsup) {
        this.nlRoot = new EnumTreeNode(this);
        this.closedItemsets.clear();
        MemoryLogger.getInstance().reset();
        long start = System.currentTimeMillis();
        this.getData(transactions, minsup);
        this.itemsetXLen = 0;
        this.itemsetX = new int[this.numOfFItem];
        this.buildTree(transactions);
        this.nlRoot.label = this.numOfFItem;
        this.nlRoot.firstChild = null;
        this.nlRoot.next = null;
        this.initializeTree();
        this.cpStorage = new CPStorage();
        EnumTreeNode curNode = this.nlRoot.firstChild;
        this.nlRoot.firstChild = null;
        EnumTreeNode next = null;
        while (curNode != null) {
            this.traverse(curNode, 1);
            next = curNode.next;
            curNode.next = null;
            curNode = next;
        }
        MemoryLogger.getInstance().checkMemory();
        long end = System.currentTimeMillis();
        this.printStats(start, end);
        return this.closedItemsets;
    }

    void buildTree(int[][] transactions) {
        this.mapItemTIDS = new HashMap<Integer, BitSet>();
        int tid = 1;
        int[][] nArray = transactions;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] transaction;
            block1: for (int itemX : transaction = nArray[i]) {
                for (int j = 0; j < this.numOfFItem; ++j) {
                    if (itemX != this.item[j].index) continue;
                    BitSet tids = this.mapItemTIDS.get(j);
                    if (tids == null) {
                        tids = new BitSet();
                        this.mapItemTIDS.put(j, tids);
                    }
                    tids.set(tid);
                    continue block1;
                }
            }
            ++tid;
        }
    }

    void getData(int[][] transactions, double minsup) {
        this.numOfTrans = 0;
        HashMap<Integer, Integer> mapItemCount = new HashMap<Integer, Integer>();
        for (int[] transaction : transactions) {
            ++this.numOfTrans;
            for (int item : transaction) {
                mapItemCount.putIfAbsent(item, 0);
                Integer count = (Integer)mapItemCount.get(item);
                count = count + 1;
                mapItemCount.put(item, count);
            }
        }
        this.minSupport = (int)Math.ceil(minsup * (double)this.numOfTrans);
        this.numOfFItem = mapItemCount.size();
        Item[] tempItems = new Item[this.numOfFItem];
        int i = 0;
        for (Map.Entry entry : mapItemCount.entrySet()) {
            if ((Integer)entry.getValue() < this.minSupport) continue;
            tempItems[i] = new Item((Integer)entry.getKey(), (Integer)entry.getValue());
            ++i;
        }
        this.item = new Item[i];
        System.arraycopy(tempItems, 0, this.item, 0, i);
        this.numOfFItem = this.item.length;
        Arrays.sort(this.item, comp);
    }

    void initializeTree() {
        EnumTreeNode lastChild = null;
        for (int t = this.numOfFItem - 1; t >= 0; --t) {
            EnumTreeNode nlNode = new EnumTreeNode(this);
            nlNode.label = t;
            nlNode.firstChild = null;
            nlNode.next = null;
            nlNode.tidSET = this.mapItemTIDS.get(nlNode.label);
            nlNode.count = nlNode.tidSET.cardinality();
            if (this.nlRoot.firstChild == null) {
                this.nlRoot.firstChild = nlNode;
                lastChild = nlNode;
                continue;
            }
            lastChild.next = nlNode;
            lastChild = nlNode;
        }
    }

    public void traverse(EnumTreeNode curr, int level) {
        MemoryLogger.getInstance().checkMemory();
        EnumTreeNode prev = curr;
        EnumTreeNode sibling = prev.next;
        EnumTreeNode lastChild = null;
        int sameCount = 0;
        this.itemsetX[this.itemsetXLen++] = curr.label;
        while (sibling != null) {
            EnumTreeNode child = new EnumTreeNode(this);
            if (level == 1) {
                if (sibling.tidSET.cardinality() != 0) {
                    child.tidSET = (BitSet)curr.tidSET.clone();
                    child.tidSET.andNot(sibling.tidSET);
                }
            } else if (curr.tidSET.cardinality() != 0) {
                child.tidSET = (BitSet)sibling.tidSET.clone();
                child.tidSET.andNot(curr.tidSET);
            }
            child.count = curr.count - child.tidSET.cardinality();
            if (child.count >= this.minSupport) {
                if (curr.count == child.count) {
                    this.itemsetX[this.itemsetXLen++] = sibling.label;
                    ++sameCount;
                } else {
                    child.label = sibling.label;
                    child.firstChild = null;
                    child.next = null;
                    if (curr.firstChild == null) {
                        curr.firstChild = child;
                        lastChild = child;
                    } else {
                        lastChild.next = child;
                        lastChild = child;
                    }
                }
            }
            sibling = sibling.next;
        }
        BitVector itemsetBitset = new BitVector(this.itemsetX, this.itemsetXLen);
        if (this.cpStorage.insertIfClose(itemsetBitset, curr.count)) {
            int[] indices = new int[this.itemsetXLen];
            for (int i = 0; i < this.itemsetXLen; ++i) {
                indices[i] = this.item[this.itemsetX[i]].index;
            }
            this.closedItemsets.add(new ItemSet(indices, curr.count));
        }
        EnumTreeNode child = curr.firstChild;
        curr.firstChild = null;
        while (child != null) {
            this.traverse(child, level + 1);
            EnumTreeNode next = child.next;
            child.next = null;
            child = next;
        }
        this.itemsetXLen -= 1 + sameCount;
    }

    public void printStats(long start, long end) {
        System.out.println("========== NEclatClosed - STATS ============");
        System.out.println("minSupport : " + (int)(100.0 * (double)this.minSupport / (double)this.numOfTrans) + "%");
        System.out.println(" Total time ~: " + (end - start) + " ms");
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("=====================================");
    }

    class EnumTreeNode {
        public int label;
        public EnumTreeNode firstChild;
        public EnumTreeNode next;
        BitSet tidSET;
        int count;

        EnumTreeNode(NEclatClosed this$0) {
        }
    }

    record Item(int index, int num) {
    }
}

