
# Examples <!-- {docsify-ignore-all} -->

<!-- select:start -->
<!-- select-menu-labels: Schema -->

Here you can browse various example schemas and their rendition with several templates.


## --additional_properties--
### Additional Properties

**Description:** A schema using additionalProperties true, false and a complex type.


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/additional_properties.json](examples/cases/additional_properties.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/additional_properties.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/additional_properties.html](examples/examples_js_default/additional_properties.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/additional_properties.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/additional_properties.html](examples/examples_flat_default/additional_properties.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/additional_properties.md" target="_blank">Open it in github</a>

[examples/examples_md_default/additional_properties.md](examples/examples_md_default/additional_properties.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/additional_properties.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/additional_properties.md](examples/examples_md_with_badges/additional_properties.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/additional_properties.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/additional_properties.md](examples/examples_md_nested_default/additional_properties.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/additional_properties.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/additional_properties.md](examples/examples_md_nested_with_badges/additional_properties.md ':include')
</details>

## --anyOf_option_names--
### anyOf_option_names


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/anyOf_option_names.json](examples/cases/anyOf_option_names.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/anyOf_option_names.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/anyOf_option_names.html](examples/examples_js_default/anyOf_option_names.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/anyOf_option_names.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/anyOf_option_names.html](examples/examples_flat_default/anyOf_option_names.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/anyOf_option_names.md" target="_blank">Open it in github</a>

[examples/examples_md_default/anyOf_option_names.md](examples/examples_md_default/anyOf_option_names.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/anyOf_option_names.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/anyOf_option_names.md](examples/examples_md_with_badges/anyOf_option_names.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/anyOf_option_names.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/anyOf_option_names.md](examples/examples_md_nested_default/anyOf_option_names.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/anyOf_option_names.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/anyOf_option_names.md](examples/examples_md_nested_with_badges/anyOf_option_names.md ':include')
</details>

## --array--
### Array of schemas

**Description:** Introduces arrays


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/array.json](examples/cases/array.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/array.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/array.html](examples/examples_js_default/array.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/array.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/array.html](examples/examples_flat_default/array.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/array.md" target="_blank">Open it in github</a>

[examples/examples_md_default/array.md](examples/examples_md_default/array.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/array.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/array.md](examples/examples_md_with_badges/array.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/array.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/array.md](examples/examples_md_nested_default/array.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/array.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/array.md](examples/examples_md_nested_with_badges/array.md ':include')
</details>

## --array_additionalItems--
### array_additionalItems


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/array_additionalItems.json](examples/cases/array_additionalItems.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/array_additionalItems.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/array_additionalItems.html](examples/examples_js_default/array_additionalItems.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/array_additionalItems.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/array_additionalItems.html](examples/examples_flat_default/array_additionalItems.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/array_additionalItems.md" target="_blank">Open it in github</a>

[examples/examples_md_default/array_additionalItems.md](examples/examples_md_default/array_additionalItems.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/array_additionalItems.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/array_additionalItems.md](examples/examples_md_with_badges/array_additionalItems.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/array_additionalItems.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/array_additionalItems.md](examples/examples_md_nested_default/array_additionalItems.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/array_additionalItems.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/array_additionalItems.md](examples/examples_md_nested_with_badges/array_additionalItems.md ':include')
</details>

## --array_advanced--
### Array with more restrictions

**Description:** Introduces *minItems*, *maxItems*, and *uniqueItems*


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/array_advanced.json](examples/cases/array_advanced.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/array_advanced.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/array_advanced.html](examples/examples_js_default/array_advanced.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/array_advanced.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/array_advanced.html](examples/examples_flat_default/array_advanced.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/array_advanced.md" target="_blank">Open it in github</a>

[examples/examples_md_default/array_advanced.md](examples/examples_md_default/array_advanced.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/array_advanced.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/array_advanced.md](examples/examples_md_with_badges/array_advanced.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/array_advanced.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/array_advanced.md](examples/examples_md_nested_default/array_advanced.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/array_advanced.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/array_advanced.md](examples/examples_md_nested_with_badges/array_advanced.md ':include')
</details>

## --basic--
### Basic schema

**Description:** A very simple example


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/basic.json](examples/cases/basic.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/basic.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/basic.html](examples/examples_js_default/basic.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/basic.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/basic.html](examples/examples_flat_default/basic.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/basic.md" target="_blank">Open it in github</a>

[examples/examples_md_default/basic.md](examples/examples_md_default/basic.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/basic.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/basic.md](examples/examples_md_with_badges/basic.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/basic.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/basic.md](examples/examples_md_nested_default/basic.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/basic.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/basic.md](examples/examples_md_nested_with_badges/basic.md ':include')
</details>

## --break_on_newline--
### break_on_newline


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/break_on_newline.json](examples/cases/break_on_newline.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/break_on_newline.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/break_on_newline.html](examples/examples_js_default/break_on_newline.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/break_on_newline.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/break_on_newline.html](examples/examples_flat_default/break_on_newline.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/break_on_newline.md" target="_blank">Open it in github</a>

[examples/examples_md_default/break_on_newline.md](examples/examples_md_default/break_on_newline.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/break_on_newline.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/break_on_newline.md](examples/examples_md_with_badges/break_on_newline.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/break_on_newline.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/break_on_newline.md](examples/examples_md_nested_default/break_on_newline.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/break_on_newline.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/break_on_newline.md](examples/examples_md_nested_with_badges/break_on_newline.md ':include')
</details>

## --circular--
### circular


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/circular.json](examples/cases/circular.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/circular.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/circular.html](examples/examples_js_default/circular.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/circular.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/circular.html](examples/examples_flat_default/circular.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/circular.md" target="_blank">Open it in github</a>

[examples/examples_md_default/circular.md](examples/examples_md_default/circular.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/circular.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/circular.md](examples/examples_md_with_badges/circular.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/circular.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/circular.md](examples/examples_md_nested_default/circular.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/circular.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/circular.md](examples/examples_md_nested_with_badges/circular.md ':include')
</details>

## --combining_not--
### Using *not*



<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/combining_not.json](examples/cases/combining_not.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/combining_not.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/combining_not.html](examples/examples_js_default/combining_not.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/combining_not.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/combining_not.html](examples/examples_flat_default/combining_not.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/combining_not.md" target="_blank">Open it in github</a>

[examples/examples_md_default/combining_not.md](examples/examples_md_default/combining_not.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/combining_not.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/combining_not.md](examples/examples_md_with_badges/combining_not.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/combining_not.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/combining_not.md](examples/examples_md_nested_default/combining_not.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/combining_not.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/combining_not.md](examples/examples_md_nested_with_badges/combining_not.md ':include')
</details>

## --combining_oneOf--
### Using *oneOf*

**Description:** Each option is shown in a tab


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/combining_oneOf.json](examples/cases/combining_oneOf.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/combining_oneOf.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/combining_oneOf.html](examples/examples_js_default/combining_oneOf.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/combining_oneOf.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/combining_oneOf.html](examples/examples_flat_default/combining_oneOf.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/combining_oneOf.md" target="_blank">Open it in github</a>

[examples/examples_md_default/combining_oneOf.md](examples/examples_md_default/combining_oneOf.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/combining_oneOf.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/combining_oneOf.md](examples/examples_md_with_badges/combining_oneOf.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/combining_oneOf.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/combining_oneOf.md](examples/examples_md_nested_default/combining_oneOf.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/combining_oneOf.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/combining_oneOf.md](examples/examples_md_nested_with_badges/combining_oneOf.md ':include')
</details>

## --conditional_subschema--
### conditional_subschema


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/conditional_subschema.json](examples/cases/conditional_subschema.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/conditional_subschema.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/conditional_subschema.html](examples/examples_js_default/conditional_subschema.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/conditional_subschema.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/conditional_subschema.html](examples/examples_flat_default/conditional_subschema.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/conditional_subschema.md" target="_blank">Open it in github</a>

[examples/examples_md_default/conditional_subschema.md](examples/examples_md_default/conditional_subschema.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/conditional_subschema.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/conditional_subschema.md](examples/examples_md_with_badges/conditional_subschema.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/conditional_subschema.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/conditional_subschema.md](examples/examples_md_nested_default/conditional_subschema.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/conditional_subschema.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/conditional_subschema.md](examples/examples_md_nested_with_badges/conditional_subschema.md ':include')
</details>

## --conditional_subschema_no_else--
### conditional_subschema_no_else


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/conditional_subschema_no_else.json](examples/cases/conditional_subschema_no_else.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/conditional_subschema_no_else.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/conditional_subschema_no_else.html](examples/examples_js_default/conditional_subschema_no_else.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/conditional_subschema_no_else.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/conditional_subschema_no_else.html](examples/examples_flat_default/conditional_subschema_no_else.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/conditional_subschema_no_else.md" target="_blank">Open it in github</a>

[examples/examples_md_default/conditional_subschema_no_else.md](examples/examples_md_default/conditional_subschema_no_else.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/conditional_subschema_no_else.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/conditional_subschema_no_else.md](examples/examples_md_with_badges/conditional_subschema_no_else.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/conditional_subschema_no_else.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/conditional_subschema_no_else.md](examples/examples_md_nested_default/conditional_subschema_no_else.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/conditional_subschema_no_else.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/conditional_subschema_no_else.md](examples/examples_md_nested_with_badges/conditional_subschema_no_else.md ':include')
</details>

## --defaults--
### defaults


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/defaults.json](examples/cases/defaults.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/defaults.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/defaults.html](examples/examples_js_default/defaults.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/defaults.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/defaults.html](examples/examples_flat_default/defaults.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/defaults.md" target="_blank">Open it in github</a>

[examples/examples_md_default/defaults.md](examples/examples_md_default/defaults.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/defaults.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/defaults.md](examples/examples_md_with_badges/defaults.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/defaults.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/defaults.md](examples/examples_md_nested_default/defaults.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/defaults.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/defaults.md](examples/examples_md_nested_with_badges/defaults.md ':include')
</details>

## --deprecated--
### Deprecation notice

**Description:** When using `--deprecated-from-description`, a deprecation notice is added if `[Deprecated` is found in
the description of an attribute



<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/deprecated.json](examples/cases/deprecated.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/deprecated.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/deprecated.html](examples/examples_js_default/deprecated.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/deprecated.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/deprecated.html](examples/examples_flat_default/deprecated.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/deprecated.md" target="_blank">Open it in github</a>

[examples/examples_md_default/deprecated.md](examples/examples_md_default/deprecated.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/deprecated.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/deprecated.md](examples/examples_md_with_badges/deprecated.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/deprecated.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/deprecated.md](examples/examples_md_nested_default/deprecated.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/deprecated.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/deprecated.md](examples/examples_md_nested_with_badges/deprecated.md ':include')
</details>

## --description_from_ref--
### description_from_ref


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/description_from_ref.json](examples/cases/description_from_ref.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/description_from_ref.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/description_from_ref.html](examples/examples_js_default/description_from_ref.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/description_from_ref.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/description_from_ref.html](examples/examples_flat_default/description_from_ref.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/description_from_ref.md" target="_blank">Open it in github</a>

[examples/examples_md_default/description_from_ref.md](examples/examples_md_default/description_from_ref.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/description_from_ref.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/description_from_ref.md](examples/examples_md_with_badges/description_from_ref.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/description_from_ref.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/description_from_ref.md](examples/examples_md_nested_default/description_from_ref.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/description_from_ref.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/description_from_ref.md](examples/examples_md_nested_with_badges/description_from_ref.md ':include')
</details>

## --description_markdown--
### description_markdown


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/description_markdown.json](examples/cases/description_markdown.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/description_markdown.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/description_markdown.html](examples/examples_js_default/description_markdown.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/description_markdown.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/description_markdown.html](examples/examples_flat_default/description_markdown.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/description_markdown.md" target="_blank">Open it in github</a>

[examples/examples_md_default/description_markdown.md](examples/examples_md_default/description_markdown.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/description_markdown.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/description_markdown.md](examples/examples_md_with_badges/description_markdown.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/description_markdown.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/description_markdown.md](examples/examples_md_nested_default/description_markdown.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/description_markdown.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/description_markdown.md](examples/examples_md_nested_with_badges/description_markdown.md ':include')
</details>

## --description_with_ref--
### description_with_ref


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/description_with_ref.json](examples/cases/description_with_ref.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/description_with_ref.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/description_with_ref.html](examples/examples_js_default/description_with_ref.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/description_with_ref.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/description_with_ref.html](examples/examples_flat_default/description_with_ref.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/description_with_ref.md" target="_blank">Open it in github</a>

[examples/examples_md_default/description_with_ref.md](examples/examples_md_default/description_with_ref.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/description_with_ref.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/description_with_ref.md](examples/examples_md_with_badges/description_with_ref.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/description_with_ref.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/description_with_ref.md](examples/examples_md_nested_default/description_with_ref.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/description_with_ref.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/description_with_ref.md](examples/examples_md_nested_with_badges/description_with_ref.md ':include')
</details>

## --geo--
### Geographical coordinates

**Description:** Introduces numerical values that have restrictions


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/geo.json](examples/cases/geo.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/geo.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/geo.html](examples/examples_js_default/geo.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/geo.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/geo.html](examples/examples_flat_default/geo.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/geo.md" target="_blank">Open it in github</a>

[examples/examples_md_default/geo.md](examples/examples_md_default/geo.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/geo.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/geo.md](examples/examples_md_with_badges/geo.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/geo.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/geo.md](examples/examples_md_nested_default/geo.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/geo.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/geo.md](examples/examples_md_nested_with_badges/geo.md ':include')
</details>

## --html_in_patterns--
### html_in_patterns


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/html_in_patterns.json](examples/cases/html_in_patterns.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/html_in_patterns.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/html_in_patterns.html](examples/examples_js_default/html_in_patterns.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/html_in_patterns.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/html_in_patterns.html](examples/examples_flat_default/html_in_patterns.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/html_in_patterns.md" target="_blank">Open it in github</a>

[examples/examples_md_default/html_in_patterns.md](examples/examples_md_default/html_in_patterns.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/html_in_patterns.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/html_in_patterns.md](examples/examples_md_with_badges/html_in_patterns.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/html_in_patterns.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/html_in_patterns.md](examples/examples_md_nested_default/html_in_patterns.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/html_in_patterns.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/html_in_patterns.md](examples/examples_md_nested_with_badges/html_in_patterns.md ':include')
</details>

## --long_description--
### long_description


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/long_description.json](examples/cases/long_description.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/long_description.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/long_description.html](examples/examples_js_default/long_description.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/long_description.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/long_description.html](examples/examples_flat_default/long_description.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/long_description.md" target="_blank">Open it in github</a>

[examples/examples_md_default/long_description.md](examples/examples_md_default/long_description.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/long_description.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/long_description.md](examples/examples_md_with_badges/long_description.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/long_description.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/long_description.md](examples/examples_md_nested_default/long_description.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/long_description.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/long_description.md](examples/examples_md_nested_with_badges/long_description.md ':include')
</details>

## --multiple_types--
### Multiple Types

**Description:** This one has several options for the type


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/multiple_types.json](examples/cases/multiple_types.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/multiple_types.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/multiple_types.html](examples/examples_js_default/multiple_types.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/multiple_types.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/multiple_types.html](examples/examples_flat_default/multiple_types.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/multiple_types.md" target="_blank">Open it in github</a>

[examples/examples_md_default/multiple_types.md](examples/examples_md_default/multiple_types.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/multiple_types.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/multiple_types.md](examples/examples_md_with_badges/multiple_types.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/multiple_types.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/multiple_types.md](examples/examples_md_nested_default/multiple_types.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/multiple_types.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/multiple_types.md](examples/examples_md_nested_with_badges/multiple_types.md ':include')
</details>

## --pattern_properties--
### Using pattern properties

**Description:** The schema permits property names matching a regex, using the pattern properties tag


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/pattern_properties.json](examples/cases/pattern_properties.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/pattern_properties.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/pattern_properties.html](examples/examples_js_default/pattern_properties.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/pattern_properties.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/pattern_properties.html](examples/examples_flat_default/pattern_properties.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/pattern_properties.md" target="_blank">Open it in github</a>

[examples/examples_md_default/pattern_properties.md](examples/examples_md_default/pattern_properties.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/pattern_properties.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/pattern_properties.md](examples/examples_md_with_badges/pattern_properties.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/pattern_properties.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/pattern_properties.md](examples/examples_md_nested_default/pattern_properties.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/pattern_properties.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/pattern_properties.md](examples/examples_md_nested_with_badges/pattern_properties.md ':include')
</details>

## --pattern_properties_html_id--
### pattern_properties_html_id


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/pattern_properties_html_id.json](examples/cases/pattern_properties_html_id.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/pattern_properties_html_id.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/pattern_properties_html_id.html](examples/examples_js_default/pattern_properties_html_id.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/pattern_properties_html_id.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/pattern_properties_html_id.html](examples/examples_flat_default/pattern_properties_html_id.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/pattern_properties_html_id.md" target="_blank">Open it in github</a>

[examples/examples_md_default/pattern_properties_html_id.md](examples/examples_md_default/pattern_properties_html_id.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/pattern_properties_html_id.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/pattern_properties_html_id.md](examples/examples_md_with_badges/pattern_properties_html_id.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/pattern_properties_html_id.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/pattern_properties_html_id.md](examples/examples_md_nested_default/pattern_properties_html_id.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/pattern_properties_html_id.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/pattern_properties_html_id.md](examples/examples_md_nested_with_badges/pattern_properties_html_id.md ':include')
</details>

## --recursive--
### recursive


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/recursive.json](examples/cases/recursive.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/recursive.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/recursive.html](examples/examples_js_default/recursive.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/recursive.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/recursive.html](examples/examples_flat_default/recursive.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/recursive.md" target="_blank">Open it in github</a>

[examples/examples_md_default/recursive.md](examples/examples_md_default/recursive.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/recursive.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/recursive.md](examples/examples_md_with_badges/recursive.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/recursive.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/recursive.md](examples/examples_md_nested_default/recursive.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/recursive.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/recursive.md](examples/examples_md_nested_with_badges/recursive.md ':include')
</details>

## --recursive_array--
### recursive_array


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/recursive_array.json](examples/cases/recursive_array.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/recursive_array.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/recursive_array.html](examples/examples_js_default/recursive_array.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/recursive_array.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/recursive_array.html](examples/examples_flat_default/recursive_array.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/recursive_array.md" target="_blank">Open it in github</a>

[examples/examples_md_default/recursive_array.md](examples/examples_md_default/recursive_array.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/recursive_array.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/recursive_array.md](examples/examples_md_with_badges/recursive_array.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/recursive_array.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/recursive_array.md](examples/examples_md_nested_default/recursive_array.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/recursive_array.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/recursive_array.md](examples/examples_md_nested_with_badges/recursive_array.md ':include')
</details>

## --recursive_parent_in_definition--
### recursive_parent_in_definition


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/recursive_parent_in_definition.json](examples/cases/recursive_parent_in_definition.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/recursive_parent_in_definition.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/recursive_parent_in_definition.html](examples/examples_js_default/recursive_parent_in_definition.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/recursive_parent_in_definition.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/recursive_parent_in_definition.html](examples/examples_flat_default/recursive_parent_in_definition.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/recursive_parent_in_definition.md" target="_blank">Open it in github</a>

[examples/examples_md_default/recursive_parent_in_definition.md](examples/examples_md_default/recursive_parent_in_definition.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/recursive_parent_in_definition.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/recursive_parent_in_definition.md](examples/examples_md_with_badges/recursive_parent_in_definition.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/recursive_parent_in_definition.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/recursive_parent_in_definition.md](examples/examples_md_nested_default/recursive_parent_in_definition.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/recursive_parent_in_definition.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/recursive_parent_in_definition.md](examples/examples_md_nested_with_badges/recursive_parent_in_definition.md ':include')
</details>

## --recursive_two_files--
### recursive_two_files


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/recursive_two_files.json](examples/cases/recursive_two_files.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/recursive_two_files.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/recursive_two_files.html](examples/examples_js_default/recursive_two_files.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/recursive_two_files.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/recursive_two_files.html](examples/examples_flat_default/recursive_two_files.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/recursive_two_files.md" target="_blank">Open it in github</a>

[examples/examples_md_default/recursive_two_files.md](examples/examples_md_default/recursive_two_files.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/recursive_two_files.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/recursive_two_files.md](examples/examples_md_with_badges/recursive_two_files.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/recursive_two_files.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/recursive_two_files.md](examples/examples_md_nested_default/recursive_two_files.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/recursive_two_files.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/recursive_two_files.md](examples/examples_md_nested_with_badges/recursive_two_files.md ':include')
</details>

## --recursive_two_files2--
### recursive_two_files2


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/recursive_two_files2.json](examples/cases/recursive_two_files2.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/recursive_two_files2.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/recursive_two_files2.html](examples/examples_js_default/recursive_two_files2.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/recursive_two_files2.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/recursive_two_files2.html](examples/examples_flat_default/recursive_two_files2.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/recursive_two_files2.md" target="_blank">Open it in github</a>

[examples/examples_md_default/recursive_two_files2.md](examples/examples_md_default/recursive_two_files2.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/recursive_two_files2.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/recursive_two_files2.md](examples/examples_md_with_badges/recursive_two_files2.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/recursive_two_files2.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/recursive_two_files2.md](examples/examples_md_nested_default/recursive_two_files2.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/recursive_two_files2.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/recursive_two_files2.md](examples/examples_md_nested_with_badges/recursive_two_files2.md ':include')
</details>

## --ref_merge--
### ref_merge


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/ref_merge.json](examples/cases/ref_merge.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/ref_merge.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/ref_merge.html](examples/examples_js_default/ref_merge.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/ref_merge.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/ref_merge.html](examples/examples_flat_default/ref_merge.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/ref_merge.md" target="_blank">Open it in github</a>

[examples/examples_md_default/ref_merge.md](examples/examples_md_default/ref_merge.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/ref_merge.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/ref_merge.md](examples/examples_md_with_badges/ref_merge.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/ref_merge.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/ref_merge.md](examples/examples_md_nested_default/ref_merge.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/ref_merge.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/ref_merge.md](examples/examples_md_nested_with_badges/ref_merge.md ':include')
</details>

## --references--
### With references



<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/references.json](examples/cases/references.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/references.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/references.html](examples/examples_js_default/references.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/references.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/references.html](examples/examples_flat_default/references.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/references.md" target="_blank">Open it in github</a>

[examples/examples_md_default/references.md](examples/examples_md_default/references.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/references.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/references.md](examples/examples_md_with_badges/references.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/references.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/references.md](examples/examples_md_nested_default/references.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/references.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/references.md](examples/examples_md_nested_with_badges/references.md ':include')
</details>

## --references_url--
### references_url


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/references_url.json](examples/cases/references_url.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/references_url.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/references_url.html](examples/examples_js_default/references_url.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/references_url.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/references_url.html](examples/examples_flat_default/references_url.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/references_url.md" target="_blank">Open it in github</a>

[examples/examples_md_default/references_url.md](examples/examples_md_default/references_url.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/references_url.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/references_url.md](examples/examples_md_with_badges/references_url.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/references_url.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/references_url.md](examples/examples_md_nested_default/references_url.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/references_url.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/references_url.md](examples/examples_md_nested_with_badges/references_url.md ':include')
</details>

## --references_url_two_levels--
### references_url_two_levels


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/references_url_two_levels.json](examples/cases/references_url_two_levels.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/references_url_two_levels.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/references_url_two_levels.html](examples/examples_js_default/references_url_two_levels.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/references_url_two_levels.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/references_url_two_levels.html](examples/examples_flat_default/references_url_two_levels.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/references_url_two_levels.md" target="_blank">Open it in github</a>

[examples/examples_md_default/references_url_two_levels.md](examples/examples_md_default/references_url_two_levels.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/references_url_two_levels.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/references_url_two_levels.md](examples/examples_md_with_badges/references_url_two_levels.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/references_url_two_levels.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/references_url_two_levels.md](examples/examples_md_nested_default/references_url_two_levels.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/references_url_two_levels.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/references_url_two_levels.md](examples/examples_md_nested_with_badges/references_url_two_levels.md ':include')
</details>

## --references_url_yaml--
### references_url_yaml


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/references_url_yaml.json](examples/cases/references_url_yaml.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/references_url_yaml.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/references_url_yaml.html](examples/examples_js_default/references_url_yaml.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/references_url_yaml.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/references_url_yaml.html](examples/examples_flat_default/references_url_yaml.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/references_url_yaml.md" target="_blank">Open it in github</a>

[examples/examples_md_default/references_url_yaml.md](examples/examples_md_default/references_url_yaml.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/references_url_yaml.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/references_url_yaml.md](examples/examples_md_with_badges/references_url_yaml.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/references_url_yaml.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/references_url_yaml.md](examples/examples_md_nested_default/references_url_yaml.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/references_url_yaml.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/references_url_yaml.md](examples/examples_md_nested_with_badges/references_url_yaml.md ':include')
</details>

## --single_element_allOf--
### single_element_allOf


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/single_element_allOf.json](examples/cases/single_element_allOf.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/single_element_allOf.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/single_element_allOf.html](examples/examples_js_default/single_element_allOf.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/single_element_allOf.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/single_element_allOf.html](examples/examples_flat_default/single_element_allOf.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/single_element_allOf.md" target="_blank">Open it in github</a>

[examples/examples_md_default/single_element_allOf.md](examples/examples_md_default/single_element_allOf.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/single_element_allOf.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/single_element_allOf.md](examples/examples_md_with_badges/single_element_allOf.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/single_element_allOf.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/single_element_allOf.md](examples/examples_md_nested_default/single_element_allOf.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/single_element_allOf.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/single_element_allOf.md](examples/examples_md_nested_with_badges/single_element_allOf.md ':include')
</details>

## --top_level_array--
### top_level_array


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/top_level_array.json](examples/cases/top_level_array.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/top_level_array.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/top_level_array.html](examples/examples_js_default/top_level_array.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/top_level_array.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/top_level_array.html](examples/examples_flat_default/top_level_array.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/top_level_array.md" target="_blank">Open it in github</a>

[examples/examples_md_default/top_level_array.md](examples/examples_md_default/top_level_array.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/top_level_array.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/top_level_array.md](examples/examples_md_with_badges/top_level_array.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/top_level_array.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/top_level_array.md](examples/examples_md_nested_default/top_level_array.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/top_level_array.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/top_level_array.md](examples/examples_md_nested_with_badges/top_level_array.md ':include')
</details>

## --top_level_combining--
### top_level_combining


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/top_level_combining.json](examples/cases/top_level_combining.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/top_level_combining.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/top_level_combining.html](examples/examples_js_default/top_level_combining.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/top_level_combining.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/top_level_combining.html](examples/examples_flat_default/top_level_combining.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/top_level_combining.md" target="_blank">Open it in github</a>

[examples/examples_md_default/top_level_combining.md](examples/examples_md_default/top_level_combining.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/top_level_combining.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/top_level_combining.md](examples/examples_md_with_badges/top_level_combining.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/top_level_combining.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/top_level_combining.md](examples/examples_md_nested_default/top_level_combining.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/top_level_combining.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/top_level_combining.md](examples/examples_md_nested_with_badges/top_level_combining.md ':include')
</details>

## --with_default--
### With default value



<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/with_default.json](examples/cases/with_default.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/with_default.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/with_default.html](examples/examples_js_default/with_default.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/with_default.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/with_default.html](examples/examples_flat_default/with_default.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/with_default.md" target="_blank">Open it in github</a>

[examples/examples_md_default/with_default.md](examples/examples_md_default/with_default.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/with_default.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/with_default.md](examples/examples_md_with_badges/with_default.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/with_default.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/with_default.md](examples/examples_md_nested_default/with_default.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/with_default.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/with_default.md](examples/examples_md_nested_with_badges/with_default.md ':include')
</details>

## --with_definitions--
### Using definitions

**Description:** The schema use references to inline definitions to decrease its size


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/with_definitions.json](examples/cases/with_definitions.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/with_definitions.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/with_definitions.html](examples/examples_js_default/with_definitions.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/with_definitions.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/with_definitions.html](examples/examples_flat_default/with_definitions.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/with_definitions.md" target="_blank">Open it in github</a>

[examples/examples_md_default/with_definitions.md](examples/examples_md_default/with_definitions.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/with_definitions.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/with_definitions.md](examples/examples_md_with_badges/with_definitions.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/with_definitions.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/with_definitions.md](examples/examples_md_nested_default/with_definitions.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/with_definitions.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/with_definitions.md](examples/examples_md_nested_with_badges/with_definitions.md ':include')
</details>

## --with_descriptions--
### with_descriptions


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/with_descriptions.json](examples/cases/with_descriptions.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/with_descriptions.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/with_descriptions.html](examples/examples_js_default/with_descriptions.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/with_descriptions.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/with_descriptions.html](examples/examples_flat_default/with_descriptions.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/with_descriptions.md" target="_blank">Open it in github</a>

[examples/examples_md_default/with_descriptions.md](examples/examples_md_default/with_descriptions.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/with_descriptions.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/with_descriptions.md](examples/examples_md_with_badges/with_descriptions.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/with_descriptions.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/with_descriptions.md](examples/examples_md_nested_default/with_descriptions.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/with_descriptions.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/with_descriptions.md](examples/examples_md_nested_with_badges/with_descriptions.md ':include')
</details>

## --with_examples--
### With examples

**Description:** Display examples. Longer examples are collapsed by default.


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/with_examples.json](examples/cases/with_examples.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/with_examples.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/with_examples.html](examples/examples_js_default/with_examples.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/with_examples.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/with_examples.html](examples/examples_flat_default/with_examples.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/with_examples.md" target="_blank">Open it in github</a>

[examples/examples_md_default/with_examples.md](examples/examples_md_default/with_examples.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/with_examples.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/with_examples.md](examples/examples_md_with_badges/with_examples.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/with_examples.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/with_examples.md](examples/examples_md_nested_default/with_examples.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/with_examples.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/with_examples.md](examples/examples_md_nested_with_badges/with_examples.md ':include')
</details>

## --with_keywords--
### with_keywords


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/with_keywords.json](examples/cases/with_keywords.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/with_keywords.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/with_keywords.html](examples/examples_js_default/with_keywords.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/with_keywords.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/with_keywords.html](examples/examples_flat_default/with_keywords.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/with_keywords.md" target="_blank">Open it in github</a>

[examples/examples_md_default/with_keywords.md](examples/examples_md_default/with_keywords.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/with_keywords.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/with_keywords.md](examples/examples_md_with_badges/with_keywords.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/with_keywords.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/with_keywords.md](examples/examples_md_nested_default/with_keywords.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/with_keywords.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/with_keywords.md](examples/examples_md_nested_with_badges/with_keywords.md ':include')
</details>

## --with_special_chars--
### with_special_chars


<details>
<summary>Json schema - Click here to expand source code...</summary>

[examples/cases/with_special_chars.json](examples/cases/with_special_chars.json ':include :type=code')
</details>


<details>
<summary>JS template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_js_default/with_special_chars.html" target="_blank">Open it in full page</a>

[examples/examples_js_default/with_special_chars.html](examples/examples_js_default/with_special_chars.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Flat template - Click here to expand the rendered result...</summary>
<a href="https://coveooss.github.io/json-schema-for-humans/examples/examples_flat_default/with_special_chars.html" target="_blank">Open it in full page</a>

[examples/examples_flat_default/with_special_chars.html](examples/examples_flat_default/with_special_chars.html ':include :type=iframe width=100% height=400px')
</details>


<details>
<summary>Markdown without badge template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_default/with_special_chars.md" target="_blank">Open it in github</a>

[examples/examples_md_default/with_special_chars.md](examples/examples_md_default/with_special_chars.md ':include')
</details>


<details>
<summary>Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_with_badges/with_special_chars.md" target="_blank">Open it in github</a>

[examples/examples_md_with_badges/with_special_chars.md](examples/examples_md_with_badges/with_special_chars.md ':include')
</details>


<details>
<summary>Nested Markdown without badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_default/with_special_chars.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_default/with_special_chars.md](examples/examples_md_nested_default/with_special_chars.md ':include')
</details>


<details>
<summary>Nested Markdown with badges template - Click here to expand the rendered result...</summary>
<a href="https://github.com/coveooss/json-schema-for-humans/blob/master/docs/examples/examples_md_nested_with_badges/with_special_chars.md" target="_blank">Open it in github</a>

[examples/examples_md_nested_with_badges/with_special_chars.md](examples/examples_md_nested_with_badges/with_special_chars.md ':include')
</details>


<!-- select:end -->
