# generated by datamodel-codegen:
#   filename:  data_products.schema.json
#   timestamp: 2023-03-07T10:21:46+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Dict, List, Optional
from uuid import UUID

from pydantic import BaseModel, Field, constr


class DataUnit(Enum):
    counts = "counts"
    m_s = "m/s"
    m_s2 = "m/s2"


class TraceModel(BaseModel):
    uid: Optional[str] = Field(None, title="Uid")
    endtime: datetime = Field(..., title="Endtime")
    delta_t: float = Field(..., title="Delta T")
    data: Dict[str, bytes] = Field(..., title="Data")
    data_unit: Optional[DataUnit] = Field("counts", title="Data Unit")
    compressed: Optional[bool] = Field(False, title="Compressed")


class WaveformRequestResponse(BaseModel):
    name: Optional[constr(min_length=1)] = Field(
        "WaveformRequestResponse", title="Name"
    )
    persistent: Optional[bool] = Field(True, title="Persistent")
    timestamp: Optional[datetime] = Field(None, title="Timestamp")
    sensor_uid: Optional[str] = Field(None, title="Sensor Uid")
    uid: Optional[UUID] = Field(None, title="Uid")
    request_id: UUID = Field(..., title="Request Id")
    traces: Optional[TraceModel] = None


class WaveformData(BaseModel):
    name: Optional[constr(min_length=1)] = Field("WaveformData", title="Name")
    persistent: Optional[bool] = Field(True, title="Persistent")
    timestamp: Optional[datetime] = Field(None, title="Timestamp")
    sensor_uid: Optional[str] = Field(None, title="Sensor Uid")
    uid: Optional[UUID] = Field(None, title="Uid")
    traces: TraceModel
    sequence_number: int = Field(..., title="Sequence Number")


class NoiseAutocorrelation(BaseModel):
    name: Optional[constr(min_length=1)] = Field("NoiseAutocorrelation", title="Name")
    persistent: Optional[bool] = Field(True, title="Persistent")
    timestamp: Optional[datetime] = Field(None, title="Timestamp")
    sensor_uid: Optional[str] = Field(None, title="Sensor Uid")
    uid: Optional[UUID] = Field(None, title="Uid")
    correlogram: List[float] = Field(..., title="Correlogram")
    deltat: float = Field(..., title="Deltat")
    max_lagtime: float = Field(..., title="Max Lagtime")
    stacking_method: str = Field(..., title="Stacking Method")


class HVSpectra(BaseModel):
    name: Optional[constr(min_length=1)] = Field("HVSpectra", title="Name")
    persistent: Optional[bool] = Field(True, title="Persistent")
    timestamp: Optional[datetime] = Field(None, title="Timestamp")
    sensor_uid: Optional[str] = Field(None, title="Sensor Uid")
    uid: Optional[UUID] = Field(None, title="Uid")
    frequencies: List[float] = Field(..., title="Frequencies")
    spectrum: List[float] = Field(..., title="Spectrum")
    spectrum_std: List[float] = Field(..., title="Spectrum Std")
    stack_duration: float = Field(..., title="Stack Duration")
    window_length: float = Field(..., title="Window Length")


class EventAttibute(BaseModel):
    name: str = Field(..., title="Name")


class EventTrigger(BaseModel):
    name: str = Field(..., title="Name")
    time: Optional[datetime] = Field(None, title="Time")
    value: Optional[float] = Field(None, title="Value")


class EventRecord(BaseModel):
    name: Optional[constr(min_length=1)] = Field("EventRecord", title="Name")
    persistent: Optional[bool] = Field(True, title="Persistent")
    timestamp: Optional[datetime] = Field(None, title="Timestamp")
    sensor_uid: Optional[str] = Field(None, title="Sensor Uid")
    uid: Optional[UUID] = Field(None, title="Uid")
    attributes: Optional[List[EventAttibute]] = Field([], title="Attributes")
    trigger_time: datetime = Field(..., title="Trigger Time")
    recording_length: float = Field(..., title="Recording Length")
    traces: TraceModel
    trigger: Optional[EventTrigger] = None


class DataProducts(BaseModel):
    WaveformRequestResponse: WaveformRequestResponse
    WaveformData: WaveformData
    NoiseAutocorrelation: NoiseAutocorrelation
    HVSpectra: HVSpectra
    EventRecord: EventRecord
