# Code generated by "autogen"; DO NOT EDIT
# Copyright 2020 Aptpod, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
import io
from enum import Enum

from . import field

PREAMBLE = int.from_bytes(b"\xaa", "little")
RESULT_CODE_OK = int.from_bytes(b"\x00", "little")
RESULT_CODE_NG = int.from_bytes(b"\x01", "little")


class ElemType(Enum):
    upstream_spec_request = int.from_bytes(b"\x90", "little")
    upstream_spec_response = int.from_bytes(b"\x81", "little")
    downstream_spec_request = int.from_bytes(b"\x91", "little")
    downstream_spec_response = int.from_bytes(b"\x83", "little")
    downstream_filter_request = int.from_bytes(b"\x86", "little")
    downstream_filter_response = int.from_bytes(b"\x87", "little")
    measurement_id_request = int.from_bytes(b"\x92", "little")
    measurement_id_response = int.from_bytes(b"\x85", "little")
    sos_marker = int.from_bytes(b"\xf9", "little")
    eos_marker = int.from_bytes(b"\xf8", "little")
    section_ack = int.from_bytes(b"\xfa", "little")
    unit = int.from_bytes(b"\x03", "little")


def type2elem(elem_type):
    if elem_type == ElemType.upstream_spec_request.value:
        return UpstreamSpecRequest
    if elem_type == ElemType.upstream_spec_response.value:
        return UpstreamSpecResponse
    if elem_type == ElemType.downstream_spec_request.value:
        return DownstreamSpecRequest
    if elem_type == ElemType.downstream_spec_response.value:
        return DownstreamSpecResponse
    if elem_type == ElemType.downstream_filter_request.value:
        return DownstreamFilterRequest
    if elem_type == ElemType.downstream_filter_response.value:
        return DownstreamFilterResponse
    if elem_type == ElemType.measurement_id_request.value:
        return MeasurementIdRequest
    if elem_type == ElemType.measurement_id_response.value:
        return MeasurementIdResponse
    if elem_type == ElemType.sos_marker.value:
        return SosMarker
    if elem_type == ElemType.eos_marker.value:
        return EosMarker
    if elem_type == ElemType.section_ack.value:
        return SectionAck
    if elem_type == ElemType.unit.value:
        return Unit
    raise NotImplementedError


def elem2type(elem):
    if type(elem) == UpstreamSpecRequest:
        return ElemType.upstream_spec_request.value
    if type(elem) == UpstreamSpecResponse:
        return ElemType.upstream_spec_response.value
    if type(elem) == DownstreamSpecRequest:
        return ElemType.downstream_spec_request.value
    if type(elem) == DownstreamSpecResponse:
        return ElemType.downstream_spec_response.value
    if type(elem) == DownstreamFilterRequest:
        return ElemType.downstream_filter_request.value
    if type(elem) == DownstreamFilterResponse:
        return ElemType.downstream_filter_response.value
    if type(elem) == MeasurementIdRequest:
        return ElemType.measurement_id_request.value
    if type(elem) == MeasurementIdResponse:
        return ElemType.measurement_id_response.value
    if type(elem) == SosMarker:
        return ElemType.sos_marker.value
    if type(elem) == EosMarker:
        return ElemType.eos_marker.value
    if type(elem) == SectionAck:
        return ElemType.section_ack.value
    if type(elem) == Unit:
        return ElemType.unit.value
    raise NotImplementedError


class CommonHeader(object):
    def __init__(self, preamble, elem_type):
        self.preamble = preamble
        self.elem_type = elem_type

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        preamble = field.Uint8._read_from(rd)
        elem_type = field.Uint8._read_from(rd)
        return CommonHeader(preamble=preamble, elem_type=elem_type)

    def _write_to(self, wr: io.BufferedWriter):
        self.preamble._write_to(wr)
        self.elem_type._write_to(wr)

    def _length(self):
        l = 0
        l += self.preamble._length()
        l += self.elem_type._length()
        return l


class UpstreamSpecRequest(object):
    def __init__(self, req_id, stream_num, specs):
        self.req_id = req_id
        self.stream_num = stream_num
        self.specs = specs

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        req_id = field.Uint8._read_from(rd)
        stream_num = field.Uint8._read_from(rd)
        specs = [UpstreamSpec._read_from(rd) for i in range(stream_num.value)]
        return UpstreamSpecRequest(req_id=req_id, stream_num=stream_num, specs=specs)

    def _write_to(self, wr: io.BufferedWriter):
        self.req_id._write_to(wr)
        self.stream_num._write_to(wr)
        [x._write_to(wr) for x in self.specs]

    def _length(self):
        l = 0
        l += self.req_id._length()
        l += self.stream_num._length()
        l += sum([v._length() for v in self.specs])
        return l


class UpstreamSpec(object):
    def __init__(
        self, stream_id, dst_num, flags, measurement_uuid, src_edge_uuid, dst_edge_uuids
    ):
        self.stream_id = stream_id
        self.dst_num = dst_num
        self.flags = flags
        self.measurement_uuid = measurement_uuid
        self.src_edge_uuid = src_edge_uuid
        self.dst_edge_uuids = dst_edge_uuids

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        stream_id = field.Uint8._read_from(rd)
        dst_num = field.Uint8._read_from(rd)
        flags = field.Uint8._read_from(rd)
        measurement_uuid = field.Uuid._read_from(rd)
        src_edge_uuid = field.Uuid._read_from(rd)
        dst_edge_uuids = [field.Uuid._read_from(rd) for i in range(dst_num.value)]
        return UpstreamSpec(
            stream_id=stream_id,
            dst_num=dst_num,
            flags=flags,
            measurement_uuid=measurement_uuid,
            src_edge_uuid=src_edge_uuid,
            dst_edge_uuids=dst_edge_uuids,
        )

    def _write_to(self, wr: io.BufferedWriter):
        self.stream_id._write_to(wr)
        self.dst_num._write_to(wr)
        self.flags._write_to(wr)
        self.measurement_uuid._write_to(wr)
        self.src_edge_uuid._write_to(wr)
        [x._write_to(wr) for x in self.dst_edge_uuids]

    def _length(self):
        l = 0
        l += self.stream_id._length()
        l += self.dst_num._length()
        l += self.flags._length()
        l += self.measurement_uuid._length()
        l += self.src_edge_uuid._length()
        l += sum([v._length() for v in self.dst_edge_uuids])
        return l

    @property
    def store(self):
        return ((self.flags.value & 2) >> 1) == 1

    @store.setter
    def store(self, v):
        i = 1 if v else 0
        self.flags.value = self.flags.value | 2 & (i << 1)

    @property
    def resend(self):
        return ((self.flags.value & 1) >> 0) == 1

    @resend.setter
    def resend(self, v):
        i = 1 if v else 0
        self.flags.value = self.flags.value | 1 & (i << 0)


class UpstreamSpecResponse(object):
    def __init__(self, req_id, result_code):
        self.req_id = req_id
        self.result_code = result_code

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        req_id = field.Uint8._read_from(rd)
        result_code = field.Uint8._read_from(rd)
        return UpstreamSpecResponse(req_id=req_id, result_code=result_code)

    def _write_to(self, wr: io.BufferedWriter):
        self.req_id._write_to(wr)
        self.result_code._write_to(wr)

    def _length(self):
        l = 0
        l += self.req_id._length()
        l += self.result_code._length()
        return l


class DownstreamSpecRequest(object):
    def __init__(self, req_id, stream_num, specs):
        self.req_id = req_id
        self.stream_num = stream_num
        self.specs = specs

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        req_id = field.Uint8._read_from(rd)
        stream_num = field.Uint8._read_from(rd)
        specs = [DownstreamSpec._read_from(rd) for i in range(stream_num.value)]
        return DownstreamSpecRequest(req_id=req_id, stream_num=stream_num, specs=specs)

    def _write_to(self, wr: io.BufferedWriter):
        self.req_id._write_to(wr)
        self.stream_num._write_to(wr)
        [x._write_to(wr) for x in self.specs]

    def _length(self):
        l = 0
        l += self.req_id._length()
        l += self.stream_num._length()
        l += sum([v._length() for v in self.specs])
        return l


class DownstreamSpec(object):
    def __init__(self, stream_id, src_edge_uuid, dst_edge_uuid):
        self.stream_id = stream_id
        self.src_edge_uuid = src_edge_uuid
        self.dst_edge_uuid = dst_edge_uuid

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        stream_id = field.Uint8._read_from(rd)
        src_edge_uuid = field.Uuid._read_from(rd)
        dst_edge_uuid = field.Uuid._read_from(rd)
        return DownstreamSpec(
            stream_id=stream_id,
            src_edge_uuid=src_edge_uuid,
            dst_edge_uuid=dst_edge_uuid,
        )

    def _write_to(self, wr: io.BufferedWriter):
        self.stream_id._write_to(wr)
        self.src_edge_uuid._write_to(wr)
        self.dst_edge_uuid._write_to(wr)

    def _length(self):
        l = 0
        l += self.stream_id._length()
        l += self.src_edge_uuid._length()
        l += self.dst_edge_uuid._length()
        return l


class DownstreamSpecResponse(object):
    def __init__(self, req_id, result_code):
        self.req_id = req_id
        self.result_code = result_code

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        req_id = field.Uint8._read_from(rd)
        result_code = field.Uint8._read_from(rd)
        return DownstreamSpecResponse(req_id=req_id, result_code=result_code)

    def _write_to(self, wr: io.BufferedWriter):
        self.req_id._write_to(wr)
        self.result_code._write_to(wr)

    def _length(self):
        l = 0
        l += self.req_id._length()
        l += self.result_code._length()
        return l


class DownstreamFilterRequest(object):
    def __init__(self, req_id, stream_num, filters):
        self.req_id = req_id
        self.stream_num = stream_num
        self.filters = filters

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        req_id = field.Uint8._read_from(rd)
        stream_num = field.Uint8._read_from(rd)
        filters = [DownstreamFilter._read_from(rd) for i in range(stream_num.value)]
        return DownstreamFilterRequest(
            req_id=req_id, stream_num=stream_num, filters=filters
        )

    def _write_to(self, wr: io.BufferedWriter):
        self.req_id._write_to(wr)
        self.stream_num._write_to(wr)
        [x._write_to(wr) for x in self.filters]

    def _length(self):
        l = 0
        l += self.req_id._length()
        l += self.stream_num._length()
        l += sum([v._length() for v in self.filters])
        return l


class DownstreamFilter(object):
    def __init__(self, stream_id, data_num, downstream_data_filters):
        self.stream_id = stream_id
        self.data_num = data_num
        self.downstream_data_filters = downstream_data_filters

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        stream_id = field.Uint8._read_from(rd)
        data_num = field.Uint16._read_from(rd)
        downstream_data_filters = [
            DownstreamDataFilter._read_from(rd) for i in range(data_num.value)
        ]
        return DownstreamFilter(
            stream_id=stream_id,
            data_num=data_num,
            downstream_data_filters=downstream_data_filters,
        )

    def _write_to(self, wr: io.BufferedWriter):
        self.stream_id._write_to(wr)
        self.data_num._write_to(wr)
        [x._write_to(wr) for x in self.downstream_data_filters]

    def _length(self):
        l = 0
        l += self.stream_id._length()
        l += self.data_num._length()
        l += sum([v._length() for v in self.downstream_data_filters])
        return l


class DownstreamDataFilter(object):
    def __init__(self, channel, data_type, length, content):
        self.channel = channel
        self.data_type = data_type
        self.length = length
        self.content = content

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        channel = field.Uint8._read_from(rd)
        data_type = field.Uint8._read_from(rd)
        length = field.Uint16._read_from(rd)
        content = field.Bytes._read_n_from(rd, length.value)
        return DownstreamDataFilter(
            channel=channel, data_type=data_type, length=length, content=content
        )

    def _write_to(self, wr: io.BufferedWriter):
        self.channel._write_to(wr)
        self.data_type._write_to(wr)
        self.length._write_to(wr)
        self.content._write_to(wr)

    def _length(self):
        l = 0
        l += self.channel._length()
        l += self.data_type._length()
        l += self.length._length()
        l += self.content._length()
        return l


class DownstreamFilterResponse(object):
    def __init__(self, req_id, result_code):
        self.req_id = req_id
        self.result_code = result_code

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        req_id = field.Uint8._read_from(rd)
        result_code = field.Uint8._read_from(rd)
        return DownstreamFilterResponse(req_id=req_id, result_code=result_code)

    def _write_to(self, wr: io.BufferedWriter):
        self.req_id._write_to(wr)
        self.result_code._write_to(wr)

    def _length(self):
        l = 0
        l += self.req_id._length()
        l += self.result_code._length()
        return l


class MeasurementIdRequest(object):
    def __init__(self, req_id, edge_uuid):
        self.req_id = req_id
        self.edge_uuid = edge_uuid

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        req_id = field.Uint8._read_from(rd)
        edge_uuid = field.Uuid._read_from(rd)
        return MeasurementIdRequest(req_id=req_id, edge_uuid=edge_uuid)

    def _write_to(self, wr: io.BufferedWriter):
        self.req_id._write_to(wr)
        self.edge_uuid._write_to(wr)

    def _length(self):
        l = 0
        l += self.req_id._length()
        l += self.edge_uuid._length()
        return l


class MeasurementIdResponse(object):
    def __init__(self, req_id, result_code, measurement_uuid):
        self.req_id = req_id
        self.result_code = result_code
        self.measurement_uuid = measurement_uuid

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        req_id = field.Uint8._read_from(rd)
        result_code = field.Uint8._read_from(rd)
        measurement_uuid = field.Uuid._read_from(rd)
        return MeasurementIdResponse(
            req_id=req_id, result_code=result_code, measurement_uuid=measurement_uuid
        )

    def _write_to(self, wr: io.BufferedWriter):
        self.req_id._write_to(wr)
        self.result_code._write_to(wr)
        self.measurement_uuid._write_to(wr)

    def _length(self):
        l = 0
        l += self.req_id._length()
        l += self.result_code._length()
        l += self.measurement_uuid._length()
        return l


class SosMarker(object):
    def __init__(self, stream_id, serial_number):
        self.stream_id = stream_id
        self.serial_number = serial_number

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        stream_id = field.Uint8._read_from(rd)
        serial_number = field.Uint32._read_from(rd)
        return SosMarker(stream_id=stream_id, serial_number=serial_number)

    def _write_to(self, wr: io.BufferedWriter):
        self.stream_id._write_to(wr)
        self.serial_number._write_to(wr)

    def _length(self):
        l = 0
        l += self.stream_id._length()
        l += self.serial_number._length()
        return l


class EosMarker(object):
    def __init__(self, stream_id, flags, serial_number):
        self.stream_id = stream_id
        self.flags = flags
        self.serial_number = serial_number

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        stream_id = field.Uint8._read_from(rd)
        flags = field.Uint8._read_from(rd)
        serial_number = field.Uint32._read_from(rd)
        return EosMarker(stream_id=stream_id, flags=flags, serial_number=serial_number)

    def _write_to(self, wr: io.BufferedWriter):
        self.stream_id._write_to(wr)
        self.flags._write_to(wr)
        self.serial_number._write_to(wr)

    def _length(self):
        l = 0
        l += self.stream_id._length()
        l += self.flags._length()
        l += self.serial_number._length()
        return l

    @property
    def final(self):
        return ((self.flags.value & 1) >> 0) == 1

    @final.setter
    def final(self, v):
        i = 1 if v else 0
        self.flags.value = self.flags.value | 1 & (i << 0)


class SectionAck(object):
    def __init__(self, stream_id, result_code, serial_number):
        self.stream_id = stream_id
        self.result_code = result_code
        self.serial_number = serial_number

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        stream_id = field.Uint8._read_from(rd)
        result_code = field.Uint8._read_from(rd)
        serial_number = field.Uint32._read_from(rd)
        return SectionAck(
            stream_id=stream_id, result_code=result_code, serial_number=serial_number
        )

    def _write_to(self, wr: io.BufferedWriter):
        self.stream_id._write_to(wr)
        self.result_code._write_to(wr)
        self.serial_number._write_to(wr)

    def _length(self):
        l = 0
        l += self.stream_id._length()
        l += self.result_code._length()
        l += self.serial_number._length()
        return l


class Unit(object):
    def __init__(
        self,
        stream_id,
        channel,
        data_type,
        elapsed_time_sec,
        elapsed_time_frac,
        length,
        content,
    ):
        self.stream_id = stream_id
        self.channel = channel
        self.data_type = data_type
        self.elapsed_time_sec = elapsed_time_sec
        self.elapsed_time_frac = elapsed_time_frac
        self.length = length
        self.content = content

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        stream_id = field.Uint8._read_from(rd)
        channel = field.Uint8._read_from(rd)
        data_type = field.Uint8._read_from(rd)
        elapsed_time_sec = field.VarUint16to24._read_from(rd)
        elapsed_time_frac = field.VarUint16to32._read_from(rd)
        length = field.VarUint8to32._read_from(rd)
        content = field.Bytes._read_n_from(rd, length.value)
        return Unit(
            stream_id=stream_id,
            channel=channel,
            data_type=data_type,
            elapsed_time_sec=elapsed_time_sec,
            elapsed_time_frac=elapsed_time_frac,
            length=length,
            content=content,
        )

    def _write_to(self, wr: io.BufferedWriter):
        self.stream_id._write_to(wr)
        self.channel._write_to(wr)
        self.data_type._write_to(wr)
        self.elapsed_time_sec._write_to(wr)
        self.elapsed_time_frac._write_to(wr)
        self.length._write_to(wr)
        self.content._write_to(wr)

    def _length(self):
        l = 0
        l += self.stream_id._length()
        l += self.channel._length()
        l += self.data_type._length()
        l += self.elapsed_time_sec._length()
        l += self.elapsed_time_frac._length()
        l += self.length._length()
        l += self.content._length()
        return l
