"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourcePackage = exports.ResourcePackageProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const bss_generated_1 = require("./bss.generated");
Object.defineProperty(exports, "ResourcePackageProperty", { enumerable: true, get: function () { return bss_generated_1.RosResourcePackage; } });
/**
 * A ROS resource type:  `ALIYUN::BSS::ResourcePackage`
 */
class ResourcePackage extends ros.Resource {
    /**
     * Create a new `ALIYUN::BSS::ResourcePackage`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosResourcePackage = new bss_generated_1.RosResourcePackage(this, id, {
            productCode: props.productCode,
            pricingCycle: props.pricingCycle,
            packageType: props.packageType,
            specification: props.specification,
            duration: props.duration,
            effectiveDate: props.effectiveDate,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosResourcePackage;
        this.attrInstanceId = rosResourcePackage.attrInstanceId;
        this.attrOrderId = rosResourcePackage.attrOrderId;
    }
}
exports.ResourcePackage = ResourcePackage;
//# sourceMappingURL=data:application/json;base64,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