window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"laceworksdk": {"fullname": "laceworksdk", "modulename": "laceworksdk", "type": "module", "doc": "<p>Community-developed Python SDK for interacting with Lacework APIs.</p>\n"}, "laceworksdk.api": {"fullname": "laceworksdk.api", "modulename": "laceworksdk.api", "type": "module", "doc": "<p>Lacework API wrappers.</p>\n"}, "laceworksdk.api.LaceworkClient": {"fullname": "laceworksdk.api.LaceworkClient", "modulename": "laceworksdk.api", "qualname": "LaceworkClient", "type": "class", "doc": "<p>Lacework API wrapper for Python.</p>\n"}, "laceworksdk.api.LaceworkClient.__init__": {"fullname": "laceworksdk.api.LaceworkClient.__init__", "modulename": "laceworksdk.api", "qualname": "LaceworkClient.__init__", "type": "function", "doc": "<p>Initializes the Lacework Client object.</p>\n\n<p>Order of operation is:\n    1. Parameters passed in via the init function (flags).\n    2. Environmental variables.\n    3. Configuration file, located in ~/.lacework.toml</p>\n\n<p>:return LaceworkClient object.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">account</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">subaccount</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">api_key</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">api_secret</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">instance</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">base_domain</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">profile</span><span class=\"o\">=</span><span class=\"kc\">None</span></span>)</span>"}, "laceworksdk.api.LaceworkClient.set_org_level_access": {"fullname": "laceworksdk.api.LaceworkClient.set_org_level_access", "modulename": "laceworksdk.api", "qualname": "LaceworkClient.set_org_level_access", "type": "function", "doc": "<p>A method to set whether the client should use organization-level API calls.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">org_level_access</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.LaceworkClient.set_subaccount": {"fullname": "laceworksdk.api.LaceworkClient.set_subaccount", "modulename": "laceworksdk.api", "qualname": "LaceworkClient.set_subaccount", "type": "function", "doc": "<p>A method to update the subaccount the client should use for API calls.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">subaccount</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.base_endpoint": {"fullname": "laceworksdk.api.base_endpoint", "modulename": "laceworksdk.api.base_endpoint", "type": "module", "doc": "<p></p>\n"}, "laceworksdk.api.base_endpoint.BaseEndpoint": {"fullname": "laceworksdk.api.base_endpoint.BaseEndpoint", "modulename": "laceworksdk.api.base_endpoint", "qualname": "BaseEndpoint", "type": "class", "doc": "<p>A class used to implement base functionality for Lacework API Endpoints</p>\n"}, "laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"fullname": "laceworksdk.api.base_endpoint.BaseEndpoint.__init__", "modulename": "laceworksdk.api.base_endpoint", "qualname": "BaseEndpoint.__init__", "type": "function", "doc": "<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class.</li>\n<li><strong>object_type</strong>:  The Lacework object type to use.</li>\n<li><strong>endpoint_root</strong>:  The URL endpoint root to use.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span>, </span><span class=\"param\"><span class=\"n\">object_type</span>, </span><span class=\"param\"><span class=\"n\">endpoint_root</span><span class=\"o\">=</span><span class=\"s1\">&#39;/api/v2&#39;</span></span>)</span>"}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"fullname": "laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items", "modulename": "laceworksdk.api.base_endpoint", "qualname": "BaseEndpoint.build_dict_from_items", "type": "function", "doc": "<p>A method to build a dictionary based on inputs, pruning items that are None.</p>\n\n<p>:returns: A single dict built from the input.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">dicts</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">items</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"fullname": "laceworksdk.api.base_endpoint.BaseEndpoint.build_url", "modulename": "laceworksdk.api.base_endpoint", "qualname": "BaseEndpoint.build_url", "type": "function", "doc": "<p>Builds the URL to use based on the endpoint path, resource, type, and ID.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>id</strong>:  A string representing the ID of an object to use in the URL</li>\n<li><strong>resource</strong>:  A string representing the type of resource to append to the URL</li>\n<li><strong>action</strong>:  A string representing the type of action to append to the URL</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">resource</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">action</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.base_endpoint.BaseEndpoint.session": {"fullname": "laceworksdk.api.base_endpoint.BaseEndpoint.session", "modulename": "laceworksdk.api.base_endpoint", "qualname": "BaseEndpoint.session", "type": "variable", "doc": "<p>Get the <code>HttpSession</code> instance the object is using.</p>\n"}, "laceworksdk.api.base_endpoint.BaseEndpoint.validate_json": {"fullname": "laceworksdk.api.base_endpoint.BaseEndpoint.validate_json", "modulename": "laceworksdk.api.base_endpoint", "qualname": "BaseEndpoint.validate_json", "type": "function", "doc": "<p>TODO: A method to validate the provided JSON based on the schema of the current object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">json</span>, </span><span class=\"param\"><span class=\"n\">subtype</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.crud_endpoint": {"fullname": "laceworksdk.api.crud_endpoint", "modulename": "laceworksdk.api.crud_endpoint", "type": "module", "doc": "<p></p>\n"}, "laceworksdk.api.crud_endpoint.CrudEndpoint": {"fullname": "laceworksdk.api.crud_endpoint.CrudEndpoint", "modulename": "laceworksdk.api.crud_endpoint", "qualname": "CrudEndpoint", "type": "class", "doc": "<p>A class used to implement CRUD create/read/update/delete functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.base_endpoint.BaseEndpoint"}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"fullname": "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__", "modulename": "laceworksdk.api.crud_endpoint", "qualname": "CrudEndpoint.__init__", "type": "function", "doc": "<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class.</li>\n<li><strong>object_type</strong>:  The Lacework object type to use.</li>\n<li><strong>endpoint_root</strong>:  The URL endpoint root to use.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span>, </span><span class=\"param\"><span class=\"n\">object_type</span>, </span><span class=\"param\"><span class=\"n\">endpoint_root</span><span class=\"o\">=</span><span class=\"s1\">&#39;/api/v2&#39;</span></span>)</span>"}, "laceworksdk.api.crud_endpoint.CrudEndpoint.create": {"fullname": "laceworksdk.api.crud_endpoint.CrudEndpoint.create", "modulename": "laceworksdk.api.crud_endpoint", "qualname": "CrudEndpoint.create", "type": "function", "doc": "<p>A method to create a new object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>request_params</strong>:  Request parameters.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">params</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"fullname": "laceworksdk.api.crud_endpoint.CrudEndpoint.get", "modulename": "laceworksdk.api.crud_endpoint", "qualname": "CrudEndpoint.get", "type": "function", "doc": "<p>A method to get objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object ID.</li>\n<li><strong>type</strong>:  A string representing the object resource type.</li>\n<li><strong>request_params</strong>:  A dictionary of parameters to add to the request.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">resource</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.crud_endpoint.CrudEndpoint.search": {"fullname": "laceworksdk.api.crud_endpoint.CrudEndpoint.search", "modulename": "laceworksdk.api.crud_endpoint", "qualname": "CrudEndpoint.search", "type": "function", "doc": "<p>A method to search objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>json</strong>:  A dictionary containing the desired search parameters.\n(filters, returns)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">json</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.crud_endpoint.CrudEndpoint.update": {"fullname": "laceworksdk.api.crud_endpoint.CrudEndpoint.update", "modulename": "laceworksdk.api.crud_endpoint", "qualname": "CrudEndpoint.update", "type": "function", "doc": "<p>A method to update an object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object ID.</li>\n<li><strong>request_params</strong>:  Request parameters.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">params</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.crud_endpoint.CrudEndpoint.delete": {"fullname": "laceworksdk.api.crud_endpoint.CrudEndpoint.delete", "modulename": "laceworksdk.api.crud_endpoint", "qualname": "CrudEndpoint.delete", "type": "function", "doc": "<p>A method to delete an object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the alert channel GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span>, </span><span class=\"param\"><span class=\"n\">params</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.search_endpoint": {"fullname": "laceworksdk.api.search_endpoint", "modulename": "laceworksdk.api.search_endpoint", "type": "module", "doc": "<p></p>\n"}, "laceworksdk.api.search_endpoint.SearchEndpoint": {"fullname": "laceworksdk.api.search_endpoint.SearchEndpoint", "modulename": "laceworksdk.api.search_endpoint", "qualname": "SearchEndpoint", "type": "class", "doc": "<p>A class used to implement Search functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.base_endpoint.BaseEndpoint"}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"fullname": "laceworksdk.api.search_endpoint.SearchEndpoint.__init__", "modulename": "laceworksdk.api.search_endpoint", "qualname": "SearchEndpoint.__init__", "type": "function", "doc": "<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class.</li>\n<li><strong>object_type</strong>:  The Lacework object type to use.</li>\n<li><strong>endpoint_root</strong>:  The URL endpoint root to use.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span>, </span><span class=\"param\"><span class=\"n\">object_type</span>, </span><span class=\"param\"><span class=\"n\">endpoint_root</span><span class=\"o\">=</span><span class=\"s1\">&#39;/api/v2&#39;</span></span>)</span>"}, "laceworksdk.api.search_endpoint.SearchEndpoint.RESOURCE": {"fullname": "laceworksdk.api.search_endpoint.SearchEndpoint.RESOURCE", "modulename": "laceworksdk.api.search_endpoint", "qualname": "SearchEndpoint.RESOURCE", "type": "variable", "doc": "<p></p>\n", "default_value": " = &#x27;&#x27;"}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"fullname": "laceworksdk.api.search_endpoint.SearchEndpoint.search", "modulename": "laceworksdk.api.search_endpoint", "qualname": "SearchEndpoint.search", "type": "function", "doc": "<p>A method to search objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>json</strong>:  A dictionary containing the desired search parameters.\n(timeFilter, filters, returns)</li>\n</ul>\n\n<p>:return a generator which yields a page of objects at a time as returned by the Lacework API.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">json</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">resource</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1": {"fullname": "laceworksdk.api.v1", "modulename": "laceworksdk.api.v1", "type": "module", "doc": "<p></p>\n"}, "laceworksdk.api.v1.account": {"fullname": "laceworksdk.api.v1.account", "modulename": "laceworksdk.api.v1.account", "type": "module", "doc": "<p>Lacework Account API wrapper.</p>\n"}, "laceworksdk.api.v1.account.AccountAPI": {"fullname": "laceworksdk.api.v1.account.AccountAPI", "modulename": "laceworksdk.api.v1.account", "qualname": "AccountAPI", "type": "class", "doc": "<p>Lacework Account API.</p>\n"}, "laceworksdk.api.v1.account.AccountAPI.__init__": {"fullname": "laceworksdk.api.v1.account.AccountAPI.__init__", "modulename": "laceworksdk.api.v1.account", "qualname": "AccountAPI.__init__", "type": "function", "doc": "<p>Initializes the AccountAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class.</li>\n</ul>\n\n<p>:return AccountAPI object</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v1.account.AccountAPI.get_org_info": {"fullname": "laceworksdk.api.v1.account.AccountAPI.get_org_info", "modulename": "laceworksdk.api.v1.account", "qualname": "AccountAPI.get_org_info", "type": "function", "doc": "<p>A method to get Account's organization info</p>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.compliance": {"fullname": "laceworksdk.api.v1.compliance", "modulename": "laceworksdk.api.v1.compliance", "type": "module", "doc": "<p>Lacework Compliance API wrapper.</p>\n"}, "laceworksdk.api.v1.compliance.ComplianceAPI": {"fullname": "laceworksdk.api.v1.compliance.ComplianceAPI", "modulename": "laceworksdk.api.v1.compliance", "qualname": "ComplianceAPI", "type": "class", "doc": "<p>Lacework Compliance API.</p>\n"}, "laceworksdk.api.v1.compliance.ComplianceAPI.__init__": {"fullname": "laceworksdk.api.v1.compliance.ComplianceAPI.__init__", "modulename": "laceworksdk.api.v1.compliance", "qualname": "ComplianceAPI.__init__", "type": "function", "doc": "<p>Initializes the ComplianceAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return ComplianceAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"fullname": "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report", "modulename": "laceworksdk.api.v1.compliance", "qualname": "ComplianceAPI.get_latest_aws_report", "type": "function", "doc": "<p>A method to get the latest compiance report for an AWS account.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>aws_account_id</strong>:  A string representing which AWS Account to query.</li>\n<li><strong>file_format</strong>:  A string representing the desired file format. (\"pdf\" or \"json\")</li>\n<li><strong>report_type</strong>:  A string representing the desired report type.\n(\"AWS_CIS_S3\", \"NIST_800-53_Rev4\", \"ISO_2700\", \"HIPAA\", \"SOC\", or \"PCI\")</li>\n<li><strong>pdf_path</strong>:  An absolute path for writing PDF compliance reports</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">aws_account_id</span>,</span><span class=\"param\">\t<span class=\"n\">file_format</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">report_type</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">pdf_path</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"fullname": "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report", "modulename": "laceworksdk.api.v1.compliance", "qualname": "ComplianceAPI.get_latest_azure_report", "type": "function", "doc": "<p>A method to get the latest compiance report for an Azure tenant.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>azure_tenant_id</strong>:  A string representing which Azure Tenant to query.</li>\n<li><strong>azure_subscription_id</strong>:  A string representing which Azure Subscription to query.</li>\n<li><strong>file_format</strong>:  A string representing the desired file format. (\"pdf\" or \"json\")</li>\n<li><strong>report_type</strong>:  A string representing the desired report type.\n(\"AZURE_CIS\", \"AZURE_SOC\", or \"AZURE_PCI\")</li>\n<li><strong>pdf_path</strong>:  An absolute path for writing PDF compliance reports</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">azure_tenant_id</span>,</span><span class=\"param\">\t<span class=\"n\">azure_subscription_id</span>,</span><span class=\"param\">\t<span class=\"n\">file_format</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">report_type</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">pdf_path</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"fullname": "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report", "modulename": "laceworksdk.api.v1.compliance", "qualname": "ComplianceAPI.get_latest_gcp_report", "type": "function", "doc": "<p>A method to get the latest compiance report for a Google Cloud organization.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>gcp_organization_id</strong>:  A string representing which GCP Organization to query.</li>\n<li><strong>gcp_project_id</strong>:  A string representing which GCP Project to query.</li>\n<li><strong>file_format</strong>:  A string representing the desired file format. (\"pdf\" or \"json\")</li>\n<li><strong>report_type</strong>:  A string representing the desired report type.\n(\"GCP_CIS\", \"GCP_SOC\", or \"GCP_PCI\")</li>\n<li><strong>pdf_path</strong>:  An absolute path for writing PDF compliance reports</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">gcp_organization_id</span>,</span><span class=\"param\">\t<span class=\"n\">gcp_project_id</span>,</span><span class=\"param\">\t<span class=\"n\">file_format</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">report_type</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">pdf_path</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"fullname": "laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions", "modulename": "laceworksdk.api.v1.compliance", "qualname": "ComplianceAPI.list_azure_subscriptions", "type": "function", "doc": "<p>A method to list the subscriptions in an Azure account.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>azure_tenant_id</strong>:  A string representing which Azure Tenant to query.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">azure_tenant_id</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"fullname": "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects", "modulename": "laceworksdk.api.v1.compliance", "qualname": "ComplianceAPI.list_gcp_projects", "type": "function", "doc": "<p>A method to list the projects in a Google Cloud organization.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>gcp_organization_id</strong>:  A string representing which GCP Organization to query.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">gcp_organization_id</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.custom_compliance_config": {"fullname": "laceworksdk.api.v1.custom_compliance_config", "modulename": "laceworksdk.api.v1.custom_compliance_config", "type": "module", "doc": "<p>Lacework Custom Compliance Config API wrapper.</p>\n"}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI": {"fullname": "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI", "modulename": "laceworksdk.api.v1.custom_compliance_config", "qualname": "CustomComplianceConfigAPI", "type": "class", "doc": "<p>Lacework Custom Compliance Config API.</p>\n"}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"fullname": "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__", "modulename": "laceworksdk.api.v1.custom_compliance_config", "qualname": "CustomComplianceConfigAPI.__init__", "type": "function", "doc": "<p>Initializes the CustomComplianceConfigAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class.</li>\n</ul>\n\n<p>:return CustomComplianceConfigAPI object</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.get": {"fullname": "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.get", "modulename": "laceworksdk.api.v1.custom_compliance_config", "qualname": "CustomComplianceConfigAPI.get", "type": "function", "doc": "<p>A method to get the custom compliance settings from Lacework.</p>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"fullname": "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set", "modulename": "laceworksdk.api.v1.custom_compliance_config", "qualname": "CustomComplianceConfigAPI.set", "type": "function", "doc": "<p>A method to set the custom compliance settings in Lacework.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>settings</strong>:  A JSON object</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">data</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.download_file": {"fullname": "laceworksdk.api.v1.download_file", "modulename": "laceworksdk.api.v1.download_file", "type": "module", "doc": "<p>Lacework Download File API wrapper.</p>\n"}, "laceworksdk.api.v1.download_file.DownloadFileAPI": {"fullname": "laceworksdk.api.v1.download_file.DownloadFileAPI", "modulename": "laceworksdk.api.v1.download_file", "qualname": "DownloadFileAPI", "type": "class", "doc": "<p>Lacework Download File API.</p>\n"}, "laceworksdk.api.v1.download_file.DownloadFileAPI.__init__": {"fullname": "laceworksdk.api.v1.download_file.DownloadFileAPI.__init__", "modulename": "laceworksdk.api.v1.download_file", "qualname": "DownloadFileAPI.__init__", "type": "function", "doc": "<p>Initializes the DownloadFileAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return DownloadFileAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"fullname": "laceworksdk.api.v1.download_file.DownloadFileAPI.get", "modulename": "laceworksdk.api.v1.download_file", "qualname": "DownloadFileAPI.get", "type": "function", "doc": "<p>A method to get the AWS CloudFormation template of the specified type.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>file</strong>:  a string representing which template to download.\n(\"aws-config\" or \"aws-cloudtrail\")</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">file</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.events": {"fullname": "laceworksdk.api.v1.events", "modulename": "laceworksdk.api.v1.events", "type": "module", "doc": "<p>Lacework Events API wrapper.</p>\n"}, "laceworksdk.api.v1.events.EventsAPIv1": {"fullname": "laceworksdk.api.v1.events.EventsAPIv1", "modulename": "laceworksdk.api.v1.events", "qualname": "EventsAPIv1", "type": "class", "doc": "<p>Lacework Events API.</p>\n"}, "laceworksdk.api.v1.events.EventsAPIv1.__init__": {"fullname": "laceworksdk.api.v1.events.EventsAPIv1.__init__", "modulename": "laceworksdk.api.v1.events", "qualname": "EventsAPIv1.__init__", "type": "function", "doc": "<p>Initializes the EventsAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class.</li>\n</ul>\n\n<p>:return EventsAPI object</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v1.events.EventsAPIv1.get": {"fullname": "laceworksdk.api.v1.events.EventsAPIv1.get", "modulename": "laceworksdk.api.v1.events", "qualname": "EventsAPIv1.get", "type": "function", "doc": "<p>A method to get Event details</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>event_id</strong>:  An integer representing the Event ID to retrieve.</li>\n<li><strong>start_time: A \"%Y-%m-%dT%H:%M</strong>: %S%z\" structured timestamp to begin from.</li>\n<li><strong>end_time: A \"%Y-%m-%dT%H:%M</strong>: %S%z\" structured timestamp to end at.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">start_time</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">end_time</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.events.EventsAPIv1.get_details": {"fullname": "laceworksdk.api.v1.events.EventsAPIv1.get_details", "modulename": "laceworksdk.api.v1.events", "qualname": "EventsAPIv1.get_details", "type": "function", "doc": "<p>A method to get the Event Details for the specified Event ID.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>event_id</strong>:  An integer representing the Event ID to retrieve.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">event_id</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"fullname": "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range", "modulename": "laceworksdk.api.v1.events", "qualname": "EventsAPIv1.get_for_date_range", "type": "function", "doc": "<p>A method to get Events for the specified time range.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>start_time: A \"%Y-%m-%dT%H:%M</strong>: %S%z\" structured timestamp to begin from.</li>\n<li><strong>end_time: A \"%Y-%m-%dT%H:%M</strong>: %S%z\" structured timestamp to end at.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">start_time</span>, </span><span class=\"param\"><span class=\"n\">end_time</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.integrations": {"fullname": "laceworksdk.api.v1.integrations", "modulename": "laceworksdk.api.v1.integrations", "type": "module", "doc": "<p>Lacework Integrations API wrapper.</p>\n"}, "laceworksdk.api.v1.integrations.IntegrationsAPI": {"fullname": "laceworksdk.api.v1.integrations.IntegrationsAPI", "modulename": "laceworksdk.api.v1.integrations", "qualname": "IntegrationsAPI", "type": "class", "doc": "<p>Lacework Integrations API.</p>\n"}, "laceworksdk.api.v1.integrations.IntegrationsAPI.__init__": {"fullname": "laceworksdk.api.v1.integrations.IntegrationsAPI.__init__", "modulename": "laceworksdk.api.v1.integrations", "qualname": "IntegrationsAPI.__init__", "type": "function", "doc": "<p>Initializes the IntegrationsAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return IntegrationsAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"fullname": "laceworksdk.api.v1.integrations.IntegrationsAPI.create", "modulename": "laceworksdk.api.v1.integrations", "qualname": "IntegrationsAPI.create", "type": "function", "doc": "<p>A method to create a new cloud integration.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>name</strong>:  A string representing the integration name.</li>\n<li><strong>type</strong>:  A string representing the integration type.</li>\n<li><strong>enabled</strong>:  An integer representing whether the integration is enabled.\n(0 or 1)</li>\n<li><strong>data</strong>:  A JSON object matching the schema for the specified type.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span>, </span><span class=\"param\"><span class=\"nb\">type</span>, </span><span class=\"param\"><span class=\"n\">enabled</span>, </span><span class=\"param\"><span class=\"n\">data</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"fullname": "laceworksdk.api.v1.integrations.IntegrationsAPI.get", "modulename": "laceworksdk.api.v1.integrations", "qualname": "IntegrationsAPI.get", "type": "function", "doc": "<p>A generic method to get cloud integrations.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the integration GUID.</li>\n<li><strong>schema</strong>:  A string representing the schema type.</li>\n<li><strong>type</strong>:  A string representing the integration type.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">schema</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"nb\">type</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_all": {"fullname": "laceworksdk.api.v1.integrations.IntegrationsAPI.get_all", "modulename": "laceworksdk.api.v1.integrations", "qualname": "IntegrationsAPI.get_all", "type": "function", "doc": "<p>A method to get a list of all cloud integrations.</p>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"fullname": "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id", "modulename": "laceworksdk.api.v1.integrations", "qualname": "IntegrationsAPI.get_by_id", "type": "function", "doc": "<p>A method to get the specified cloud integration.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>id</strong>:  A string representing the Lacework integration GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"fullname": "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type", "modulename": "laceworksdk.api.v1.integrations", "qualname": "IntegrationsAPI.get_by_type", "type": "function", "doc": "<p>A method to get the specified cloud integration.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>type</strong>:  A string representing the integration type.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">type</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"fullname": "laceworksdk.api.v1.integrations.IntegrationsAPI.update", "modulename": "laceworksdk.api.v1.integrations", "qualname": "IntegrationsAPI.update", "type": "function", "doc": "<p>A method to update the specified cloud integration.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the Lacework integration GUID.</li>\n<li><strong>name</strong>:  A string representing the integration name.</li>\n<li><strong>type</strong>:  A string representing the integration type.</li>\n<li><strong>enabled</strong>:  An integer representing whether the integration is enabled.\n(0 or 1)</li>\n<li><strong>data</strong>:  A JSON object matching the schema for the specified type.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"nb\">type</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">enabled</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"fullname": "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id", "modulename": "laceworksdk.api.v1.integrations", "qualname": "IntegrationsAPI.update_by_id", "type": "function", "doc": "<p>A method to update the specified cloud integration.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>id</strong>:  A string representing the Lacework integration GUID.</li>\n<li><strong>name</strong>:  A string representing the integration name.</li>\n<li><strong>type</strong>:  A string representing the integration type.</li>\n<li><strong>enabled</strong>:  An integer representing whether the integration is enabled. (0 or 1)</li>\n<li><strong>data</strong>:  A JSON object matching the schema for the specified type.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"nb\">type</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">enabled</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"fullname": "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status", "modulename": "laceworksdk.api.v1.integrations", "qualname": "IntegrationsAPI.update_status", "type": "function", "doc": "<p>A method to update the status of a specified cloud integration.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>id</strong>:  A string representing the Lacework integration GUID.</li>\n<li><strong>enabled</strong>:  A boolean representing whether the integration is enabled.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span>, </span><span class=\"param\"><span class=\"n\">enabled</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete": {"fullname": "laceworksdk.api.v1.integrations.IntegrationsAPI.delete", "modulename": "laceworksdk.api.v1.integrations", "qualname": "IntegrationsAPI.delete", "type": "function", "doc": "<p>A method to delete the specified cloud integration.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the Lacework integration GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"fullname": "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id", "modulename": "laceworksdk.api.v1.integrations", "qualname": "IntegrationsAPI.delete_by_id", "type": "function", "doc": "<p>A method to delete the specified cloud integration.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>id</strong>:  A string representing the Lacework integration GUID.</li>\n</ul>\n\n<p>:return response json</p>\n\n<p><em>*</em>* Needs to be deprecated</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"fullname": "laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema", "modulename": "laceworksdk.api.v1.integrations", "qualname": "IntegrationsAPI.get_schema", "type": "function", "doc": "<p>A method to get the schema for a specified cloud integration type.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>type</strong>:  A string representing the integration type.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">type</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.recommendations": {"fullname": "laceworksdk.api.v1.recommendations", "modulename": "laceworksdk.api.v1.recommendations", "type": "module", "doc": "<p>Lacework Recommendations API wrapper.</p>\n"}, "laceworksdk.api.v1.recommendations.RecommendationsAPI": {"fullname": "laceworksdk.api.v1.recommendations.RecommendationsAPI", "modulename": "laceworksdk.api.v1.recommendations", "qualname": "RecommendationsAPI", "type": "class", "doc": "<p>Lacework Recommendations API.</p>\n"}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.__init__": {"fullname": "laceworksdk.api.v1.recommendations.RecommendationsAPI.__init__", "modulename": "laceworksdk.api.v1.recommendations", "qualname": "RecommendationsAPI.__init__", "type": "function", "doc": "<p>Initializes the RecommendationsAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return RecommendationsAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"fullname": "laceworksdk.api.v1.recommendations.RecommendationsAPI.get", "modulename": "laceworksdk.api.v1.recommendations", "qualname": "RecommendationsAPI.get", "type": "function", "doc": "<p>A method to get all compliance recommendations for the specified Cloud Service Provider.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>type</strong>:  A string representing the type of CSP recommendations to retreive.\n('aws', 'azure', or 'gcp')</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">type</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"fullname": "laceworksdk.api.v1.recommendations.RecommendationsAPI.update", "modulename": "laceworksdk.api.v1.recommendations", "qualname": "RecommendationsAPI.update", "type": "function", "doc": "<p>A method to update compliance recommendations for the specified Cloud Service Provider.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>type</strong>:  A string representing the type of CSP recommendations to update.\n('aws', 'azure', or 'gcp')</li>\n<li><strong>data</strong>:  A JSON object representing which checks to enable/disable.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">type</span>, </span><span class=\"param\"><span class=\"n\">data</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.run_reports": {"fullname": "laceworksdk.api.v1.run_reports", "modulename": "laceworksdk.api.v1.run_reports", "type": "module", "doc": "<p>Lacework Run Reports API wrapper.</p>\n"}, "laceworksdk.api.v1.run_reports.RunReportsAPI": {"fullname": "laceworksdk.api.v1.run_reports.RunReportsAPI", "modulename": "laceworksdk.api.v1.run_reports", "qualname": "RunReportsAPI", "type": "class", "doc": "<p>Lacework RunReports API.</p>\n"}, "laceworksdk.api.v1.run_reports.RunReportsAPI.__init__": {"fullname": "laceworksdk.api.v1.run_reports.RunReportsAPI.__init__", "modulename": "laceworksdk.api.v1.run_reports", "qualname": "RunReportsAPI.__init__", "type": "function", "doc": "<p>Initializes the RunReportsAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return RunReportsAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"fullname": "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report", "modulename": "laceworksdk.api.v1.run_reports", "qualname": "RunReportsAPI.run_report", "type": "function", "doc": "<p>A method to initiate a compliance assessment.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>type</strong>:  A string representing the type of compliance assessment to initiate.</li>\n<li><strong>account_id</strong>:  A string representing the account identifier for which to initiate a compliance assessment.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">type</span>, </span><span class=\"param\"><span class=\"n\">account_id</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"fullname": "laceworksdk.api.v1.run_reports.RunReportsAPI.aws", "modulename": "laceworksdk.api.v1.run_reports", "qualname": "RunReportsAPI.aws", "type": "function", "doc": "<p>A method to initiate a compliance assessment for an AWS account.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>aws_account_id</strong>:  A string representing which AWS account to assess.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">aws_account_id</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"fullname": "laceworksdk.api.v1.run_reports.RunReportsAPI.azure", "modulename": "laceworksdk.api.v1.run_reports", "qualname": "RunReportsAPI.azure", "type": "function", "doc": "<p>A method to initiate a compliance assessment for an Azure tenant.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>azure_tenant_id</strong>:  A string representing which Azure tenant to assess.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">azure_tenant_id</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"fullname": "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp", "modulename": "laceworksdk.api.v1.run_reports", "qualname": "RunReportsAPI.gcp", "type": "function", "doc": "<p>A method to initiate a compliance assessment for a GCP project.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>gcp_project_id</strong>:  A string representing which GCP project to assess.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">gcp_project_id</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.run_reports.RunReportsAPI.integration": {"fullname": "laceworksdk.api.v1.run_reports.RunReportsAPI.integration", "modulename": "laceworksdk.api.v1.run_reports", "qualname": "RunReportsAPI.integration", "type": "function", "doc": "<p>A method to run a compliance report based on a Lacework integration GUID.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>integration_guid</strong>:  A string representing the Lacework integration ID to query.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">integration_guid</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.suppressions": {"fullname": "laceworksdk.api.v1.suppressions", "modulename": "laceworksdk.api.v1.suppressions", "type": "module", "doc": "<p>Lacework Suppressions API wrapper.</p>\n"}, "laceworksdk.api.v1.suppressions.SuppressionsAPI": {"fullname": "laceworksdk.api.v1.suppressions.SuppressionsAPI", "modulename": "laceworksdk.api.v1.suppressions", "qualname": "SuppressionsAPI", "type": "class", "doc": "<p>Lacework Suppressions API.</p>\n"}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.__init__": {"fullname": "laceworksdk.api.v1.suppressions.SuppressionsAPI.__init__", "modulename": "laceworksdk.api.v1.suppressions", "qualname": "SuppressionsAPI.__init__", "type": "function", "doc": "<p>Initializes the SuppressionsAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return SuppressionsAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"fullname": "laceworksdk.api.v1.suppressions.SuppressionsAPI.create", "modulename": "laceworksdk.api.v1.suppressions", "qualname": "SuppressionsAPI.create", "type": "function", "doc": "<p>A method to create supressions.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>type</strong>:  A string representing the type of CSP supression(s) to create.\n('aws', 'azure', or 'gcp')</li>\n<li><strong>data</strong>:  A JSON object containing the supression(s) to create</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">type</span>, </span><span class=\"param\"><span class=\"n\">data</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"fullname": "laceworksdk.api.v1.suppressions.SuppressionsAPI.get", "modulename": "laceworksdk.api.v1.suppressions", "qualname": "SuppressionsAPI.get", "type": "function", "doc": "<p>A method to get supressions.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>type</strong>:  A string representing the type of CSP suppression(s) to retreive.\n('aws', 'azure', or 'gcp')</li>\n<li><strong>recommendation_id</strong>:  A string representing the recommendation ID to retreive.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">type</span>, </span><span class=\"param\"><span class=\"n\">recommendation_id</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"fullname": "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete", "modulename": "laceworksdk.api.v1.suppressions", "qualname": "SuppressionsAPI.delete", "type": "function", "doc": "<p>A method to delete supressions.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>type</strong>:  A string representing the type of CSP suppression(s) to delete.\n('aws', 'azure', or 'gcp')</li>\n<li><strong>data</strong>:  A JSON object containing the supression(s) to create</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">type</span>, </span><span class=\"param\"><span class=\"n\">data</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.token": {"fullname": "laceworksdk.api.v1.token", "modulename": "laceworksdk.api.v1.token", "type": "module", "doc": "<p>Lacework Agent Access Token API wrapper.</p>\n"}, "laceworksdk.api.v1.token.TokenAPI": {"fullname": "laceworksdk.api.v1.token.TokenAPI", "modulename": "laceworksdk.api.v1.token", "qualname": "TokenAPI", "type": "class", "doc": "<p>Lacework Agent Access Token API.</p>\n"}, "laceworksdk.api.v1.token.TokenAPI.__init__": {"fullname": "laceworksdk.api.v1.token.TokenAPI.__init__", "modulename": "laceworksdk.api.v1.token", "qualname": "TokenAPI.__init__", "type": "function", "doc": "<p>Initializes the TokenAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return TokenAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v1.token.TokenAPI.create": {"fullname": "laceworksdk.api.v1.token.TokenAPI.create", "modulename": "laceworksdk.api.v1.token", "qualname": "TokenAPI.create", "type": "function", "doc": "<p>A method to create a new agent access token.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>alias</strong>:  A string representing the alias for the agent access token.</li>\n<li><strong>enabled</strong>:  A boolean representing whether the agent access token should be enabled.</li>\n<li><strong>description</strong>:  A string representing a description for the agent access token.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">alias</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">enabled</span><span class=\"o\">=</span><span class=\"kc\">True</span>, </span><span class=\"param\"><span class=\"n\">description</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.token.TokenAPI.get": {"fullname": "laceworksdk.api.v1.token.TokenAPI.get", "modulename": "laceworksdk.api.v1.token", "qualname": "TokenAPI.get", "type": "function", "doc": "<p>A method to get a list of enabled agent access tokens.</p>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">access_token</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.token.TokenAPI.get_enabled": {"fullname": "laceworksdk.api.v1.token.TokenAPI.get_enabled", "modulename": "laceworksdk.api.v1.token", "qualname": "TokenAPI.get_enabled", "type": "function", "doc": "<p>A method to get a list of enabled agent access tokens.</p>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.token.TokenAPI.get_token": {"fullname": "laceworksdk.api.v1.token.TokenAPI.get_token", "modulename": "laceworksdk.api.v1.token", "qualname": "TokenAPI.get_token", "type": "function", "doc": "<p>A method to get details about an agent access token.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>access_token</strong>:  A string representing the agent access token to get.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">access_token</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.token.TokenAPI.update": {"fullname": "laceworksdk.api.v1.token.TokenAPI.update", "modulename": "laceworksdk.api.v1.token", "qualname": "TokenAPI.update", "type": "function", "doc": "<p>A method to update the details about an agent access token.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>access_token</strong>:  A string representing the agent access token to update.</li>\n<li><strong>alias</strong>:  A string representing the alias for the agent access token.</li>\n<li><strong>enabled</strong>:  A boolean representing whether the agent access token should be enabled.</li>\n<li><strong>description</strong>:  A string representing a description for the agent access token.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">access_token</span>, </span><span class=\"param\"><span class=\"n\">alias</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">enabled</span><span class=\"o\">=</span><span class=\"kc\">True</span>, </span><span class=\"param\"><span class=\"n\">description</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"fullname": "laceworksdk.api.v1.token.TokenAPI.update_token", "modulename": "laceworksdk.api.v1.token", "qualname": "TokenAPI.update_token", "type": "function", "doc": "<p>A method to update the details about an agent access token.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>access_token</strong>:  A string representing the agent access token to update.</li>\n<li><strong>token_alias</strong>:  A string representing the alias for the agent access token.</li>\n<li><strong>token_enalbed</strong>:  A boolean representing whether the agent access token should be enabled.</li>\n<li><strong>token_description</strong>:  A string representing a description for the agent access token.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">access_token</span>,</span><span class=\"param\">\t<span class=\"n\">token_alias</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">token_enabled</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">token_description</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.vulnerability": {"fullname": "laceworksdk.api.v1.vulnerability", "modulename": "laceworksdk.api.v1.vulnerability", "type": "module", "doc": "<p>Lacework Vulnerability API wrapper.</p>\n"}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI": {"fullname": "laceworksdk.api.v1.vulnerability.VulnerabilityAPI", "modulename": "laceworksdk.api.v1.vulnerability", "qualname": "VulnerabilityAPI", "type": "class", "doc": "<p>Lacework Vulnerability API.</p>\n"}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.__init__": {"fullname": "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.__init__", "modulename": "laceworksdk.api.v1.vulnerability", "qualname": "VulnerabilityAPI.__init__", "type": "function", "doc": "<p>Initializes the VulnerabilityAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return VulnerabilityAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"fullname": "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date", "modulename": "laceworksdk.api.v1.vulnerability", "qualname": "VulnerabilityAPI.get_container_assessments_by_date", "type": "function", "doc": "<p>A method to get a list of container vulnerability assessments for the specified date range.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>start_time: A \"%Y-%m-%dT%H:%M</strong>: %SZ\" structured timestamp to begin from.</li>\n<li><strong>end_time: A \"%Y-%m-%dT%H:%M</strong>: %S%Z\" structured timestamp to end at.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>response json</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">start_time</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">end_time</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"fullname": "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities", "modulename": "laceworksdk.api.v1.vulnerability", "qualname": "VulnerabilityAPI.get_container_vulnerabilities", "type": "function", "doc": "<p>A method to get the last scan data of the specified container.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>image_digest</strong>:  A string representing the container image digest for which to fetch vulnerabilities.</li>\n<li><strong>image_id</strong>:  A string representing the container image ID for which to fetch vulnerabilities.</li>\n<li><strong>severity</strong>:  A string representing the severity of vulnerabilities to fetch.</li>\n<li><strong>fixable</strong>:  A boolean which filters for fixable vulnerabilities.</li>\n<li><strong>start_time: A \"%Y-%m-%dT%H:%M</strong>: %S%z\" structured timestamp to begin from.</li>\n<li><strong>end_time: A \"%Y-%m-%dT%H:%M</strong>: %S%z\" structured timestamp to end at.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>response json</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">image_digest</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">image_id</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">severity</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">fixable</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">start_time</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">end_time</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"fullname": "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan", "modulename": "laceworksdk.api.v1.vulnerability", "qualname": "VulnerabilityAPI.initiate_container_scan", "type": "function", "doc": "<p>A method to initiate a container vulnerability scan.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>registry</strong>:  A string representing the container registry.</li>\n<li><strong>repository</strong>:  A string representing the container repository.</li>\n<li><strong>tag</strong>:  A string representing the container tag.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>response json</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">registry</span>, </span><span class=\"param\"><span class=\"n\">repository</span>, </span><span class=\"param\"><span class=\"n\">tag</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"fullname": "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status", "modulename": "laceworksdk.api.v1.vulnerability", "qualname": "VulnerabilityAPI.get_container_scan_status", "type": "function", "doc": "<p>A method to get the status/results of a container vulnerability scan from Lacework.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>request_id</strong>:  A string representing the request ID to be queried.</li>\n<li><strong>severity</strong>:  A string representing the severity of vulnerabilities to fetch.</li>\n<li><strong>fixable</strong>:  A boolean which filters for fixable vulnerabilities.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>response json</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">request_id</span>, </span><span class=\"param\"><span class=\"n\">severity</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">fixable</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"fullname": "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities", "modulename": "laceworksdk.api.v1.vulnerability", "qualname": "VulnerabilityAPI.get_host_vulnerabilities", "type": "function", "doc": "<p>A method to get the Host Vulnerabilities found by Lacework.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>fixable</strong>:  A boolean which filters for fixable vulnerabilities.</li>\n<li><strong>namespace</strong>:  A string representing the package namespace for which to filter results.</li>\n<li><strong>severity</strong>:  A string representing the severity for which to filter returned results.</li>\n<li><strong>start_time: A \"%Y-%m-%dT%H:%M</strong>: %S%z\" structured timestamp to begin from.</li>\n<li><strong>end_time: A \"%Y-%m-%dT%H:%M</strong>: %S%z\" structured timestamp to end at.</li>\n<li><strong>cve</strong>:  A string representing the CVE ID for which to filter returned results.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>response json</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">fixable</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">namespace</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">severity</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">start_time</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">end_time</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">cve</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"fullname": "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve", "modulename": "laceworksdk.api.v1.vulnerability", "qualname": "VulnerabilityAPI.get_host_vulnerabilities_by_cve", "type": "function", "doc": "<p>A method to get the Host Vulnerabilities by CVE.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>cve</strong>:  A string representing the CVE ID for which to filter returned results.</li>\n<li><strong>hostname</strong>:  A string representing a hostname for which to filter returned results.</li>\n<li><strong>machine_status</strong>:  A string representing the machine status for which to filter results.</li>\n<li><strong>status</strong>:  A string representing a status for which to filter results.\n(\"New\", \"Active\", or \"Fixed\")</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>response json</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">cve</span>, </span><span class=\"param\"><span class=\"n\">hostname</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">machine_status</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">status</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"fullname": "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id", "modulename": "laceworksdk.api.v1.vulnerability", "qualname": "VulnerabilityAPI.get_host_vulnerabilities_by_machine_id", "type": "function", "doc": "<p>A method to get the Host Vulnerabilities by Machine ID.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>machine</strong>:  A string representing the Lacework Machine ID.</li>\n<li><strong>fixable</strong>:  A boolean which filters for fixable vulnerabilities.</li>\n<li><strong>namespace</strong>:  A string representing the package namespace for which to filter results.</li>\n<li><strong>severity</strong>:  A string representing a severity for which to filter returned results.</li>\n<li><strong>start_time: A \"%Y-%m-%dT%H:%M</strong>: %S%z\" structured timestamp to begin from.</li>\n<li><strong>end_time: A \"%Y-%m-%dT%H:%M</strong>: %S%z\" structured timestamp to end at.</li>\n<li><strong>cve</strong>:  A string representing the CVE ID for which to filter returned results.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>response json</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">machine</span>,</span><span class=\"param\">\t<span class=\"n\">fixable</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">namespace</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">severity</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">start_time</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">end_time</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">cve</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"fullname": "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan", "modulename": "laceworksdk.api.v1.vulnerability", "qualname": "VulnerabilityAPI.initiate_package_scan", "type": "function", "doc": "<p>A method to initiate a package vulnerability scan in Lacework.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><p><strong>os_pkg_info_list</strong>:  A Lacework PackageScanRequest object.  This is a list of packages to be scanned\ngiven the OS, OS Version, Package, and Package Version.  Up to 1,000 packages can be submitted with\na single request.</p></li>\n<li><p><strong>os</strong>:  A string representing the operating system for which to initiate a scan.</p></li>\n<li><strong>os_version</strong>:  A string representing the operating system version(s) for which to initiate a scan.</li>\n<li><strong>package</strong>:  A string representing the software package for which to initiate a scan.</li>\n<li><strong>package_version</strong>:  A string representing the software package version(s) for which to initiate a scan.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>response json</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">os_pkg_info_list</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">os</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">os_version</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">package</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">package_version</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2": {"fullname": "laceworksdk.api.v2", "modulename": "laceworksdk.api.v2", "type": "module", "doc": "<p></p>\n"}, "laceworksdk.api.v2.activities": {"fullname": "laceworksdk.api.v2.activities", "modulename": "laceworksdk.api.v2.activities", "type": "module", "doc": "<p>Lacework Activities API wrapper.</p>\n"}, "laceworksdk.api.v2.activities.ActivitiesAPI": {"fullname": "laceworksdk.api.v2.activities.ActivitiesAPI", "modulename": "laceworksdk.api.v2.activities", "qualname": "ActivitiesAPI", "type": "class", "doc": "<p>A class used to represent the Activities API endpoint.</p>\n\n<p>The Activities API endpoint is simply a parent for different types of\nactivities that can be queried.</p>\n\n<h2 id=\"attributes\">Attributes</h2>\n\n<p>changed_files:\n    A ChangedFilesAPI instance.\nconnections:\n    A ConnectionsAPI instance.\ndns:\n    A DnsAPI instance.\nuser_logins:\n    A UserLoginsAPI instance.</p>\n"}, "laceworksdk.api.v2.activities.ActivitiesAPI.__init__": {"fullname": "laceworksdk.api.v2.activities.ActivitiesAPI.__init__", "modulename": "laceworksdk.api.v2.activities", "qualname": "ActivitiesAPI.__init__", "type": "function", "doc": "<p>Initializes the ActivitiesAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return ActivitiesAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.activities.ChangedFilesAPI": {"fullname": "laceworksdk.api.v2.activities.ChangedFilesAPI", "modulename": "laceworksdk.api.v2.activities", "qualname": "ChangedFilesAPI", "type": "class", "doc": "<p>A class used to represent the Changed Files API endpoint.</p>\n\n<h2 id=\"methods\">Methods</h2>\n\n<p>search(json=None)\n    A method to search ChangedFiles objects.</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.activities.ChangedFilesAPI.RESOURCE": {"fullname": "laceworksdk.api.v2.activities.ChangedFilesAPI.RESOURCE", "modulename": "laceworksdk.api.v2.activities", "qualname": "ChangedFilesAPI.RESOURCE", "type": "variable", "doc": "<p></p>\n", "default_value": " = &#x27;ChangedFiles&#x27;"}, "laceworksdk.api.v2.activities.ConnectionsAPI": {"fullname": "laceworksdk.api.v2.activities.ConnectionsAPI", "modulename": "laceworksdk.api.v2.activities", "qualname": "ConnectionsAPI", "type": "class", "doc": "<p>A class used to represent the Connections API endpoint.</p>\n\n<h2 id=\"methods\">Methods</h2>\n\n<p>search(json=None)\n    A method to search Connections objects.</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.activities.ConnectionsAPI.RESOURCE": {"fullname": "laceworksdk.api.v2.activities.ConnectionsAPI.RESOURCE", "modulename": "laceworksdk.api.v2.activities", "qualname": "ConnectionsAPI.RESOURCE", "type": "variable", "doc": "<p></p>\n", "default_value": " = &#x27;Connections&#x27;"}, "laceworksdk.api.v2.activities.DnsAPI": {"fullname": "laceworksdk.api.v2.activities.DnsAPI", "modulename": "laceworksdk.api.v2.activities", "qualname": "DnsAPI", "type": "class", "doc": "<p>A class used to represent the DNS Lookup API endpoint.</p>\n\n<h2 id=\"methods\">Methods</h2>\n\n<p>search(json=None)\n    A method to search DNS lookup objects.</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.activities.DnsAPI.RESOURCE": {"fullname": "laceworksdk.api.v2.activities.DnsAPI.RESOURCE", "modulename": "laceworksdk.api.v2.activities", "qualname": "DnsAPI.RESOURCE", "type": "variable", "doc": "<p></p>\n", "default_value": " = &#x27;DNSs&#x27;"}, "laceworksdk.api.v2.activities.UserLoginsAPI": {"fullname": "laceworksdk.api.v2.activities.UserLoginsAPI", "modulename": "laceworksdk.api.v2.activities", "qualname": "UserLoginsAPI", "type": "class", "doc": "<p>A class used to represent the UserLogins API endpoint.</p>\n\n<h2 id=\"methods\">Methods</h2>\n\n<p>search(json=None)\n    A method to search UserLogins objects.</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.activities.UserLoginsAPI.RESOURCE": {"fullname": "laceworksdk.api.v2.activities.UserLoginsAPI.RESOURCE", "modulename": "laceworksdk.api.v2.activities", "qualname": "UserLoginsAPI.RESOURCE", "type": "variable", "doc": "<p></p>\n", "default_value": " = &#x27;UserLogins&#x27;"}, "laceworksdk.api.v2.agent_access_tokens": {"fullname": "laceworksdk.api.v2.agent_access_tokens", "modulename": "laceworksdk.api.v2.agent_access_tokens", "type": "module", "doc": "<p>Lacework AgentAccessTokens API wrapper.</p>\n"}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI": {"fullname": "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI", "modulename": "laceworksdk.api.v2.agent_access_tokens", "qualname": "AgentAccessTokensAPI", "type": "class", "doc": "<p>A class used to implement CRUD create/read/update/delete functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.crud_endpoint.CrudEndpoint"}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__": {"fullname": "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__", "modulename": "laceworksdk.api.v2.agent_access_tokens", "qualname": "AgentAccessTokensAPI.__init__", "type": "function", "doc": "<p>Initializes the AgentAccessTokensAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return AgentAccessTokensAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"fullname": "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create", "modulename": "laceworksdk.api.v2.agent_access_tokens", "qualname": "AgentAccessTokensAPI.create", "type": "function", "doc": "<p>A method to create a new AgentAccessTokens object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>alias</strong>:  A string representing the object alias.</li>\n<li><strong>enabled</strong>:  A boolean/integer representing whether the object is enabled.\n(0 or 1)</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">alias</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">enabled</span><span class=\"o\">=</span><span class=\"kc\">True</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"fullname": "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id", "modulename": "laceworksdk.api.v2.agent_access_tokens", "qualname": "AgentAccessTokensAPI.get_by_id", "type": "function", "doc": "<p>A method to get an AgentAccessTokens object by ID.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>id</strong>:  A string representing the object ID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"fullname": "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update", "modulename": "laceworksdk.api.v2.agent_access_tokens", "qualname": "AgentAccessTokensAPI.update", "type": "function", "doc": "<p>A method to update an AgentAccessTokens object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>id</strong>:  A string representing the object ID.</li>\n<li><strong>alias</strong>:  A string representing the object alias.</li>\n<li><strong>enabled</strong>:  A boolean/integer representing whether the object is enabled.\n(0 or 1)</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span>, </span><span class=\"param\"><span class=\"n\">token_enabled</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete": {"fullname": "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete", "modulename": "laceworksdk.api.v2.agent_access_tokens", "qualname": "AgentAccessTokensAPI.delete", "type": "function", "doc": "<p>A method to 'pass' when attempting to delete an AgentAccessToken object.</p>\n\n<p>Lacework does not currently allow for agent access tokens to be deleted.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.agent_info": {"fullname": "laceworksdk.api.v2.agent_info", "modulename": "laceworksdk.api.v2.agent_info", "type": "module", "doc": "<p>Lacework AgentInfo API wrapper.</p>\n"}, "laceworksdk.api.v2.agent_info.AgentInfoAPI": {"fullname": "laceworksdk.api.v2.agent_info.AgentInfoAPI", "modulename": "laceworksdk.api.v2.agent_info", "qualname": "AgentInfoAPI", "type": "class", "doc": "<p>A class used to implement Search functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.agent_info.AgentInfoAPI.__init__": {"fullname": "laceworksdk.api.v2.agent_info.AgentInfoAPI.__init__", "modulename": "laceworksdk.api.v2.agent_info", "qualname": "AgentInfoAPI.__init__", "type": "function", "doc": "<p>Initializes the AgentInfo API object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return AgentInfoAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.alert_channels": {"fullname": "laceworksdk.api.v2.alert_channels", "modulename": "laceworksdk.api.v2.alert_channels", "type": "module", "doc": "<p>Lacework AlertChannels API wrapper.</p>\n"}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI": {"fullname": "laceworksdk.api.v2.alert_channels.AlertChannelsAPI", "modulename": "laceworksdk.api.v2.alert_channels", "qualname": "AlertChannelsAPI", "type": "class", "doc": "<p>A class used to implement CRUD create/read/update/delete functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.crud_endpoint.CrudEndpoint"}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.__init__": {"fullname": "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.__init__", "modulename": "laceworksdk.api.v2.alert_channels", "qualname": "AlertChannelsAPI.__init__", "type": "function", "doc": "<p>Initializes the AlertChannelsAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return AlertChannelsAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"fullname": "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create", "modulename": "laceworksdk.api.v2.alert_channels", "qualname": "AlertChannelsAPI.create", "type": "function", "doc": "<p>A method to create a new AlertChannels object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>name</strong>:  A string representing the object name.</li>\n<li><strong>type</strong>:  A string representing the object type.</li>\n<li><strong>enabled</strong>:  A boolean/integer representing whether the object is enabled.\n(0 or 1)</li>\n<li><strong>data</strong>:  A JSON object matching the schema for the specified type.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span>, </span><span class=\"param\"><span class=\"nb\">type</span>, </span><span class=\"param\"><span class=\"n\">enabled</span>, </span><span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get": {"fullname": "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get", "modulename": "laceworksdk.api.v2.alert_channels", "qualname": "AlertChannelsAPI.get", "type": "function", "doc": "<p>A method to get AlertChannels objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n<li><strong>type</strong>:  A string representing the object type.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"nb\">type</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_guid": {"fullname": "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_guid", "modulename": "laceworksdk.api.v2.alert_channels", "qualname": "AlertChannelsAPI.get_by_guid", "type": "function", "doc": "<p>A method to get AlertChannels objects by GUID.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_type": {"fullname": "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_type", "modulename": "laceworksdk.api.v2.alert_channels", "qualname": "AlertChannelsAPI.get_by_type", "type": "function", "doc": "<p>A method to get AlertChannels objects by type.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>type</strong>:  A string representing the object type.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">type</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"fullname": "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update", "modulename": "laceworksdk.api.v2.alert_channels", "qualname": "AlertChannelsAPI.update", "type": "function", "doc": "<p>A method to update an AlertChannels object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n<li><strong>name</strong>:  A string representing the object name.</li>\n<li><strong>type</strong>:  A string representing the object type.</li>\n<li><strong>enabled</strong>:  A boolean/integer representing whether the object is enabled.\n(0 or 1)</li>\n<li><strong>data</strong>:  A JSON object matching the schema for the specified type.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">guid</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"nb\">type</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">enabled</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.delete": {"fullname": "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.delete", "modulename": "laceworksdk.api.v2.alert_channels", "qualname": "AlertChannelsAPI.delete", "type": "function", "doc": "<p>A method to delete an AlertChannels object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.test": {"fullname": "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.test", "modulename": "laceworksdk.api.v2.alert_channels", "qualname": "AlertChannelsAPI.test", "type": "function", "doc": "<p>A method to test an AlertChannels object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.alert_profiles": {"fullname": "laceworksdk.api.v2.alert_profiles", "modulename": "laceworksdk.api.v2.alert_profiles", "type": "module", "doc": "<p>Lacework AlertProfiles API wrapper.</p>\n"}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI": {"fullname": "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI", "modulename": "laceworksdk.api.v2.alert_profiles", "qualname": "AlertProfilesAPI", "type": "class", "doc": "<p>A class used to implement CRUD create/read/update/delete functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.crud_endpoint.CrudEndpoint"}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.__init__": {"fullname": "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.__init__", "modulename": "laceworksdk.api.v2.alert_profiles", "qualname": "AlertProfilesAPI.__init__", "type": "function", "doc": "<p>Initializes the AlertProfilesAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return AlertProfilesAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"fullname": "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create", "modulename": "laceworksdk.api.v2.alert_profiles", "qualname": "AlertProfilesAPI.create", "type": "function", "doc": "<p>A method to create a new AlertProfiles object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>alert_profile_id</strong>:  A string representing the id of the object.</li>\n<li><strong>alerts</strong>:  A list of objects containing alert details for the parent object.\nobj:\n    :param name: A string representing the name of the alert.\n    :param eventName: A string representing the name to show in Event Triage.\n    :param description: A string representing the description to show in Event Triage.\n    :param subject: A string representing the subject to show in the Event Dossier.</li>\n<li><strong>extends</strong>:  A string representing the base alert profile object.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">alert_profile_id</span>, </span><span class=\"param\"><span class=\"n\">alerts</span>, </span><span class=\"param\"><span class=\"n\">extends</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get": {"fullname": "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get", "modulename": "laceworksdk.api.v2.alert_profiles", "qualname": "AlertProfilesAPI.get", "type": "function", "doc": "<p>A method to get AlertProfiles objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>id</strong>:  A string representing the object ID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id": {"fullname": "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id", "modulename": "laceworksdk.api.v2.alert_profiles", "qualname": "AlertProfilesAPI.get_by_id", "type": "function", "doc": "<p>A method to get an AlertProfiles object by ID.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>id</strong>:  A string representing the object ID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"fullname": "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search", "modulename": "laceworksdk.api.v2.alert_profiles", "qualname": "AlertProfilesAPI.search", "type": "function", "doc": "<p>A method to 'pass' when attempting to search AlertProfiles objects.</p>\n\n<p>Search functionality is not yet implemented for Alert Profiles.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"fullname": "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update", "modulename": "laceworksdk.api.v2.alert_profiles", "qualname": "AlertProfilesAPI.update", "type": "function", "doc": "<p>A method to update an AlertProfiles object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>id</strong>:  A string representing the object ID.</li>\n<li><strong>alerts</strong>:  A list of objects containing alert details for the parent object.\nobj:\n    :param name: A string representing the name of the alert.\n    :param eventName: A string representing the name to show in Event Triage.\n    :param description: A string representing the description to show in Event Triage.\n    :param subject: A string representing the subject to show in the Event Dossier.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span>, </span><span class=\"param\"><span class=\"n\">alerts</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.delete": {"fullname": "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.delete", "modulename": "laceworksdk.api.v2.alert_profiles", "qualname": "AlertProfilesAPI.delete", "type": "function", "doc": "<p>A method to delete an AlertProfiles object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object ID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.alert_rules": {"fullname": "laceworksdk.api.v2.alert_rules", "modulename": "laceworksdk.api.v2.alert_rules", "type": "module", "doc": "<p>Lacework AlertRules API wrapper.</p>\n"}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI": {"fullname": "laceworksdk.api.v2.alert_rules.AlertRulesAPI", "modulename": "laceworksdk.api.v2.alert_rules", "qualname": "AlertRulesAPI", "type": "class", "doc": "<p>A class used to implement CRUD create/read/update/delete functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.crud_endpoint.CrudEndpoint"}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.__init__": {"fullname": "laceworksdk.api.v2.alert_rules.AlertRulesAPI.__init__", "modulename": "laceworksdk.api.v2.alert_rules", "qualname": "AlertRulesAPI.__init__", "type": "function", "doc": "<p>Initializes the AlertRulesAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return AlertRulesAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"fullname": "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create", "modulename": "laceworksdk.api.v2.alert_rules", "qualname": "AlertRulesAPI.create", "type": "function", "doc": "<p>A method to create a new AlertRules object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>type</strong>:  A string representing the type of the object.\n('Event')</li>\n<li><strong>filters</strong>:  A filter object for the object configuration.\nobj:\n    :param name: A string representing the object name.\n    :param description: A string representing the object description.\n    :param enabled: A boolean/integer representing whether the object is enabled.\n        (0 or 1)\n    :param resourceGroups: A list of resource groups to define for the object.\n    :param eventCategory: A list of event categories to define for the object.\n        (\"Compliance\", \"App\", \"Cloud\", \"File\", \"Machine\", \"User\", \"Platform\", \"K8sActivity\")\n    :param severity: A list of alert severities to define for the object.\n        (1, 2, 3, 4, 5)</li>\n<li><strong>intg_guid_list</strong>:  A list of integration GUIDs representing the alert channels to use.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">type</span>, </span><span class=\"param\"><span class=\"n\">filters</span>, </span><span class=\"param\"><span class=\"n\">intg_guid_list</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get": {"fullname": "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get", "modulename": "laceworksdk.api.v2.alert_rules", "qualname": "AlertRulesAPI.get", "type": "function", "doc": "<p>A method to get AlertRules objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get_by_guid": {"fullname": "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get_by_guid", "modulename": "laceworksdk.api.v2.alert_rules", "qualname": "AlertRulesAPI.get_by_guid", "type": "function", "doc": "<p>A method to get an AlertRules object by GUID.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"fullname": "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update", "modulename": "laceworksdk.api.v2.alert_rules", "qualname": "AlertRulesAPI.update", "type": "function", "doc": "<p>A method to update an AlertRules object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n<li><strong>type</strong>:  A string representing the type of the object.\n('Event')</li>\n<li><strong>filters</strong>:  A filter object for the object configuration.\nobj:\n    :param name: A string representing the object name.\n    :param description: A string representing the object description.\n    :param enabled: A boolean/integer representing whether the object is enabled.\n        (0 or 1)\n    :param resourceGroups: A list of resource groups to define for the object.\n    :param eventCategory: A list of event categories to define for the object.\n        (\"Compliance\", \"App\", \"Cloud\", \"File\", \"Machine\", \"User\", \"Platform\", \"K8sActivity\")\n    :param severity: A list of alert severities to define for the object.\n        (1, 2, 3, 4, 5)</li>\n<li><strong>intg_guid_list</strong>:  A list of integration GUIDs representing the alert channels to use.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">guid</span>,</span><span class=\"param\">\t<span class=\"nb\">type</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filters</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">intg_guid_list</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.delete": {"fullname": "laceworksdk.api.v2.alert_rules.AlertRulesAPI.delete", "modulename": "laceworksdk.api.v2.alert_rules", "qualname": "AlertRulesAPI.delete", "type": "function", "doc": "<p>A method to delete an AlertRules object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.alerts": {"fullname": "laceworksdk.api.v2.alerts", "modulename": "laceworksdk.api.v2.alerts", "type": "module", "doc": "<p>Lacework Alerts API wrapper.</p>\n"}, "laceworksdk.api.v2.alerts.AlertsAPI": {"fullname": "laceworksdk.api.v2.alerts.AlertsAPI", "modulename": "laceworksdk.api.v2.alerts", "qualname": "AlertsAPI", "type": "class", "doc": "<p>A class used to implement Search functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.alerts.AlertsAPI.__init__": {"fullname": "laceworksdk.api.v2.alerts.AlertsAPI.__init__", "modulename": "laceworksdk.api.v2.alerts", "qualname": "AlertsAPI.__init__", "type": "function", "doc": "<p>Initializes the AlertsAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return AlertsAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"fullname": "laceworksdk.api.v2.alerts.AlertsAPI.get", "modulename": "laceworksdk.api.v2.alerts", "qualname": "AlertsAPI.get", "type": "function", "doc": "<p>A method to get Alerts objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>start_time: A \"%Y-%m-%dT%H:%M</strong>: %SZ\" structured timestamp to begin from.</li>\n<li><strong>end_time: A \"%Y-%m-%dT%H:%M</strong>: %S%Z\" structured timestamp to end at.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">start_time</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">end_time</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"fullname": "laceworksdk.api.v2.alerts.AlertsAPI.get_details", "modulename": "laceworksdk.api.v2.alerts", "qualname": "AlertsAPI.get_details", "type": "function", "doc": "<p>A method to get Alerts objects by ID.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>id</strong>:  A string representing the object ID.</li>\n<li><strong>scope</strong>:  A string representing the scope of the detailst to return.\n(\"Details\", \"Investigation\", \"Events\", \"RelatedAlerts\", \"Integrations\", \"Timeline\")</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span>, </span><span class=\"param\"><span class=\"n\">scope</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.alerts.AlertsAPI.search": {"fullname": "laceworksdk.api.v2.alerts.AlertsAPI.search", "modulename": "laceworksdk.api.v2.alerts", "qualname": "AlertsAPI.search", "type": "function", "doc": "<p>A method to search Alerts objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>json</strong>:  A dictionary containing the necessary search parameters.\n(timeFilter, filters, returns)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">json</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.alerts.AlertsAPI.comment": {"fullname": "laceworksdk.api.v2.alerts.AlertsAPI.comment", "modulename": "laceworksdk.api.v2.alerts", "qualname": "AlertsAPI.comment", "type": "function", "doc": "<p>A method to comment on an Alerts object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>id</strong>:  A string representing the object ID.</li>\n<li><strong>comment</strong>:  A string representing the comment to post.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span>, </span><span class=\"param\"><span class=\"n\">comment</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"fullname": "laceworksdk.api.v2.alerts.AlertsAPI.close", "modulename": "laceworksdk.api.v2.alerts", "qualname": "AlertsAPI.close", "type": "function", "doc": "<p>A method to close an Alerts object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>id</strong>:  A string representing the object ID.</li>\n<li><strong>reason</strong>:  An integer representing the close reason.\n0: Other\n1: False positive\n2: Not enough information\n3: Malicious and have resolution in place\n4: Expected because of routine testing</li>\n<li><strong>comment</strong>:  A string representing the comment to post.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span>, </span><span class=\"param\"><span class=\"n\">reason</span>, </span><span class=\"param\"><span class=\"n\">comment</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.audit_logs": {"fullname": "laceworksdk.api.v2.audit_logs", "modulename": "laceworksdk.api.v2.audit_logs", "type": "module", "doc": "<p>Lacework AuditLogs API wrapper.</p>\n"}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI": {"fullname": "laceworksdk.api.v2.audit_logs.AuditLogsAPI", "modulename": "laceworksdk.api.v2.audit_logs", "qualname": "AuditLogsAPI", "type": "class", "doc": "<p>A class used to implement base functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.base_endpoint.BaseEndpoint"}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.__init__": {"fullname": "laceworksdk.api.v2.audit_logs.AuditLogsAPI.__init__", "modulename": "laceworksdk.api.v2.audit_logs", "qualname": "AuditLogsAPI.__init__", "type": "function", "doc": "<p>Initializes the AuditLogsAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return AuditLogsAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"fullname": "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get", "modulename": "laceworksdk.api.v2.audit_logs", "qualname": "AuditLogsAPI.get", "type": "function", "doc": "<p>A method to get AuditLogs objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>start_time: A \"%Y-%m-%dT%H:%M</strong>: %SZ\" structured timestamp to begin from.</li>\n<li><strong>end_time: A \"%Y-%m-%dT%H:%M</strong>: %S%Z\" structured timestamp to end at.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">start_time</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">end_time</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.search": {"fullname": "laceworksdk.api.v2.audit_logs.AuditLogsAPI.search", "modulename": "laceworksdk.api.v2.audit_logs", "qualname": "AuditLogsAPI.search", "type": "function", "doc": "<p>A method to search AuditLogs objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>json</strong>:  A dictionary containing the necessary search parameters.\n(timeFilter, filters, returns)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">json</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.cloud_accounts": {"fullname": "laceworksdk.api.v2.cloud_accounts", "modulename": "laceworksdk.api.v2.cloud_accounts", "type": "module", "doc": "<p>Lacework CloudAccounts API wrapper.</p>\n"}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI": {"fullname": "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI", "modulename": "laceworksdk.api.v2.cloud_accounts", "qualname": "CloudAccountsAPI", "type": "class", "doc": "<p>A class used to implement CRUD create/read/update/delete functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.crud_endpoint.CrudEndpoint"}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__": {"fullname": "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__", "modulename": "laceworksdk.api.v2.cloud_accounts", "qualname": "CloudAccountsAPI.__init__", "type": "function", "doc": "<p>Initializes the CloudAccountsAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return CloudAccountsAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"fullname": "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create", "modulename": "laceworksdk.api.v2.cloud_accounts", "qualname": "CloudAccountsAPI.create", "type": "function", "doc": "<p>A method to create a new CloudAccounts object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>name</strong>:  A string representing the object name.</li>\n<li><strong>type</strong>:  A string representing the object type.</li>\n<li><strong>enabled</strong>:  A boolean/integer representing whether the object is enabled.\n(0 or 1)</li>\n<li><strong>data</strong>:  A JSON object matching the schema for the specified type.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span>, </span><span class=\"param\"><span class=\"nb\">type</span>, </span><span class=\"param\"><span class=\"n\">enabled</span>, </span><span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get": {"fullname": "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get", "modulename": "laceworksdk.api.v2.cloud_accounts", "qualname": "CloudAccountsAPI.get", "type": "function", "doc": "<p>A method to get CloudAccounts objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n<li><strong>type</strong>:  A string representing the object type.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"nb\">type</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid": {"fullname": "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid", "modulename": "laceworksdk.api.v2.cloud_accounts", "qualname": "CloudAccountsAPI.get_by_guid", "type": "function", "doc": "<p>A method to get CloudAccounts objects by GUID.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type": {"fullname": "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type", "modulename": "laceworksdk.api.v2.cloud_accounts", "qualname": "CloudAccountsAPI.get_by_type", "type": "function", "doc": "<p>A method to get CloudAccounts objects by type.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>type</strong>:  A string representing the object type.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">type</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"fullname": "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update", "modulename": "laceworksdk.api.v2.cloud_accounts", "qualname": "CloudAccountsAPI.update", "type": "function", "doc": "<p>A method to update an CloudAccounts object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n<li><strong>name</strong>:  A string representing the object name.</li>\n<li><strong>type</strong>:  A string representing the object type.</li>\n<li><strong>enabled</strong>:  A boolean/integer representing whether the object is enabled.\n(0 or 1)</li>\n<li><strong>data</strong>:  A JSON object matching the schema for the specified type.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">guid</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"nb\">type</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">enabled</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.delete": {"fullname": "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.delete", "modulename": "laceworksdk.api.v2.cloud_accounts", "qualname": "CloudAccountsAPI.delete", "type": "function", "doc": "<p>A method to delete an CloudAccounts object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.cloud_activities": {"fullname": "laceworksdk.api.v2.cloud_activities", "modulename": "laceworksdk.api.v2.cloud_activities", "type": "module", "doc": "<p>Lacework CloudActivities API wrapper.</p>\n"}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI": {"fullname": "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI", "modulename": "laceworksdk.api.v2.cloud_activities", "qualname": "CloudActivitiesAPI", "type": "class", "doc": "<p>A class used to implement base functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.base_endpoint.BaseEndpoint"}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__": {"fullname": "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__", "modulename": "laceworksdk.api.v2.cloud_activities", "qualname": "CloudActivitiesAPI.__init__", "type": "function", "doc": "<p>Initializes the CloudActivitiesAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return CloudActivitiesAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"fullname": "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get", "modulename": "laceworksdk.api.v2.cloud_activities", "qualname": "CloudActivitiesAPI.get", "type": "function", "doc": "<p>A method to get CloudActivities objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>start_time: A \"%Y-%m-%dT%H:%M</strong>: %SZ\" structured timestamp to begin from.</li>\n<li><strong>end_time: A \"%Y-%m-%dT%H:%M</strong>: %S%Z\" structured timestamp to end at.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">start_time</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">end_time</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"fullname": "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages", "modulename": "laceworksdk.api.v2.cloud_activities", "qualname": "CloudActivitiesAPI.get_pages", "type": "function", "doc": "<p>A method to get pages of objects objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>request_params</strong>:  request parameters.</li>\n</ul>\n\n<p>:return a generator which yields pages of CloudActivities objects returned by the Lacework API.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"fullname": "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items", "modulename": "laceworksdk.api.v2.cloud_activities", "qualname": "CloudActivitiesAPI.get_data_items", "type": "function", "doc": "<p>A method to get data items.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>request_params</strong>:  request parameters.</li>\n</ul>\n\n<p>:return a generator which yields individual CloudActivities objects returned by the Lacework API.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search": {"fullname": "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search", "modulename": "laceworksdk.api.v2.cloud_activities", "qualname": "CloudActivitiesAPI.search", "type": "function", "doc": "<p>A method to search CloudActivities objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>json</strong>:  A dictionary containing the necessary search parameters.\n(timeFilter, filters, returns)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">json</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.configs": {"fullname": "laceworksdk.api.v2.configs", "modulename": "laceworksdk.api.v2.configs", "type": "module", "doc": "<p>Lacework Configs API wrapper.</p>\n"}, "laceworksdk.api.v2.configs.ConfigsAPI": {"fullname": "laceworksdk.api.v2.configs.ConfigsAPI", "modulename": "laceworksdk.api.v2.configs", "qualname": "ConfigsAPI", "type": "class", "doc": "<p>A class used to represent the Configs API endpoint.</p>\n\n<p>The Configs API endpoint is simply a parent for different types of\nconfigs that can be queried.</p>\n\n<h2 id=\"attributes\">Attributes</h2>\n\n<p>compliance_evaluations:\n    A ComplianceEvaluationsAPI instance.</p>\n"}, "laceworksdk.api.v2.configs.ConfigsAPI.__init__": {"fullname": "laceworksdk.api.v2.configs.ConfigsAPI.__init__", "modulename": "laceworksdk.api.v2.configs", "qualname": "ConfigsAPI.__init__", "type": "function", "doc": "<p>Initializes the ConfigsAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return ConfigsAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI": {"fullname": "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI", "modulename": "laceworksdk.api.v2.configs", "qualname": "ComplianceEvaluationsAPI", "type": "class", "doc": "<p>A class used to represent the Compliance Evaluations API endpoint.</p>\n\n<h2 id=\"methods\">Methods</h2>\n\n<p>search(json=None)\n    A method to search ComplianceEvaluations objects.</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI.RESOURCE": {"fullname": "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI.RESOURCE", "modulename": "laceworksdk.api.v2.configs", "qualname": "ComplianceEvaluationsAPI.RESOURCE", "type": "variable", "doc": "<p></p>\n", "default_value": " = &#x27;ComplianceEvaluations&#x27;"}, "laceworksdk.api.v2.container_registries": {"fullname": "laceworksdk.api.v2.container_registries", "modulename": "laceworksdk.api.v2.container_registries", "type": "module", "doc": "<p>Lacework ContainerRegistries API wrapper.</p>\n"}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI": {"fullname": "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI", "modulename": "laceworksdk.api.v2.container_registries", "qualname": "ContainerRegistriesAPI", "type": "class", "doc": "<p>A class used to implement CRUD create/read/update/delete functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.crud_endpoint.CrudEndpoint"}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__": {"fullname": "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__", "modulename": "laceworksdk.api.v2.container_registries", "qualname": "ContainerRegistriesAPI.__init__", "type": "function", "doc": "<p>Initializes the ContainerRegistriesAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return ContainerRegistriesAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"fullname": "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create", "modulename": "laceworksdk.api.v2.container_registries", "qualname": "ContainerRegistriesAPI.create", "type": "function", "doc": "<p>A method to create a new ContainerRegistries object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>name</strong>:  A string representing the object name.</li>\n<li><strong>type</strong>:  A string representing the object type.</li>\n<li><strong>enabled</strong>:  A boolean/integer representing whether the object is enabled.\n(0 or 1)</li>\n<li><strong>data</strong>:  A JSON object matching the schema for the specified type.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span>, </span><span class=\"param\"><span class=\"nb\">type</span>, </span><span class=\"param\"><span class=\"n\">enabled</span>, </span><span class=\"param\"><span class=\"n\">data</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get": {"fullname": "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get", "modulename": "laceworksdk.api.v2.container_registries", "qualname": "ContainerRegistriesAPI.get", "type": "function", "doc": "<p>A method to get ContainerRegistries objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n<li><strong>type</strong>:  A string representing the object type.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"nb\">type</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid": {"fullname": "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid", "modulename": "laceworksdk.api.v2.container_registries", "qualname": "ContainerRegistriesAPI.get_by_guid", "type": "function", "doc": "<p>A method to get ContainerRegistries objects by GUID.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type": {"fullname": "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type", "modulename": "laceworksdk.api.v2.container_registries", "qualname": "ContainerRegistriesAPI.get_by_type", "type": "function", "doc": "<p>A method to get ContainerRegistries objects by type.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>type</strong>:  A string representing the object type.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">type</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"fullname": "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update", "modulename": "laceworksdk.api.v2.container_registries", "qualname": "ContainerRegistriesAPI.update", "type": "function", "doc": "<p>A method to update an ContainerRegistries object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n<li><strong>name</strong>:  A string representing the object name.</li>\n<li><strong>type</strong>:  A string representing the object type.</li>\n<li><strong>enabled</strong>:  A boolean/integer representing whether the object is enabled.\n(0 or 1)</li>\n<li><strong>data</strong>:  A JSON object matching the schema for the specified type.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">guid</span>,</span><span class=\"param\">\t<span class=\"n\">name</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"nb\">type</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">enabled</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.delete": {"fullname": "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.delete", "modulename": "laceworksdk.api.v2.container_registries", "qualname": "ContainerRegistriesAPI.delete", "type": "function", "doc": "<p>A method to delete a ContainerRegistries object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.contract_info": {"fullname": "laceworksdk.api.v2.contract_info", "modulename": "laceworksdk.api.v2.contract_info", "type": "module", "doc": "<p>Lacework ContractInfo API wrapper.</p>\n"}, "laceworksdk.api.v2.contract_info.ContractInfoAPI": {"fullname": "laceworksdk.api.v2.contract_info.ContractInfoAPI", "modulename": "laceworksdk.api.v2.contract_info", "qualname": "ContractInfoAPI", "type": "class", "doc": "<p>A class used to implement base functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.base_endpoint.BaseEndpoint"}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__": {"fullname": "laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__", "modulename": "laceworksdk.api.v2.contract_info", "qualname": "ContractInfoAPI.__init__", "type": "function", "doc": "<p>Initializes the ContractInfoAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return ContractInfoAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"fullname": "laceworksdk.api.v2.contract_info.ContractInfoAPI.get", "modulename": "laceworksdk.api.v2.contract_info", "qualname": "ContractInfoAPI.get", "type": "function", "doc": "<p>A method to get ContractInfo objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.datasources": {"fullname": "laceworksdk.api.v2.datasources", "modulename": "laceworksdk.api.v2.datasources", "type": "module", "doc": "<p>Lacework Datasources API wrapper.</p>\n"}, "laceworksdk.api.v2.datasources.DatasourcesAPI": {"fullname": "laceworksdk.api.v2.datasources.DatasourcesAPI", "modulename": "laceworksdk.api.v2.datasources", "qualname": "DatasourcesAPI", "type": "class", "doc": "<p>A class used to implement base functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.base_endpoint.BaseEndpoint"}, "laceworksdk.api.v2.datasources.DatasourcesAPI.__init__": {"fullname": "laceworksdk.api.v2.datasources.DatasourcesAPI.__init__", "modulename": "laceworksdk.api.v2.datasources", "qualname": "DatasourcesAPI.__init__", "type": "function", "doc": "<p>Initializes the Datasources object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return DatasourcesAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get": {"fullname": "laceworksdk.api.v2.datasources.DatasourcesAPI.get", "modulename": "laceworksdk.api.v2.datasources", "qualname": "DatasourcesAPI.get", "type": "function", "doc": "<p>A method to get Datasources objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>type</strong>:  A string representing the object type.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">type</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_by_type": {"fullname": "laceworksdk.api.v2.datasources.DatasourcesAPI.get_by_type", "modulename": "laceworksdk.api.v2.datasources", "qualname": "DatasourcesAPI.get_by_type", "type": "function", "doc": "<p>A method to get a Datasources object by type.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>type</strong>:  A string representing the object type.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">type</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"fullname": "laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource", "modulename": "laceworksdk.api.v2.datasources", "qualname": "DatasourcesAPI.get_datasource", "type": "function", "doc": "<p>A method to get the schema for a particular datasource.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>datasource</strong>:  A string representing the datasource to check for.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">datasource</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.datasources.DatasourcesAPI.list_data_sources": {"fullname": "laceworksdk.api.v2.datasources.DatasourcesAPI.list_data_sources", "modulename": "laceworksdk.api.v2.datasources", "qualname": "DatasourcesAPI.list_data_sources", "type": "function", "doc": "<p>A method to list the datasources that are available.</p>\n\n<p>:return A list of tuples with two entries, source name and description.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.entities": {"fullname": "laceworksdk.api.v2.entities", "modulename": "laceworksdk.api.v2.entities", "type": "module", "doc": "<p>Lacework Entities API wrapper.</p>\n"}, "laceworksdk.api.v2.entities.EntitiesAPI": {"fullname": "laceworksdk.api.v2.entities.EntitiesAPI", "modulename": "laceworksdk.api.v2.entities", "qualname": "EntitiesAPI", "type": "class", "doc": "<p>A class used to represent the Entities API endpoint.</p>\n\n<p>The Entities API endpoint is simply a parent for different types of\nentities that can be queried.</p>\n\n<h2 id=\"attributes\">Attributes</h2>\n\n<p>applications:\n    A ApplicationsAPI instance.\ncommand_lines:\n    A CommandLinesAPI instance.\ncontainers:\n    A ContainersAPI instance.\nfiles:\n    A FilesAPI instance.\nimages:\n    A ImagesAPI instance.\ninternal_ip_addresses:\n    A InternalIPAddressesAPI instance.\nk8s_pods:\n    A K8sPodsAPI instance.\nmachines:\n    A MachinesAPI instance.\nmachine_details:\n    A MachineDetailsAPI instance.\nnetwork_interfaces:\n    A NetworkInterfacesAPI instance.\nnew_file_hashes:\n    A NewFileHashesAPI instance.\npackages:\n    A PackagesAPI instance.\nprocesses:\n    A ProcessesAPI instance.\nusers:\n    A UsersAPI instance.</p>\n"}, "laceworksdk.api.v2.entities.EntitiesAPI.__init__": {"fullname": "laceworksdk.api.v2.entities.EntitiesAPI.__init__", "modulename": "laceworksdk.api.v2.entities", "qualname": "EntitiesAPI.__init__", "type": "function", "doc": "<p>Initializes the EntitiesAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return EntitiesAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.entities.ApplicationsAPI": {"fullname": "laceworksdk.api.v2.entities.ApplicationsAPI", "modulename": "laceworksdk.api.v2.entities", "qualname": "ApplicationsAPI", "type": "class", "doc": "<p>A class used to represent the Applications API endpoint.</p>\n\n<h2 id=\"methods\">Methods</h2>\n\n<p>search(json=None)\n    A method to search Applications objects.</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.entities.ApplicationsAPI.RESOURCE": {"fullname": "laceworksdk.api.v2.entities.ApplicationsAPI.RESOURCE", "modulename": "laceworksdk.api.v2.entities", "qualname": "ApplicationsAPI.RESOURCE", "type": "variable", "doc": "<p></p>\n", "default_value": " = &#x27;Applications&#x27;"}, "laceworksdk.api.v2.entities.CommandLinesAPI": {"fullname": "laceworksdk.api.v2.entities.CommandLinesAPI", "modulename": "laceworksdk.api.v2.entities", "qualname": "CommandLinesAPI", "type": "class", "doc": "<p>A class used to represent the Command Lines API endpoint.</p>\n\n<h2 id=\"methods\">Methods</h2>\n\n<p>search(json=None)\n    A method to search CommandLines objects.</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.entities.CommandLinesAPI.RESOURCE": {"fullname": "laceworksdk.api.v2.entities.CommandLinesAPI.RESOURCE", "modulename": "laceworksdk.api.v2.entities", "qualname": "CommandLinesAPI.RESOURCE", "type": "variable", "doc": "<p></p>\n", "default_value": " = &#x27;CommandLines&#x27;"}, "laceworksdk.api.v2.entities.ContainersAPI": {"fullname": "laceworksdk.api.v2.entities.ContainersAPI", "modulename": "laceworksdk.api.v2.entities", "qualname": "ContainersAPI", "type": "class", "doc": "<p>A class used to represent the Containers API endpoint.</p>\n\n<h2 id=\"methods\">Methods</h2>\n\n<p>search(json=None)\n    A method to search Containers objects.</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.entities.ContainersAPI.RESOURCE": {"fullname": "laceworksdk.api.v2.entities.ContainersAPI.RESOURCE", "modulename": "laceworksdk.api.v2.entities", "qualname": "ContainersAPI.RESOURCE", "type": "variable", "doc": "<p></p>\n", "default_value": " = &#x27;Containers&#x27;"}, "laceworksdk.api.v2.entities.FilesAPI": {"fullname": "laceworksdk.api.v2.entities.FilesAPI", "modulename": "laceworksdk.api.v2.entities", "qualname": "FilesAPI", "type": "class", "doc": "<p>A class used to represent the Files API endpoint.</p>\n\n<h2 id=\"methods\">Methods</h2>\n\n<p>search(json=None)\n    A method to search Files objects.</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.entities.FilesAPI.RESOURCE": {"fullname": "laceworksdk.api.v2.entities.FilesAPI.RESOURCE", "modulename": "laceworksdk.api.v2.entities", "qualname": "FilesAPI.RESOURCE", "type": "variable", "doc": "<p></p>\n", "default_value": " = &#x27;Files&#x27;"}, "laceworksdk.api.v2.entities.ImagesAPI": {"fullname": "laceworksdk.api.v2.entities.ImagesAPI", "modulename": "laceworksdk.api.v2.entities", "qualname": "ImagesAPI", "type": "class", "doc": "<p>A class used to represent the Images API endpoint.</p>\n\n<h2 id=\"methods\">Methods</h2>\n\n<p>search(json=None)\n    A method to search Images objects.</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.entities.ImagesAPI.RESOURCE": {"fullname": "laceworksdk.api.v2.entities.ImagesAPI.RESOURCE", "modulename": "laceworksdk.api.v2.entities", "qualname": "ImagesAPI.RESOURCE", "type": "variable", "doc": "<p></p>\n", "default_value": " = &#x27;Images&#x27;"}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI": {"fullname": "laceworksdk.api.v2.entities.InternalIPAddressesAPI", "modulename": "laceworksdk.api.v2.entities", "qualname": "InternalIPAddressesAPI", "type": "class", "doc": "<p>A class used to represent the Internal IP Addresses API endpoint.</p>\n\n<h2 id=\"methods\">Methods</h2>\n\n<p>search(json=None)\n    A method to search InternalIPAddresses objects.</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI.RESOURCE": {"fullname": "laceworksdk.api.v2.entities.InternalIPAddressesAPI.RESOURCE", "modulename": "laceworksdk.api.v2.entities", "qualname": "InternalIPAddressesAPI.RESOURCE", "type": "variable", "doc": "<p></p>\n", "default_value": " = &#x27;InternalIPAddresses&#x27;"}, "laceworksdk.api.v2.entities.K8sPodsAPI": {"fullname": "laceworksdk.api.v2.entities.K8sPodsAPI", "modulename": "laceworksdk.api.v2.entities", "qualname": "K8sPodsAPI", "type": "class", "doc": "<p>A class used to represent the K8s Pods API endpoint.</p>\n\n<h2 id=\"methods\">Methods</h2>\n\n<p>search(json=None)\n    A method to search K8sPods objects.</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.entities.K8sPodsAPI.RESOURCE": {"fullname": "laceworksdk.api.v2.entities.K8sPodsAPI.RESOURCE", "modulename": "laceworksdk.api.v2.entities", "qualname": "K8sPodsAPI.RESOURCE", "type": "variable", "doc": "<p></p>\n", "default_value": " = &#x27;K8sPods&#x27;"}, "laceworksdk.api.v2.entities.MachinesAPI": {"fullname": "laceworksdk.api.v2.entities.MachinesAPI", "modulename": "laceworksdk.api.v2.entities", "qualname": "MachinesAPI", "type": "class", "doc": "<p>A class used to represent the Machines API endpoint.</p>\n\n<h2 id=\"methods\">Methods</h2>\n\n<p>search(json=None)\n    A method to search Machines objects.</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.entities.MachinesAPI.RESOURCE": {"fullname": "laceworksdk.api.v2.entities.MachinesAPI.RESOURCE", "modulename": "laceworksdk.api.v2.entities", "qualname": "MachinesAPI.RESOURCE", "type": "variable", "doc": "<p></p>\n", "default_value": " = &#x27;Machines&#x27;"}, "laceworksdk.api.v2.entities.MachineDetailsAPI": {"fullname": "laceworksdk.api.v2.entities.MachineDetailsAPI", "modulename": "laceworksdk.api.v2.entities", "qualname": "MachineDetailsAPI", "type": "class", "doc": "<p>A class used to represent the Machine Details API endpoint.</p>\n\n<h2 id=\"methods\">Methods</h2>\n\n<p>search(json=None)\n    A method to search MachineDetails objects.</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.entities.MachineDetailsAPI.RESOURCE": {"fullname": "laceworksdk.api.v2.entities.MachineDetailsAPI.RESOURCE", "modulename": "laceworksdk.api.v2.entities", "qualname": "MachineDetailsAPI.RESOURCE", "type": "variable", "doc": "<p></p>\n", "default_value": " = &#x27;MachineDetails&#x27;"}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI": {"fullname": "laceworksdk.api.v2.entities.NetworkInterfacesAPI", "modulename": "laceworksdk.api.v2.entities", "qualname": "NetworkInterfacesAPI", "type": "class", "doc": "<p>A class used to represent the Network Interfaces API endpoint.</p>\n\n<h2 id=\"methods\">Methods</h2>\n\n<p>search(json=None)\n    A method to search NetworkInterfaces objects.</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI.RESOURCE": {"fullname": "laceworksdk.api.v2.entities.NetworkInterfacesAPI.RESOURCE", "modulename": "laceworksdk.api.v2.entities", "qualname": "NetworkInterfacesAPI.RESOURCE", "type": "variable", "doc": "<p></p>\n", "default_value": " = &#x27;NetworkInterfaces&#x27;"}, "laceworksdk.api.v2.entities.NewFileHashesAPI": {"fullname": "laceworksdk.api.v2.entities.NewFileHashesAPI", "modulename": "laceworksdk.api.v2.entities", "qualname": "NewFileHashesAPI", "type": "class", "doc": "<p>A class used to represent the New File Hashes API endpoint.</p>\n\n<h2 id=\"methods\">Methods</h2>\n\n<p>search(json=None)\n    A method to search NewFileHashes objects.</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.entities.NewFileHashesAPI.RESOURCE": {"fullname": "laceworksdk.api.v2.entities.NewFileHashesAPI.RESOURCE", "modulename": "laceworksdk.api.v2.entities", "qualname": "NewFileHashesAPI.RESOURCE", "type": "variable", "doc": "<p></p>\n", "default_value": " = &#x27;NewFileHashes&#x27;"}, "laceworksdk.api.v2.entities.PackagesAPI": {"fullname": "laceworksdk.api.v2.entities.PackagesAPI", "modulename": "laceworksdk.api.v2.entities", "qualname": "PackagesAPI", "type": "class", "doc": "<p>A class used to represent the Packages API endpoint.</p>\n\n<h2 id=\"methods\">Methods</h2>\n\n<p>search(json=None)\n    A method to search Packages objects.</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.entities.PackagesAPI.RESOURCE": {"fullname": "laceworksdk.api.v2.entities.PackagesAPI.RESOURCE", "modulename": "laceworksdk.api.v2.entities", "qualname": "PackagesAPI.RESOURCE", "type": "variable", "doc": "<p></p>\n", "default_value": " = &#x27;Packages&#x27;"}, "laceworksdk.api.v2.entities.ProcessesAPI": {"fullname": "laceworksdk.api.v2.entities.ProcessesAPI", "modulename": "laceworksdk.api.v2.entities", "qualname": "ProcessesAPI", "type": "class", "doc": "<p>A class used to represent the Processes API endpoint.</p>\n\n<h2 id=\"methods\">Methods</h2>\n\n<p>search(json=None)\n    A method to search Processes objects.</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.entities.ProcessesAPI.RESOURCE": {"fullname": "laceworksdk.api.v2.entities.ProcessesAPI.RESOURCE", "modulename": "laceworksdk.api.v2.entities", "qualname": "ProcessesAPI.RESOURCE", "type": "variable", "doc": "<p></p>\n", "default_value": " = &#x27;Processes&#x27;"}, "laceworksdk.api.v2.entities.UsersAPI": {"fullname": "laceworksdk.api.v2.entities.UsersAPI", "modulename": "laceworksdk.api.v2.entities", "qualname": "UsersAPI", "type": "class", "doc": "<p>A class used to represent the Users API endpoint.</p>\n\n<h2 id=\"methods\">Methods</h2>\n\n<p>search(json=None)\n    A method to search Users objects.</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.entities.UsersAPI.RESOURCE": {"fullname": "laceworksdk.api.v2.entities.UsersAPI.RESOURCE", "modulename": "laceworksdk.api.v2.entities", "qualname": "UsersAPI.RESOURCE", "type": "variable", "doc": "<p></p>\n", "default_value": " = &#x27;Users&#x27;"}, "laceworksdk.api.v2.events": {"fullname": "laceworksdk.api.v2.events", "modulename": "laceworksdk.api.v2.events", "type": "module", "doc": "<p>Lacework Events API wrapper.</p>\n"}, "laceworksdk.api.v2.events.EventsAPIv2": {"fullname": "laceworksdk.api.v2.events.EventsAPIv2", "modulename": "laceworksdk.api.v2.events", "qualname": "EventsAPIv2", "type": "class", "doc": "<p>Lacework Events API.</p>\n", "bases": "laceworksdk.api.v1.events.EventsAPIv1, laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.events.EventsAPIv2.__init__": {"fullname": "laceworksdk.api.v2.events.EventsAPIv2.__init__", "modulename": "laceworksdk.api.v2.events", "qualname": "EventsAPIv2.__init__", "type": "function", "doc": "<p>Initializes the EventsAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return EventsAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.inventory": {"fullname": "laceworksdk.api.v2.inventory", "modulename": "laceworksdk.api.v2.inventory", "type": "module", "doc": "<p>Lacework Inventory API wrapper.</p>\n"}, "laceworksdk.api.v2.inventory.InventoryAPI": {"fullname": "laceworksdk.api.v2.inventory.InventoryAPI", "modulename": "laceworksdk.api.v2.inventory", "qualname": "InventoryAPI", "type": "class", "doc": "<p>A class used to implement Search functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.inventory.InventoryAPI.__init__": {"fullname": "laceworksdk.api.v2.inventory.InventoryAPI.__init__", "modulename": "laceworksdk.api.v2.inventory", "qualname": "InventoryAPI.__init__", "type": "function", "doc": "<p>Initializes the Inventory API object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return InventoryAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.organization_info": {"fullname": "laceworksdk.api.v2.organization_info", "modulename": "laceworksdk.api.v2.organization_info", "type": "module", "doc": "<p>Lacework OrganizationInfo API wrapper.</p>\n"}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI": {"fullname": "laceworksdk.api.v2.organization_info.OrganizationInfoAPI", "modulename": "laceworksdk.api.v2.organization_info", "qualname": "OrganizationInfoAPI", "type": "class", "doc": "<p>A class used to implement base functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.base_endpoint.BaseEndpoint"}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.__init__": {"fullname": "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.__init__", "modulename": "laceworksdk.api.v2.organization_info", "qualname": "OrganizationInfoAPI.__init__", "type": "function", "doc": "<p>Initializes the OrganizationInfoAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return OrganizationInfoAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.get": {"fullname": "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.get", "modulename": "laceworksdk.api.v2.organization_info", "qualname": "OrganizationInfoAPI.get", "type": "function", "doc": "<p>A method to get OrganizationInfo object.</p>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.policies": {"fullname": "laceworksdk.api.v2.policies", "modulename": "laceworksdk.api.v2.policies", "type": "module", "doc": "<p>Lacework Policies API wrapper.</p>\n"}, "laceworksdk.api.v2.policies.PoliciesAPI": {"fullname": "laceworksdk.api.v2.policies.PoliciesAPI", "modulename": "laceworksdk.api.v2.policies", "qualname": "PoliciesAPI", "type": "class", "doc": "<p>A class used to implement CRUD create/read/update/delete functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.crud_endpoint.CrudEndpoint"}, "laceworksdk.api.v2.policies.PoliciesAPI.__init__": {"fullname": "laceworksdk.api.v2.policies.PoliciesAPI.__init__", "modulename": "laceworksdk.api.v2.policies", "qualname": "PoliciesAPI.__init__", "type": "function", "doc": "<p>Initializes the PoliciesAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return PoliciesAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"fullname": "laceworksdk.api.v2.policies.PoliciesAPI.create", "modulename": "laceworksdk.api.v2.policies", "qualname": "PoliciesAPI.create", "type": "function", "doc": "<p>A method to create a new Policies object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>policy_type</strong>:  A string representing the object policy type.</li>\n<li><strong>query_id</strong>:  A string representing the object query ID.</li>\n<li><strong>enabled</strong>:  A boolean representing whether the object is enabled.</li>\n<li><strong>title</strong>:  A string representing the object title.</li>\n<li><strong>description</strong>:  A string representing the object description.</li>\n<li><strong>remediation</strong>:  A string representing the remediation strategy for the object.</li>\n<li><strong>severity</strong>:  A string representing the object severity.\n(\"info\", \"low\", \"medium\", \"high\", \"critical\")</li>\n<li><strong>alert_enabled</strong>:  A boolean representing whether alerting is enabled.</li>\n<li><strong>alert_profile</strong>:  A string representing the alert profile.</li>\n<li><strong>evaluator_id</strong>:  A string representing the evaluator in which the object is to be run.</li>\n<li><strong>limit</strong>:  An integer representing the number of results to return.</li>\n<li><strong>eval_frequency</strong>:  A string representing the frequency in which to evaluate the object.\n(\"Hourly\", \"Daily\")</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">policy_type</span>,</span><span class=\"param\">\t<span class=\"n\">query_id</span>,</span><span class=\"param\">\t<span class=\"n\">enabled</span>,</span><span class=\"param\">\t<span class=\"n\">title</span>,</span><span class=\"param\">\t<span class=\"n\">description</span>,</span><span class=\"param\">\t<span class=\"n\">remediation</span>,</span><span class=\"param\">\t<span class=\"n\">severity</span>,</span><span class=\"param\">\t<span class=\"n\">alert_enabled</span>,</span><span class=\"param\">\t<span class=\"n\">alert_profile</span>,</span><span class=\"param\">\t<span class=\"n\">evaluator_id</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">limit</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">eval_frequency</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.policies.PoliciesAPI.get": {"fullname": "laceworksdk.api.v2.policies.PoliciesAPI.get", "modulename": "laceworksdk.api.v2.policies", "qualname": "PoliciesAPI.get", "type": "function", "doc": "<p>A method to get Policies objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>policy_id</strong>:  A string representing the object policy ID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">policy_id</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"fullname": "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id", "modulename": "laceworksdk.api.v2.policies", "qualname": "PoliciesAPI.get_by_id", "type": "function", "doc": "<p>A method to get a Policies object by policy ID.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>policy_id</strong>:  A string representing the object policy ID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">policy_id</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"fullname": "laceworksdk.api.v2.policies.PoliciesAPI.update", "modulename": "laceworksdk.api.v2.policies", "qualname": "PoliciesAPI.update", "type": "function", "doc": "<p>A method to update a Lacework Query Language (LQL) policy.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>policy_id</strong>:  A string representing the object policy ID.</li>\n<li><strong>policy_type</strong>:  A string representing the object policy type.</li>\n<li><strong>query_id</strong>:  A string representing the object query ID.</li>\n<li><strong>enabled</strong>:  A boolean representing whether the object is enabled.</li>\n<li><strong>title</strong>:  A string representing the object title.</li>\n<li><strong>description</strong>:  A string representing the object description.</li>\n<li><strong>remediation</strong>:  A string representing the remediation strategy for the object.</li>\n<li><strong>severity</strong>:  A string representing the object severity.\n(\"info\", \"low\", \"medium\", \"high\", \"critical\")</li>\n<li><strong>alert_enabled</strong>:  A boolean representing whether alerting is enabled.</li>\n<li><strong>alert_profile</strong>:  A string representing the alert profile.</li>\n<li><strong>limit</strong>:  An integer representing the number of results to return.</li>\n<li><strong>eval_frequency</strong>:  A string representing the frequency in which to evaluate the object.\n(\"Hourly\", \"Daily\")</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">policy_id</span>,</span><span class=\"param\">\t<span class=\"n\">policy_type</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">query_id</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">enabled</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">title</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">description</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">remediation</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">severity</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">alert_enabled</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">alert_profile</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">limit</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">eval_frequency</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.policies.PoliciesAPI.delete": {"fullname": "laceworksdk.api.v2.policies.PoliciesAPI.delete", "modulename": "laceworksdk.api.v2.policies", "qualname": "PoliciesAPI.delete", "type": "function", "doc": "<p>A method to delete a Policies object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>policy_id</strong>:  A string representing the object policy ID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">policy_id</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.policy_exceptions": {"fullname": "laceworksdk.api.v2.policy_exceptions", "modulename": "laceworksdk.api.v2.policy_exceptions", "type": "module", "doc": "<p>Lacework Exceptions API wrapper.</p>\n"}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI": {"fullname": "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI", "modulename": "laceworksdk.api.v2.policy_exceptions", "qualname": "PolicyExceptionsAPI", "type": "class", "doc": "<p>A class used to implement CRUD create/read/update/delete functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.crud_endpoint.CrudEndpoint"}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__": {"fullname": "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__", "modulename": "laceworksdk.api.v2.policy_exceptions", "qualname": "PolicyExceptionsAPI.__init__", "type": "function", "doc": "<p>Initializes the PolicyExceptionsAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return PolicyExceptionsAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"fullname": "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create", "modulename": "laceworksdk.api.v2.policy_exceptions", "qualname": "PolicyExceptionsAPI.create", "type": "function", "doc": "<p>A method to create a new Exceptions object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>policy_id</strong>:  A string representing the object policy ID.</li>\n<li><strong>description</strong>:  A string representing the object description.</li>\n<li><strong>constraints</strong>:  A string representing the object contraints.\n:obj\n    :param field_key: A string representing the contraint key\n        ('accountIds', 'resourceNames', 'regionNames' and 'resourceTags')\n    :param field_values: An array of strings representing constraint values</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">policy_id</span>, </span><span class=\"param\"><span class=\"n\">description</span>, </span><span class=\"param\"><span class=\"n\">constraints</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get": {"fullname": "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get", "modulename": "laceworksdk.api.v2.policy_exceptions", "qualname": "PolicyExceptionsAPI.get", "type": "function", "doc": "<p>A method to get Exceptions objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>exception_id</strong>:  A string representing the exception ID.</li>\n<li><strong>policy_id</strong>:  A string representing the object policy ID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">exception_id</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">policy_id</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"fullname": "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id", "modulename": "laceworksdk.api.v2.policy_exceptions", "qualname": "PolicyExceptionsAPI.get_by_id", "type": "function", "doc": "<p>A method to get a Exceptions object by policy ID.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>exception_id</strong>:  A string representing the exception ID.</li>\n<li><strong>policy_id</strong>:  A string representing the object policy ID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">exception_id</span>, </span><span class=\"param\"><span class=\"n\">policy_id</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"fullname": "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update", "modulename": "laceworksdk.api.v2.policy_exceptions", "qualname": "PolicyExceptionsAPI.update", "type": "function", "doc": "<p>A method to create a new Exceptions object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>exception_id</strong>:  A string representing the exception ID.</li>\n<li><strong>policy_id</strong>:  A string representing the object policy ID.</li>\n<li><strong>description</strong>:  A string representing the object description.</li>\n<li><strong>constraints</strong>:  A string representing the object contraints.\n:obj\n    :param field_key: A string representing the contraint key\n        ('accountIds', 'resourceNames', 'regionNames' and 'resourceTags')\n    :param field_values: An array of strings representing constraint values</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">exception_id</span>,</span><span class=\"param\">\t<span class=\"n\">policy_id</span>,</span><span class=\"param\">\t<span class=\"n\">description</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">constraints</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete": {"fullname": "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete", "modulename": "laceworksdk.api.v2.policy_exceptions", "qualname": "PolicyExceptionsAPI.delete", "type": "function", "doc": "<p>A method to delete an Exceptions object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>exception_id</strong>:  A string representing the exception ID.</li>\n<li><strong>policy_id</strong>:  A string representing the object policy ID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">exception_id</span>, </span><span class=\"param\"><span class=\"n\">policy_id</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.queries": {"fullname": "laceworksdk.api.v2.queries", "modulename": "laceworksdk.api.v2.queries", "type": "module", "doc": "<p>Lacework Queries API wrapper.</p>\n"}, "laceworksdk.api.v2.queries.QueriesAPI": {"fullname": "laceworksdk.api.v2.queries.QueriesAPI", "modulename": "laceworksdk.api.v2.queries", "qualname": "QueriesAPI", "type": "class", "doc": "<p>A class used to implement CRUD create/read/update/delete functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.crud_endpoint.CrudEndpoint"}, "laceworksdk.api.v2.queries.QueriesAPI.__init__": {"fullname": "laceworksdk.api.v2.queries.QueriesAPI.__init__", "modulename": "laceworksdk.api.v2.queries", "qualname": "QueriesAPI.__init__", "type": "function", "doc": "<p>Initializes the QueriesAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return QueriesAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"fullname": "laceworksdk.api.v2.queries.QueriesAPI.create", "modulename": "laceworksdk.api.v2.queries", "qualname": "QueriesAPI.create", "type": "function", "doc": "<p>A method to create a new Queries object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>query_id</strong>:  A string representing the object query ID.</li>\n<li><strong>query_text</strong>:  A string representing the object query text.</li>\n<li><strong>evaluator_id</strong>:  A string representing the evaluator in which the\n    query is to be run. This is an optional parameter, with the\n    default behaviour of omitting the value while sending the API call.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">query_id</span>, </span><span class=\"param\"><span class=\"n\">query_text</span>, </span><span class=\"param\"><span class=\"n\">evaluator_id</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.queries.QueriesAPI.get": {"fullname": "laceworksdk.api.v2.queries.QueriesAPI.get", "modulename": "laceworksdk.api.v2.queries", "qualname": "QueriesAPI.get", "type": "function", "doc": "<p>A method to get Queries objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>query_id</strong>:  A string representing the object query ID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">query_id</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.queries.QueriesAPI.get_by_id": {"fullname": "laceworksdk.api.v2.queries.QueriesAPI.get_by_id", "modulename": "laceworksdk.api.v2.queries", "qualname": "QueriesAPI.get_by_id", "type": "function", "doc": "<p>A method to get a Queries object by query ID.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>query_id</strong>:  A string representing the object query ID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">query_id</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"fullname": "laceworksdk.api.v2.queries.QueriesAPI.execute", "modulename": "laceworksdk.api.v2.queries", "qualname": "QueriesAPI.execute", "type": "function", "doc": "<p>A method to execute a Queries object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>evaluator_id</strong>:  A string representing the evaluator in which the query object is to be run.</li>\n<li><strong>query_id</strong>:  A string representing the object query ID.</li>\n<li><strong>query_text</strong>:  A string representing the object query text.</li>\n<li><strong>arguments</strong>:  A dictionary of key/value pairs to be used as arguments in the query object.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">evaluator_id</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">query_id</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">query_text</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">arguments</span><span class=\"o\">=</span><span class=\"p\">{}</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"fullname": "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id", "modulename": "laceworksdk.api.v2.queries", "qualname": "QueriesAPI.execute_by_id", "type": "function", "doc": "<p>A method to execute a Queries object by query ID.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>query_id</strong>:  A string representing the object query ID.</li>\n<li><strong>arguments</strong>:  A dictionary of key/value pairs to be used as arguments in the query object.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">query_id</span>, </span><span class=\"param\"><span class=\"n\">arguments</span><span class=\"o\">=</span><span class=\"p\">{}</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"fullname": "laceworksdk.api.v2.queries.QueriesAPI.validate", "modulename": "laceworksdk.api.v2.queries", "qualname": "QueriesAPI.validate", "type": "function", "doc": "<p>A method to validate a Queries object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>query_text</strong>:  A string representing the object query text.</li>\n<li><strong>evaluator_id</strong>:  A string representing the evaluator in which the\n    query is to be run. Optional parameter, defaults to omitting\n    the evaluator from the validation request.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">query_text</span>, </span><span class=\"param\"><span class=\"n\">evaluator_id</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"fullname": "laceworksdk.api.v2.queries.QueriesAPI.update", "modulename": "laceworksdk.api.v2.queries", "qualname": "QueriesAPI.update", "type": "function", "doc": "<p>A method to update a Queries object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>query_id</strong>:  A string representing the object query ID.</li>\n<li><strong>query_text</strong>:  A string representing the object query text.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">query_id</span>, </span><span class=\"param\"><span class=\"n\">query_text</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.queries.QueriesAPI.delete": {"fullname": "laceworksdk.api.v2.queries.QueriesAPI.delete", "modulename": "laceworksdk.api.v2.queries", "qualname": "QueriesAPI.delete", "type": "function", "doc": "<p>A method to delete a Queries object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>query_id</strong>:  A string representing the object query ID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">query_id</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.report_definitions": {"fullname": "laceworksdk.api.v2.report_definitions", "modulename": "laceworksdk.api.v2.report_definitions", "type": "module", "doc": "<p>Lacework ReportDefinitions API wrapper.</p>\n"}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI": {"fullname": "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI", "modulename": "laceworksdk.api.v2.report_definitions", "qualname": "ReportDefinitionsAPI", "type": "class", "doc": "<p>A class used to implement CRUD create/read/update/delete functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.crud_endpoint.CrudEndpoint"}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.__init__": {"fullname": "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.__init__", "modulename": "laceworksdk.api.v2.report_definitions", "qualname": "ReportDefinitionsAPI.__init__", "type": "function", "doc": "<p>Initializes the ReportDefinitionsAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return ReportDefinitionsAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"fullname": "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create", "modulename": "laceworksdk.api.v2.report_definitions", "qualname": "ReportDefinitionsAPI.create", "type": "function", "doc": "<p>A method to create a new ReportDefinitions object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>report_name</strong>:  A string representing the name of the report definition.</li>\n<li><strong>report_type</strong>:  A string representing the type of the report definition.</li>\n<li><strong>sub_report_name</strong>:  A string representing the sub-type of the report definition.\n(\"AWS\", \"GCP\", \"Azure\")</li>\n<li><strong>report_definition</strong>:  An object representing the the report definition.\nobj:\n    :param sections: An array of objects representing the sections of the report definition.\n        :param category: A string representing the section's category.\n        :param title: A string representing the section's title.\n        :param policies: An array of strings representing the section's policies.\n    :param overrides: An array of objects representing the overrides of the report definition.\n        :param title: A string representing the policy's title.\n        :param policy: A string representing the policy ID.</li>\n<li><strong>props</strong>:  An object representing metadata about the report definition.\nobj:\n    :param engine: A string representing the evaluation engine used for the report.\n    :param integrations: An array of strings representing integrations (e.g. AWS Account IDs)\n    :param resource_groups: An array of strings representing resource group IDs.</li>\n<li><strong>alert_channels</strong>:  An array of strings representing the alert channels for report distribution.</li>\n<li><strong>distribution_type</strong>:  A string representing the report format.\n(\"csv\", \"html\", \"pdf\")</li>\n<li><strong>frequency</strong>:  A string representing the frequency of report distribution.\n(\"daily\", \"weekly\")</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">report_name</span>,</span><span class=\"param\">\t<span class=\"n\">report_type</span>,</span><span class=\"param\">\t<span class=\"n\">sub_report_type</span>,</span><span class=\"param\">\t<span class=\"n\">report_definition</span>,</span><span class=\"param\">\t<span class=\"n\">props</span>,</span><span class=\"param\">\t<span class=\"n\">alert_channels</span>,</span><span class=\"param\">\t<span class=\"n\">distribution_type</span>,</span><span class=\"param\">\t<span class=\"n\">frequency</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get": {"fullname": "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get", "modulename": "laceworksdk.api.v2.report_definitions", "qualname": "ReportDefinitionsAPI.get", "type": "function", "doc": "<p>A method to get ReportDefinitions objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>id</strong>:  A string representing the object ID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id": {"fullname": "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id", "modulename": "laceworksdk.api.v2.report_definitions", "qualname": "ReportDefinitionsAPI.get_by_id", "type": "function", "doc": "<p>A method to get a ReportDefinitions object by ID.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>id</strong>:  A string representing the object ID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"fullname": "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search", "modulename": "laceworksdk.api.v2.report_definitions", "qualname": "ReportDefinitionsAPI.search", "type": "function", "doc": "<p>A method to 'pass' when attempting to search ReportDefinitions objects.</p>\n\n<p>Search functionality is not yet implemented for Alert Profiles.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"fullname": "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update", "modulename": "laceworksdk.api.v2.report_definitions", "qualname": "ReportDefinitionsAPI.update", "type": "function", "doc": "<p>A method to update an ReportDefinitions object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>id</strong>:  A string representing the object ID.</li>\n<li><strong>report_name</strong>:  A string representing the name of the report definition.</li>\n<li><strong>report_type</strong>:  A string representing the type of the report definition.</li>\n<li><strong>sub_report_name</strong>:  A string representing the sub-type of the report definition.\n(\"AWS\", \"GCP\", \"Azure\")</li>\n<li><strong>report_definition</strong>:  An object representing the the report definition.\nobj:\n    :param sections: An array of objects representing the sections of the report definition.\n        :param category: A string representing the section's category.\n        :param title: A string representing the section's title.\n        :param policies: An array of strings representing the section's policies.\n    :param overrides: An array of objects representing the overrides of the report definition.\n        :param title: A string representing the policy's title.\n        :param policy: A string representing the policy ID.</li>\n<li><strong>props</strong>:  An object representing metadata about the report definition.\nobj:\n    :param engine: A string representing the evaluation engine used for the report.\n    :param integrations: An array of strings representing integrations (e.g. AWS Account IDs)\n    :param resource_groups: An array of strings representing resource group IDs.</li>\n<li><strong>alert_channels</strong>:  An array of strings representing the alert channels for report distribution.</li>\n<li><strong>distribution_type</strong>:  A string representing the report format.\n(\"csv\", \"html\", \"pdf\")</li>\n<li><strong>frequency</strong>:  A string representing the frequency of report distribution.\n(\"daily\", \"weekly\")</li>\n<li><strong>update_type</strong>:  A string representing the type of update for the report definition.\n(\"Update\", \"Revert\")</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"nb\">id</span>,</span><span class=\"param\">\t<span class=\"n\">report_name</span>,</span><span class=\"param\">\t<span class=\"n\">report_type</span>,</span><span class=\"param\">\t<span class=\"n\">sub_report_type</span>,</span><span class=\"param\">\t<span class=\"n\">report_definition</span>,</span><span class=\"param\">\t<span class=\"n\">props</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">alert_channels</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">distribution_type</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">frequency</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">update_type</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.delete": {"fullname": "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.delete", "modulename": "laceworksdk.api.v2.report_definitions", "qualname": "ReportDefinitionsAPI.delete", "type": "function", "doc": "<p>A method to delete a ReportDefinitions object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object ID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">id</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.report_rules": {"fullname": "laceworksdk.api.v2.report_rules", "modulename": "laceworksdk.api.v2.report_rules", "type": "module", "doc": "<p>Lacework ReportRules API wrapper.</p>\n"}, "laceworksdk.api.v2.report_rules.ReportRulesAPI": {"fullname": "laceworksdk.api.v2.report_rules.ReportRulesAPI", "modulename": "laceworksdk.api.v2.report_rules", "qualname": "ReportRulesAPI", "type": "class", "doc": "<p>A class used to implement CRUD create/read/update/delete functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.crud_endpoint.CrudEndpoint"}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.__init__": {"fullname": "laceworksdk.api.v2.report_rules.ReportRulesAPI.__init__", "modulename": "laceworksdk.api.v2.report_rules", "qualname": "ReportRulesAPI.__init__", "type": "function", "doc": "<p>Initializes the ReportRulesAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return ReportRulesAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"fullname": "laceworksdk.api.v2.report_rules.ReportRulesAPI.create", "modulename": "laceworksdk.api.v2.report_rules", "qualname": "ReportRulesAPI.create", "type": "function", "doc": "<p>A method to create a new ReportRules object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>type</strong>:  A string representing the type of the object.\n('Report')</li>\n<li><strong>filters</strong>:  A filter object for the object configuration.\nobj:\n    :param name: A string representing the object name.\n    :param description: A string representing the object description.\n    :param enabled: A boolean/integer representing whether the object is enabled.\n        (0 or 1)\n    :param resourceGroups: A list of resource groups to define for the object.\n    :param severity: A list of alert severities to define for the object.\n        (1, 2, 3, 4, 5)</li>\n<li><strong>intg_guid_list</strong>:  A list of integration GUIDs representing the report channels to use.</li>\n<li><strong>report_notification_types</strong>:  An object of booleans for the types of reports that should be sent.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"nb\">type</span>,</span><span class=\"param\">\t<span class=\"n\">filters</span>,</span><span class=\"param\">\t<span class=\"n\">intg_guid_list</span>,</span><span class=\"param\">\t<span class=\"n\">report_notification_types</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get": {"fullname": "laceworksdk.api.v2.report_rules.ReportRulesAPI.get", "modulename": "laceworksdk.api.v2.report_rules", "qualname": "ReportRulesAPI.get", "type": "function", "doc": "<p>A method to get ReportRules objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get_by_guid": {"fullname": "laceworksdk.api.v2.report_rules.ReportRulesAPI.get_by_guid", "modulename": "laceworksdk.api.v2.report_rules", "qualname": "ReportRulesAPI.get_by_guid", "type": "function", "doc": "<p>A method to get a ReportRules object by GUID.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"fullname": "laceworksdk.api.v2.report_rules.ReportRulesAPI.update", "modulename": "laceworksdk.api.v2.report_rules", "qualname": "ReportRulesAPI.update", "type": "function", "doc": "<p>A method to update a ReportRules object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n<li><strong>type</strong>:  A string representing the type of the object.\n('Report')</li>\n<li><strong>filters</strong>:  A filter object for the object configuration.\nobj:\n    :param name: A string representing the object name.\n    :param description: A string representing the object description.\n    :param enabled: A boolean/integer representing whether the object is enabled.\n        (0 or 1)\n    :param resourceGroups: A list of resource groups to define for the object.\n    :param severity: A list of alert severities to define for the object.\n        (1, 2, 3, 4, 5)</li>\n<li><strong>intg_guid_list</strong>:  A list of integration GUIDs representing the report channels to use.</li>\n<li><strong>report_notification_types</strong>:  An object of booleans for the types of reports that should be sent.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">guid</span>,</span><span class=\"param\">\t<span class=\"nb\">type</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filters</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">intg_guid_list</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">report_notification_types</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.delete": {"fullname": "laceworksdk.api.v2.report_rules.ReportRulesAPI.delete", "modulename": "laceworksdk.api.v2.report_rules", "qualname": "ReportRulesAPI.delete", "type": "function", "doc": "<p>A method to delete a ReportRules object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.reports": {"fullname": "laceworksdk.api.v2.reports", "modulename": "laceworksdk.api.v2.reports", "type": "module", "doc": "<p>Lacework Reports API wrapper.</p>\n"}, "laceworksdk.api.v2.reports.ReportsAPI": {"fullname": "laceworksdk.api.v2.reports.ReportsAPI", "modulename": "laceworksdk.api.v2.reports", "qualname": "ReportsAPI", "type": "class", "doc": "<p>A class used to implement base functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.base_endpoint.BaseEndpoint"}, "laceworksdk.api.v2.reports.ReportsAPI.__init__": {"fullname": "laceworksdk.api.v2.reports.ReportsAPI.__init__", "modulename": "laceworksdk.api.v2.reports", "qualname": "ReportsAPI.__init__", "type": "function", "doc": "<p>Initializes the ReportsAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return ReportsAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"fullname": "laceworksdk.api.v2.reports.ReportsAPI.get", "modulename": "laceworksdk.api.v2.reports", "qualname": "ReportsAPI.get", "type": "function", "doc": "<p>A method to get Reports objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>primary_query_id</strong>:  The primary ID that is used to fetch the report.\n(AWS Account ID or Azure Tenant ID)</li>\n<li><strong>secondary_query_id</strong>:  The secondary ID that is used to fetch the report.\n(GCP Project ID or Azure Subscription ID)</li>\n<li><strong>format</strong>:  The format of the report.\n(\"csv\", \"html\", \"json\", \"pdf\")</li>\n<li><strong>type</strong>:  The type of the report.</li>\n<li><strong>report_name</strong>:  The name of the report definition to use when generating the report.</li>\n<li><strong>report_type</strong>:  The type of the report definition to use when generating the report.</li>\n<li><strong>template_name</strong>:  The name of the template to be used for the report.</li>\n<li><strong>latest</strong>:  A boolean representing whether to retreive the latest report.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">primary_query_id</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">secondary_query_id</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"nb\">format</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"nb\">type</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">report_name</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">report_type</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">template_name</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">latest</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.resource_groups": {"fullname": "laceworksdk.api.v2.resource_groups", "modulename": "laceworksdk.api.v2.resource_groups", "type": "module", "doc": "<p>Lacework ResourceGroups API wrapper.</p>\n"}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI": {"fullname": "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI", "modulename": "laceworksdk.api.v2.resource_groups", "qualname": "ResourceGroupsAPI", "type": "class", "doc": "<p>A class used to implement CRUD create/read/update/delete functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.crud_endpoint.CrudEndpoint"}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.__init__": {"fullname": "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.__init__", "modulename": "laceworksdk.api.v2.resource_groups", "qualname": "ResourceGroupsAPI.__init__", "type": "function", "doc": "<p>Initializes the ResourceGroupsAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return ResourceGroupsAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"fullname": "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create", "modulename": "laceworksdk.api.v2.resource_groups", "qualname": "ResourceGroupsAPI.create", "type": "function", "doc": "<p>A method to create a new ResourceGroups object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>resource_name</strong>:  A string representing the object name.</li>\n<li><strong>resource_type</strong>:  A string representing the object type.</li>\n<li><strong>enabled</strong>:  A boolean/integer representing whether the object is enabled.\n(0 or 1)</li>\n<li><strong>props</strong>:  A JSON object matching the schema for the specified type.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">resource_name</span>, </span><span class=\"param\"><span class=\"n\">resource_type</span>, </span><span class=\"param\"><span class=\"n\">enabled</span>, </span><span class=\"param\"><span class=\"n\">props</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get": {"fullname": "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get", "modulename": "laceworksdk.api.v2.resource_groups", "qualname": "ResourceGroupsAPI.get", "type": "function", "doc": "<p>A method to get ResourceGroups objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get_by_guid": {"fullname": "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get_by_guid", "modulename": "laceworksdk.api.v2.resource_groups", "qualname": "ResourceGroupsAPI.get_by_guid", "type": "function", "doc": "<p>A method to get ResourceGroups objects by GUID.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"fullname": "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update", "modulename": "laceworksdk.api.v2.resource_groups", "qualname": "ResourceGroupsAPI.update", "type": "function", "doc": "<p>A method to update an ResourceGroups object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n<li><strong>resource_name</strong>:  A string representing the object name.</li>\n<li><strong>resource_type</strong>:  A string representing the object type.</li>\n<li><strong>enabled</strong>:  A boolean/integer representing whether the object is enabled.\n(0 or 1)</li>\n<li><strong>props</strong>:  A JSON object matching the schema for the specified type.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">guid</span>,</span><span class=\"param\">\t<span class=\"n\">resource_name</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">resource_type</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">enabled</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">props</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.delete": {"fullname": "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.delete", "modulename": "laceworksdk.api.v2.resource_groups", "qualname": "ResourceGroupsAPI.delete", "type": "function", "doc": "<p>A method to delete a ResourceGroups object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.schemas": {"fullname": "laceworksdk.api.v2.schemas", "modulename": "laceworksdk.api.v2.schemas", "type": "module", "doc": "<p>Lacework Schemas API wrapper.</p>\n"}, "laceworksdk.api.v2.schemas.SchemasAPI": {"fullname": "laceworksdk.api.v2.schemas.SchemasAPI", "modulename": "laceworksdk.api.v2.schemas", "qualname": "SchemasAPI", "type": "class", "doc": "<p>Lacework Schemas API.</p>\n", "bases": "laceworksdk.api.base_endpoint.BaseEndpoint"}, "laceworksdk.api.v2.schemas.SchemasAPI.__init__": {"fullname": "laceworksdk.api.v2.schemas.SchemasAPI.__init__", "modulename": "laceworksdk.api.v2.schemas", "qualname": "SchemasAPI.__init__", "type": "function", "doc": "<p>Initializes the SchemasAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return SchemasAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.schemas.SchemasAPI.get": {"fullname": "laceworksdk.api.v2.schemas.SchemasAPI.get", "modulename": "laceworksdk.api.v2.schemas", "qualname": "SchemasAPI.get", "type": "function", "doc": "<p>A method to get schema objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object type.</li>\n<li><strong>type</strong>:  A string representing the object subtype.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">type</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">subtype</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"fullname": "laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype", "modulename": "laceworksdk.api.v2.schemas", "qualname": "SchemasAPI.get_by_subtype", "type": "function", "doc": "<p>A method to fetch a specific subtype schema</p>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"nb\">type</span>, </span><span class=\"param\"><span class=\"n\">subtype</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.team_members": {"fullname": "laceworksdk.api.v2.team_members", "modulename": "laceworksdk.api.v2.team_members", "type": "module", "doc": "<p>Lacework TeamMembers API wrapper.</p>\n"}, "laceworksdk.api.v2.team_members.TeamMembersAPI": {"fullname": "laceworksdk.api.v2.team_members.TeamMembersAPI", "modulename": "laceworksdk.api.v2.team_members", "qualname": "TeamMembersAPI", "type": "class", "doc": "<p>A class used to implement CRUD create/read/update/delete functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.crud_endpoint.CrudEndpoint"}, "laceworksdk.api.v2.team_members.TeamMembersAPI.__init__": {"fullname": "laceworksdk.api.v2.team_members.TeamMembersAPI.__init__", "modulename": "laceworksdk.api.v2.team_members", "qualname": "TeamMembersAPI.__init__", "type": "function", "doc": "<p>Initializes the TeamMembersAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return TeamMembersAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"fullname": "laceworksdk.api.v2.team_members.TeamMembersAPI.create", "modulename": "laceworksdk.api.v2.team_members", "qualname": "TeamMembersAPI.create", "type": "function", "doc": "<p>A method to create a new TeamMembers object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>user_name</strong>:  A string representing the email address of the user.</li>\n<li><strong>user_enabled</strong>:  A boolean/integer representing whether the object is enabled.\n(0 or 1)</li>\n<li><strong>props</strong>:  An object containing object configuration\nobj:\n    :param firstName: The first name of the team member.\n    :param lastName: The last name of the team member.\n    :param company: The company of the team member.\n    :param accountAdmin: A boolean representing if the team member is an account admin.</li>\n<li><strong>org_admin</strong>:  A boolean representing if the object is an organization admin.\n(Organization-level Access Required)</li>\n<li><strong>org_user</strong>:  A boolean representing if the object is an organization user.\n(Organization-level Access Required)</li>\n<li><strong>admin_role_accounts</strong>:  A list of strings representing accounts where the object is an admin.\n(Organization-level Access Required)</li>\n<li><strong>user_role_accounts</strong>:  A list of strings representing accounts where the object is a user.\n(Organization-level Access Required)</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">user_name</span>,</span><span class=\"param\">\t<span class=\"n\">user_enabled</span>,</span><span class=\"param\">\t<span class=\"n\">props</span>,</span><span class=\"param\">\t<span class=\"n\">org_admin</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">org_user</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">admin_role_accounts</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">user_role_accounts</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get": {"fullname": "laceworksdk.api.v2.team_members.TeamMembersAPI.get", "modulename": "laceworksdk.api.v2.team_members", "qualname": "TeamMembersAPI.get", "type": "function", "doc": "<p>A method to get TeamMembers objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get_by_guid": {"fullname": "laceworksdk.api.v2.team_members.TeamMembersAPI.get_by_guid", "modulename": "laceworksdk.api.v2.team_members", "qualname": "TeamMembersAPI.get_by_guid", "type": "function", "doc": "<p>A method to get a TeamMembers object by GUID.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"fullname": "laceworksdk.api.v2.team_members.TeamMembersAPI.update", "modulename": "laceworksdk.api.v2.team_members", "qualname": "TeamMembersAPI.update", "type": "function", "doc": "<p>A method to update a TeamMembers object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n<li><strong>user_name</strong>:  A string representing the email address of the object.</li>\n<li><strong>user_enabled</strong>:  A boolean/integer representing whether the object is enabled.\n(0 or 1)</li>\n<li><strong>props</strong>:  An object containing object configuration\nobj:\n    :param firstName: The first name of the team member.\n    :param lastName: The last name of the team member.\n    :param company: The company of the team member.\n    :param accountAdmin: A boolean representing if the team member is an account admin.</li>\n<li><strong>org_admin</strong>:  A boolean representing if the object is an organization admin.\n(Organization-level Access Required)</li>\n<li><strong>org_user</strong>:  A boolean representing if the object is an organization user.\n(Organization-level Access Required)</li>\n<li><strong>admin_role_accounts</strong>:  A list of strings representing accounts where the object is an admin.\n(Organization-level Access Required)</li>\n<li><strong>user_role_accounts</strong>:  A list of strings representing accounts where the object is a user.\n(Organization-level Access Required)</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">guid</span>,</span><span class=\"param\">\t<span class=\"n\">user_name</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">user_enabled</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">props</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">org_admin</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">org_user</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">admin_role_accounts</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">user_role_accounts</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.team_members.TeamMembersAPI.delete": {"fullname": "laceworksdk.api.v2.team_members.TeamMembersAPI.delete", "modulename": "laceworksdk.api.v2.team_members", "qualname": "TeamMembersAPI.delete", "type": "function", "doc": "<p>A method to delete a TeamMembers object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.user_profile": {"fullname": "laceworksdk.api.v2.user_profile", "modulename": "laceworksdk.api.v2.user_profile", "type": "module", "doc": "<p>Lacework UserProfile API wrapper.</p>\n"}, "laceworksdk.api.v2.user_profile.UserProfileAPI": {"fullname": "laceworksdk.api.v2.user_profile.UserProfileAPI", "modulename": "laceworksdk.api.v2.user_profile", "qualname": "UserProfileAPI", "type": "class", "doc": "<p>A class used to implement base functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.base_endpoint.BaseEndpoint"}, "laceworksdk.api.v2.user_profile.UserProfileAPI.__init__": {"fullname": "laceworksdk.api.v2.user_profile.UserProfileAPI.__init__", "modulename": "laceworksdk.api.v2.user_profile", "qualname": "UserProfileAPI.__init__", "type": "function", "doc": "<p>Initializes the UserProfileAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return UserProfileAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.user_profile.UserProfileAPI.get": {"fullname": "laceworksdk.api.v2.user_profile.UserProfileAPI.get", "modulename": "laceworksdk.api.v2.user_profile", "qualname": "UserProfileAPI.get", "type": "function", "doc": "<p>A method to get UserProfile object.</p>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.vulnerabilities": {"fullname": "laceworksdk.api.v2.vulnerabilities", "modulename": "laceworksdk.api.v2.vulnerabilities", "type": "module", "doc": "<p>Lacework Vulnerabilities API wrapper.</p>\n"}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"fullname": "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI", "modulename": "laceworksdk.api.v2.vulnerabilities", "qualname": "VulnerabilitiesAPI", "type": "class", "doc": "<p>A class used to represent the Vulnerabilities API endpoint.</p>\n\n<p>The Vulnerabilities API endpoint is simply a parent for different types of\nvulnerabilities that can be queried.  Due to namespace overlap with the v1\nAPI, this class is a subclass of VulnerabilityAPI to expose those methods\nand provide backwards compatibility.</p>\n\n<h2 id=\"attributes\">Attributes</h2>\n\n<p>containers:\n    A ContainerVulnerabilitiesAPI instance.\nhosts:\n    A HostVulnerabilitiesAPI instance.\npackages:\n    A SoftwarePackagesAPI instance.</p>\n", "bases": "laceworksdk.api.v1.vulnerability.VulnerabilityAPI"}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI.__init__": {"fullname": "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI.__init__", "modulename": "laceworksdk.api.v2.vulnerabilities", "qualname": "VulnerabilitiesAPI.__init__", "type": "function", "doc": "<p>Initializes the VulnerabilitiesAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return VulnerabilitiesAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI": {"fullname": "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI", "modulename": "laceworksdk.api.v2.vulnerabilities", "qualname": "ContainerVulnerabilitiesAPI", "type": "class", "doc": "<p>A class used to represent the Container Vulnerabilities API endpoint.</p>\n\n<h2 id=\"methods\">Methods</h2>\n\n<p>search(json=None)\n    A method to search Container Vulnerabilities objects.\nscan(registry, repository, tag, **request_params)\n    A method to issue a Container Vulnerability scan.\nstatus(request_id)\n    A method to get the status of a Container Vulnerability scan.</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.RESOURCE": {"fullname": "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.RESOURCE", "modulename": "laceworksdk.api.v2.vulnerabilities", "qualname": "ContainerVulnerabilitiesAPI.RESOURCE", "type": "variable", "doc": "<p></p>\n", "default_value": " = &#x27;Containers&#x27;"}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"fullname": "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan", "modulename": "laceworksdk.api.v2.vulnerabilities", "qualname": "ContainerVulnerabilitiesAPI.scan", "type": "function", "doc": "<p>A method to issue Container Vulnerability scans.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>registry</strong>:  A string representing the container registry to use.</li>\n<li><strong>repository</strong>:  A string representing the container repository to use.</li>\n<li><strong>tag</strong>:  A string representing the container tag to use.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">registry</span>, </span><span class=\"param\"><span class=\"n\">repository</span>, </span><span class=\"param\"><span class=\"n\">tag</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.status": {"fullname": "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.status", "modulename": "laceworksdk.api.v2.vulnerabilities", "qualname": "ContainerVulnerabilitiesAPI.status", "type": "function", "doc": "<p>A method to get the status of a Container Vulnerability scan.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>rquest_id</strong>:  A string representing the request ID of the container scan.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">request_id</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI": {"fullname": "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI", "modulename": "laceworksdk.api.v2.vulnerabilities", "qualname": "HostVulnerabilitiesAPI", "type": "class", "doc": "<p>A class used to represent the Host Vulnerabilities API endpoint.</p>\n\n<h2 id=\"methods\">Methods</h2>\n\n<p>search(json=None)\n    A method to search Host Vulnerabilities objects.</p>\n", "bases": "laceworksdk.api.search_endpoint.SearchEndpoint"}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI.RESOURCE": {"fullname": "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI.RESOURCE", "modulename": "laceworksdk.api.v2.vulnerabilities", "qualname": "HostVulnerabilitiesAPI.RESOURCE", "type": "variable", "doc": "<p></p>\n", "default_value": " = &#x27;Hosts&#x27;"}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"fullname": "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI", "modulename": "laceworksdk.api.v2.vulnerabilities", "qualname": "SoftwarePackagesAPI", "type": "class", "doc": "<p>A class used to represent the Software Packages API endpoint.</p>\n\n<h2 id=\"methods\">Methods</h2>\n\n<p>scan(os_pkg_info_list, **request_params)\n    A method to initiate a Software Package vulnerability scan.</p>\n", "bases": "laceworksdk.api.base_endpoint.BaseEndpoint"}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"fullname": "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan", "modulename": "laceworksdk.api.v2.vulnerabilities", "qualname": "SoftwarePackagesAPI.scan", "type": "function", "doc": "<p>A method to initiate a software package vulnerability scan.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>os_pkg_info_list</strong>:  A list of packages to be scanned given the OS, OS Version, Package, and Package Version.\n:obj\n    :param os: A string representing the name of the operating system.\n    :param osVer: A string representing the version of the operating system.\n    :param pkg: A string representing the name of the software package.\n    :param pkgVer: A string representing the verion of the software package.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>response json</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">os_pkg_info_list</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.vulnerability_exceptions": {"fullname": "laceworksdk.api.v2.vulnerability_exceptions", "modulename": "laceworksdk.api.v2.vulnerability_exceptions", "type": "module", "doc": "<p>Lacework VulnerabilityExceptions API wrapper.</p>\n"}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI": {"fullname": "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI", "modulename": "laceworksdk.api.v2.vulnerability_exceptions", "qualname": "VulnerabilityExceptionsAPI", "type": "class", "doc": "<p>A class used to implement CRUD create/read/update/delete functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.crud_endpoint.CrudEndpoint"}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.__init__": {"fullname": "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.__init__", "modulename": "laceworksdk.api.v2.vulnerability_exceptions", "qualname": "VulnerabilityExceptionsAPI.__init__", "type": "function", "doc": "<p>Initializes the VulnerabilityExceptionsAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return VulnerabilityExceptionsAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"fullname": "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create", "modulename": "laceworksdk.api.v2.vulnerability_exceptions", "qualname": "VulnerabilityExceptionsAPI.create", "type": "function", "doc": "<p>A method to create a new VulnerabilityExceptions object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>exception_name</strong>:  A string representing the name of the exception.</li>\n<li><strong>exception_reason</strong>:  A string representing the exception reason.\n(\"False Positive\", \"Accepted Risk\", \"Compensating Controls\", \"Fix Pending\", \"Other\")</li>\n<li><strong>exception_type</strong>:  A string representing the exception type.\n(\"Container\", \"Host\")</li>\n<li><strong>props</strong>:  An object containing properties of the exception.\nobj:\n    :param description: A string representing the exception description.\n    :param createdBy: A string representing the creator of the exception.\n    :param updatedBy: A string representing the updator of the exception.</li>\n<li><strong>vulnerability_criteria</strong>:  An object containing criteria for excepted vulnerabilities.\nobj:\n    :param cve: A list of strings representing CVEs.\n    :param package: A list of objects representing packages.\n    :param severity: A list of strings representing severities.\n        (\"Info\", \"Low\", \"Medium\", \"High\", \"Critical\")\n    :param fixable: A list of numbers representing the fixability status.</li>\n<li><strong>resource_scope</strong>:  An object containing the scope of resources for which to apply the exception.\nobj:\n    :param imageId: A list of strings representing image IDs.\n    :param imageTag: A list of strings representing image tags.\n    :param registry: A list of strings representing container registries.\n    :param repository: A list of strings representing container repositories.\n    :param namespace: A list of strings representing package namespaces.</li>\n<li><strong>expiry_time</strong>:  A string representing the expiration time for the exception.</li>\n<li><strong>state</strong>:  A boolean representing the state of the exception.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">exception_name</span>,</span><span class=\"param\">\t<span class=\"n\">exception_reason</span>,</span><span class=\"param\">\t<span class=\"n\">exception_type</span>,</span><span class=\"param\">\t<span class=\"n\">props</span>,</span><span class=\"param\">\t<span class=\"n\">vulnerability_criteria</span>,</span><span class=\"param\">\t<span class=\"n\">resource_scope</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">expiry_time</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">state</span><span class=\"o\">=</span><span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get": {"fullname": "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get", "modulename": "laceworksdk.api.v2.vulnerability_exceptions", "qualname": "VulnerabilityExceptionsAPI.get", "type": "function", "doc": "<p>A method to get VulnerabilityExceptions objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get_by_guid": {"fullname": "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get_by_guid", "modulename": "laceworksdk.api.v2.vulnerability_exceptions", "qualname": "VulnerabilityExceptionsAPI.get_by_guid", "type": "function", "doc": "<p>A method to get a VulnerabilityExceptions object by GUID.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"fullname": "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update", "modulename": "laceworksdk.api.v2.vulnerability_exceptions", "qualname": "VulnerabilityExceptionsAPI.update", "type": "function", "doc": "<p>A method to update a VulnerabilityExceptions object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n<li><strong>exception_name</strong>:  A string representing the name of the exception.</li>\n<li><strong>exception_reason</strong>:  A string representing the exception reason.\n(\"False Positive\", \"Accepted Risk\", \"Compensating Controls\", \"Fix Pending\", \"Other\")</li>\n<li><strong>exception_type</strong>:  A string representing the exception type.\n(\"Container\", \"Host\")</li>\n<li><strong>props</strong>:  An object containing properties of the exception.\nobj:\n    :param description: A string representing the exception description.\n    :param createdBy: A string representing the creator of the exception.\n    :param updatedBy: A string representing the updator of the exception.</li>\n<li><strong>vulnerability_criteria</strong>:  An object containing criteria for excepted vulnerabilities.\nobj:\n    :param cve: A list of strings representing CVEs.\n    :param package: A list of objects representing packages.\n    :param severity: A list of strings representing severities.\n        (\"Info\", \"Low\", \"Medium\", \"High\", \"Critical\")\n    :param fixable: A list of numbers representing the fixability status.</li>\n<li><strong>resource_scope</strong>:  An object containing the scope of resources for which to apply the exception.\nobj:\n    :param imageId: A list of strings representing image IDs.\n    :param imageTag: A list of strings representing image tags.\n    :param registry: A list of strings representing container registries.\n    :param repository: A list of strings representing container repositories.\n    :param namespace: A list of strings representing package namespaces.</li>\n<li><strong>expiry_time</strong>:  A string representing the expiration time for the exception.</li>\n<li><strong>state</strong>:  A boolean representing the state of the exception.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">guid</span>,</span><span class=\"param\">\t<span class=\"n\">exception_name</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">exception_reason</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">props</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">vulnerability_criteria</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">resource_scope</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">expiry_time</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">state</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.delete": {"fullname": "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.delete", "modulename": "laceworksdk.api.v2.vulnerability_exceptions", "qualname": "VulnerabilityExceptionsAPI.delete", "type": "function", "doc": "<p>A method to delete a VulnerabilityExceptions object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.vulnerability_policies": {"fullname": "laceworksdk.api.v2.vulnerability_policies", "modulename": "laceworksdk.api.v2.vulnerability_policies", "type": "module", "doc": "<p>Lacework VulnerabilityPolicies API wrapper.</p>\n"}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI": {"fullname": "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI", "modulename": "laceworksdk.api.v2.vulnerability_policies", "qualname": "VulnerabilityPoliciesAPI", "type": "class", "doc": "<p>A class used to implement CRUD create/read/update/delete functionality for Lacework API Endpoints</p>\n", "bases": "laceworksdk.api.crud_endpoint.CrudEndpoint"}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.__init__": {"fullname": "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.__init__", "modulename": "laceworksdk.api.v2.vulnerability_policies", "qualname": "VulnerabilityPoliciesAPI.__init__", "type": "function", "doc": "<p>Initializes the VulnerabilityPoliciesAPI object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>session</strong>:  An instance of the HttpSession class</li>\n</ul>\n\n<p>:return VulnerabilityPoliciesAPI object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">session</span></span>)</span>"}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"fullname": "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create", "modulename": "laceworksdk.api.v2.vulnerability_policies", "qualname": "VulnerabilityPoliciesAPI.create", "type": "function", "doc": "<p>A method to create a new VulnerabilityPolicies object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>policy_type</strong>:  A string representing the type of the policy.</li>\n<li><strong>policy_name</strong>:  A string representing the name of the policy.</li>\n<li><strong>severity</strong>:  A string representing the severity of the policy.\n(\"Info\", \"Low\", \"Medium\", \"High\", \"Critical\")</li>\n<li><strong>state</strong>:  A boolean representing the state of the policy.</li>\n<li><strong>filter</strong>: \nobj:\n    :param rule: An object representing a policy filter rule.\n        obj:\n            :param operator: A string representing the rule operator.\n                (\"include\", \"exclude\", \"equals\", \"notEquals\")\n            :param values: An array of strings representing the rule values.\n    :param exception: An object representing a policy filter exception.\n        obj:\n            :param operator: A string representing the rule operator.\n                (\"include\", \"exclude\", \"equals\", \"notEquals\")\n            :param values: An array of strings representing the exception values.</li>\n<li><strong>props</strong>:  An object containing properties of the policy.\nobj:\n    :param description: A string representing the property description.\n    :param createdBy: A string representing the creator of the property.\n    :param updatedBy: A string representing the updater of the property.</li>\n<li><strong>policy_eval_type</strong>:  A string representing the policy evaluation type.</li>\n<li><strong>fail_on_violation</strong>:  A boolean representing whether the policy should fail on violations.</li>\n<li><strong>alert_on_violation</strong>:  A boolean representing whether the policy should alert on violations.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">policy_type</span>,</span><span class=\"param\">\t<span class=\"n\">policy_name</span>,</span><span class=\"param\">\t<span class=\"n\">severity</span>,</span><span class=\"param\">\t<span class=\"n\">state</span>,</span><span class=\"param\">\t<span class=\"nb\">filter</span>,</span><span class=\"param\">\t<span class=\"n\">props</span>,</span><span class=\"param\">\t<span class=\"n\">policy_eval_type</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">fail_on_violation</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">alert_on_violation</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get": {"fullname": "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get", "modulename": "laceworksdk.api.v2.vulnerability_policies", "qualname": "VulnerabilityPoliciesAPI.get", "type": "function", "doc": "<p>A method to get VulnerabilityPolicies objects.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get_by_guid": {"fullname": "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get_by_guid", "modulename": "laceworksdk.api.v2.vulnerability_policies", "qualname": "VulnerabilityPoliciesAPI.get_by_guid", "type": "function", "doc": "<p>A method to get a VulnerabilityPolicies object by GUID.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"fullname": "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update", "modulename": "laceworksdk.api.v2.vulnerability_policies", "qualname": "VulnerabilityPoliciesAPI.update", "type": "function", "doc": "<p>A method to update a VulnerabilityPolicies object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n<li><strong>policy_type</strong>:  A string representing the type of the policy.</li>\n<li><strong>policy_name</strong>:  A string representing the name of the policy.</li>\n<li><strong>severity</strong>:  A string representing the severity of the policy.\n(\"Info\", \"Low\", \"Medium\", \"High\", \"Critical\")</li>\n<li><strong>state</strong>:  A boolean representing the state of the policy.</li>\n<li><strong>filter</strong>: \nobj:\n    :param rule: An object representing a policy filter rule.\n        obj:\n            :param operator: A string representing the rule operator.\n                (\"include\", \"exclude\", \"equals\", \"notEquals\")\n            :param values: An array of strings representing the rule values.\n    :param exception: An object representing a policy filter exception.\n        obj:\n            :param operator: A string representing the rule operator.\n                (\"include\", \"exclude\", \"equals\", \"notEquals\")\n            :param values: An array of strings representing the exception values.</li>\n<li><strong>props</strong>:  An object containing properties of the policy.\nobj:\n    :param description: A string representing the property description.\n    :param createdBy: A string representing the creator of the property.\n    :param updatedBy: A string representing the updater of the property.</li>\n<li><strong>policy_eval_type</strong>:  A string representing the policy evaluation type.</li>\n<li><strong>fail_on_violation</strong>:  A boolean representing whether the policy should fail on violations.</li>\n<li><strong>alert_on_violation</strong>:  A boolean representing whether the policy should alert on violations.</li>\n<li><strong>request_params</strong>:  Additional request parameters.\n(provides support for parameters that may be added in the future)</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">guid</span>,</span><span class=\"param\">\t<span class=\"n\">policy_type</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">policy_name</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">severity</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">state</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"nb\">filter</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">props</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">policy_eval_type</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">fail_on_violation</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">alert_on_violation</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">request_params</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.delete": {"fullname": "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.delete", "modulename": "laceworksdk.api.v2.vulnerability_policies", "qualname": "VulnerabilityPoliciesAPI.delete", "type": "function", "doc": "<p>A method to delete a VulnerabilityPolicies object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>guid</strong>:  A string representing the object GUID.</li>\n</ul>\n\n<p>:return response json</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">guid</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.config": {"fullname": "laceworksdk.config", "modulename": "laceworksdk.config", "type": "module", "doc": "<p>Package configuration.</p>\n"}, "laceworksdk.exceptions": {"fullname": "laceworksdk.exceptions", "modulename": "laceworksdk.exceptions", "type": "module", "doc": "<p>Package exceptions.</p>\n"}, "laceworksdk.exceptions.LaceworkSDKException": {"fullname": "laceworksdk.exceptions.LaceworkSDKException", "modulename": "laceworksdk.exceptions", "qualname": "LaceworkSDKException", "type": "class", "doc": "<p>Base class for all lacework package exceptions.</p>\n", "bases": "builtins.Exception"}, "laceworksdk.exceptions.ApiError": {"fullname": "laceworksdk.exceptions.ApiError", "modulename": "laceworksdk.exceptions", "qualname": "ApiError", "type": "class", "doc": "<p>Errors returned in response to requests sent to the Lacework APIs.\nSeveral data attributes are available for inspection.</p>\n", "bases": "LaceworkSDKException"}, "laceworksdk.exceptions.ApiError.__init__": {"fullname": "laceworksdk.exceptions.ApiError.__init__", "modulename": "laceworksdk.exceptions", "qualname": "ApiError.__init__", "type": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">response</span></span>)</span>"}, "laceworksdk.exceptions.ApiError.response": {"fullname": "laceworksdk.exceptions.ApiError.response", "modulename": "laceworksdk.exceptions", "qualname": "ApiError.response", "type": "variable", "doc": "<p>The <code>requests.Response</code> object returned from the API call.</p>\n"}, "laceworksdk.exceptions.ApiError.request": {"fullname": "laceworksdk.exceptions.ApiError.request", "modulename": "laceworksdk.exceptions", "qualname": "ApiError.request", "type": "variable", "doc": "<p>The <code>requests.PreparedRequest</code> of the API call.</p>\n"}, "laceworksdk.exceptions.ApiError.status_code": {"fullname": "laceworksdk.exceptions.ApiError.status_code", "modulename": "laceworksdk.exceptions", "qualname": "ApiError.status_code", "type": "variable", "doc": "<p>The HTTP status code from the API response.</p>\n"}, "laceworksdk.exceptions.ApiError.status": {"fullname": "laceworksdk.exceptions.ApiError.status", "modulename": "laceworksdk.exceptions", "qualname": "ApiError.status", "type": "variable", "doc": "<p>The HTTP status from the API response.</p>\n"}, "laceworksdk.exceptions.ApiError.details": {"fullname": "laceworksdk.exceptions.ApiError.details", "modulename": "laceworksdk.exceptions", "qualname": "ApiError.details", "type": "variable", "doc": "<p>The parsed JSON details from the API response.</p>\n"}, "laceworksdk.exceptions.MalformedResponse": {"fullname": "laceworksdk.exceptions.MalformedResponse", "modulename": "laceworksdk.exceptions", "qualname": "MalformedResponse", "type": "class", "doc": "<p>Raised when a malformed response is received from Lacework.</p>\n", "bases": "LaceworkSDKException"}, "laceworksdk.exceptions.RateLimitError": {"fullname": "laceworksdk.exceptions.RateLimitError", "modulename": "laceworksdk.exceptions", "qualname": "RateLimitError", "type": "class", "doc": "<p>LAcework Rate-Limit exceeded Error.</p>\n\n<p>Raised when a rate-limit exceeded message is received and the request <strong>will not</strong> be retried.</p>\n", "bases": "ApiError"}, "laceworksdk.http_session": {"fullname": "laceworksdk.http_session", "modulename": "laceworksdk.http_session", "type": "module", "doc": "<p>HttpSession class for package HTTP functions.</p>\n"}, "laceworksdk.http_session.HttpSession": {"fullname": "laceworksdk.http_session.HttpSession", "modulename": "laceworksdk.http_session", "qualname": "HttpSession", "type": "class", "doc": "<p>Package HttpSession class.</p>\n"}, "laceworksdk.http_session.HttpSession.__init__": {"fullname": "laceworksdk.http_session.HttpSession.__init__", "modulename": "laceworksdk.http_session", "qualname": "HttpSession.__init__", "type": "function", "doc": "<p>Initializes the HttpSession object.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>account</strong>:  a Lacework Account name</li>\n<li><strong>subaccount</strong>:  a Lacework Sub-account name</li>\n<li><strong>api_key</strong>:  a Lacework API Key</li>\n<li><strong>api_secret</strong>:  a Lacework API Secret</li>\n<li><strong>base_domain</strong>:  a Lacework Domain (defaults to \"lacework.net\")</li>\n</ul>\n\n<p>:return HttpSession object.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">account</span>, </span><span class=\"param\"><span class=\"n\">subaccount</span>, </span><span class=\"param\"><span class=\"n\">api_key</span>, </span><span class=\"param\"><span class=\"n\">api_secret</span>, </span><span class=\"param\"><span class=\"n\">base_domain</span></span>)</span>"}, "laceworksdk.http_session.HttpSession.get": {"fullname": "laceworksdk.http_session.HttpSession.get", "modulename": "laceworksdk.http_session", "qualname": "HttpSession.get", "type": "function", "doc": "<p>A method to build a GET request to interact with Lacework.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>uri</strong>:  uri to send the HTTP GET request to</li>\n<li><strong>params</strong>:  dict of parameters for the HTTP request</li>\n<li><strong>kwargs</strong>:  passed on to the requests package</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>response json</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li>ApiError if anything but expected response code is returned</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">uri</span>, </span><span class=\"param\"><span class=\"n\">params</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.http_session.HttpSession.get_pages": {"fullname": "laceworksdk.http_session.HttpSession.get_pages", "modulename": "laceworksdk.http_session", "qualname": "HttpSession.get_pages", "type": "function", "doc": "<p>A method to build a GET request that yields pages of data returned by Lacework.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>uri</strong>:  uri to send the initial HTTP GET request to</li>\n<li><strong>params</strong>:  dict of parameters for the HTTP request</li>\n<li><strong>kwargs</strong>:  passed on to the requests package</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>a generator that yields pages of data</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li>ApiError if anything but expected response code is returned</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">uri</span>, </span><span class=\"param\"><span class=\"n\">params</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.http_session.HttpSession.get_data_items": {"fullname": "laceworksdk.http_session.HttpSession.get_data_items", "modulename": "laceworksdk.http_session", "qualname": "HttpSession.get_data_items", "type": "function", "doc": "<p>A method to build a GET request that yields individual objects as returned by Lacework.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>uri</strong>:  uri to send the initial HTTP GET request to</li>\n<li><strong>params</strong>:  dict of parameters for the HTTP request</li>\n<li><strong>kwargs</strong>:  passed on to the requests package</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>a generator that yields individual objects from pages of data</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li>ApiError if anything but expected response code is returned</li>\n<li>MalformedResponse if the returned response does not contain a\n    top-level dictionary with an \"data\" key.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">uri</span>, </span><span class=\"param\"><span class=\"n\">params</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.http_session.HttpSession.patch": {"fullname": "laceworksdk.http_session.HttpSession.patch", "modulename": "laceworksdk.http_session", "qualname": "HttpSession.patch", "type": "function", "doc": "<p>A method to build a PATCH request to interact with Lacework.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>uri</strong>:  uri to send the HTTP POST request to</li>\n<li><strong>data</strong>:  data to be sent in the body of the request</li>\n<li><strong>json</strong>:  data to be sent in JSON format in the body of the request</li>\n<li><strong>kwargs</strong>:  passed on to the requests package</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>response json</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li>ApiError if anything but expected response code is returned</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">uri</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">json</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.http_session.HttpSession.post": {"fullname": "laceworksdk.http_session.HttpSession.post", "modulename": "laceworksdk.http_session", "qualname": "HttpSession.post", "type": "function", "doc": "<p>A method to build a POST request to interact with Lacework.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>uri</strong>:  uri to send the HTTP POST request to</li>\n<li><strong>data</strong>:  data to be sent in the body of the request</li>\n<li><strong>json</strong>:  data to be sent in JSON format in the body of the request</li>\n<li><strong>kwargs</strong>:  passed on to the requests package</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>response json</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li>ApiError if anything but expected response code is returned</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">uri</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">json</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.http_session.HttpSession.put": {"fullname": "laceworksdk.http_session.HttpSession.put", "modulename": "laceworksdk.http_session", "qualname": "HttpSession.put", "type": "function", "doc": "<p>A method to build a PUT request to interact with Lacework.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>uri</strong>:  uri to send the HTTP POST request to</li>\n<li><strong>data</strong>:  data to be sent in the body of the request</li>\n<li><strong>json</strong>:  data to be sent in JSON format in the body of the request</li>\n<li><strong>kwargs</strong>:  passed on to the requests package</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>response json</p>\n</blockquote>\n\n<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li>ApiError if anything but expected response code is returned</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">uri</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">json</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.http_session.HttpSession.delete": {"fullname": "laceworksdk.http_session.HttpSession.delete", "modulename": "laceworksdk.http_session", "qualname": "HttpSession.delete", "type": "function", "doc": "<p>A method to build a DELETE request to interact with Lacework.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>uri</strong>:  uri to send the http DELETE request to</li>\n<li><strong>data</strong>:  data to be sent in the body of the request</li>\n<li><strong>json</strong>:  data to be sent in JSON format in the body of the request</li>\n<li><strong>kwargs</strong>:  passed on to the requests package</li>\n</ul>\n\n<p>:response: reponse json</p>\n\n<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li>ApiError if anything but expected response code is returned</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">uri</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">json</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "laceworksdk.version": {"fullname": "laceworksdk.version", "modulename": "laceworksdk.version", "type": "module", "doc": "<p></p>\n"}}, "docInfo": {"laceworksdk": {"qualname": 0, "fullname": 1, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 12}, "laceworksdk.api": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 6}, "laceworksdk.api.LaceworkClient": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 8}, "laceworksdk.api.LaceworkClient.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 84, "bases": 0, "doc": 40}, "laceworksdk.api.LaceworkClient.set_org_level_access": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 18, "bases": 0, "doc": 16}, "laceworksdk.api.LaceworkClient.set_subaccount": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 16}, "laceworksdk.api.base_endpoint": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.base_endpoint.BaseEndpoint": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 13}, "laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 45}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"qualname": 5, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 28}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 76}, "laceworksdk.api.base_endpoint.BaseEndpoint.session": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 13}, "laceworksdk.api.base_endpoint.BaseEndpoint.validate_json": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 19}, "laceworksdk.api.crud_endpoint": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.crud_endpoint.CrudEndpoint": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 14}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 45}, "laceworksdk.api.crud_endpoint.CrudEndpoint.create": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 29, "bases": 0, "doc": 31}, "laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 61}, "laceworksdk.api.crud_endpoint.CrudEndpoint.search": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 28, "bases": 0, "doc": 35}, "laceworksdk.api.crud_endpoint.CrudEndpoint.update": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 42}, "laceworksdk.api.crud_endpoint.CrudEndpoint.delete": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 34}, "laceworksdk.api.search_endpoint": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.search_endpoint.SearchEndpoint": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 13}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 45}, "laceworksdk.api.search_endpoint.SearchEndpoint.RESOURCE": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 4, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 38, "bases": 0, "doc": 52}, "laceworksdk.api.v1": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v1.account": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v1.account.AccountAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 6}, "laceworksdk.api.v1.account.AccountAPI.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v1.account.AccountAPI.get_org_info": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 15}, "laceworksdk.api.v1.compliance": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v1.compliance.ComplianceAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 6}, "laceworksdk.api.v1.compliance.ComplianceAPI.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"qualname": 5, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 56, "bases": 0, "doc": 101}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"qualname": 5, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 64, "bases": 0, "doc": 111}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"qualname": 5, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 64, "bases": 0, "doc": 112}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 18, "bases": 0, "doc": 41}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 18, "bases": 0, "doc": 42}, "laceworksdk.api.v1.custom_compliance_config": {"qualname": 0, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 9}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI": {"qualname": 1, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 8}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"qualname": 3, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.get": {"qualname": 2, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 18}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"qualname": 2, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 33}, "laceworksdk.api.v1.download_file": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 8}, "laceworksdk.api.v1.download_file.DownloadFileAPI": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v1.download_file.DownloadFileAPI.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 45}, "laceworksdk.api.v1.events": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v1.events.EventsAPIv1": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 6}, "laceworksdk.api.v1.events.EventsAPIv1.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v1.events.EventsAPIv1.get": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 43, "bases": 0, "doc": 69}, "laceworksdk.api.v1.events.EventsAPIv1.get_details": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 17, "bases": 0, "doc": 42}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"qualname": 5, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 59}, "laceworksdk.api.v1.integrations": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v1.integrations.IntegrationsAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 6}, "laceworksdk.api.v1.integrations.IntegrationsAPI.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 80}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 58}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_all": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 18}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 36}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 35}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 56, "bases": 0, "doc": 93}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 56, "bases": 0, "doc": 93}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 53}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 36}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 45}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 39}, "laceworksdk.api.v1.recommendations": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v1.recommendations.RecommendationsAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 6}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 48}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 61}, "laceworksdk.api.v1.run_reports": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 8}, "laceworksdk.api.v1.run_reports.RunReportsAPI": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 6}, "laceworksdk.api.v1.run_reports.RunReportsAPI.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 58}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 18, "bases": 0, "doc": 42}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 18, "bases": 0, "doc": 42}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 18, "bases": 0, "doc": 42}, "laceworksdk.api.v1.run_reports.RunReportsAPI.integration": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 17, "bases": 0, "doc": 44}, "laceworksdk.api.v1.suppressions": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v1.suppressions.SuppressionsAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 6}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 55}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 27, "bases": 0, "doc": 56}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 55}, "laceworksdk.api.v1.token": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 9}, "laceworksdk.api.v1.token.TokenAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 8}, "laceworksdk.api.v1.token.TokenAPI.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v1.token.TokenAPI.create": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 73}, "laceworksdk.api.v1.token.TokenAPI.get": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 19}, "laceworksdk.api.v1.token.TokenAPI.get_enabled": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 19}, "laceworksdk.api.v1.token.TokenAPI.get_token": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 17, "bases": 0, "doc": 41}, "laceworksdk.api.v1.token.TokenAPI.update": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 47, "bases": 0, "doc": 91}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 55, "bases": 0, "doc": 94}, "laceworksdk.api.v1.vulnerability": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 6}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"qualname": 6, "fullname": 10, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 70}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 82, "bases": 0, "doc": 133}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 65}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"qualname": 5, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 37, "bases": 0, "doc": 78}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 80, "bases": 0, "doc": 130}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"qualname": 6, "fullname": 10, "annotation": 0, "default_value": 0, "signature": 47, "bases": 0, "doc": 103}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"qualname": 7, "fullname": 11, "annotation": 0, "default_value": 0, "signature": 86, "bases": 0, "doc": 143}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 72, "bases": 0, "doc": 156}, "laceworksdk.api.v2": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v2.activities": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.activities.ActivitiesAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 56}, "laceworksdk.api.v2.activities.ActivitiesAPI.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.activities.ChangedFilesAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 28}, "laceworksdk.api.v2.activities.ChangedFilesAPI.RESOURCE": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v2.activities.ConnectionsAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 27}, "laceworksdk.api.v2.activities.ConnectionsAPI.RESOURCE": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v2.activities.DnsAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 29}, "laceworksdk.api.v2.activities.DnsAPI.RESOURCE": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v2.activities.UserLoginsAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 27}, "laceworksdk.api.v2.activities.UserLoginsAPI.RESOURCE": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v2.agent_access_tokens": {"qualname": 0, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI": {"qualname": 1, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 14}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__": {"qualname": 3, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"qualname": 2, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 73}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"qualname": 4, "fullname": 10, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 36}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"qualname": 2, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 84}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete": {"qualname": 2, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 29}, "laceworksdk.api.v2.agent_info": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.agent_info.AgentInfoAPI": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 13}, "laceworksdk.api.v2.agent_info.AgentInfoAPI.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 32}, "laceworksdk.api.v2.alert_channels": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 14}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 101}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 45}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_guid": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 35}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_type": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 35}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 71, "bases": 0, "doc": 112}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.delete": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 34}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.test": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 34}, "laceworksdk.api.v2.alert_profiles": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 14}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 139}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 33}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 36}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 25}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 120}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.delete": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 34}, "laceworksdk.api.v2.alert_rules": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 14}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 170}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 33}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get_by_guid": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 36}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 62, "bases": 0, "doc": 181}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.delete": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 34}, "laceworksdk.api.v2.alerts": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.alerts.AlertsAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 13}, "laceworksdk.api.v2.alerts.AlertsAPI.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 76}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 29, "bases": 0, "doc": 78}, "laceworksdk.api.v2.alerts.AlertsAPI.search": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 37}, "laceworksdk.api.v2.alerts.AlertsAPI.comment": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 48}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 80}, "laceworksdk.api.v2.audit_logs": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 13}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 76}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.search": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 37}, "laceworksdk.api.v2.cloud_accounts": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 14}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 101}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 45}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 35}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 35}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 71, "bases": 0, "doc": 112}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.delete": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 34}, "laceworksdk.api.v2.cloud_activities": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 13}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 76}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 44}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 41}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 37}, "laceworksdk.api.v2.configs": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.configs.ConfigsAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 43}, "laceworksdk.api.v2.configs.ConfigsAPI.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 28}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI.RESOURCE": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v2.container_registries": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 14}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 101}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 45}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 35}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 35}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 71, "bases": 0, "doc": 112}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.delete": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 34}, "laceworksdk.api.v2.contract_info": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.contract_info.ContractInfoAPI": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 13}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 42}, "laceworksdk.api.v2.datasources": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.datasources.DatasourcesAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 13}, "laceworksdk.api.v2.datasources.DatasourcesAPI.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 33}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_by_type": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 36}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 39}, "laceworksdk.api.v2.datasources.DatasourcesAPI.list_data_sources": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 27}, "laceworksdk.api.v2.entities": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.entities.EntitiesAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 102}, "laceworksdk.api.v2.entities.EntitiesAPI.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.entities.ApplicationsAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 27}, "laceworksdk.api.v2.entities.ApplicationsAPI.RESOURCE": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v2.entities.CommandLinesAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 28}, "laceworksdk.api.v2.entities.CommandLinesAPI.RESOURCE": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v2.entities.ContainersAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 27}, "laceworksdk.api.v2.entities.ContainersAPI.RESOURCE": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v2.entities.FilesAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 27}, "laceworksdk.api.v2.entities.FilesAPI.RESOURCE": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v2.entities.ImagesAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 27}, "laceworksdk.api.v2.entities.ImagesAPI.RESOURCE": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 29}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI.RESOURCE": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v2.entities.K8sPodsAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 28}, "laceworksdk.api.v2.entities.K8sPodsAPI.RESOURCE": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v2.entities.MachinesAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 27}, "laceworksdk.api.v2.entities.MachinesAPI.RESOURCE": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v2.entities.MachineDetailsAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 28}, "laceworksdk.api.v2.entities.MachineDetailsAPI.RESOURCE": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 28}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI.RESOURCE": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v2.entities.NewFileHashesAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 29}, "laceworksdk.api.v2.entities.NewFileHashesAPI.RESOURCE": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v2.entities.PackagesAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 27}, "laceworksdk.api.v2.entities.PackagesAPI.RESOURCE": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v2.entities.ProcessesAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 27}, "laceworksdk.api.v2.entities.ProcessesAPI.RESOURCE": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v2.entities.UsersAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 27}, "laceworksdk.api.v2.entities.UsersAPI.RESOURCE": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v2.events": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.events.EventsAPIv2": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 10, "doc": 6}, "laceworksdk.api.v2.events.EventsAPIv2.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.inventory": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.inventory.InventoryAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 13}, "laceworksdk.api.v2.inventory.InventoryAPI.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 32}, "laceworksdk.api.v2.organization_info": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 13}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.get": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 14}, "laceworksdk.api.v2.policies": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.policies.PoliciesAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 14}, "laceworksdk.api.v2.policies.PoliciesAPI.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 114, "bases": 0, "doc": 224}, "laceworksdk.api.v2.policies.PoliciesAPI.get": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 35}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 17, "bases": 0, "doc": 39}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 154, "bases": 0, "doc": 220}, "laceworksdk.api.v2.policies.PoliciesAPI.delete": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 17, "bases": 0, "doc": 36}, "laceworksdk.api.v2.policy_exceptions": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 14}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 106}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 48}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 52}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 57, "bases": 0, "doc": 119}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 49}, "laceworksdk.api.v2.queries": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.queries.QueriesAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 14}, "laceworksdk.api.v2.queries.QueriesAPI.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 42, "bases": 0, "doc": 110}, "laceworksdk.api.v2.queries.QueriesAPI.get": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 35}, "laceworksdk.api.v2.queries.QueriesAPI.get_by_id": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 17, "bases": 0, "doc": 39}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 59, "bases": 0, "doc": 91}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 27, "bases": 0, "doc": 59}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 67}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 71}, "laceworksdk.api.v2.queries.QueriesAPI.delete": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 17, "bases": 0, "doc": 36}, "laceworksdk.api.v2.report_definitions": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 14}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 76, "bases": 0, "doc": 285}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 33}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 36}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 25}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 114, "bases": 0, "doc": 316}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.delete": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 34}, "laceworksdk.api.v2.report_rules": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.report_rules.ReportRulesAPI": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 14}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 171}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 33}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get_by_guid": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 36}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 75, "bases": 0, "doc": 182}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.delete": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 34}, "laceworksdk.api.v2.reports": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.reports.ReportsAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 13}, "laceworksdk.api.v2.reports.ReportsAPI.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 116, "bases": 0, "doc": 189}, "laceworksdk.api.v2.resource_groups": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 14}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 103}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 33}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get_by_guid": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 35}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 73, "bases": 0, "doc": 114}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.delete": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 34}, "laceworksdk.api.v2.schemas": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.schemas.SchemasAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 6}, "laceworksdk.api.v2.schemas.SchemasAPI.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.schemas.SchemasAPI.get": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 45}, "laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 15}, "laceworksdk.api.v2.team_members": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.team_members.TeamMembersAPI": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 14}, "laceworksdk.api.v2.team_members.TeamMembersAPI.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 91, "bases": 0, "doc": 219}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 33}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get_by_guid": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 36}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 112, "bases": 0, "doc": 230}, "laceworksdk.api.v2.team_members.TeamMembersAPI.delete": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 34}, "laceworksdk.api.v2.user_profile": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.user_profile.UserProfileAPI": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 13}, "laceworksdk.api.v2.user_profile.UserProfileAPI.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.user_profile.UserProfileAPI.get": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 14}, "laceworksdk.api.v2.vulnerabilities": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 73}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 57}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.RESOURCE": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 85}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.status": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 17, "bases": 0, "doc": 43}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 29}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI.RESOURCE": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 35}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 27, "bases": 0, "doc": 121}, "laceworksdk.api.v2.vulnerability_exceptions": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 14}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 90, "bases": 0, "doc": 288}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 33}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get_by_guid": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 36}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 109, "bases": 0, "doc": 299}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.delete": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 34}, "laceworksdk.api.v2.vulnerability_policies": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 14}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 31}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 271}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 33}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get_by_guid": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 36}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 134, "bases": 0, "doc": 282}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.delete": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 34}, "laceworksdk.config": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 5}, "laceworksdk.exceptions": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 5}, "laceworksdk.exceptions.LaceworkSDKException": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 10}, "laceworksdk.exceptions.ApiError": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 21}, "laceworksdk.exceptions.ApiError.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 3}, "laceworksdk.exceptions.ApiError.response": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 14}, "laceworksdk.exceptions.ApiError.request": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 12}, "laceworksdk.exceptions.ApiError.status_code": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 11}, "laceworksdk.exceptions.ApiError.status": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 10}, "laceworksdk.exceptions.ApiError.details": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 11}, "laceworksdk.exceptions.MalformedResponse": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 12}, "laceworksdk.exceptions.RateLimitError": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 29}, "laceworksdk.http_session": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 9}, "laceworksdk.http_session.HttpSession": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 6}, "laceworksdk.http_session.HttpSession.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 73}, "laceworksdk.http_session.HttpSession.get": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 86}, "laceworksdk.http_session.HttpSession.get_pages": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 96}, "laceworksdk.http_session.HttpSession.get_data_items": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 118}, "laceworksdk.http_session.HttpSession.patch": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 43, "bases": 0, "doc": 107}, "laceworksdk.http_session.HttpSession.post": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 43, "bases": 0, "doc": 107}, "laceworksdk.http_session.HttpSession.put": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 43, "bases": 0, "doc": 107}, "laceworksdk.http_session.HttpSession.delete": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 43, "bases": 0, "doc": 101}, "laceworksdk.version": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}}, "length": 374, "save": true}, "index": {"qualname": {"root": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.__init__": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2.__init__": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.__init__": {"tf": 1}, "laceworksdk.exceptions.ApiError.__init__": {"tf": 1}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 1}}, "df": 48, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.LaceworkClient": {"tf": 1}, "laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 1}, "laceworksdk.api.LaceworkClient.set_subaccount": {"tf": 1}}, "df": 4}}}}}}, "s": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.exceptions.LaceworkSDKException": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}}, "df": 3}}}}}, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.list_data_sources": {"tf": 1}}, "df": 3}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.__init__": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2.__init__": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.__init__": {"tf": 1}, "laceworksdk.exceptions.ApiError.__init__": {"tf": 1}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 1}}, "df": 48, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}}, "df": 2}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {"laceworksdk.api.v1.account.AccountAPI.get_org_info": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v1.run_reports.RunReportsAPI.integration": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_all": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"tf": 1}}, "df": 13}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.InternalIPAddressesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.inventory.InventoryAPI": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}}, "df": 3}}}}, "d": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id": {"tf": 1}}, "df": 11}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.ImagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ImagesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 1}, "laceworksdk.api.LaceworkClient.set_subaccount": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"tf": 1}}, "df": 3}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.session": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint.search": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.search": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.search": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"tf": 1}}, "df": 7, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.search_endpoint.SearchEndpoint": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.RESOURCE": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 1}}, "df": 4}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.LaceworkClient.set_subaccount": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 1}}, "df": 1}}}}}}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.suppressions.SuppressionsAPI": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 1}}, "df": 5}}}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.status": {"tf": 1}, "laceworksdk.exceptions.ApiError.status_code": {"tf": 1}, "laceworksdk.exceptions.ApiError.status": {"tf": 1}}, "df": 5}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.schemas.SchemasAPI": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"tf": 1}}, "df": 4}}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}}, "df": 5}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.datasources.DatasourcesAPI.list_data_sources": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {"laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.get_org_info": {"tf": 1}}, "df": 2, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.organization_info.OrganizationInfoAPI": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.get": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.account.AccountAPI": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.get_org_info": {"tf": 1}}, "df": 3}}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.activities.ActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "w": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"tf": 1}}, "df": 2}}, "z": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"tf": 1}}, "df": 3}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI.get_all": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.alert_channels.AlertChannelsAPI": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.test": {"tf": 1}}, "df": 9}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.alert_profiles.AlertProfilesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.delete": {"tf": 1}}, "df": 8}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.alert_rules.AlertRulesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.delete": {"tf": 1}}, "df": 7}}}}}}}}, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.alerts.AlertsAPI": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.search": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.comment": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}}, "df": 7}}}}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}}, "df": 1}}}}}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.agent_info.AgentInfoAPI": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.audit_logs.AuditLogsAPI": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.search": {"tf": 1}}, "df": 4}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.ApplicationsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ApplicationsAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.exceptions.ApiError": {"tf": 1}, "laceworksdk.exceptions.ApiError.__init__": {"tf": 1}, "laceworksdk.exceptions.ApiError.response": {"tf": 1}, "laceworksdk.exceptions.ApiError.request": {"tf": 1}, "laceworksdk.exceptions.ApiError.status_code": {"tf": 1}, "laceworksdk.exceptions.ApiError.status": {"tf": 1}, "laceworksdk.exceptions.ApiError.details": {"tf": 1}}, "df": 7}}}}}}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.session": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.validate_json": {"tf": 1}}, "df": 6}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"tf": 1}}, "df": 2}}}}, "y": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get_by_guid": {"tf": 1}}, "df": 28}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint.delete": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.delete": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.delete": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1}}, "df": 20}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.events.EventsAPIv1.get_details": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.exceptions.ApiError.details": {"tf": 1}}, "df": 3}}}}}}, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.download_file.DownloadFileAPI": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}}, "df": 2}, "a": {"docs": {"laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.list_data_sources": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}}, "df": 3, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.datasources.DatasourcesAPI": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.list_data_sources": {"tf": 1}}, "df": 6}}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.activities.DnsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.DnsAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.FilesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.FilesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "l": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"tf": 1}}, "df": 1}}, "p": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}}, "df": 22}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.activities.UserLoginsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.UserLoginsAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.UsersAPI": {"tf": 1}, "laceworksdk.api.v2.entities.UsersAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.user_profile.UserProfileAPI": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.get": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.validate_json": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}}, "df": 2}}}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}}, "df": 10}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.delete": {"tf": 1}}, "df": 7}}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.delete": {"tf": 1}}, "df": 7}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}}, "df": 4, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.validate_json": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.create": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.search": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.update": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.delete": {"tf": 1}}, "df": 7}}}}}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}}, "df": 19}}}}}, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}}, "df": 7}}}, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.configs.ComplianceEvaluationsAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.alerts.AlertsAPI.comment": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.CommandLinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.CommandLinesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}}, "df": 4, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.container_registries.ContainerRegistriesAPI": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.delete": {"tf": 1}}, "df": 8}}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.ContainersAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ContainersAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}, "v": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.status": {"tf": 1}}, "df": 4}}}}}}}}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.contract_info.ContractInfoAPI": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"tf": 1}}, "df": 3}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.activities.ConnectionsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ConnectionsAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.configs.ConfigsAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI.__init__": {"tf": 1}}, "df": 2}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.exceptions.ApiError.status_code": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.get": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"tf": 1}}, "df": 4}}}}}}}}}}}}}}}}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}}, "df": 1}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.activities.ChangedFilesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ChangedFilesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.delete": {"tf": 1}}, "df": 8}}}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.get_org_info": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.get": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_details": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_all": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get_enabled": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get_token": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get_by_guid": {"tf": 1}, "laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}}, "df": 76}}, "c": {"docs": {}, "df": 0, "p": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 1}}, "df": 3}}, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get_by_guid": {"tf": 1}}, "df": 9}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.search_endpoint.SearchEndpoint.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.activities.ChangedFilesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.activities.ConnectionsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.activities.DnsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.activities.UserLoginsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.ApplicationsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.CommandLinesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.ContainersAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.FilesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.ImagesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.K8sPodsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.MachinesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.MachineDetailsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.NewFileHashesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.PackagesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.ProcessesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.UsersAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI.RESOURCE": {"tf": 1}}, "df": 22, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.resource_groups.ResourceGroupsAPI": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.delete": {"tf": 1}}, "df": 7}}}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.exceptions.ApiError.response": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 1}}, "df": 4, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.delete": {"tf": 1}}, "df": 8}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.report_rules.ReportRulesAPI": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.delete": {"tf": 1}}, "df": 7}}}}}}}}, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.reports.ReportsAPI": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}}, "df": 3}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.recommendations.RecommendationsAPI": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}}, "df": 4}}}}}}}}}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.exceptions.ApiError.request": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.exceptions.RateLimitError": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.run_reports.RunReportsAPI": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.integration": {"tf": 1}}, "df": 7}}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.ProcessesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ProcessesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.PackagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.PackagesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}}, "df": 2}}}, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"laceworksdk.http_session.HttpSession.patch": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.policies.PoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.delete": {"tf": 1}}, "df": 7}}}}}}, "y": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete": {"tf": 1}}, "df": 7}}}}}}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.http_session.HttpSession.post": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.http_session.HttpSession.put": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"1": {"docs": {"laceworksdk.api.v1.events.EventsAPIv1": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.__init__": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_details": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1}}, "df": 5}, "2": {"docs": {"laceworksdk.api.v2.events.EventsAPIv2": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2.__init__": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}}}}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v1.token.TokenAPI.get_enabled": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 1}}, "df": 2}}}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_by_type": {"tf": 1}}, "df": 5}}}, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v1.token.TokenAPI.get_token": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1}}, "df": 2, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.token.TokenAPI": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.create": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get_enabled": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get_token": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1}}, "df": 8}}}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.alert_channels.AlertChannelsAPI.test": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.team_members.TeamMembersAPI": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.delete": {"tf": 1}}, "df": 7}}}}}}}}}}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}}, "df": 3, "v": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.http_session.HttpSession": {"tf": 1}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 1}, "laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1}, "laceworksdk.http_session.HttpSession.post": {"tf": 1}, "laceworksdk.http_session.HttpSession.put": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1}}, "df": 9}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.MachinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachinesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.MachineDetailsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachineDetailsAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.exceptions.MalformedResponse": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}, "k": {"8": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.K8sPodsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.K8sPodsAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}, "docs": {}, "df": 0}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.NetworkInterfacesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}, "w": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.NewFileHashesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NewFileHashesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.queries.QueriesAPI": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.delete": {"tf": 1}}, "df": 10}}}}}}}}}}}}, "fullname": {"root": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.__init__": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2.__init__": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.__init__": {"tf": 1}, "laceworksdk.exceptions.ApiError.__init__": {"tf": 1}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 1}}, "df": 48, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "k": {"docs": {"laceworksdk": {"tf": 1}, "laceworksdk.api": {"tf": 1}, "laceworksdk.api.LaceworkClient": {"tf": 1}, "laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 1}, "laceworksdk.api.LaceworkClient.set_subaccount": {"tf": 1}, "laceworksdk.api.base_endpoint": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.session": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.validate_json": {"tf": 1}, "laceworksdk.api.crud_endpoint": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.create": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.search": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.update": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.delete": {"tf": 1}, "laceworksdk.api.search_endpoint": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.RESOURCE": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 1}, "laceworksdk.api.v1": {"tf": 1}, "laceworksdk.api.v1.account": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.get_org_info": {"tf": 1}, "laceworksdk.api.v1.compliance": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.get": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"tf": 1}, "laceworksdk.api.v1.download_file": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"tf": 1}, "laceworksdk.api.v1.events": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.__init__": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_details": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1}, "laceworksdk.api.v1.integrations": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_all": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"tf": 1}, "laceworksdk.api.v1.recommendations": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.run_reports": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.integration": {"tf": 1}, "laceworksdk.api.v1.suppressions": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.token": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.create": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get_enabled": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get_token": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1}, "laceworksdk.api.v1.vulnerability": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}, "laceworksdk.api.v2": {"tf": 1}, "laceworksdk.api.v2.activities": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.activities.ChangedFilesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ChangedFilesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.activities.ConnectionsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ConnectionsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.activities.DnsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.DnsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.activities.UserLoginsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.UserLoginsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete": {"tf": 1}, "laceworksdk.api.v2.agent_info": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_channels": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.test": {"tf": 1}, "laceworksdk.api.v2.alert_profiles": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_rules": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alerts": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.search": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.comment": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}, "laceworksdk.api.v2.audit_logs": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.search": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.cloud_activities": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search": {"tf": 1}, "laceworksdk.api.v2.configs": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.container_registries": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.contract_info": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"tf": 1}, "laceworksdk.api.v2.datasources": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.list_data_sources": {"tf": 1}, "laceworksdk.api.v2.entities": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.entities.ApplicationsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ApplicationsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.CommandLinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.CommandLinesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.ContainersAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ContainersAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.FilesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.FilesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.ImagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ImagesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.K8sPodsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.K8sPodsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.MachinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachinesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.MachineDetailsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachineDetailsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.NewFileHashesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NewFileHashesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.PackagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.PackagesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.ProcessesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ProcessesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.UsersAPI": {"tf": 1}, "laceworksdk.api.v2.entities.UsersAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.events": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2.__init__": {"tf": 1}, "laceworksdk.api.v2.inventory": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.organization_info": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.queries": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_definitions": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_rules": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.reports": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.schemas": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"tf": 1}, "laceworksdk.api.v2.team_members": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.delete": {"tf": 1}, "laceworksdk.api.v2.user_profile": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.status": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.delete": {"tf": 1}, "laceworksdk.config": {"tf": 1}, "laceworksdk.exceptions": {"tf": 1}, "laceworksdk.exceptions.LaceworkSDKException": {"tf": 1}, "laceworksdk.exceptions.ApiError": {"tf": 1}, "laceworksdk.exceptions.ApiError.__init__": {"tf": 1}, "laceworksdk.exceptions.ApiError.response": {"tf": 1}, "laceworksdk.exceptions.ApiError.request": {"tf": 1}, "laceworksdk.exceptions.ApiError.status_code": {"tf": 1}, "laceworksdk.exceptions.ApiError.status": {"tf": 1}, "laceworksdk.exceptions.ApiError.details": {"tf": 1}, "laceworksdk.exceptions.MalformedResponse": {"tf": 1}, "laceworksdk.exceptions.RateLimitError": {"tf": 1}, "laceworksdk.http_session": {"tf": 1}, "laceworksdk.http_session.HttpSession": {"tf": 1}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 1}, "laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1}, "laceworksdk.http_session.HttpSession.post": {"tf": 1}, "laceworksdk.http_session.HttpSession.put": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1}, "laceworksdk.version": {"tf": 1}}, "df": 374, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.exceptions.LaceworkSDKException": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.LaceworkClient": {"tf": 1}, "laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 1}, "laceworksdk.api.LaceworkClient.set_subaccount": {"tf": 1}}, "df": 4}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}}, "df": 3}}}}}, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.list_data_sources": {"tf": 1}}, "df": 3}}}, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.audit_logs": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.search": {"tf": 1}}, "df": 5}}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api": {"tf": 1}, "laceworksdk.api.LaceworkClient": {"tf": 1}, "laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 1}, "laceworksdk.api.LaceworkClient.set_subaccount": {"tf": 1}, "laceworksdk.api.base_endpoint": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.session": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.validate_json": {"tf": 1}, "laceworksdk.api.crud_endpoint": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.create": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.search": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.update": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.delete": {"tf": 1}, "laceworksdk.api.search_endpoint": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.RESOURCE": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 1}, "laceworksdk.api.v1": {"tf": 1}, "laceworksdk.api.v1.account": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.get_org_info": {"tf": 1}, "laceworksdk.api.v1.compliance": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.get": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"tf": 1}, "laceworksdk.api.v1.download_file": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"tf": 1}, "laceworksdk.api.v1.events": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.__init__": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_details": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1}, "laceworksdk.api.v1.integrations": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_all": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"tf": 1}, "laceworksdk.api.v1.recommendations": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.run_reports": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.integration": {"tf": 1}, "laceworksdk.api.v1.suppressions": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.token": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.create": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get_enabled": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get_token": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1}, "laceworksdk.api.v1.vulnerability": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}, "laceworksdk.api.v2": {"tf": 1}, "laceworksdk.api.v2.activities": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.activities.ChangedFilesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ChangedFilesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.activities.ConnectionsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ConnectionsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.activities.DnsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.DnsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.activities.UserLoginsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.UserLoginsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete": {"tf": 1}, "laceworksdk.api.v2.agent_info": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_channels": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.test": {"tf": 1}, "laceworksdk.api.v2.alert_profiles": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_rules": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alerts": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.search": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.comment": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}, "laceworksdk.api.v2.audit_logs": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.search": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.cloud_activities": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search": {"tf": 1}, "laceworksdk.api.v2.configs": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.container_registries": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.contract_info": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"tf": 1}, "laceworksdk.api.v2.datasources": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.list_data_sources": {"tf": 1}, "laceworksdk.api.v2.entities": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.entities.ApplicationsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ApplicationsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.CommandLinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.CommandLinesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.ContainersAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ContainersAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.FilesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.FilesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.ImagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ImagesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.K8sPodsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.K8sPodsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.MachinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachinesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.MachineDetailsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachineDetailsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.NewFileHashesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NewFileHashesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.PackagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.PackagesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.ProcessesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ProcessesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.UsersAPI": {"tf": 1}, "laceworksdk.api.v2.entities.UsersAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.events": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2.__init__": {"tf": 1}, "laceworksdk.api.v2.inventory": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.organization_info": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.queries": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_definitions": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_rules": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.reports": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.schemas": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"tf": 1}, "laceworksdk.api.v2.team_members": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.delete": {"tf": 1}, "laceworksdk.api.v2.user_profile": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.status": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.delete": {"tf": 1}}, "df": 350, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.exceptions.ApiError": {"tf": 1}, "laceworksdk.exceptions.ApiError.__init__": {"tf": 1}, "laceworksdk.exceptions.ApiError.response": {"tf": 1}, "laceworksdk.exceptions.ApiError.request": {"tf": 1}, "laceworksdk.exceptions.ApiError.status_code": {"tf": 1}, "laceworksdk.exceptions.ApiError.status": {"tf": 1}, "laceworksdk.exceptions.ApiError.details": {"tf": 1}}, "df": 7}}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.ApplicationsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ApplicationsAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete": {"tf": 1}}, "df": 8}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v1.account": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.get_org_info": {"tf": 1}}, "df": 4, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.account.AccountAPI": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.get_org_info": {"tf": 1}}, "df": 3}}}, "s": {"docs": {"laceworksdk.api.v2.cloud_accounts": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.delete": {"tf": 1}}, "df": 9}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.activities": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.activities.ChangedFilesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ChangedFilesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.activities.ConnectionsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ConnectionsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.activities.DnsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.DnsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.activities.UserLoginsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.UserLoginsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.cloud_activities": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search": {"tf": 1}}, "df": 18, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.activities.ActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "w": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"tf": 1}}, "df": 2}}, "z": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"tf": 1}}, "df": 3}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI.get_all": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.alert_channels": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.test": {"tf": 1}, "laceworksdk.api.v2.alert_profiles": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_rules": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.delete": {"tf": 1}}, "df": 27, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.alert_channels.AlertChannelsAPI": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.test": {"tf": 1}}, "df": 9}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.alert_profiles.AlertProfilesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.delete": {"tf": 1}}, "df": 8}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.alert_rules.AlertRulesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.delete": {"tf": 1}}, "df": 7}}}}}}}}, "s": {"docs": {"laceworksdk.api.v2.alerts": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.search": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.comment": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}}, "df": 8, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.alerts.AlertsAPI": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.search": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.comment": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}}, "df": 7}}}}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}}, "df": 1}}}}}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.agent_access_tokens": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete": {"tf": 1}, "laceworksdk.api.v2.agent_info": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI.__init__": {"tf": 1}}, "df": 10, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.agent_info.AgentInfoAPI": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.audit_logs": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.search": {"tf": 1}}, "df": 5, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.audit_logs.AuditLogsAPI": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.search": {"tf": 1}}, "df": 4}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.__init__": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2.__init__": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.__init__": {"tf": 1}, "laceworksdk.exceptions.ApiError.__init__": {"tf": 1}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 1}}, "df": 48, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}}, "df": 2}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {"laceworksdk.api.v1.account.AccountAPI.get_org_info": {"tf": 1}, "laceworksdk.api.v2.agent_info": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.contract_info": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"tf": 1}, "laceworksdk.api.v2.organization_info": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.get": {"tf": 1}}, "df": 12}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v1.run_reports.RunReportsAPI.integration": {"tf": 1}}, "df": 1, "s": {"docs": {"laceworksdk.api.v1.integrations": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_all": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"tf": 1}}, "df": 14, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_all": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"tf": 1}}, "df": 13}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.InternalIPAddressesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v2.inventory": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI.__init__": {"tf": 1}}, "df": 3, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.inventory.InventoryAPI": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}}, "df": 3}}}}, "d": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id": {"tf": 1}}, "df": 11}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.ImagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ImagesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 1}, "laceworksdk.api.LaceworkClient.set_subaccount": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"tf": 1}}, "df": 3}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.session": {"tf": 1}, "laceworksdk.http_session": {"tf": 1}, "laceworksdk.http_session.HttpSession": {"tf": 1}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 1}, "laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1}, "laceworksdk.http_session.HttpSession.post": {"tf": 1}, "laceworksdk.http_session.HttpSession.put": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1}}, "df": 11}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint.search": {"tf": 1}, "laceworksdk.api.search_endpoint": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.RESOURCE": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.search": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.search": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"tf": 1}}, "df": 11, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.search_endpoint.SearchEndpoint": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.RESOURCE": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 1}}, "df": 4}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.LaceworkClient.set_subaccount": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 1}}, "df": 1}}}}}}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.suppressions": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 1}}, "df": 6, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.suppressions.SuppressionsAPI": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 1}}, "df": 5}}}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.status": {"tf": 1}, "laceworksdk.exceptions.ApiError.status_code": {"tf": 1}, "laceworksdk.exceptions.ApiError.status": {"tf": 1}}, "df": 5}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"tf": 1}}, "df": 1, "s": {"docs": {"laceworksdk.api.v2.schemas": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"tf": 1}}, "df": 5, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.schemas.SchemasAPI": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"tf": 1}}, "df": 4}}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}}, "df": 5}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.datasources.DatasourcesAPI.list_data_sources": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {"laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.get_org_info": {"tf": 1}}, "df": 2, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v2.organization_info": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.get": {"tf": 1}}, "df": 4, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.organization_info.OrganizationInfoAPI": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.get": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}}}}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.base_endpoint": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.session": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.validate_json": {"tf": 1}}, "df": 7, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.session": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.validate_json": {"tf": 1}}, "df": 6}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"tf": 1}}, "df": 2}}}}, "y": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get_by_guid": {"tf": 1}}, "df": 28}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.base_endpoint": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.session": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.validate_json": {"tf": 1}, "laceworksdk.api.crud_endpoint": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.create": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.search": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.update": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.delete": {"tf": 1}, "laceworksdk.api.search_endpoint": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.RESOURCE": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 1}}, "df": 20}}}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v1.token.TokenAPI.get_enabled": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.entities": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.entities.ApplicationsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ApplicationsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.CommandLinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.CommandLinesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.ContainersAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ContainersAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.FilesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.FilesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.ImagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ImagesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.K8sPodsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.K8sPodsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.MachinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachinesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.MachineDetailsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachineDetailsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.NewFileHashesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NewFileHashesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.PackagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.PackagesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.ProcessesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ProcessesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.UsersAPI": {"tf": 1}, "laceworksdk.api.v2.entities.UsersAPI.RESOURCE": {"tf": 1}}, "df": 31, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.events": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.__init__": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_details": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1}, "laceworksdk.api.v2.events": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2.__init__": {"tf": 1}}, "df": 9, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"1": {"docs": {"laceworksdk.api.v1.events.EventsAPIv1": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.__init__": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_details": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1}}, "df": 5}, "2": {"docs": {"laceworksdk.api.v2.events.EventsAPIv2": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2.__init__": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}}}}}}}}}, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.policy_exceptions": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.delete": {"tf": 1}, "laceworksdk.exceptions": {"tf": 1}, "laceworksdk.exceptions.LaceworkSDKException": {"tf": 1}, "laceworksdk.exceptions.ApiError": {"tf": 1}, "laceworksdk.exceptions.ApiError.__init__": {"tf": 1}, "laceworksdk.exceptions.ApiError.response": {"tf": 1}, "laceworksdk.exceptions.ApiError.request": {"tf": 1}, "laceworksdk.exceptions.ApiError.status_code": {"tf": 1}, "laceworksdk.exceptions.ApiError.status": {"tf": 1}, "laceworksdk.exceptions.ApiError.details": {"tf": 1}, "laceworksdk.exceptions.MalformedResponse": {"tf": 1}, "laceworksdk.exceptions.RateLimitError": {"tf": 1}}, "df": 27}}}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 1}}, "df": 2}}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint.delete": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.delete": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.delete": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1}}, "df": 20}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.events.EventsAPIv1.get_details": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.exceptions.ApiError.details": {"tf": 1}}, "df": 3}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.report_definitions": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.delete": {"tf": 1}}, "df": 9}}}}}}}}}}, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v1.download_file": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"tf": 1}}, "df": 4, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.download_file.DownloadFileAPI": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}}, "df": 2}, "a": {"docs": {"laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.list_data_sources": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}}, "df": 3, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"tf": 1}}, "df": 1, "s": {"docs": {"laceworksdk.api.v2.datasources": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.list_data_sources": {"tf": 1}}, "df": 7, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.datasources.DatasourcesAPI": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.list_data_sources": {"tf": 1}}, "df": 6}}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.activities.DnsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.DnsAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.download_file": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"tf": 1}}, "df": 4, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.FilesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.FilesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "l": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"tf": 1}}, "df": 1}}, "p": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}}, "df": 22}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.api.v2.user_profile": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.get": {"tf": 1}}, "df": 4, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.activities.UserLoginsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.UserLoginsAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.UsersAPI": {"tf": 1}, "laceworksdk.api.v2.entities.UsersAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.user_profile.UserProfileAPI": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.get": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}, "v": {"1": {"docs": {"laceworksdk.api.v1": {"tf": 1}, "laceworksdk.api.v1.account": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.get_org_info": {"tf": 1}, "laceworksdk.api.v1.compliance": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.get": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"tf": 1}, "laceworksdk.api.v1.download_file": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"tf": 1}, "laceworksdk.api.v1.events": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.__init__": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_details": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1}, "laceworksdk.api.v1.integrations": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_all": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"tf": 1}, "laceworksdk.api.v1.recommendations": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.run_reports": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.integration": {"tf": 1}, "laceworksdk.api.v1.suppressions": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.token": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.create": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get_enabled": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get_token": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1}, "laceworksdk.api.v1.vulnerability": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}}, "df": 81}, "2": {"docs": {"laceworksdk.api.v2": {"tf": 1}, "laceworksdk.api.v2.activities": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.activities.ChangedFilesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ChangedFilesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.activities.ConnectionsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ConnectionsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.activities.DnsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.DnsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.activities.UserLoginsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.UserLoginsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete": {"tf": 1}, "laceworksdk.api.v2.agent_info": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_channels": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.test": {"tf": 1}, "laceworksdk.api.v2.alert_profiles": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_rules": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alerts": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.search": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.comment": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}, "laceworksdk.api.v2.audit_logs": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.search": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.cloud_activities": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search": {"tf": 1}, "laceworksdk.api.v2.configs": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.container_registries": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.contract_info": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"tf": 1}, "laceworksdk.api.v2.datasources": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.list_data_sources": {"tf": 1}, "laceworksdk.api.v2.entities": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.entities.ApplicationsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ApplicationsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.CommandLinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.CommandLinesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.ContainersAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ContainersAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.FilesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.FilesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.ImagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ImagesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.K8sPodsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.K8sPodsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.MachinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachinesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.MachineDetailsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachineDetailsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.NewFileHashesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NewFileHashesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.PackagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.PackagesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.ProcessesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ProcessesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.UsersAPI": {"tf": 1}, "laceworksdk.api.v2.entities.UsersAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.events": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2.__init__": {"tf": 1}, "laceworksdk.api.v2.inventory": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.organization_info": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.queries": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_definitions": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_rules": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.reports": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.schemas": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"tf": 1}, "laceworksdk.api.v2.team_members": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.delete": {"tf": 1}, "laceworksdk.api.v2.user_profile": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.status": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.delete": {"tf": 1}}, "df": 244}, "docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.validate_json": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}}, "df": 2}}}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v1.vulnerability": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.delete": {"tf": 1}}, "df": 27, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}}, "df": 10}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.delete": {"tf": 1}}, "df": 7}}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.delete": {"tf": 1}}, "df": 7}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.status": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}}, "df": 15, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.version": {"tf": 1}}, "df": 1}}}}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.validate_json": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.crud_endpoint": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.create": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.search": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.update": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.delete": {"tf": 1}}, "df": 8, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.create": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.search": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.update": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.delete": {"tf": 1}}, "df": 7}}}}}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}}, "df": 19}}}}}, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.compliance": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.get": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"tf": 1}}, "df": 13, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}}, "df": 7}}}, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.configs.ComplianceEvaluationsAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.alerts.AlertsAPI.comment": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.CommandLinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.CommandLinesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"laceworksdk.api.v1.custom_compliance_config": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.get": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"tf": 1}, "laceworksdk.config": {"tf": 1}}, "df": 6, "s": {"docs": {"laceworksdk.api.v2.configs": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI.RESOURCE": {"tf": 1}}, "df": 5, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.configs.ConfigsAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI.__init__": {"tf": 1}}, "df": 2}}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v2.container_registries": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.delete": {"tf": 1}}, "df": 13, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.container_registries.ContainerRegistriesAPI": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.delete": {"tf": 1}}, "df": 8}}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.ContainersAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ContainersAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}, "v": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.status": {"tf": 1}}, "df": 4}}}}}}}}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.contract_info": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"tf": 1}}, "df": 4, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.contract_info.ContractInfoAPI": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"tf": 1}}, "df": 3}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.activities.ConnectionsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ConnectionsAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.exceptions.ApiError.status_code": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"laceworksdk.api.v1.custom_compliance_config": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.get": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"tf": 1}}, "df": 5, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.get": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"tf": 1}}, "df": 4}}}}}}}}}}}}}}}}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}}, "df": 1}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.activities.ChangedFilesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ChangedFilesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.alert_channels": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.test": {"tf": 1}}, "df": 10}}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v2.cloud_accounts": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.cloud_activities": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search": {"tf": 1}}, "df": 16, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.delete": {"tf": 1}}, "df": 8}}}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.get_org_info": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.get": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_details": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_all": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get_enabled": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get_token": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get_by_guid": {"tf": 1}, "laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}}, "df": 76}}, "c": {"docs": {}, "df": 0, "p": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 1}}, "df": 3}}, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get_by_guid": {"tf": 1}}, "df": 9}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.resource_groups": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.delete": {"tf": 1}}, "df": 8}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.search_endpoint.SearchEndpoint.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.activities.ChangedFilesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.activities.ConnectionsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.activities.DnsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.activities.UserLoginsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.ApplicationsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.CommandLinesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.ContainersAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.FilesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.ImagesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.K8sPodsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.MachinesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.MachineDetailsAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.NewFileHashesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.PackagesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.ProcessesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.entities.UsersAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.resource_groups": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI.RESOURCE": {"tf": 1}}, "df": 30, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.resource_groups.ResourceGroupsAPI": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.delete": {"tf": 1}}, "df": 7}}}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.exceptions.ApiError.response": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 1}, "laceworksdk.api.v2.report_definitions": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_rules": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.delete": {"tf": 1}}, "df": 21, "s": {"docs": {"laceworksdk.api.v1.run_reports": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.integration": {"tf": 1}, "laceworksdk.api.v2.reports": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}}, "df": 12, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.reports.ReportsAPI": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}}, "df": 3}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.delete": {"tf": 1}}, "df": 8}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.report_rules.ReportRulesAPI": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.delete": {"tf": 1}}, "df": 7}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.recommendations": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}}, "df": 5, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.recommendations.RecommendationsAPI": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}}, "df": 4}}}}}}}}}}}}}}}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.container_registries": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.delete": {"tf": 1}}, "df": 9}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.exceptions.ApiError.request": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.exceptions.RateLimitError": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v1.run_reports": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.integration": {"tf": 1}}, "df": 8, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.run_reports.RunReportsAPI": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.integration": {"tf": 1}}, "df": 7}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.alert_rules": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_rules": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.delete": {"tf": 1}}, "df": 16}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.user_profile": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.get": {"tf": 1}}, "df": 4, "s": {"docs": {"laceworksdk.api.v2.alert_profiles": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.delete": {"tf": 1}}, "df": 9}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.ProcessesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ProcessesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.PackagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.PackagesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}}, "df": 2}}}, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"laceworksdk.http_session.HttpSession.patch": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.policies": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.delete": {"tf": 1}}, "df": 16, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.policies.PoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.delete": {"tf": 1}}, "df": 7}}}}}}, "y": {"docs": {"laceworksdk.api.v2.policy_exceptions": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete": {"tf": 1}}, "df": 8, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete": {"tf": 1}}, "df": 7}}}}}}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.http_session.HttpSession.post": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.http_session.HttpSession.put": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_by_type": {"tf": 1}}, "df": 5}}}, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v1.token": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.create": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get_enabled": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get_token": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1.4142135623730951}}, "df": 9, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.token.TokenAPI": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.create": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get_enabled": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get_token": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1}}, "df": 8}}}, "s": {"docs": {"laceworksdk.api.v2.agent_access_tokens": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete": {"tf": 1}}, "df": 7}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.alert_channels.AlertChannelsAPI.test": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "m": {"docs": {"laceworksdk.api.v2.team_members": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.delete": {"tf": 1}}, "df": 8, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.team_members.TeamMembersAPI": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.delete": {"tf": 1}}, "df": 7}}}}}}}}}}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}}, "df": 3, "v": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {"laceworksdk.http_session": {"tf": 1}, "laceworksdk.http_session.HttpSession": {"tf": 1}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 1}, "laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1}, "laceworksdk.http_session.HttpSession.post": {"tf": 1}, "laceworksdk.http_session.HttpSession.put": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1}}, "df": 10, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.http_session.HttpSession": {"tf": 1}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 1}, "laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1}, "laceworksdk.http_session.HttpSession.post": {"tf": 1}, "laceworksdk.http_session.HttpSession.put": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1}}, "df": 9}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.MachinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachinesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.MachineDetailsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachineDetailsAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.exceptions.MalformedResponse": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.team_members": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.delete": {"tf": 1}}, "df": 8}}}}}}}, "k": {"8": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.K8sPodsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.K8sPodsAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}, "docs": {}, "df": 0}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.NetworkInterfacesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}, "w": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.NewFileHashesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NewFileHashesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.queries": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.delete": {"tf": 1}}, "df": 11, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.queries.QueriesAPI": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.delete": {"tf": 1}}, "df": 10}}}}}}}}}}}}, "annotation": {"root": {"docs": {}, "df": 0}}, "default_value": {"root": {"docs": {"laceworksdk.api.search_endpoint.SearchEndpoint.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.activities.ChangedFilesAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.activities.ConnectionsAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.activities.DnsAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.activities.UserLoginsAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.ApplicationsAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.CommandLinesAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.ContainersAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.FilesAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.ImagesAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.K8sPodsAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.MachinesAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.MachineDetailsAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.NewFileHashesAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.PackagesAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.ProcessesAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.UsersAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI.RESOURCE": {"tf": 1.4142135623730951}}, "df": 22, "x": {"2": {"7": {"docs": {"laceworksdk.api.search_endpoint.SearchEndpoint.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.activities.ChangedFilesAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.activities.ConnectionsAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.activities.DnsAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.activities.UserLoginsAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.ApplicationsAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.CommandLinesAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.ContainersAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.FilesAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.ImagesAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.K8sPodsAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.MachinesAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.MachineDetailsAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.NewFileHashesAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.PackagesAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.ProcessesAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.UsersAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.RESOURCE": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI.RESOURCE": {"tf": 1.4142135623730951}}, "df": 22}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.activities.ChangedFilesAPI.RESOURCE": {"tf": 1}}, "df": 1}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.activities.ConnectionsAPI.RESOURCE": {"tf": 1}}, "df": 1}}}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.entities.ContainersAPI.RESOURCE": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.RESOURCE": {"tf": 1}}, "df": 2}}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.configs.ComplianceEvaluationsAPI.RESOURCE": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.entities.CommandLinesAPI.RESOURCE": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.activities.DnsAPI.RESOURCE": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.activities.UserLoginsAPI.RESOURCE": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {"laceworksdk.api.v2.entities.UsersAPI.RESOURCE": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.entities.ApplicationsAPI.RESOURCE": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.entities.FilesAPI.RESOURCE": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.entities.ImagesAPI.RESOURCE": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.entities.InternalIPAddressesAPI.RESOURCE": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}, "k": {"8": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.entities.K8sPodsAPI.RESOURCE": {"tf": 1}}, "df": 1}}}}}}, "docs": {}, "df": 0}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.entities.MachinesAPI.RESOURCE": {"tf": 1}}, "df": 1}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.entities.MachineDetailsAPI.RESOURCE": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.entities.NetworkInterfacesAPI.RESOURCE": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}, "w": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.entities.NewFileHashesAPI.RESOURCE": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.entities.PackagesAPI.RESOURCE": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.entities.ProcessesAPI.RESOURCE": {"tf": 1}}, "df": 1}}}}}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI.RESOURCE": {"tf": 1}}, "df": 1}}}}}}}, "signature": {"root": {"3": {"9": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 1.4142135623730951}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 1.4142135623730951}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 1.4142135623730951}}, "df": 3}, "docs": {}, "df": 0}, "docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 8.18535277187245}, "laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 3.7416573867739413}, "laceworksdk.api.LaceworkClient.set_subaccount": {"tf": 3.7416573867739413}, "laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 4.69041575982343}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 4.69041575982343}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"tf": 5.830951894845301}, "laceworksdk.api.base_endpoint.BaseEndpoint.validate_json": {"tf": 4.69041575982343}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 4.69041575982343}, "laceworksdk.api.crud_endpoint.CrudEndpoint.create": {"tf": 4.898979485566356}, "laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"tf": 5.656854249492381}, "laceworksdk.api.crud_endpoint.CrudEndpoint.search": {"tf": 4.898979485566356}, "laceworksdk.api.crud_endpoint.CrudEndpoint.update": {"tf": 5.656854249492381}, "laceworksdk.api.crud_endpoint.CrudEndpoint.delete": {"tf": 4.69041575982343}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 4.69041575982343}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 5.656854249492381}, "laceworksdk.api.v1.account.AccountAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v1.account.AccountAPI.get_org_info": {"tf": 3.1622776601683795}, "laceworksdk.api.v1.compliance.ComplianceAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 6.557438524302}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 6.928203230275509}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 6.928203230275509}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 3.7416573867739413}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 3.7416573867739413}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.get": {"tf": 3.1622776601683795}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"tf": 3.7416573867739413}, "laceworksdk.api.v1.download_file.DownloadFileAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"tf": 3.7416573867739413}, "laceworksdk.api.v1.events.EventsAPIv1.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 5.830951894845301}, "laceworksdk.api.v1.events.EventsAPIv1.get_details": {"tf": 3.7416573867739413}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 4.242640687119285}, "laceworksdk.api.v1.integrations.IntegrationsAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 5.0990195135927845}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"tf": 5.830951894845301}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_all": {"tf": 3.1622776601683795}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 3.7416573867739413}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"tf": 3.7416573867739413}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 6.782329983125268}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 6.782329983125268}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 4.242640687119285}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete": {"tf": 3.7416573867739413}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 3.7416573867739413}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"tf": 3.7416573867739413}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"tf": 3.7416573867739413}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 4.242640687119285}, "laceworksdk.api.v1.run_reports.RunReportsAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 4.242640687119285}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"tf": 3.7416573867739413}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"tf": 3.7416573867739413}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 3.7416573867739413}, "laceworksdk.api.v1.run_reports.RunReportsAPI.integration": {"tf": 3.7416573867739413}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"tf": 4.242640687119285}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"tf": 4.69041575982343}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 4.242640687119285}, "laceworksdk.api.v1.token.TokenAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v1.token.TokenAPI.create": {"tf": 5.830951894845301}, "laceworksdk.api.v1.token.TokenAPI.get": {"tf": 4.242640687119285}, "laceworksdk.api.v1.token.TokenAPI.get_enabled": {"tf": 3.1622776601683795}, "laceworksdk.api.v1.token.TokenAPI.get_token": {"tf": 3.7416573867739413}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 6.164414002968976}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 6.557438524302}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 5.0990195135927845}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 8.06225774829855}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 4.69041575982343}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 5.477225575051661}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 8.06225774829855}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 6.164414002968976}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 8.366600265340756}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 7.483314773547883}, "laceworksdk.api.v2.activities.ActivitiesAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 5.656854249492381}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 5.291502622129181}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete": {"tf": 3.1622776601683795}, "laceworksdk.api.v2.agent_info.AgentInfoAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 5.656854249492381}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get": {"tf": 5.0990195135927845}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_guid": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_type": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 7.681145747868608}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.delete": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.test": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 5.291502622129181}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get": {"tf": 4.242640687119285}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"tf": 4}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 5.291502622129181}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.delete": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 5.291502622129181}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get": {"tf": 4.242640687119285}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get_by_guid": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 7.0710678118654755}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.delete": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.alerts.AlertsAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 5.656854249492381}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 4.898979485566356}, "laceworksdk.api.v2.alerts.AlertsAPI.search": {"tf": 4.242640687119285}, "laceworksdk.api.v2.alerts.AlertsAPI.comment": {"tf": 4.242640687119285}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 5.0990195135927845}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 5.656854249492381}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.search": {"tf": 4.242640687119285}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 5.656854249492381}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get": {"tf": 5.0990195135927845}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 7.681145747868608}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.delete": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 5.656854249492381}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"tf": 4}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 4}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search": {"tf": 4.242640687119285}, "laceworksdk.api.v2.configs.ConfigsAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 5.656854249492381}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get": {"tf": 5.0990195135927845}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 7.681145747868608}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.delete": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"tf": 4}, "laceworksdk.api.v2.datasources.DatasourcesAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get": {"tf": 4.242640687119285}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_by_type": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.datasources.DatasourcesAPI.list_data_sources": {"tf": 3.1622776601683795}, "laceworksdk.api.v2.entities.EntitiesAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.events.EventsAPIv2.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.inventory.InventoryAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.get": {"tf": 3.1622776601683795}, "laceworksdk.api.v2.policies.PoliciesAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 9.486832980505138}, "laceworksdk.api.v2.policies.PoliciesAPI.get": {"tf": 4.242640687119285}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 11.045361017187261}, "laceworksdk.api.v2.policies.PoliciesAPI.delete": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 5.291502622129181}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get": {"tf": 5.0990195135927845}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 4.242640687119285}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 6.782329983125268}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete": {"tf": 4.242640687119285}, "laceworksdk.api.v2.queries.QueriesAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 5.656854249492381}, "laceworksdk.api.v2.queries.QueriesAPI.get": {"tf": 4.242640687119285}, "laceworksdk.api.v2.queries.QueriesAPI.get_by_id": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 6.928203230275509}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 4.795831523312719}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 5.291502622129181}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 4.898979485566356}, "laceworksdk.api.v2.queries.QueriesAPI.delete": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 7.615773105863909}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get": {"tf": 4.242640687119285}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"tf": 4}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 9.38083151964686}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.delete": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 6.164414002968976}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get": {"tf": 4.242640687119285}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get_by_guid": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 7.681145747868608}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.delete": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.reports.ReportsAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 9.486832980505138}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 5.656854249492381}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get": {"tf": 4.242640687119285}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get_by_guid": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 7.681145747868608}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.delete": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.schemas.SchemasAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.schemas.SchemasAPI.get": {"tf": 5.0990195135927845}, "laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"tf": 4.242640687119285}, "laceworksdk.api.v2.team_members.TeamMembersAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 8.306623862918075}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get": {"tf": 4.242640687119285}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get_by_guid": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 9.273618495495704}, "laceworksdk.api.v2.team_members.TeamMembersAPI.delete": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.user_profile.UserProfileAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.user_profile.UserProfileAPI.get": {"tf": 3.1622776601683795}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 5.291502622129181}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.status": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 4.47213595499958}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 8.366600265340756}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get": {"tf": 4.242640687119285}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get_by_guid": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 9.273618495495704}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.delete": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.__init__": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 8.660254037844387}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get": {"tf": 4.242640687119285}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get_by_guid": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 10.198039027185569}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.delete": {"tf": 3.7416573867739413}, "laceworksdk.exceptions.ApiError.__init__": {"tf": 2.8284271247461903}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 4.898979485566356}, "laceworksdk.http_session.HttpSession.get": {"tf": 5.291502622129181}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 5.291502622129181}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 5.291502622129181}, "laceworksdk.http_session.HttpSession.patch": {"tf": 6}, "laceworksdk.http_session.HttpSession.post": {"tf": 6}, "laceworksdk.http_session.HttpSession.put": {"tf": 6}, "laceworksdk.http_session.HttpSession.delete": {"tf": 6}}, "df": 220, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"tf": 1}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 1}}, "df": 5, "s": {"docs": {"laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get_token": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1}}, "df": 5}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1.4142135623730951}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 1.4142135623730951}}, "df": 2, "/": {"docs": {}, "df": 0, "v": {"2": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 1}}, "df": 3}, "docs": {}, "df": 0}}}}, "w": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"tf": 1}}, "df": 2}}, "z": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"tf": 1}}, "df": 3}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.token.TokenAPI.create": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}}, "df": 4}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}}, "df": 7, "s": {"docs": {"laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}}, "df": 2}}}}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 1}}, "df": 2}}}}}}}}, "d": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 2.6457513110645907}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"tf": 1.7320508075688772}, "laceworksdk.api.base_endpoint.BaseEndpoint.validate_json": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.create": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"tf": 1.4142135623730951}, "laceworksdk.api.crud_endpoint.CrudEndpoint.search": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.update": {"tf": 1.4142135623730951}, "laceworksdk.api.crud_endpoint.CrudEndpoint.delete": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 2}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 2}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.token.TokenAPI.get": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 2.449489742783178}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 2.449489742783178}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 2.449489742783178}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 2.23606797749979}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 2}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alerts.AlertsAPI.search": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.search": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 2}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 2}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.policies.PoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 3.3166247903554}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 2.23606797749979}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 2}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 2}, "laceworksdk.api.v2.schemas.SchemasAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 2}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 2.6457513110645907}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 2.6457513110645907}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 3}, "laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1.4142135623730951}, "laceworksdk.http_session.HttpSession.post": {"tf": 1.4142135623730951}, "laceworksdk.http_session.HttpSession.put": {"tf": 1.4142135623730951}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1.4142135623730951}}, "df": 81}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}}, "df": 2}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}}, "df": 20, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}}, "df": 2}}}}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {"laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}}, "df": 2, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.api.LaceworkClient.set_subaccount": {"tf": 1}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 1}}, "df": 3}}}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.validate_json": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"tf": 1}}, "df": 3}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}}, "df": 1}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 1}}, "df": 2}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "f": {"docs": {"laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 1}, "laceworksdk.api.LaceworkClient.set_subaccount": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.validate_json": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.create": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.search": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.update": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.delete": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.get_org_info": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.get": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_details": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_all": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.integration": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.create": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get_enabled": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get_token": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.test": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.search": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.comment": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.search": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.list_data_sources": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.delete": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.status": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.delete": {"tf": 1}, "laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1}, "laceworksdk.http_session.HttpSession.post": {"tf": 1}, "laceworksdk.http_session.HttpSession.put": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1}}, "df": 172}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.__init__": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2.__init__": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.__init__": {"tf": 1}}, "df": 45}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}}, "df": 8}}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}}, "df": 9}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1.4142135623730951}}, "df": 1}}, "e": {"docs": {"laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}}, "df": 4}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 3}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 1}}, "df": 2}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint.search": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 1}, "laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1}, "laceworksdk.http_session.HttpSession.post": {"tf": 1}, "laceworksdk.http_session.HttpSession.put": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1}}, "df": 9}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v1.run_reports.RunReportsAPI.integration": {"tf": 1}}, "df": 1}}}}}}}}, "g": {"docs": {"laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}}, "df": 4}}, "f": {"docs": {}, "df": 0, "o": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}}, "df": 2}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.update": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.delete": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_details": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.comment": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policies.PoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policies.PoliciesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.queries.QueriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.status": {"tf": 1}}, "df": 56}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 1}}, "df": 2}}}}, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 1}}, "df": 2}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}}, "df": 1}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}}, "df": 2}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1}, "laceworksdk.http_session.HttpSession.post": {"tf": 1}, "laceworksdk.http_session.HttpSession.put": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1}}, "df": 17, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"tf": 1}}, "df": 1}}}}}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v1.token.TokenAPI.create": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}}, "df": 7}}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}}, "df": 2}}}}}}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}}, "df": 4}}}}, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 1}}, "df": 2}}}}, "p": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}}, "df": 10}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint.create": {"tf": 1.4142135623730951}, "laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.update": {"tf": 1.4142135623730951}, "laceworksdk.api.crud_endpoint.CrudEndpoint.delete": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}, "laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}}, "df": 50}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}}, "df": 3}}, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "d": {"docs": {}, "df": 0, "f": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}}, "df": 3}}, "k": {"docs": {}, "df": 0, "g": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}}, "df": 2}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policies.PoliciesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1.7320508075688772}}, "df": 12}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {"laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1.4142135623730951}}, "df": 3, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}}, "df": 2}}}}}}}}}}}, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 1}}, "df": 3}}}}}, "s": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}}, "df": 2}, "n": {"docs": {"laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1.4142135623730951}}, "df": 2}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}}, "df": 6}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 2}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1.4142135623730951}}, "df": 48, "s": {"docs": {"laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"tf": 1}}, "df": 3}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1}}, "df": 4}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 11}}, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.token.TokenAPI.create": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}}, "df": 4}}}, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v1.token.TokenAPI.get": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get_token": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 2}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}}, "df": 5}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}}, "df": 9, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 1}}, "df": 3}}}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.create": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}}, "df": 21}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v1.events.EventsAPIv1.get_details": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {"laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}}, "df": 4, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}}, "df": 4}}}}}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1.4142135623730951}}, "df": 6}}}}}}}, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 2}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 1}}, "df": 3}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1.4142135623730951}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 7}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.exceptions.ApiError.__init__": {"tf": 1}}, "df": 1}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint.create": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.update": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.status": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}}, "df": 48}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 2}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 2}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1.4142135623730951}}, "df": 8}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1}}, "df": 2}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1}}, "df": 2}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 3}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}}, "df": 2}}}}}}}}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.validate_json": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.search": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.search": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.search": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search": {"tf": 1}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1}, "laceworksdk.http_session.HttpSession.post": {"tf": 1}, "laceworksdk.http_session.HttpSession.put": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1}}, "df": 10}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"tf": 1}}, "df": 4}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}}, "df": 2, "s": {"docs": {"laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}}, "df": 4}}}}}, "x": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}}, "df": 4}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}}, "df": 4}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1.4142135623730951}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {"laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}}, "df": 4}}}}}}}}}, "g": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "p": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 1}}, "df": 3}}, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.integration": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.test": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.delete": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.delete": {"tf": 1}}, "df": 43}}}}, "c": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}}, "df": 3}}, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.alerts.AlertsAPI.comment": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}}, "df": 2}}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}}, "df": 2}}}}}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}}, "df": 2}}}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {"laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 2}}}}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}}, "df": 1}}}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}}, "df": 2}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.queries.QueriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.queries.QueriesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1.4142135623730951}}, "df": 11}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 2}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 2}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1}, "laceworksdk.http_session.HttpSession.post": {"tf": 1}, "laceworksdk.http_session.HttpSession.put": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1}}, "df": 7}}}}}, "bases": {"root": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "k": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint": {"tf": 1}, "laceworksdk.api.v2.activities.ChangedFilesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ConnectionsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.DnsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.UserLoginsAPI": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ApplicationsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.CommandLinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ContainersAPI": {"tf": 1}, "laceworksdk.api.v2.entities.FilesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ImagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.K8sPodsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachineDetailsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NewFileHashesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.PackagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ProcessesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.UsersAPI": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.inventory.InventoryAPI": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI": {"tf": 1}}, "df": 52, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.exceptions.ApiError": {"tf": 1}, "laceworksdk.exceptions.MalformedResponse": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint": {"tf": 1}, "laceworksdk.api.v2.activities.ChangedFilesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ConnectionsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.DnsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.UserLoginsAPI": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ApplicationsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.CommandLinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ContainersAPI": {"tf": 1}, "laceworksdk.api.v2.entities.FilesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ImagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.K8sPodsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachineDetailsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NewFileHashesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.PackagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ProcessesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.UsersAPI": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.inventory.InventoryAPI": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI": {"tf": 1}}, "df": 52, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.exceptions.RateLimitError": {"tf": 1}}, "df": 1}}}}}}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"tf": 1}}, "df": 11, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"tf": 1}}, "df": 11}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.exceptions.LaceworkSDKException": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint": {"tf": 1}, "laceworksdk.api.v2.activities.ChangedFilesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ConnectionsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.DnsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.UserLoginsAPI": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ApplicationsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.CommandLinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ContainersAPI": {"tf": 1}, "laceworksdk.api.v2.entities.FilesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ImagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.K8sPodsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachineDetailsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NewFileHashesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.PackagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ProcessesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.UsersAPI": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI": {"tf": 1}}, "df": 51}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.events.EventsAPIv2": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"1": {"docs": {"laceworksdk.api.v2.events.EventsAPIv2": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}}}}}}}}}, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.exceptions.LaceworkSDKException": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"laceworksdk.api.v2.activities.ChangedFilesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ConnectionsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.DnsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.UserLoginsAPI": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ApplicationsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.CommandLinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ContainersAPI": {"tf": 1}, "laceworksdk.api.v2.entities.FilesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ImagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.K8sPodsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachineDetailsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NewFileHashesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.PackagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ProcessesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.UsersAPI": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI": {"tf": 1}}, "df": 25, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.activities.ChangedFilesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ConnectionsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.DnsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.UserLoginsAPI": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ApplicationsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.CommandLinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ContainersAPI": {"tf": 1}, "laceworksdk.api.v2.entities.FilesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ImagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.K8sPodsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachineDetailsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NewFileHashesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.PackagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ProcessesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.UsersAPI": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI": {"tf": 1}}, "df": 25}}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI": {"tf": 1}}, "df": 15, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI": {"tf": 1}}, "df": 15}}}}}}}}}}}}, "v": {"1": {"docs": {"laceworksdk.api.v2.events.EventsAPIv2": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}, "doc": {"root": {"0": {"0": {"0": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}}, "df": 20}, "1": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}}, "df": 22}, "2": {"7": {"0": {"0": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}}, "df": 6}, "3": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}}, "df": 6}, "4": {"docs": {"laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}}, "df": 5}, "5": {"3": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}}, "df": 1}, "docs": {"laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}}, "df": 4}, "8": {"0": {"0": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"laceworksdk": {"tf": 1.7320508075688772}, "laceworksdk.api": {"tf": 1.7320508075688772}, "laceworksdk.api.LaceworkClient": {"tf": 1.7320508075688772}, "laceworksdk.api.LaceworkClient.__init__": {"tf": 3}, "laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 1.7320508075688772}, "laceworksdk.api.LaceworkClient.set_subaccount": {"tf": 1.7320508075688772}, "laceworksdk.api.base_endpoint": {"tf": 1.7320508075688772}, "laceworksdk.api.base_endpoint.BaseEndpoint": {"tf": 1.4142135623730951}, "laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 4.58257569495584}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 2.449489742783178}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"tf": 4.58257569495584}, "laceworksdk.api.base_endpoint.BaseEndpoint.session": {"tf": 2.23606797749979}, "laceworksdk.api.base_endpoint.BaseEndpoint.validate_json": {"tf": 1.7320508075688772}, "laceworksdk.api.crud_endpoint": {"tf": 1.7320508075688772}, "laceworksdk.api.crud_endpoint.CrudEndpoint": {"tf": 1.4142135623730951}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 4.58257569495584}, "laceworksdk.api.crud_endpoint.CrudEndpoint.create": {"tf": 4}, "laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"tf": 5.0990195135927845}, "laceworksdk.api.crud_endpoint.CrudEndpoint.search": {"tf": 4}, "laceworksdk.api.crud_endpoint.CrudEndpoint.update": {"tf": 4.58257569495584}, "laceworksdk.api.crud_endpoint.CrudEndpoint.delete": {"tf": 4}, "laceworksdk.api.search_endpoint": {"tf": 1.7320508075688772}, "laceworksdk.api.search_endpoint.SearchEndpoint": {"tf": 1.4142135623730951}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 4.58257569495584}, "laceworksdk.api.search_endpoint.SearchEndpoint.RESOURCE": {"tf": 1.7320508075688772}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 4.123105625617661}, "laceworksdk.api.v1": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.account": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.account.AccountAPI": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.account.AccountAPI.__init__": {"tf": 4}, "laceworksdk.api.v1.account.AccountAPI.get_org_info": {"tf": 2}, "laceworksdk.api.v1.compliance": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.compliance.ComplianceAPI": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.compliance.ComplianceAPI.__init__": {"tf": 4}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 5.477225575051661}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 5.916079783099616}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 5.916079783099616}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 4}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 4}, "laceworksdk.api.v1.custom_compliance_config": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"tf": 4}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.get": {"tf": 2.23606797749979}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"tf": 3.872983346207417}, "laceworksdk.api.v1.download_file": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.download_file.DownloadFileAPI": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.download_file.DownloadFileAPI.__init__": {"tf": 4}, "laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"tf": 4}, "laceworksdk.api.v1.events": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.events.EventsAPIv1": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.events.EventsAPIv1.__init__": {"tf": 4}, "laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 5}, "laceworksdk.api.v1.events.EventsAPIv1.get_details": {"tf": 4}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 4.58257569495584}, "laceworksdk.api.v1.integrations": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.integrations.IntegrationsAPI": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.integrations.IntegrationsAPI.__init__": {"tf": 4}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 5.5677643628300215}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"tf": 5.0990195135927845}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_all": {"tf": 2.23606797749979}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 4}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"tf": 4}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 6}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 6}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 4.58257569495584}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete": {"tf": 4}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 4.58257569495584}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"tf": 4}, "laceworksdk.api.v1.recommendations": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.recommendations.RecommendationsAPI": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.__init__": {"tf": 4}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"tf": 4}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 4.58257569495584}, "laceworksdk.api.v1.run_reports": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.run_reports.RunReportsAPI": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.run_reports.RunReportsAPI.__init__": {"tf": 4}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 4.58257569495584}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"tf": 4}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"tf": 4}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 4}, "laceworksdk.api.v1.run_reports.RunReportsAPI.integration": {"tf": 4}, "laceworksdk.api.v1.suppressions": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.suppressions.SuppressionsAPI": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.__init__": {"tf": 4}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"tf": 4.47213595499958}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"tf": 4.58257569495584}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 4.47213595499958}, "laceworksdk.api.v1.token": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.token.TokenAPI": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.token.TokenAPI.__init__": {"tf": 4}, "laceworksdk.api.v1.token.TokenAPI.create": {"tf": 5.0990195135927845}, "laceworksdk.api.v1.token.TokenAPI.get": {"tf": 2.23606797749979}, "laceworksdk.api.v1.token.TokenAPI.get_enabled": {"tf": 2.23606797749979}, "laceworksdk.api.v1.token.TokenAPI.get_token": {"tf": 4}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 5.5677643628300215}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 5.5677643628300215}, "laceworksdk.api.v1.vulnerability": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.__init__": {"tf": 4}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 5.196152422706632}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 6.855654600401044}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 5.656854249492381}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 5.656854249492381}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 6.855654600401044}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 6.082762530298219}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 7.211102550927978}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 6.782329983125268}, "laceworksdk.api.v2": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.activities": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.activities.ActivitiesAPI": {"tf": 3.3166247903554}, "laceworksdk.api.v2.activities.ActivitiesAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.activities.ChangedFilesAPI": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.activities.ChangedFilesAPI.RESOURCE": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.activities.ConnectionsAPI": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.activities.ConnectionsAPI.RESOURCE": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.activities.DnsAPI": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.activities.DnsAPI.RESOURCE": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.activities.UserLoginsAPI": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.activities.UserLoginsAPI.RESOURCE": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.agent_access_tokens": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 5.0990195135927845}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"tf": 4}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 5.5677643628300215}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete": {"tf": 2.449489742783178}, "laceworksdk.api.v2.agent_info": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.agent_info.AgentInfoAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.agent_info.AgentInfoAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.alert_channels": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 6}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get": {"tf": 4.58257569495584}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_guid": {"tf": 4}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_type": {"tf": 4}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 6.4031242374328485}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.delete": {"tf": 4}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.test": {"tf": 4}, "laceworksdk.api.v2.alert_profiles": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 5.5677643628300215}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get": {"tf": 4}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id": {"tf": 4}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"tf": 2.449489742783178}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 5.0990195135927845}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.delete": {"tf": 4}, "laceworksdk.api.v2.alert_rules": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 5.5677643628300215}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get": {"tf": 4}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get_by_guid": {"tf": 4}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 6}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.delete": {"tf": 4}, "laceworksdk.api.v2.alerts": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.alerts.AlertsAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alerts.AlertsAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 5.0990195135927845}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 5.0990195135927845}, "laceworksdk.api.v2.alerts.AlertsAPI.search": {"tf": 4}, "laceworksdk.api.v2.alerts.AlertsAPI.comment": {"tf": 4.58257569495584}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 5}, "laceworksdk.api.v2.audit_logs": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 5.0990195135927845}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.search": {"tf": 4}, "laceworksdk.api.v2.cloud_accounts": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 6}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get": {"tf": 4.58257569495584}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid": {"tf": 4}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type": {"tf": 4}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 6.4031242374328485}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.delete": {"tf": 4}, "laceworksdk.api.v2.cloud_activities": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 5.0990195135927845}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"tf": 4.123105625617661}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 4.123105625617661}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search": {"tf": 4}, "laceworksdk.api.v2.configs": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.configs.ConfigsAPI": {"tf": 3.3166247903554}, "laceworksdk.api.v2.configs.ConfigsAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI.RESOURCE": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.container_registries": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 6}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get": {"tf": 4.58257569495584}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid": {"tf": 4}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type": {"tf": 4}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 6.4031242374328485}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.delete": {"tf": 4}, "laceworksdk.api.v2.contract_info": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.contract_info.ContractInfoAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"tf": 4}, "laceworksdk.api.v2.datasources": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.datasources.DatasourcesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.datasources.DatasourcesAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get": {"tf": 4}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_by_type": {"tf": 4}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"tf": 4}, "laceworksdk.api.v2.datasources.DatasourcesAPI.list_data_sources": {"tf": 2.449489742783178}, "laceworksdk.api.v2.entities": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 3.3166247903554}, "laceworksdk.api.v2.entities.EntitiesAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.entities.ApplicationsAPI": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.entities.ApplicationsAPI.RESOURCE": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.entities.CommandLinesAPI": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.entities.CommandLinesAPI.RESOURCE": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.entities.ContainersAPI": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.entities.ContainersAPI.RESOURCE": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.entities.FilesAPI": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.entities.FilesAPI.RESOURCE": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.entities.ImagesAPI": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.entities.ImagesAPI.RESOURCE": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI.RESOURCE": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.entities.K8sPodsAPI": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.entities.K8sPodsAPI.RESOURCE": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.entities.MachinesAPI": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.entities.MachinesAPI.RESOURCE": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.entities.MachineDetailsAPI": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.entities.MachineDetailsAPI.RESOURCE": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI.RESOURCE": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.entities.NewFileHashesAPI": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.entities.NewFileHashesAPI.RESOURCE": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.entities.PackagesAPI": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.entities.PackagesAPI.RESOURCE": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.entities.ProcessesAPI": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.entities.ProcessesAPI.RESOURCE": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.entities.UsersAPI": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.entities.UsersAPI.RESOURCE": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.events": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.events.EventsAPIv2": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.events.EventsAPIv2.__init__": {"tf": 4}, "laceworksdk.api.v2.inventory": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.inventory.InventoryAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.inventory.InventoryAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.organization_info": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.get": {"tf": 2.23606797749979}, "laceworksdk.api.v2.policies": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.policies.PoliciesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policies.PoliciesAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 8.717797887081348}, "laceworksdk.api.v2.policies.PoliciesAPI.get": {"tf": 4}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"tf": 4}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 8.717797887081348}, "laceworksdk.api.v2.policies.PoliciesAPI.delete": {"tf": 4}, "laceworksdk.api.v2.policy_exceptions": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 5.477225575051661}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get": {"tf": 4.58257569495584}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 4.58257569495584}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 5.916079783099616}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete": {"tf": 4.58257569495584}, "laceworksdk.api.v2.queries": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.queries.QueriesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.queries.QueriesAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 5.5677643628300215}, "laceworksdk.api.v2.queries.QueriesAPI.get": {"tf": 4}, "laceworksdk.api.v2.queries.QueriesAPI.get_by_id": {"tf": 4}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 5.5677643628300215}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 4.58257569495584}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 4.58257569495584}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 5.0990195135927845}, "laceworksdk.api.v2.queries.QueriesAPI.delete": {"tf": 4}, "laceworksdk.api.v2.report_definitions": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 7.483314773547883}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get": {"tf": 4}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id": {"tf": 4}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"tf": 2.449489742783178}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 8.12403840463596}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.delete": {"tf": 4}, "laceworksdk.api.v2.report_rules": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.report_rules.ReportRulesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 6}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get": {"tf": 4}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get_by_guid": {"tf": 4}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 6.4031242374328485}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.delete": {"tf": 4}, "laceworksdk.api.v2.reports": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.reports.ReportsAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.reports.ReportsAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 7.483314773547883}, "laceworksdk.api.v2.resource_groups": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 6}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get": {"tf": 4}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get_by_guid": {"tf": 4}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 6.4031242374328485}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.delete": {"tf": 4}, "laceworksdk.api.v2.schemas": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.schemas.SchemasAPI": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.schemas.SchemasAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.schemas.SchemasAPI.get": {"tf": 4.58257569495584}, "laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"tf": 2}, "laceworksdk.api.v2.team_members": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.team_members.TeamMembersAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.team_members.TeamMembersAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 7.14142842854285}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get": {"tf": 4}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get_by_guid": {"tf": 4}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 7.483314773547883}, "laceworksdk.api.v2.team_members.TeamMembersAPI.delete": {"tf": 4}, "laceworksdk.api.v2.user_profile": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.user_profile.UserProfileAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.user_profile.UserProfileAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.user_profile.UserProfileAPI.get": {"tf": 2.23606797749979}, "laceworksdk.api.v2.vulnerabilities": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 3.3166247903554}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.RESOURCE": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 5.5677643628300215}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.status": {"tf": 4}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI.RESOURCE": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 5.196152422706632}, "laceworksdk.api.v2.vulnerability_exceptions": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 7.483314773547883}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get": {"tf": 4}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get_by_guid": {"tf": 4}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 7.810249675906654}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.delete": {"tf": 4}, "laceworksdk.api.v2.vulnerability_policies": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.__init__": {"tf": 4}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 7.810249675906654}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get": {"tf": 4}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get_by_guid": {"tf": 4}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 8.12403840463596}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.delete": {"tf": 4}, "laceworksdk.config": {"tf": 1.7320508075688772}, "laceworksdk.exceptions": {"tf": 1.7320508075688772}, "laceworksdk.exceptions.LaceworkSDKException": {"tf": 1.7320508075688772}, "laceworksdk.exceptions.ApiError": {"tf": 1.7320508075688772}, "laceworksdk.exceptions.ApiError.__init__": {"tf": 1.7320508075688772}, "laceworksdk.exceptions.ApiError.response": {"tf": 2.23606797749979}, "laceworksdk.exceptions.ApiError.request": {"tf": 2.23606797749979}, "laceworksdk.exceptions.ApiError.status_code": {"tf": 1.7320508075688772}, "laceworksdk.exceptions.ApiError.status": {"tf": 1.7320508075688772}, "laceworksdk.exceptions.ApiError.details": {"tf": 1.7320508075688772}, "laceworksdk.exceptions.MalformedResponse": {"tf": 1.7320508075688772}, "laceworksdk.exceptions.RateLimitError": {"tf": 2.8284271247461903}, "laceworksdk.http_session": {"tf": 1.7320508075688772}, "laceworksdk.http_session.HttpSession": {"tf": 1.7320508075688772}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 5.744562646538029}, "laceworksdk.http_session.HttpSession.get": {"tf": 6.082762530298219}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 6.082762530298219}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 6.324555320336759}, "laceworksdk.http_session.HttpSession.patch": {"tf": 6.4031242374328485}, "laceworksdk.http_session.HttpSession.post": {"tf": 6.4031242374328485}, "laceworksdk.http_session.HttpSession.put": {"tf": 6.4031242374328485}, "laceworksdk.http_session.HttpSession.delete": {"tf": 5.916079783099616}, "laceworksdk.version": {"tf": 1.7320508075688772}}, "df": 374, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.alerts.AlertsAPI.comment": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1.4142135623730951}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.CommandLinesAPI": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.entities.CommandLinesAPI": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.compliance": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.get": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.integration": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI": {"tf": 1}}, "df": 20, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.configs.ComplianceEvaluationsAPI": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.configs.ConfigsAPI": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}}, "df": 3}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1.4142135623730951}}, "df": 2}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}}, "df": 1}}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 2}}}}}}}}}}, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"laceworksdk.api.v1.custom_compliance_config": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"tf": 1}}, "df": 3, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.config": {"tf": 1}}, "df": 8}}}}}}}, "s": {"docs": {"laceworksdk.api.v2.configs": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI": {"tf": 1.7320508075688772}}, "df": 2, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.configs.ConfigsAPI.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint.search": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.search": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.search": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}}, "df": 15}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 2}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI": {"tf": 2}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 2}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.status": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1.7320508075688772}}, "df": 9, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.container_registries": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.delete": {"tf": 1}}, "df": 7, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}}, "s": {"docs": {"laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ContainersAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}}, "df": 3, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}}, "df": 1}}}}, "v": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {"laceworksdk.api.v2.contract_info": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"tf": 1}}, "df": 2, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}}, "df": 2, "s": {"docs": {"laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 2}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.activities.ActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ConnectionsAPI": {"tf": 1.4142135623730951}}, "df": 2, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.activities.ActivitiesAPI": {"tf": 1}}, "df": 1}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}}, "df": 2, "s": {"docs": {"laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}}, "df": 2}}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.exceptions.ApiError.status_code": {"tf": 1}, "laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1}, "laceworksdk.http_session.HttpSession.post": {"tf": 1}, "laceworksdk.http_session.HttpSession.put": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1}}, "df": 8}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 1}, "laceworksdk.api.LaceworkClient.set_subaccount": {"tf": 1}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.__init__": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.activities.ChangedFilesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ConnectionsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.DnsAPI": {"tf": 1}, "laceworksdk.api.v2.activities.UserLoginsAPI": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.entities.ApplicationsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.CommandLinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ContainersAPI": {"tf": 1}, "laceworksdk.api.v2.entities.FilesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ImagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.K8sPodsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachinesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachineDetailsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NewFileHashesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.PackagesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ProcessesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.UsersAPI": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2.__init__": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.__init__": {"tf": 1}, "laceworksdk.exceptions.LaceworkSDKException": {"tf": 1}, "laceworksdk.http_session": {"tf": 1}, "laceworksdk.http_session.HttpSession": {"tf": 1}}, "df": 102}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_all": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}}, "df": 17, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.cloud_accounts": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.delete": {"tf": 1}}, "df": 7, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.cloud_activities": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search": {"tf": 1}}, "df": 5, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1.4142135623730951}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.exceptions.ApiError.response": {"tf": 1}, "laceworksdk.exceptions.ApiError.request": {"tf": 1}}, "df": 3, "s": {"docs": {"laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 1}, "laceworksdk.api.LaceworkClient.set_subaccount": {"tf": 1}}, "df": 2}}}, "n": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}}, "df": 5}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}}, "df": 2}}}, "y": {"docs": {"laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.validate_json": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"laceworksdk.api.v1.custom_compliance_config": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.get": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"tf": 1}}, "df": 4, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI": {"tf": 1}}, "df": 16}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}}, "df": 21, "/": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI": {"tf": 1}}, "df": 16}}}}}}}}}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}}, "df": 4}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}}, "df": 4}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}}, "df": 6}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {"laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint.delete": {"tf": 1}}, "df": 1, "s": {"docs": {"laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}}, "df": 6}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v2.activities.ActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ChangedFilesAPI": {"tf": 1}}, "df": 2, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.activities.ChangedFilesAPI": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.activities.ActivitiesAPI": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"tf": 1}}, "df": 1, "s": {"docs": {"laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}}, "df": 3}}, "s": {"docs": {}, "df": 0, "p": {"docs": {"laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 1}}, "df": 5}, "v": {"docs": {"laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}}, "df": 3}}, "v": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 5, "s": {"docs": {"laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 2}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint.search": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1.4142135623730951}}, "df": 5}}}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v1.token.TokenAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.datasources.DatasourcesAPI.list_data_sources": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1.4142135623730951}}, "df": 18}}}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint.delete": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.delete": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.delete": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1.4142135623730951}}, "df": 20, "d": {"docs": {"laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_details": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get_token": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.MachineDetailsAPI": {"tf": 1}, "laceworksdk.exceptions.ApiError.details": {"tf": 1}}, "df": 11, "t": {"docs": {"laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1}}, "df": 1}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1.4142135623730951}}, "df": 4}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 3}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1.4142135623730951}}, "df": 3}}}}}}}, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}}, "df": 1, "s": {"docs": {"laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 1}}, "df": 2}}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}, "laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}}, "df": 4, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.search": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.search": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.search": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}}, "df": 10}}}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1.4142135623730951}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.activities.ActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}}, "df": 4}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1.7320508075688772}}, "df": 2}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v1.download_file": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"tf": 1}}, "df": 3, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.download_file.DownloadFileAPI.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}}, "df": 2}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}}, "df": 2}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.http_session.HttpSession.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "%": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "%": {"docs": {}, "df": 0, "m": {"docs": {"laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1.4142135623730951}}, "df": 9}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.exceptions.ApiError": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1.4142135623730951}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1.4142135623730951}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1.7320508075688772}, "laceworksdk.http_session.HttpSession.post": {"tf": 1.7320508075688772}, "laceworksdk.http_session.HttpSession.put": {"tf": 1.7320508075688772}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1.7320508075688772}}, "df": 21, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"tf": 1.7320508075688772}}, "df": 1, "s": {"docs": {"laceworksdk.api.v2.datasources": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.list_data_sources": {"tf": 1}}, "df": 5, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.datasources.DatasourcesAPI.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}}, "e": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}}, "df": 4}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.activities.ActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.DnsAPI": {"tf": 1.4142135623730951}}, "df": 2, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.activities.ActivitiesAPI": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk": {"tf": 1}, "laceworksdk.api.LaceworkClient": {"tf": 1}}, "df": 2}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 2}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 2}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 2.449489742783178}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 2.449489742783178}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 3.1622776601683795}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 3.1622776601683795}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 2.23606797749979}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 2.23606797749979}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 2}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 2}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 2}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 3.4641016151377544}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 3.4641016151377544}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 3}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 3}}, "df": 17, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}}, "df": 2, "s": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.create": {"tf": 1.4142135623730951}, "laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"tf": 1.4142135623730951}, "laceworksdk.api.crud_endpoint.CrudEndpoint.search": {"tf": 1.4142135623730951}, "laceworksdk.api.crud_endpoint.CrudEndpoint.update": {"tf": 1.4142135623730951}, "laceworksdk.api.crud_endpoint.CrudEndpoint.delete": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.account.AccountAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.__init__": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_details": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.integration": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.create": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.get_token": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.agent_info.AgentInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.test": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.alerts.AlertsAPI.search": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alerts.AlertsAPI.comment": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.search": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.configs.ConfigsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.datasources.DatasourcesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2.__init__": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.policies.PoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.policies.PoliciesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.queries.QueriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.queries.QueriesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.team_members.TeamMembersAPI.delete": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.status": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.delete": {"tf": 1}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 1}, "laceworksdk.http_session.HttpSession.get": {"tf": 1.4142135623730951}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1.4142135623730951}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1.4142135623730951}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1}, "laceworksdk.http_session.HttpSession.post": {"tf": 1}, "laceworksdk.http_session.HttpSession.put": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1}}, "df": 203}}}}}, "s": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint.create": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.update": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}, "laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}}, "df": 48}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.activities.ActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}}, "df": 6}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.exceptions.ApiError.details": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1}, "laceworksdk.http_session.HttpSession.post": {"tf": 1}, "laceworksdk.http_session.HttpSession.put": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1}}, "df": 8}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1.4142135623730951}}, "df": 4}, "c": {"docs": {}, "df": 0, "h": {"docs": {"laceworksdk.http_session.HttpSession.patch": {"tf": 1}}, "df": 1}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 1}}, "df": 1, "s": {"docs": {"laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"tf": 1.4142135623730951}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1.4142135623730951}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}}, "df": 3}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 2.6457513110645907}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 2.23606797749979}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.config": {"tf": 1}, "laceworksdk.exceptions": {"tf": 1}, "laceworksdk.exceptions.LaceworkSDKException": {"tf": 1}, "laceworksdk.http_session": {"tf": 1}, "laceworksdk.http_session.HttpSession": {"tf": 1}, "laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1}, "laceworksdk.http_session.HttpSession.post": {"tf": 1}, "laceworksdk.http_session.HttpSession.put": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1}}, "df": 19, "s": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.PackagesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 8, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}}, "df": 1}}}}}}}}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}}, "df": 1}}}}}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}}, "df": 1, "d": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.validate_json": {"tf": 1}}, "df": 1}, "r": {"docs": {"laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}}, "df": 2}, "s": {"docs": {"laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}}, "df": 38}}}}}, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}}, "df": 3, "s": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1.4142135623730951}}, "df": 3, "s": {"docs": {"laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ProcessesAPI": {"tf": 1.4142135623730951}}, "df": 2, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}}, "df": 1}}}}}}}}}, "p": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}}, "df": 10}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}}, "df": 4}}}, "y": {"docs": {"laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1.7320508075688772}}, "df": 2}}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.exceptions.ApiError.request": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "f": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}}, "df": 6}}, "c": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}}, "df": 3}}, "k": {"docs": {}, "df": 0, "g": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1.4142135623730951}}, "df": 3, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.alerts.AlertsAPI.comment": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1}, "laceworksdk.http_session.HttpSession.post": {"tf": 1.4142135623730951}, "laceworksdk.http_session.HttpSession.put": {"tf": 1}}, "df": 5}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 3}}}}}}, "d": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.K8sPodsAPI": {"tf": 1}}, "df": 2}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.policies": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1.4142135623730951}}, "df": 7, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.policies.PoliciesAPI.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "y": {"docs": {"laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policies.PoliciesAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 2.23606797749979}, "laceworksdk.api.v2.policies.PoliciesAPI.delete": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 3.605551275463989}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 3.605551275463989}}, "df": 14, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 2}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.http_session.HttpSession.put": {"tf": 1}}, "df": 1}}}, "s": {"3": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}}, "df": 1}, "docs": {"laceworksdk.api.v1.account.AccountAPI.get_org_info": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 2}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 2}}, "df": 7, "d": {"docs": {}, "df": 0, "k": {"docs": {"laceworksdk": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"tf": 1}}, "df": 2, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.get": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"tf": 1.4142135623730951}}, "df": 2}}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.__init__": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2.__init__": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.__init__": {"tf": 1}}, "df": 45}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint.search": {"tf": 1.4142135623730951}, "laceworksdk.api.search_endpoint.SearchEndpoint": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.activities.ChangedFilesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.activities.ConnectionsAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.activities.DnsAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.activities.UserLoginsAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.agent_info.AgentInfoAPI": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alerts.AlertsAPI": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.search": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.search": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.configs.ComplianceEvaluationsAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.ApplicationsAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.CommandLinesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.ContainersAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.FilesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.ImagesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.K8sPodsAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.MachinesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.MachineDetailsAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.NewFileHashesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.PackagesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.ProcessesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.UsersAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.inventory.InventoryAPI": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerabilities.HostVulnerabilitiesAPI": {"tf": 1.4142135623730951}}, "df": 32}}}}, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}}, "df": 2}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1.4142135623730951}}, "df": 14}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 6}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {"laceworksdk.exceptions.ApiError": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1}, "laceworksdk.http_session.HttpSession.post": {"tf": 1}, "laceworksdk.http_session.HttpSession.put": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1}}, "df": 7, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {"laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.exceptions.ApiError": {"tf": 1}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1.4142135623730951}, "laceworksdk.http_session.HttpSession.post": {"tf": 1.4142135623730951}, "laceworksdk.http_session.HttpSession.put": {"tf": 1.4142135623730951}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1.4142135623730951}}, "df": 7}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1.7320508075688772}}, "df": 2, "s": {"docs": {"laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.http_session.HttpSession.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 1}, "laceworksdk.api.LaceworkClient.set_subaccount": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.create": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1.4142135623730951}}, "df": 9}}}, "w": {"docs": {"laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1.7320508075688772}}, "df": 2}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {"laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 1}}, "df": 3, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.LaceworkClient.set_subaccount": {"tf": 1}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 1}}, "df": 2}}}}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}}, "df": 2, "s": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 1}}, "df": 1}}}}}}}}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}}, "df": 1}}}}}}, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1.4142135623730951}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.schemas.SchemasAPI.get": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"tf": 1}}, "df": 2}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 1}}, "df": 2, "s": {"docs": {"laceworksdk.api.v1.suppressions": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI": {"tf": 1}}, "df": 2, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.suppressions.SuppressionsAPI.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}}, "df": 38}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 1}}, "df": 2, "s": {"docs": {"laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 1}}, "df": 3}}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}}, "df": 2}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v2.activities.ActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}}, "df": 4}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"tf": 1.7320508075688772}, "laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"tf": 1.4142135623730951}, "laceworksdk.api.crud_endpoint.CrudEndpoint.update": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.delete": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 2}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 2}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.integration": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.create": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.token.TokenAPI.get_token": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 2}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 2}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 2}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.test": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 2.449489742783178}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 2.23606797749979}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 2}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alerts.AlertsAPI.comment": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 3}, "laceworksdk.api.v2.policies.PoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 3}, "laceworksdk.api.v2.policies.PoliciesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 2}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 2.23606797749979}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.queries.QueriesAPI.get": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.queries.QueriesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 3.1622776601683795}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 3.4641016151377544}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 2}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.team_members.TeamMembersAPI.delete": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.status": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 2}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 2.6457513110645907}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 3}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.get_by_guid": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 3.1622776601683795}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.delete": {"tf": 1}}, "df": 131, "s": {"docs": {"laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 2}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 2}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 2.6457513110645907}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 2.6457513110645907}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1.4142135623730951}}, "df": 10}}}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1.4142135623730951}}, "df": 9}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}}, "df": 2}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}}, "df": 9}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 2}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.status": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.exceptions.ApiError.status_code": {"tf": 1}, "laceworksdk.exceptions.ApiError.status": {"tf": 1}}, "df": 8, "/": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}}, "df": 1}}}}}}}}}}, "e": {"docs": {"laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1.4142135623730951}}, "df": 4}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.validate_json": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"tf": 1}}, "df": 17, "s": {"docs": {"laceworksdk.api.v2.schemas": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI": {"tf": 1}}, "df": 2, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.schemas.SchemasAPI.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 2.23606797749979}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.status": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}}, "df": 8, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}}, "df": 2}}}, "s": {"docs": {"laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1.4142135623730951}}, "df": 3}}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}}, "df": 3}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1.7320508075688772}}, "df": 3, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.datasources.DatasourcesAPI.list_data_sources": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_details": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}}, "df": 24}}, "c": {"docs": {"laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"tf": 1}}, "df": 1}}}}}}}, "%": {"docs": {}, "df": 0, "z": {"docs": {"laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}}, "df": 9}}, "z": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}}, "df": 4}, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1.4142135623730951}}, "df": 2}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk": {"tf": 1}, "laceworksdk.api.LaceworkClient": {"tf": 1}, "laceworksdk.api.LaceworkClient.set_subaccount": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.events.EventsAPIv1.get_details": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 2}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 2}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 2}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 2}, "laceworksdk.api.v2.activities.ActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 2.23606797749979}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 2.23606797749979}, "laceworksdk.api.v2.alerts.AlertsAPI": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.contract_info.ContractInfoAPI": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.get_datasource": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 2}, "laceworksdk.api.v2.report_rules.ReportRulesAPI": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 2.23606797749979}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 2.23606797749979}, "laceworksdk.api.v2.reports.ReportsAPI": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.team_members.TeamMembersAPI": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 2}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 2}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}, "laceworksdk.exceptions.LaceworkSDKException": {"tf": 1}, "laceworksdk.exceptions.ApiError": {"tf": 1}, "laceworksdk.http_session": {"tf": 1}, "laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}}, "df": 108, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1}, "laceworksdk.http_session.HttpSession.post": {"tf": 1}, "laceworksdk.http_session.HttpSession.put": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1}}, "df": 10}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI": {"tf": 1}}, "df": 30}}}}}, "s": {"docs": {"laceworksdk.http_session": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}}, "df": 38}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.download_file": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NewFileHashesAPI": {"tf": 1}}, "df": 11, "s": {"docs": {"laceworksdk.api.v2.activities.ActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.activities.ChangedFilesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.FilesAPI": {"tf": 1.4142135623730951}}, "df": 4, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 2}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1.7320508075688772}}, "df": 9, "s": {"docs": {"laceworksdk.api.crud_endpoint.CrudEndpoint.search": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.search": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.search": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.search": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}}, "df": 13}}}}}, "x": {"docs": {"laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 2, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 6}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 2}}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1.4142135623730951}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}}, "df": 2, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}}, "df": 2}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_for_date_range": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_assessments_by_date": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}, "laceworksdk.exceptions.ApiError.response": {"tf": 1}, "laceworksdk.exceptions.ApiError.status_code": {"tf": 1}, "laceworksdk.exceptions.ApiError.status": {"tf": 1}, "laceworksdk.exceptions.ApiError.details": {"tf": 1}, "laceworksdk.exceptions.MalformedResponse": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}}, "df": 19}}, "e": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1.4142135623730951}}, "df": 4}}}}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.schemas.SchemasAPI.get_by_subtype": {"tf": 1}}, "df": 4}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 3}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {"laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1.4142135623730951}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1.4142135623730951}, "laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 2}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 2}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.get": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.get": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}, "laceworksdk.exceptions.ApiError": {"tf": 1}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1.7320508075688772}, "laceworksdk.http_session.HttpSession.post": {"tf": 1.7320508075688772}, "laceworksdk.http_session.HttpSession.put": {"tf": 1.7320508075688772}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1.7320508075688772}}, "df": 53, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1}, "laceworksdk.http_session.HttpSession.post": {"tf": 1}, "laceworksdk.http_session.HttpSession.put": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1}}, "df": 5, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"laceworksdk": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.entities.InternalIPAddressesAPI": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.NetworkInterfacesAPI": {"tf": 1}}, "df": 2}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get_details": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}}, "df": 8}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 2}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_type": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 2.23606797749979}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 2.23606797749979}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_schema": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.run_reports.RunReportsAPI.integration": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}}, "df": 15, "s": {"docs": {"laceworksdk.api.v1.integrations": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_all": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1.4142135623730951}}, "df": 7, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v1.integrations.IntegrationsAPI.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}, "g": {"docs": {"laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}}, "df": 4}}, "i": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.__init__": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2.__init__": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.__init__": {"tf": 1}, "laceworksdk.http_session.HttpSession.__init__": {"tf": 1}}, "df": 44}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_container_scan": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 2.23606797749979}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}}, "df": 8}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.session": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.__init__": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.__init__": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI": {"tf": 2}, "laceworksdk.api.v2.activities.ActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 3.7416573867739413}, "laceworksdk.api.v2.entities.EntitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.events.EventsAPIv2.__init__": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.schemas.SchemasAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.__init__": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.__init__": {"tf": 1}}, "df": 50}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.exceptions.ApiError": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}}, "df": 1, "s": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {"laceworksdk.api.v1.account.AccountAPI.get_org_info": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.SoftwarePackagesAPI.scan": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1}}, "df": 10, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1}}, "df": 1}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1}}, "df": 1}}}}}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v2.inventory": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI.__init__": {"tf": 1}}, "df": 2, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.inventory.InventoryAPI.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1.4142135623730951}}, "df": 2}}}}}}, "s": {"docs": {"laceworksdk.api.LaceworkClient.__init__": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.session": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}, "laceworksdk.api.v2.activities.ActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.configs.ConfigsAPI": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 2.449489742783178}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 2.449489742783178}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1.4142135623730951}, "laceworksdk.exceptions.MalformedResponse": {"tf": 1}, "laceworksdk.exceptions.RateLimitError": {"tf": 1}, "laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1}, "laceworksdk.http_session.HttpSession.post": {"tf": 1}, "laceworksdk.http_session.HttpSession.put": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1}}, "df": 44, "o": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}}, "df": 1}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.scan": {"tf": 1}}, "df": 2}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI": {"tf": 1}, "laceworksdk.api.v2.agent_info.AgentInfoAPI": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI": {"tf": 1}, "laceworksdk.api.v2.audit_logs.AuditLogsAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI": {"tf": 1}, "laceworksdk.api.v2.contract_info.ContractInfoAPI": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI": {"tf": 1}, "laceworksdk.api.v2.inventory.InventoryAPI": {"tf": 1}, "laceworksdk.api.v2.organization_info.OrganizationInfoAPI": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI": {"tf": 1}, "laceworksdk.api.v2.user_profile.UserProfileAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI": {"tf": 1}}, "df": 28, "e": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"tf": 1}}, "df": 2}}}}}}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 2}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1.4142135623730951}}, "df": 3, "s": {"docs": {"laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.ImagesAPI": {"tf": 1.4142135623730951}}, "df": 2, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {"laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 2}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_dict_from_items": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1}}, "df": 2}}}}, "d": {"docs": {"laceworksdk.api.base_endpoint.BaseEndpoint.build_url": {"tf": 1.7320508075688772}, "laceworksdk.api.crud_endpoint.CrudEndpoint.get": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.update": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.events.EventsAPIv1.get_details": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.integration": {"tf": 1}, "laceworksdk.api.v1.suppressions.SuppressionsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.get_by_id": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.get_by_id": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alerts.AlertsAPI.get_details": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.alerts.AlertsAPI.comment": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.alerts.AlertsAPI.close": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.policies.PoliciesAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policies.PoliciesAPI.get_by_id": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 2}, "laceworksdk.api.v2.policies.PoliciesAPI.delete": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get": {"tf": 2}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.get_by_id": {"tf": 2.23606797749979}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.update": {"tf": 2}, "laceworksdk.api.v2.policy_exceptions.PolicyExceptionsAPI.delete": {"tf": 2}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.queries.QueriesAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.queries.QueriesAPI.get_by_id": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.queries.QueriesAPI.execute_by_id": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.queries.QueriesAPI.delete": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.get_by_id": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.delete": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 2.8284271247461903}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.ContainerVulnerabilitiesAPI.status": {"tf": 1.4142135623730951}}, "df": 61, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {"laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 4}}, "p": {"docs": {"laceworksdk.api.v2.entities.EntitiesAPI": {"tf": 1}, "laceworksdk.api.v2.entities.InternalIPAddressesAPI": {"tf": 1}}, "df": 2}, "f": {"docs": {"laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1.7320508075688772}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1.7320508075688772}, "laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_pages": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1.4142135623730951}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1}, "laceworksdk.http_session.HttpSession.post": {"tf": 1}, "laceworksdk.http_session.HttpSession.put": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1}}, "df": 9}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"laceworksdk": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 1}, "laceworksdk.api.v2.datasources.DatasourcesAPI.list_data_sources": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities.VulnerabilitiesAPI": {"tf": 1}, "laceworksdk.http_session.HttpSession.get": {"tf": 1}, "laceworksdk.http_session.HttpSession.get_data_items": {"tf": 1}, "laceworksdk.http_session.HttpSession.patch": {"tf": 1}, "laceworksdk.http_session.HttpSession.post": {"tf": 1}, "laceworksdk.http_session.HttpSession.put": {"tf": 1}, "laceworksdk.http_session.HttpSession.delete": {"tf": 1}}, "df": 11}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"laceworksdk.exceptions.RateLimitError": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.api.LaceworkClient": {"tf": 1}, "laceworksdk.api.v1.account": {"tf": 1}, "laceworksdk.api.v1.compliance": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config": {"tf": 1}, "laceworksdk.api.v1.download_file": {"tf": 1}, "laceworksdk.api.v1.events": {"tf": 1}, "laceworksdk.api.v1.integrations": {"tf": 1}, "laceworksdk.api.v1.recommendations": {"tf": 1}, "laceworksdk.api.v1.run_reports": {"tf": 1}, "laceworksdk.api.v1.suppressions": {"tf": 1}, "laceworksdk.api.v1.token": {"tf": 1}, "laceworksdk.api.v1.vulnerability": {"tf": 1}, "laceworksdk.api.v2.activities": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens": {"tf": 1}, "laceworksdk.api.v2.agent_info": {"tf": 1}, "laceworksdk.api.v2.alert_channels": {"tf": 1}, "laceworksdk.api.v2.alert_profiles": {"tf": 1}, "laceworksdk.api.v2.alert_rules": {"tf": 1}, "laceworksdk.api.v2.alerts": {"tf": 1}, "laceworksdk.api.v2.audit_logs": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts": {"tf": 1}, "laceworksdk.api.v2.cloud_activities": {"tf": 1}, "laceworksdk.api.v2.configs": {"tf": 1}, "laceworksdk.api.v2.container_registries": {"tf": 1}, "laceworksdk.api.v2.contract_info": {"tf": 1}, "laceworksdk.api.v2.datasources": {"tf": 1}, "laceworksdk.api.v2.entities": {"tf": 1}, "laceworksdk.api.v2.events": {"tf": 1}, "laceworksdk.api.v2.inventory": {"tf": 1}, "laceworksdk.api.v2.organization_info": {"tf": 1}, "laceworksdk.api.v2.policies": {"tf": 1}, "laceworksdk.api.v2.policy_exceptions": {"tf": 1}, "laceworksdk.api.v2.queries": {"tf": 1}, "laceworksdk.api.v2.report_definitions": {"tf": 1}, "laceworksdk.api.v2.report_rules": {"tf": 1}, "laceworksdk.api.v2.reports": {"tf": 1}, "laceworksdk.api.v2.resource_groups": {"tf": 1}, "laceworksdk.api.v2.schemas": {"tf": 1}, "laceworksdk.api.v2.team_members": {"tf": 1}, "laceworksdk.api.v2.user_profile": {"tf": 1}, "laceworksdk.api.v2.vulnerabilities": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies": {"tf": 1}}, "df": 43, "s": {"docs": {"laceworksdk.api": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1}}, "df": 3}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"laceworksdk.api.LaceworkClient.set_org_level_access": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.create": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.create": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update": {"tf": 1}, "laceworksdk.api.v1.token.TokenAPI.update_token": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.create": {"tf": 1}, "laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_channels.AlertChannelsAPI.update": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.alert_rules.AlertRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.create": {"tf": 1}, "laceworksdk.api.v2.cloud_accounts.CloudAccountsAPI.update": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.container_registries.ContainerRegistriesAPI.update": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_rules.ReportRulesAPI.update": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.create": {"tf": 1}, "laceworksdk.api.v2.resource_groups.ResourceGroupsAPI.update": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.vulnerability_policies.VulnerabilityPoliciesAPI.update": {"tf": 1.4142135623730951}}, "df": 29}}}}, "n": {"docs": {"laceworksdk.api.v2.agent_access_tokens.AgentAccessTokensAPI.delete": {"tf": 1}, "laceworksdk.api.v2.alert_profiles.AlertProfilesAPI.search": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.search": {"tf": 1}, "laceworksdk.api.v2.reports.ReportsAPI.get": {"tf": 1.4142135623730951}, "laceworksdk.exceptions.MalformedResponse": {"tf": 1}, "laceworksdk.exceptions.RateLimitError": {"tf": 1}}, "df": 6}, "r": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.team_members.TeamMembersAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.team_members.TeamMembersAPI.update": {"tf": 1.4142135623730951}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_aws_report": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_azure_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.compliance.ComplianceAPI.get_latest_gcp_report": {"tf": 1.4142135623730951}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_azure_subscriptions": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI.list_gcp_projects": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI.get": {"tf": 1}, "laceworksdk.api.v1.recommendations.RecommendationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.run_report": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.aws": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.azure": {"tf": 1}, "laceworksdk.api.v1.run_reports.RunReportsAPI.gcp": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_vulnerabilities": {"tf": 1.7320508075688772}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_container_scan_status": {"tf": 1}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities": {"tf": 2}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_cve": {"tf": 2}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.get_host_vulnerabilities_by_machine_id": {"tf": 2}, "laceworksdk.api.v1.vulnerability.VulnerabilityAPI.initiate_package_scan": {"tf": 2}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_pages": {"tf": 1}, "laceworksdk.api.v2.cloud_activities.CloudActivitiesAPI.get_data_items": {"tf": 1}, "laceworksdk.api.v2.policies.PoliciesAPI.create": {"tf": 1.4142135623730951}, "laceworksdk.api.v2.policies.PoliciesAPI.update": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.execute": {"tf": 1}, "laceworksdk.api.v2.queries.QueriesAPI.validate": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.vulnerability_exceptions.VulnerabilityExceptionsAPI.update": {"tf": 1}}, "df": 27}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"laceworksdk.api.v2.queries.QueriesAPI.create": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.create": {"tf": 1}, "laceworksdk.api.v2.report_definitions.ReportDefinitionsAPI.update": {"tf": 1}}, "df": 2}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {"laceworksdk": {"tf": 1}, "laceworksdk.api": {"tf": 1}, "laceworksdk.api.LaceworkClient": {"tf": 1}, "laceworksdk.api.LaceworkClient.__init__": {"tf": 1.4142135623730951}, "laceworksdk.api.base_endpoint.BaseEndpoint": {"tf": 1}, "laceworksdk.api.base_endpoint.BaseEndpoint.__init__": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint": {"tf": 1}, "laceworksdk.api.crud_endpoint.CrudEndpoint.__init__": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.__init__": {"tf": 1}, "laceworksdk.api.search_endpoint.SearchEndpoint.search": {"tf": 1}, "laceworksdk.api.v1.account": {"tf": 1}, "laceworksdk.api.v1.account.AccountAPI": {"tf": 1}, "laceworksdk.api.v1.compliance": {"tf": 1}, "laceworksdk.api.v1.compliance.ComplianceAPI": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.get": {"tf": 1}, "laceworksdk.api.v1.custom_compliance_config.CustomComplianceConfigAPI.set": {"tf": 1}, "laceworksdk.api.v1.download_file": {"tf": 1}, "laceworksdk.api.v1.download_file.DownloadFileAPI": {"tf": 1}, "laceworksdk.api.v1.events": {"tf": 1}, "laceworksdk.api.v1.events.EventsAPIv1": {"tf": 1}, "laceworksdk.api.v1.integrations": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.get_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_by_id": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.update_status": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete": {"tf": 1}, "laceworksdk.api.v1.integrations.IntegrationsAPI.delete_by_id": {"tf": 1}, "lac